source(file="f:\\h\\msml\\msml_technique.R") 
data<-read.table(file="f:\\h\\msml\\data.txt") # change the path accordingly


# an example as in Section 4 (B)
# true breakpoints: 512, 768

x<-data$V1

# get taus for T=1024
tau.mat<-get.tau(length(x), q=c(.95, .975))
taus<-tau.mat[1,]
pp.taus<-tau.mat[2,]

m<-msml.bd(x, tau=taus, pp.tau=pp.taus) # default values are used
m$br.list # before across-scales post-processing
m$breakpoints # after across-scales post-processing

x11()
ts.plot(x)
abline(v=m$breakpoints, col=2, lty=3)


# an example as in Section 4 (C) 
# true breakpoints: 400, 624

x<-data$V2
m<-msml.bd(x, tau=taus, pp.tau=pp.taus)
m$br.list
m$breakpoints


# an example as in Section 4 (D)
# true breakpoint: 50

x<-data$V3
m<-msml.bd(x, tau=taus, pp.tau=pp.taus)
m$br.list
m$breakpoints

# an example as in Section 4 (E) 
# true breakpoints: 400, 750

x<-data$V4
m<-msml.bd(x, tau=taus, pp.tau=pp.taus)
m$br.list
m$breakpoints

# an example as in Section 4 (F) 
# true breakpoints: 400, 750

x<-data$V5
m<-msml.bd(x, tau=taus, pp.tau=pp.taus)
m$br.list
m$breakpoints

# an example as in Section 4 (G) 
# true breakpoints: 125, 532, 704

x<-data$V6
m<-msml.bd(x, tau=taus, pp.tau=pp.taus)
m$br.list
m$breakpoints


