% Computes clustering coefficient, based on triangle motifs count
% Gergana Bounova, October 8, 2005

function [Cave,C] = clust_coeff(adj)

% INPUT: adjacency matrix representation of a graph

% OUTPUT: graph average clustering coefficient and clustering coefficient
% per node

N = length(adj);
deg = sum(adj(:,:));

% find neighboring links
str = adj2str(adj);


for i=1:N
    adjn = adj(str(i).child,str(i).child);
    E(i) = sum(sum(adjn))/2;
    if deg(i)==1 | deg(i)==0
        C(i) = 0;
    else
        C(i) = 2*E(i)/deg(i)/(deg(i)-1);
    end
end

Cave = sum(C)/N;

