clear all
load ../datab_r8plow.mat
% scrsz = get(0,'ScreenSize');
% figure('OuterPosition',[1 1 scrsz(3)/2 scrsz(4)])

scrsz = get(0,'ScreenSize');
%figure('OuterPosition',[1 1 scrsz(3)/3 scrsz(4)/2])

xlab='uninform-to-network based links, r'
xvar=rvec;

subplot(4,2,1)

yvar=dispnt_vec;
nums=length(yvar)/length(unique(xvar));
ylab='min price-correlation';
plot(xvar,yvar,'.','MarkerSize',15)
hold on
%plot(mean(reshape(xvar,nums,length(unique(xvar)))),mean(reshape(yvar,nums,length(unique(xvar)))),'r','LineWidth',2)
plot(fliplr(unique(xvar)),mean(reshape(yvar,nums,length(unique(xvar))),1),'r','LineWidth',2)

xlabel(xlab,'Interpreter','tex')
ylabel(ylab)
title('A: Price dispersion')
xlim([min(xvar)-0.1 max(xvar)*1.1])
ylim([0.9*min(yvar) 1.1*max(yvar)])

subplot(4,2,2)
yvar=gini_vec;
ylab='Gini-coeffient'

plot(xvar,yvar,'.','MarkerSize',15)
hold on
%plot(mean(reshape(xvar,nums,length(unique(xvar)))),mean(reshape(yvar,nums,length(unique(xvar)))),'r','LineWidth',2)
plot(fliplr(unique(xvar)),mean(reshape(yvar,nums,length(unique(xvar))),1),'r','LineWidth',2)

xlabel(xlab,'Interpreter','tex')
ylabel(ylab)
title('B: Concentration of gross volume')
xlim([min(xvar)-0.1 max(xvar)*1.1])
ylim([0.9*min(yvar) 1.1*max(yvar)])




ylab='centrality coeff'
yvar=betaprof_vec2;
%yvar=corrprof;
nums=length(yvar)/length(unique(xvar));
subplot(4,2,3)
plot(xvar,yvar,'.','MarkerSize',15)
hold on
%plot(mean(reshape(xvar,nums,length(unique(xvar)))),mean(reshape(yvar,nums,length(unique(xvar)))),'r','LineWidth',2)
plot(fliplr(unique(xvar)),mean(reshape(yvar,nums,length(unique(xvar))),1),'r','LineWidth',2)

xlabel(xlab,'Interpreter','tex')
ylabel(ylab,'Interpreter','tex')
title('C: Centrality and profit')
xlim([min(xvar)-0.1 max(xvar)+0.1])
ylim([0 1.1*max(yvar)])


yvar=betaint_vec2;
subplot(4,2,4)
plot(xvar,yvar,'.','MarkerSize',15)
hold on
%plot(mean(reshape(xvar,nums,length(unique(xvar)))),mean(reshape(yvar,nums,length(unique(xvar)))),'r','LineWidth',2)
plot(fliplr(unique(xvar)),mean(reshape(yvar,nums,length(unique(xvar))),1),'r','LineWidth',2)

xlabel(xlab,'Interpreter','tex')
ylabel(ylab,'Interpreter','tex')
title('D: Centrality and intermediation')
xlim([min(xvar)-0.1 max(xvar)+0.1])
ylim([0 1.1*max(yvar)])

yvar=betailliq1_vec;
subplot(4,2,5)
plot(xvar,yvar,'.','MarkerSize',15)
hold on
%plot(mean(reshape(xvar,nums,length(unique(xvar)))),mean(reshape(yvar,nums,length(unique(xvar)))),'r','LineWidth',2)
plot(fliplr(unique(xvar)),mean(reshape(yvar,nums,length(unique(xvar))),1),'r','LineWidth',2)

xlabel(xlab,'Interpreter','tex')
ylabel(ylab,'Interpreter','tex')
title('E:Centrality and trade cost')
xlim([min(xvar)-0.1 max(xvar)+0.1])
ylim([1.1*min(yvar) 0])

yvar=betavol_vec2;

subplot(4,2,6)
plot(xvar,yvar,'.','MarkerSize',15)
hold on
%plot(mean(reshape(xvar,nums,length(unique(xvar)))),mean(reshape(yvar,nums,length(unique(xvar)))),'r','LineWidth',2)
plot(fliplr(unique(xvar)),mean(reshape(yvar,nums,length(unique(xvar))),1),'r','LineWidth',2)

xlabel(xlab,'Interpreter','tex')
ylabel(ylab,'Interpreter','tex')
title('F: Centrality and gross volume')
xlim([min(xvar)-0.1 max(xvar)+0.1])
ylim([0 1.1*max(yvar)])


subplot(4,2,7)

yvar=betalearn_vec;
nums=length(yvar)/length(unique(xvar));

plot(xvar,yvar,'.','MarkerSize',15)
hold on
plot(fliplr(unique(xvar)),mean(reshape(yvar,nums,length(unique(xvar))),1),'r','LineWidth',2)
xlabel(xlab,'Interpreter','tex')
ylabel(ylab)
title('G: Centrality and learning')
xlim([min(xvar)-0.1 max(xvar)*1.1])
ylim([0.5*min(yvar) 1.1*max(yvar)])



subplot(4,2,8)

yvar=100*diffeff2;
nums=length(yvar)/length(unique(xvar));
ylab='excess variance, %';
plot(xvar,yvar,'.','MarkerSize',15)
hold on
plot(fliplr(unique(xvar)),mean(reshape(yvar,nums,length(unique(xvar))),1),'r','LineWidth',2)
xlabel(xlab,'Interpreter','tex')
ylabel(ylab)
title('H: Inefficiency')
xlim([min(xvar)-0.1 max(xvar)*1.1])
ylim([0 1.1*max(yvar)])




export_fig D:/Dropbox/ana-peter/simulationfigures/rptrade2.eps -transparent



