% Program for paper: "Sticky Information: A Model of Monetary Nonneutrality
% and Structural Slumps" by N.G. Mankiw and Ricardo Reis.
% Created: July 2001

%This file compute Figures 3 and 4.

%Loading the data
% pi is inflation, x growth of productivity, u the unemployment rate
load Phelps_data.txt
pi=Phelps_data(:,1);
x=Phelps_data(:,2);
u=Phelps_data(:,3);
clear Phelps_data

% n is the total number of observations.
n=length(pi);

%Demean all inputs so don't have to include constants in the regressions.
pi=pi-mean(pi);
x=x-mean(x);

% Setting the required parameters. Delta1 is irrelevant so will alwyas be set to 100.
delta0=mean(u);
delta1=100;
alpha=2.64;
lambda=0.25;

%Empirical parameters and residuals. 
% Fitting AR(3) for inflation. rho is the vector of coefficients
ypi=pi(4:n,1);
X=[pi(3:n-1,1) pi(2:n-2,1) pi(1:n-3,1)];
rho=regress(ypi,X);
% Generating the MA coefficients. In the vector powerrho
powerrho=ma(rho,n);
% Creating the series of shocks. In the vector epsilon
epsilon=ypi-X*rho;
clear X ypi;
% For productivity growth, using white noise, create ni, powerni and nu:
ni=0;
powerni=ma(ni,n);
nu=x(4:n,1);

% Calling program that gives two nx1 vectors with the gamma_j from j=0...n-1
% and the phi_j.
Phelps_sim_e

%Re-adjusting the n=n-p, if fitted Ar(p)
pi=pi(4:n,1);
x=x(4:n,1);
u=u(4:n,1);
n=n-3;

% Generating the predicted unemployment series
% Employment series stored as s_e
s_e=[];
n_epsilon=[];
n_gamma=[];
n_nu=[];
n_phi=[];
for i=1:n	
   n_epsilon=epsilon(1:i,1);
   n_epsilon=flipud(n_epsilon);
   n_gamma=gamma(1:i,1)';
   n_nu=nu(1:i,1);
   n_nu=flipud(n_nu);
   n_phi=phi(1:i,1)';
   s_e(i,1)=n_gamma*n_epsilon+n_phi*n_nu;
end
clear n_gamma n_epsilon n_phi n_nu i
s_e=(1/alpha)*s_e;

%Create the predicted unemployment series here:
s_u=delta0-delta1*s_e;

% Smoothing
smooth_u=[];
smooth_u(1,1)=0;
smooth_u(2,1)=0;
smooth_u(3,1)=0;
smooth_u(n,1)=0;
smooth_u(n-1,1)=0;
smooth_u(n-2,1)=0;
for i=4:n-3
   smooth_u(i,1)=(s_u(i-3,1)+2*s_u(i-2,1)+3*s_u(i-1,1)+4*s_u(i,1)+3*s_u(i+1,1)+2*s_u(i+2,1)+s_u(i+3,1))/16;
end

%Plot it and readjust the endpoints.
%Generating the axis. The sample started at 1959.00.
%Three first wre lost due to AR(3). So it starts at 1959.75.
index(1,1)=1959.75;
for i=2:n
   index(i,1)=index(i-1,1)+0.25;
end
plot(index(4:n-3,1),u(4:n-3,1),'r',index(4:n-3,1),smooth_u(4:n-3,1),'b-.')
Title('Figure 3')

figure3=[index(4:n-3,1) u(4:n-3,1) smooth_u(4:n-3,1)];
save figure3.txt figure3 -ascii

% Calculating correlations, SSR and variances
smooth_correlation=LLCORR(u(4:n-3,1),smooth_u(4:n-3,1))
smooth_SSR=(u(4:n-3,1)-smooth_u(4:n-3,1))'*(u(4:n-3,1)-smooth_u(4:n-3,1))
smooth_var=var(u(4:n-3,1))-var(smooth_u(4:n-3,1))

%r2
Rup=((smooth_u(4:n-3,1)-delta0*ones(n-6,1))'*(smooth_u(4:n-3,1)-delta0*ones(n-6,1)));
Rdown=((u(4:n-3,1)-delta0*ones(n-6,1))'*(u(4:n-3,1)-delta0*ones(n-6,1)));
Rsq=Rup/Rdown


%aside
% Smoothing
smooth_e=[];
smooth_e(1,1)=0;
smooth_e(2,1)=0;
smooth_e(3,1)=0;
smooth_e(n,1)=0;
smooth_e(n-1,1)=0;
smooth_e(n-2,1)=0;
for i=4:n-3
   smooth_e(i,1)=(s_e(i-3,1)+2*s_e(i-2,1)+3*s_e(i-1,1)+4*s_e(i,1)+3*s_e(i+1,1)+2*s_e(i+2,1)+s_e(i+3,1))/16;
end
