% Program for paper: "Sticky Information: A Model of Monetary Nonneutrality
% and Structural Slumps" by N.G. Mankiw and Ricardo Reis.
% Created: July 2001

% This program iterates on the body of Phelps_e.m, over the alpha and lambda, to
% minimise the sum of squared residuals.
% Note that this is not optimized for speed. Indeed as is, will take hours. Modify at will.

%Output is for the predicted series: raw_min (minimum SSR),
%best_alpha_raw and best_alpha_lambda (optimal parameters)
%For the smoothed

%Data
load Phelps_data.txt
pi=Phelps_data(:,1);
x=Phelps_data(:,2);
u=Phelps_data(:,3);
n=length(pi);
pi=pi-mean(pi);
x=x-mean(x);
%Deltas
delta0=mean(u);
delta1=100;
%Empirics
ypi=pi(4:n,1);
X=[pi(3:n-1,1) pi(2:n-2,1) pi(1:n-3,1)];
rho=regress(ypi,X);
powerrho=ma(rho,n);
epsilon=ypi-X*rho;
clear X ypi;
ni=0;
powerni=ma(ni,n);
nu=x(4:n,1);

%Readjust data
pi=pi(4:n,1);
x=x(4:n,1);
u=u(4:n,1);
n=n-3;

%Where loop starts
%raw_fit keeps the SSR for the predicted series. smoth_fit same for smoothed predictions

smooth_fit=[];
for lll=1:30;
   lambda=0.1+0.01*lll
   for aaa=1:100
      alpha=2+0.01*aaa;
      %Generating unemployment
      Phelps_sim_e
		s_e=[];
		n_epsilon=[];
		n_gamma=[];
		n_nu=[];
		n_phi=[];
		for i=1:n	
		   n_epsilon=epsilon(1:i,1);
		   n_epsilon=flipud(n_epsilon);
		   n_gamma=gamma(1:i,1)';
		   n_nu=nu(1:i,1);
		   n_nu=flipud(n_nu);
		   n_phi=phi(1:i,1)';
		   s_e(i,1)=n_gamma*n_epsilon+n_phi*n_nu;
		end
		clear n_gamma n_epsilon n_phi n_nu i
		s_e=(1/alpha)*s_e;
		s_u=delta0-delta1*s_e;
      % Smoothing
		smooth_u=[];
		smooth_u(1,1)=0;
		smooth_u(2,1)=0;
		smooth_u(3,1)=0;
		smooth_u(n,1)=0;
		smooth_u(n-1,1)=0;
		smooth_u(n-2,1)=0;
		for i=4:n-3
		   smooth_u(i,1)=(s_u(i-3,1)+2*s_u(i-2,1)+3*s_u(i-1,1)+4*s_u(i,1)+3*s_u(i+1,1)+2*s_u(i+2,1)+s_u(i+3,1))/16;
		end
		%SSR for the smoothed series
		smooth_SSR=(u(4:n-3,1)-smooth_u(4:n-3,1))'*(u(4:n-3,1)-smooth_u(4:n-3,1));
		%Storing the SSR
		smooth_fit(lll,aaa)=smooth_SSR;
	end
end
clear smooth_u s_u smooth_SSR s_e gamma phi aaa alpha lll lambda

%Minimum
smooth_min=min(smooth_fit);
smooth_min=min(smooth_min);

%Spotting the parameters that generate the minimum for the smoothed series:
[best_lambda best_alpha]=find(smooth_fit<=smooth_min);
best_lambda_smooth=0.1+0.01*best_lambda;
best_alpha_smooth=2+0.01*best_alpha;
clear ggg best_lambda best_alpha

smooth_min
best_alpha_smooth
best_lambda_smooth