% Program for paper: "Sticky Information: A Model of Monetary Nonneutrality
% and Structural Slumps" by N.G. Mankiw and Ricardo Reis.
% Created: July 2001

% A copy from Phelps_e.m shutting off the inflation shocks 

%Loading the data
load Phelps_data.txt
pi=Phelps_data(:,1);
x=Phelps_data(:,2);
u=Phelps_data(:,3);
clear Phelps_data
n=length(pi);
pi=pi-mean(pi);
x=x-mean(x);

% Setting the required parameters.
delta0=mean(u);
delta1=100;
alpha=2.64;
lambda=0.25;

%Empirical parameters and residuals. 
ypi=pi(4:n,1);
X=[pi(3:n-1,1) pi(2:n-2,1) pi(1:n-3,1)];
rho=regress(ypi,X);
powerrho=ma(rho,n);
epsilon=ypi-X*rho;
clear X ypi;
ni=0;
powerni=ma(ni,n);
% Where shut off the productivity shocks
nu=zeros(n-3,1);

Phelps_sim_e
pi=pi(4:n,1);
x=x(4:n,1);
u=u(4:n,1);
n=n-3;

s_e=[];
n_epsilon=[];
n_gamma=[];
n_nu=[];
n_phi=[];
for i=1:n	
   n_epsilon=epsilon(1:i,1);
   n_epsilon=flipud(n_epsilon);
   n_gamma=gamma(1:i,1)';
   n_nu=nu(1:i,1);
   n_nu=flipud(n_nu);
   n_phi=phi(1:i,1)';
   s_e(i,1)=n_gamma*n_epsilon+n_phi*n_nu;
end
clear n_gamma n_epsilon n_phi n_nu i
s_e=(1/alpha)*s_e;
s_u=delta0-delta1*s_e;

% Smoothing
smooth_u=[];
smooth_u(1,1)=0;
smooth_u(2,1)=0;
smooth_u(3,1)=0;
smooth_u(n,1)=0;
smooth_u(n-1,1)=0;
smooth_u(n-2,1)=0;
for i=4:n-3
   smooth_u(i,1)=(s_u(i-3,1)+2*s_u(i-2,1)+3*s_u(i-1,1)+4*s_u(i,1)+3*s_u(i+1,1)+2*s_u(i+2,1)+s_u(i+3,1))/16;
end

%Plot
index(1,1)=1959.75;
for i=2:n
   index(i,1)=index(i-1,1)+0.25;
end
plot(index(4:n-3,1),u(4:n-3,1),'r',index(4:n-3,1),smooth_u(4:n-3,1),'b-.')
Title('Figure 4 top pannel - inflation shocks')

%File to export to do graphs in Excel
fig4top=[index(4:n-3,1) u(4:n-3,1) smooth_u(4:n-3,1)];
save fig4top.txt fig4top -ascii

% Calculating correlations, SSR and variances
smooth_correlation=LLCORR(u(4:n-3,1),smooth_u(4:n-3,1))
smooth_SSR=(u(4:n-3,1)-smooth_u(4:n-3,1))'*(u(4:n-3,1)-smooth_u(4:n-3,1))
smooth_var=var(u(4:n-3,1))-var(smooth_u(4:n-3,1))