% Program for paper: "Sticky Information: A Model of Monetary Nonneutrality
% and Structural Slumps" by N.G. Mankiw and Ricardo Reis.
% Created: July 2001

% This file gives the MA coefficients for the employment series.
%Inputs necessary are n and lambda
gamma=[];
phi=[];

% Generate a powerlambda series which will be useful. A column vector with 1-lambda
% raised to successive powers, starting from 0
powerlambda=[];
for i=1:n+1
   powerlambda(i,1)=(1-lambda)^(i-1);
end

%The gamma_0 and phi_0 inital values
gamma(1,1)=powerrho(1,1)*powerlambda(2,1)/lambda;
phi(1,1)=powerni(1,1)*powerlambda(2,1)/lambda;

%The recursion that gives the remaining values
for v=2:n
   firstterm=powerlambda(v+1,1)/(1-powerlambda(v+1,1));
   secondterm=1-(lambda/(1-powerlambda(v+1,1)));
   gamma(v,1)=firstterm*powerrho(v,1)+secondterm*gamma(v-1,1);
   phi(v,1)=firstterm*powerni(v,1)+secondterm*phi(v-1,1);
end

clear v firstterm secondterm