(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     15146,        333]*)
(*NotebookOutlinePosition[     15852,        357]*)
(*  CellTagsIndexPosition[     15808,        353]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[
    StyleBox[\(\( (*\ 
        Program\ to\ calculate\ SPI\ in\ Table\ 1\ \(of : \ "\<What Measure \
of Inflation Should a Central Bank Target?\>"\ by\ N . \ G . \ 
                Mankiw\ and\ Ricardo\ Reis\), \ 
        Journal\ of\ the\ European\ Economic\ Association, \ 1\ \((5)\), \ 
        2003*) \)\(\[IndentingNewLine]\)\(\[IndentingNewLine]\)\( (*Last\ \
\(Modified : \ September\ 13  th\), \ 2002*) \)\),
      "Section"]], "Input"],

Cell[BoxData[
    \(\(\( (*Start\ by\ clearing\ the\ \
memory*) \)\(\[IndentingNewLine]\)\(ClearAll[\[Theta]A, \[Theta]B, \[Theta]C, \
\[Theta]D, \[Lambda]A, \[Lambda]B, \[Lambda]C, \[Lambda]D, \[Alpha]A, \
\[Alpha]B, \[Alpha]C, \[Alpha]D, \[Sigma]A, \[Sigma]B, \[Sigma]C, \[Sigma]D, \
\[Sigma]AB, \[Sigma]AC, \[Sigma]AD, \[Sigma]BC, \[Sigma]BD, \[Sigma]CD, eqns, 
      p, pA, pB, pC, 
      pD, \[Epsilon]A, \[Epsilon]B, \[Epsilon]C, \[Epsilon]D, \[Omega]A, \
\[Omega]B, \[Omega]C, \[Omega]D, temp1, yfirst, ysecond, ythird, phiA, phiB, 
      phiC, phiD, phiAB, phiAC, phiAD, phiBC, phiBD, phiCD, yfourth, yobj, 
      zzz, minimum]\)\)\)], "Input"],

Cell[BoxData[
    \(\(\( (*First\ we\ set\ the\ parameter\ values*) \)\(\[IndentingNewLine]\
\)\( (*A\ is\ energy, \ B\ is\ food, \ C\ is\ others, \ 
      and\ D\ is\ wages*) \)\(\[IndentingNewLine]\)\(\(\[Theta]A = 
        0.06576;\)\[IndentingNewLine]
    \(\[Theta]B = 0.15403;\)\[IndentingNewLine]
    \(\[Theta]C = 1 - \[Theta]A - \[Theta]B;\)\[IndentingNewLine]
    \(\[Theta]D = 0;\)\[IndentingNewLine]\[IndentingNewLine]
    \(\[Lambda]A = 1;\)\[IndentingNewLine]
    \(\[Lambda]B = 1;\)\[IndentingNewLine]
    \(\[Lambda]C = 0.5;\)\[IndentingNewLine]
    \(\[Lambda]D = 0.5;\)\[IndentingNewLine]\[IndentingNewLine]
    \(\[Alpha]A = 0.366583574;\)\[IndentingNewLine]
    \(\[Alpha]B = 0.097260006;\)\[IndentingNewLine]
    \(\[Alpha]C = 0.10410712;\)\[IndentingNewLine]
    \(\[Alpha]D = 0.29369523;\)\[IndentingNewLine]\[IndentingNewLine]
    \(\[Sigma]A2 = 0.00279361918683;\)\[IndentingNewLine]
    \(\[Sigma]B2 = 0.000253023030769;\)\[IndentingNewLine]
    \(\[Sigma]C2 = 0.000163508783971;\)\[IndentingNewLine]
    \(\[Sigma]D2 = 0.000504826905702;\)\[IndentingNewLine]
    \(\[Sigma]AB = \(-0.00023000160694\);\)\[IndentingNewLine]
    \(\[Sigma]AC = 0.000131617848307;\)\[IndentingNewLine]
    \(\[Sigma]AD = \(-0.000198853502602\);\)\[IndentingNewLine]
    \(\[Sigma]BC = \(-0.0000488896501747\);\)\[IndentingNewLine]
    \(\[Sigma]BD = 0.00000960015055183;\)\[IndentingNewLine]
    \(\[Sigma]CD = 0.0000850525028586;\)\[IndentingNewLine]
    \)\)\)], "Input"],

Cell[BoxData[
    \(\(\( (*Second\ we\ define\ the\ economy, \ solve\ for\ y, \ 
      and\ get\ a\ function\ for\ the\ variance\ of\ y, \ 
      as\ a\ function\ of\ the\ weights\ \[Omega]*) \)\(\[IndentingNewLine]\)\
\( (*Solve\ for\ y*) \)\(\[IndentingNewLine]\)\(\(eqns = {p \[Equal] \
\[Theta]A*pA + \[Theta]B*pB + \[Theta]C*pC + \[Theta]D*pD, 
          pA == \[Lambda]A*\((p + \[Alpha]A*y + \[Epsilon]A)\), 
          pB == \[Lambda]B*\((p + \[Alpha]B*y + \[Epsilon]B)\), 
          pC == \[Lambda]C*\((p + \[Alpha]C*y + \[Epsilon]C)\), 
          pD \[Equal] \[Lambda]D*\((p + \[Alpha]D*
                    y + \[Epsilon]D)\), \[Omega]A*pA + \[Omega]B*
                pB + \[Omega]C*pC + \[Omega]D*pD == 0};\)\[IndentingNewLine]
    \(Solve[eqns, y, {pA, pB, pC, pD, p}];\)\[IndentingNewLine]
    \(temp1 = y /. %;\)\[IndentingNewLine]
    \(\(yfirst[\[Epsilon]A_, \[Epsilon]B_, \[Epsilon]C_, \[Epsilon]D_] = 
        temp1[\([1]\)];\)\(\[IndentingNewLine]\)
    \) (*Obtain\ coefficients\ on\ the\ \[Epsilon]\ in\ the\ expression\ for\ \
y*) \[IndentingNewLine]
    \(phiA = yfirst[1, 0, 0, 0];\)\[IndentingNewLine]
    \(phiB = yfirst[0, 1, 0, 0];\)\[IndentingNewLine]
    \(phiC = yfirst[0, 0, 1, 0];\)\[IndentingNewLine]
    \(\(phiD = yfirst[0, 0, 0, 1];\)\(\[IndentingNewLine]\)
    \) (*Function\ for\ variance\ of\ y, \ 
      taking\ into\ account\ of\ covariances*) \[IndentingNewLine]
    \(\(ysecond[\[Omega]A_, \[Omega]B_, \[Omega]C_, \[Omega]D_] = \
\((phiA^2)\)*\[Sigma]A2 + \((phiB^2)\)*\[Sigma]B2 + \((phiC^2)\)*\[Sigma]C2 + \
\((phiD^2)\)*\[Sigma]D2 + 
          2*\((phiA*phiB*\[Sigma]AB + phiA*phiC*\[Sigma]AC + 
                phiA*phiD*\[Sigma]AD + phiB*phiC*\[Sigma]BC + 
                phiB*phiD*\[Sigma]BD + 
                phiC*phiD*\[Sigma]CD)\);\)\(\[IndentingNewLine]\)
    \) (*Incorporate\ constraint\ that\ weights\ must\ sum\ to\ one\ to\ \
obtain\ the\ unconstrained\ minimization*) \[IndentingNewLine]
    \(yobj[\[Omega]A_, \[Omega]B_, \[Omega]C_] = 
        ysecond[\[Omega]A, \[Omega]B, \[Omega]C, 
          1 - \[Omega]A - \[Omega]B - \[Omega]C];\)\)\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\( (*Third, \ in\ this\ file, \ 
      we\ find\ the\ minimum\ of\ the\ function\ by\ using\ the\ hill - 
        climbing\ algorithm\ included\ in\ Mathematica . \ 
            We\ start\ at\ different\ points\ in\ the\ hill, \ 
      to\ ensure\ the\ robustness\ of\ the\ results*) \)\(\[IndentingNewLine]\
\)\(\[IndentingNewLine]\)\( (*Starting\ from\ the\ CPI\ weights*) \)\(\
\[IndentingNewLine]\)\(\(FindMinimum[
        yobj[\[Omega]A, \[Omega]B, \[Omega]C], {\[Omega]A, \[Theta]A}, {\
\[Omega]B, \[Theta]B}, {\[Omega]C, \[Theta]C}, 
        MaxIterations \[Rule] 200];\)\[IndentingNewLine]
    \(zzz = %;\)\[IndentingNewLine]
    Print["\<One solution is   \>", \ zzz]\[IndentingNewLine]
    \(step1 = zzz[\([2]\)];\)\[IndentingNewLine]
    \(step1[\([1]\)];\)\[IndentingNewLine]
    \(sol\[Omega]A = \[Omega]A /. %;\)\[IndentingNewLine]
    \(step1[\([2]\)];\)\[IndentingNewLine]
    \(sol\[Omega]B = \[Omega]B /. %;\)\[IndentingNewLine]
    \(step1[\([3]\)];\)\[IndentingNewLine]
    \(sol\[Omega]C = \[Omega]C /. %;\)\[IndentingNewLine]
    \(sol\[Omega]D = 
        1 - sol\[Omega]A - sol\[Omega]B - sol\[Omega]C;\)\[IndentingNewLine]
    Print["\<\[Omega]D is:   \>", sol\[Omega]D]\[IndentingNewLine]
    \(varcpi = yobj[\[Theta]A, \[Theta]B, \[Theta]C];\)\[IndentingNewLine]
    \(gain = 1 - \((zzz[\([1]\)]/varcpi)\);\)\[IndentingNewLine]
    \(Print["\<The % reduction from targeting the SPI rather than the CPI is  \
 \>", \ gain];\)\[IndentingNewLine]\[IndentingNewLine] (*Starting\ from\ 100  \
%\ weight\ to\ wages*) \[IndentingNewLine]
    \(FindMinimum[
        yobj[\[Omega]A, \[Omega]B, \[Omega]C], {\[Omega]A, 0}, {\[Omega]B, 
          0}, {\[Omega]C, 0}, 
        MaxIterations \[Rule] 200];\)\[IndentingNewLine]
    \(zzz = %;\)\[IndentingNewLine]
    Print["\<Another solution is   \>", \ zzz]\[IndentingNewLine]
    \(step1 = zzz[\([2]\)];\)\[IndentingNewLine]
    \(step1[\([1]\)];\)\[IndentingNewLine]
    \(sol\[Omega]A = \[Omega]A /. %;\)\[IndentingNewLine]
    \(step1[\([2]\)];\)\[IndentingNewLine]
    \(sol\[Omega]B = \[Omega]B /. %;\)\[IndentingNewLine]
    \(step1[\([3]\)];\)\[IndentingNewLine]
    \(sol\[Omega]C = \[Omega]C /. %;\)\[IndentingNewLine]
    \(sol\[Omega]D = 
        1 - sol\[Omega]A - sol\[Omega]B - sol\[Omega]C;\)\[IndentingNewLine]
    Print["\<\[Omega]D is:   \>", sol\[Omega]D]\[IndentingNewLine]
    \(gain = 1 - \((zzz[\([1]\)]/varcpi)\);\)\[IndentingNewLine]
    \(Print["\<The % reduction from targeting the SPI rather than the CPI is  \
 \>", \ gain];\)\[IndentingNewLine]\[IndentingNewLine] (*Starting\ from\  - 
        300  %\ to\ wages*) \[IndentingNewLine]
    \(FindMinimum[
        yobj[\[Omega]A, \[Omega]B, \[Omega]C], {\[Omega]A, 1}, {\[Omega]B, 
          1}, {\[Omega]C, 1}, 
        MaxIterations \[Rule] 200];\)\[IndentingNewLine]
    \(zzz = %;\)\[IndentingNewLine]
    Print["\<Another solution is   \>", \ zzz]\[IndentingNewLine]
    \(step1 = zzz[\([2]\)];\)\[IndentingNewLine]
    \(step1[\([1]\)];\)\[IndentingNewLine]
    \(sol\[Omega]A = \[Omega]A /. %;\)\[IndentingNewLine]
    \(step1[\([2]\)];\)\[IndentingNewLine]
    \(sol\[Omega]B = \[Omega]B /. %;\)\[IndentingNewLine]
    \(step1[\([3]\)];\)\[IndentingNewLine]
    \(sol\[Omega]C = \[Omega]C /. %;\)\[IndentingNewLine]
    \(sol\[Omega]D = 
        1 - sol\[Omega]A - sol\[Omega]B - sol\[Omega]C;\)\[IndentingNewLine]
    Print["\<\[Omega]D is:   \>", sol\[Omega]D]\[IndentingNewLine]
    \(gain = 1 - \((zzz[\([1]\)]/varcpi)\);\)\[IndentingNewLine]
    \(Print["\<The % reduction from targeting the SPI rather than the CPI is  \
 \>", \ gain];\)\[IndentingNewLine]\[IndentingNewLine] (*Starting\ from\ the\ \
solution\ in\ the\ text*) \[IndentingNewLine]
    \(FindMinimum[
        yobj[\[Omega]A, \[Omega]B, \[Omega]C], {\[Omega]A, 0.1}, {\[Omega]B, 
          0.37}, {\[Omega]C, \(-0.73\)}, 
        MaxIterations \[Rule] 200];\)\[IndentingNewLine]
    \(zzz = %;\)\[IndentingNewLine]
    Print["\<Another solution is   \>", \ zzz]\[IndentingNewLine]
    \(step1 = zzz[\([2]\)];\)\[IndentingNewLine]
    \(step1[\([1]\)];\)\[IndentingNewLine]
    \(sol\[Omega]A = \[Omega]A /. %;\)\[IndentingNewLine]
    \(step1[\([2]\)];\)\[IndentingNewLine]
    \(sol\[Omega]B = \[Omega]B /. %;\)\[IndentingNewLine]
    \(step1[\([3]\)];\)\[IndentingNewLine]
    \(sol\[Omega]C = \[Omega]C /. %;\)\[IndentingNewLine]
    \(sol\[Omega]D = 
        1 - sol\[Omega]A - sol\[Omega]B - sol\[Omega]C;\)\[IndentingNewLine]
    Print["\<\[Omega]D is:   \>", sol\[Omega]D]\[IndentingNewLine]
    \(gain = 1 - \((zzz[\([1]\)]/varcpi)\);\)\[IndentingNewLine]
    \(Print["\<The % reduction from targeting the SPI rather than the CPI is  \
 \>", \ gain];\)\)\)\)], "Input"],

Cell[BoxData[
    InterpretationBox[\("One solution is   \
"\[InvisibleSpace]{0.002884399648278029`, {\[Omega]A \[Rule] 
              0.09805108480756435`, \[Omega]B \[Rule] 
              0.3684021093552655`, \[Omega]C \[Rule] \
\(-0.7315783181981802`\)}}\),
      SequenceForm[ 
      "One solution is   ", {.0028843996482780291, {\[Omega]A -> \
.098051084807564345, \[Omega]B -> .36840210935526552, \[Omega]C -> \
-.7315783181981802}}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("\[Omega]D is:   \
"\[InvisibleSpace]1.2651251240353503`\),
      SequenceForm[ "\[Omega]D is:   ", 1.2651251240353503],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("The % reduction from targeting the SPI rather than \
the CPI is   "\[InvisibleSpace]0.5324205661003714`\),
      SequenceForm[ 
      "The % reduction from targeting the SPI rather than the CPI is   ", \
.53242056610037136],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Another solution is   \
"\[InvisibleSpace]{0.002884399648278029`, {\[Omega]A \[Rule] 
              0.09805108524683856`, \[Omega]B \[Rule] 
              0.36840210841501225`, \[Omega]C \[Rule] \
\(-0.7315783182936902`\)}}\),
      SequenceForm[ 
      "Another solution is   ", {.0028843996482780291, {\[Omega]A -> \
.09805108524683856, \[Omega]B -> .36840210841501225, \[Omega]C -> \
-.73157831829369024}}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("\[Omega]D is:   \
"\[InvisibleSpace]1.2651251246318393`\),
      SequenceForm[ "\[Omega]D is:   ", 1.2651251246318393],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("The % reduction from targeting the SPI rather than \
the CPI is   "\[InvisibleSpace]0.5324205661003714`\),
      SequenceForm[ 
      "The % reduction from targeting the SPI rather than the CPI is   ", \
.53242056610037136],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Another solution is   \
"\[InvisibleSpace]{0.002884399648278029`, {\[Omega]A \[Rule] 
              0.09805108541326446`, \[Omega]B \[Rule] 
              0.3684021089452263`, \[Omega]C \[Rule] \
\(-0.7315783054542686`\)}}\),
      SequenceForm[ 
      "Another solution is   ", {.0028843996482780291, {\[Omega]A -> \
.09805108541326446, \[Omega]B -> .36840210894522629, \[Omega]C -> \
-.73157830545426861}}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("\[Omega]D is:   \
"\[InvisibleSpace]1.2651251110957777`\),
      SequenceForm[ "\[Omega]D is:   ", 1.2651251110957777],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("The % reduction from targeting the SPI rather than \
the CPI is   "\[InvisibleSpace]0.5324205661003714`\),
      SequenceForm[ 
      "The % reduction from targeting the SPI rather than the CPI is   ", \
.53242056610037136],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Another solution is   \
"\[InvisibleSpace]{0.002884399648278029`, {\[Omega]A \[Rule] 
              0.09805108515226067`, \[Omega]B \[Rule] 
              0.36840210781564053`, \[Omega]C \[Rule] \
\(-0.7315783168372075`\)}}\),
      SequenceForm[ 
      "Another solution is   ", {.0028843996482780291, {\[Omega]A -> \
.098051085152260672, \[Omega]B -> .36840210781564053, \[Omega]C -> \
-.73157831683720753}}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("\[Omega]D is:   \
"\[InvisibleSpace]1.2651251238693062`\),
      SequenceForm[ "\[Omega]D is:   ", 1.2651251238693062],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("The % reduction from targeting the SPI rather than \
the CPI is   "\[InvisibleSpace]0.5324205661003714`\),
      SequenceForm[ 
      "The % reduction from targeting the SPI rather than the CPI is   ", \
.53242056610037136],
      Editable->False]], "Print"]
}, Open  ]]
},
FrontEndVersion->"5.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 681}},
WindowSize->{1016, 647},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 458, 8, 124, "Input"],
Cell[2215, 61, 652, 10, 90, "Input"],
Cell[2870, 73, 1479, 26, 570, "Input"],
Cell[4352, 101, 2118, 35, 350, "Input"],

Cell[CellGroupData[{
Cell[6495, 140, 4720, 86, 1370, "Input"],
Cell[11218, 228, 474, 10, 25, "Print"],
Cell[11695, 240, 192, 4, 25, "Print"],
Cell[11890, 246, 297, 6, 25, "Print"],
Cell[12190, 254, 483, 10, 25, "Print"],
Cell[12676, 266, 192, 4, 25, "Print"],
Cell[12871, 272, 297, 6, 25, "Print"],
Cell[13171, 280, 482, 10, 25, "Print"],
Cell[13656, 292, 192, 4, 25, "Print"],
Cell[13851, 298, 297, 6, 25, "Print"],
Cell[14151, 306, 484, 10, 25, "Print"],
Cell[14638, 318, 192, 4, 25, "Print"],
Cell[14833, 324, 297, 6, 25, "Print"]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

