(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 4.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    292495,       7274]*)
(*NotebookOutlinePosition[    293603,       7308]*)
(*  CellTagsIndexPosition[    293559,       7304]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[
    RowBox[{
      StyleBox["(*",
        "Title",
        FontColor->RGBColor[1, 0, 0]], "\[IndentingNewLine]", 
      StyleBox[" ",
        "Title",
        FontColor->RGBColor[1, 0, 0]], 
      StyleBox[\(Monetary\ Policy\ for\ Inattentive\ Economies\  - \ 
          figures . \[IndentingNewLine]Ball, \ Mankiw\ and\ Reis\),
        "Title",
        FontColor->RGBColor[1, 0, 0]], "\[IndentingNewLine]", 
      StyleBox["*)",
        "Title",
        FontColor->RGBColor[1, 0, 0]]}]], "Input",
  TextAlignment->Center],

Cell[BoxData[
    RowBox[{
      StyleBox[\( (*\[IndentingNewLine]\ 
          The\ notebook\ is\ organized\ by\ colors . \ 
              In\ red\ are\ headings . \ In\ blue\ are\ the\ comments . \ 
              In\ black\ and\ magenta\ is\ the\ code . \ Also, \ 
          note\ that\ in\ the\ plots, \ 
          the\ impulse\ response\ is\ always\ plotted\ in\ blue . \ 
              Very\ often\ the\ impulse\ response\ coincides\ with\ the\ \
horizontal\ axis, 
          but\ hopefully\ the\ use\ of\ blue\ should\ allow\ you\ to\ read\ \
it . \[IndentingNewLine]All\ questions\ should\ be\ directed\ to\ reis@fas . 
              harvard . edu\[IndentingNewLine]*) \),
        FontColor->RGBColor[0, 0, 1]], "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*First\ \(Created : \ August\ 13  th\), \ 
        2002*) \), 
      "\[IndentingNewLine]", \( (*Last\ \(Modified : \ December\), \ 
        2002*) \), "\[IndentingNewLine]", \( (*Ricardo\ Reis*) \)}]], "Input"],

Cell[BoxData[
    StyleBox[\( (*SETTING\ PARAMETERS*) \),
      "Section",
      FontColor->RGBColor[1, 0, 0]]], "Input",
  TextAlignment->Center],

Cell[BoxData[{
    \(\(maxloop = 30;\)\), "\[IndentingNewLine]", 
    \(\(\[Alpha] = 0.1;\)\), "\[IndentingNewLine]", 
    \(\(\[Lambda] = 0.25;\)\), "\[IndentingNewLine]", 
    \(\(\[Omega]naught = 1;\)\)}], "Input",
  TextAlignment->Left],

Cell[BoxData[
    \(\(\( (*Sum\ functions\  - \ 
        useful*) \)\(\[IndentingNewLine]\)\(\[CapitalLambda][a_, 
          b_, \[Lambda]_] = \[Lambda]*\(\[Sum]\+\(j = a\)\%b\((1 - \[Lambda])\
\)^j\);\)\)\)], "Input",
  TextAlignment->Left],

Cell[BoxData[
    StyleBox[\( (*PROGRAMS*) \),
      "Section",
      FontColor->RGBColor[1, 0, 0]]], "Input",
  TextAlignment->Center],

Cell[BoxData[
    StyleBox[\( (*DEMAND\ SHOCKS*) \),
      FontColor->RGBColor[1, 0, 0]]], "Input"],

Cell[BoxData[
    RowBox[{\( (*Time\ zero\ impact\  - \ same\ whatever\ policy*) \), 
      "\[IndentingNewLine]", 
      RowBox[{\(\[Gamma]zero = \((1 - \[Lambda])\)/\((1 - \[Lambda]*\((1 - \
\[Alpha])\))\);\), 
        "\[IndentingNewLine]", \(\[Psi]zero = \((\[Alpha]*\[Lambda])\)/\((1 - \
\[Lambda]*\((1 - \[Alpha])\))\);\), "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        StyleBox[\( (*Price\ level\ targeting*) \),
          FontColor->RGBColor[1, 0, 1]], 
        "\[IndentingNewLine]", \( (*same\ as\ optimal*) \), 
        "\[IndentingNewLine]", \(ClearAll[loop, \ Beginloop]\), 
        "\[IndentingNewLine]", \(ydp[0] = \[Gamma]zero;\), 
        "\[IndentingNewLine]", \(loop = 1;\), 
        "\[IndentingNewLine]", \(\((Label[
              Beginloop]; \[IndentingNewLine]ydp[loop] = 
              0; \[IndentingNewLine]loop = loop + 1; \[IndentingNewLine]If[
              loop \[LessEqual] maxloop, \ Goto[Beginloop]])\);\), 
        "\[IndentingNewLine]", \(ClearAll[loop, \ Beginloop]\), 
        "\[IndentingNewLine]", \(pdp[0] = \[Psi]zero;\), 
        "\[IndentingNewLine]", \(loop = 1;\), 
        "\[IndentingNewLine]", \(\((Label[
              Beginloop]; \[IndentingNewLine]pdp[loop] = 
              0; \[IndentingNewLine]loop = loop + 1; \[IndentingNewLine]If[
              loop \[LessEqual] maxloop, \ Goto[Beginloop]])\);\), 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        StyleBox[\( (*Inflation\ targeting*) \),
          FontColor->RGBColor[1, 0, 1]], 
        "\[IndentingNewLine]", \(ClearAll[loop, \ Beginloop]\), 
        "\[IndentingNewLine]", \(ydpi[0] = \[Gamma]zero;\), 
        "\[IndentingNewLine]", \(loop = 1;\), 
        "\[IndentingNewLine]", \(\((Label[
              Beginloop]; \[IndentingNewLine]ydpi[
                loop] = \((\((\[CapitalLambda][0, 
                          loop, \[Lambda]] - \[Lambda])\)/\[CapitalLambda][0, 
                      loop, \[Lambda]])\)*
                ydpi[loop - 1]; \[IndentingNewLine]loop = 
              loop + 1; \[IndentingNewLine]If[loop \[LessEqual] maxloop, \ 
              Goto[Beginloop]])\);\), 
        "\[IndentingNewLine]", \(ClearAll[loop, \ Beginloop]\), 
        "\[IndentingNewLine]", \(pdpi[0] = \[Psi]zero;\), 
        "\[IndentingNewLine]", \(loop = 1;\), 
        "\[IndentingNewLine]", \(\((Label[
              Beginloop]; \[IndentingNewLine]pdpi[
                loop] = \[Psi]zero; \[IndentingNewLine]loop = 
              loop + 1; \[IndentingNewLine]If[loop \[LessEqual] maxloop, \ 
              Goto[Beginloop]])\);\)}]}]], "Input"],

Cell[BoxData[
    StyleBox[\( (*MARKUP\ SHOCKS*) \),
      "Section",
      FontColor->RGBColor[1, 0, 0]]], "Input",
  TextAlignment->Center],

Cell[BoxData[
    RowBox[{
      StyleBox[\( (*Time\ zero\ impact\  - \ same\ whatever\ policy*) \),
        FontColor->RGBColor[1, 0, 1]], "\[IndentingNewLine]", 
      RowBox[{\(\[Gamma]zero = \(-\[Lambda]\)/\((1 - \[Lambda]*\((1 - \
\[Alpha])\))\);\), 
        "\[IndentingNewLine]", \(\[Psi]zero = \(+\[Lambda]\)/\((1 - \
\[Lambda]*\((1 - \[Alpha])\))\);\), "\[IndentingNewLine]", 
        StyleBox[\( (*The\ \[Rho]\ set\ here*) \),
          FontColor->RGBColor[1, 0, 1]], 
        "\[IndentingNewLine]", \(\[Rho] = 0.8;\), "\[IndentingNewLine]", 
        StyleBox[\( (*Optimal\ Policy*) \),
          FontColor->RGBColor[1, 0, 1]], 
        "\[IndentingNewLine]", \(ClearAll[loop, \ Beginloop]\), 
        "\[IndentingNewLine]", \(ymopt[0] = \[Gamma]zero;\), 
        "\[IndentingNewLine]", \(loop = 1;\), 
        "\[IndentingNewLine]", \(\((Label[
              Beginloop]; \[IndentingNewLine]ymopt[
                loop] = \(-\((\((\[Alpha]*\[Omega]naught)\)/\((\((\[Alpha]^2)\
\)*\[Omega]naught + \((\((1 - \[Lambda])\)^\((loop + 
                                    1)\)/\((1 - \((1 - \[Lambda])\)^\((loop + 
                                        1)\))\))\))\)*\[Rho]^
                      loop)\)\); \[IndentingNewLine]loop = 
              loop + 1; \[IndentingNewLine]If[loop \[LessEqual] maxloop, \ 
              Goto[Beginloop]])\);\), 
        "\[IndentingNewLine]", \(ClearAll[loop, \ Beginloop]\), 
        "\[IndentingNewLine]", \(pmopt[0] = \[Psi]zero;\), 
        "\[IndentingNewLine]", \(loop = 1;\), 
        "\[IndentingNewLine]", \(\((Label[
              Beginloop]; \[IndentingNewLine]pmopt[
                loop] = \(-ymopt[
                    loop]\)/\((\[Alpha]*\[Omega]naught)\); \
\[IndentingNewLine]loop = loop + 1; \[IndentingNewLine]If[
              loop \[LessEqual] maxloop, \ 
              Goto[Beginloop]])\);\)}]}]], "Input"],

Cell[BoxData[{\(ClearAll[\[Rho]];\), "\[IndentingNewLine]", 
    RowBox[{\(\[Rho] = 0.4;\), "\[IndentingNewLine]", 
      StyleBox[\( (*With\ the\ different\ \[Rho]\ now*) \),
        FontColor->GrayLevel[0]], "\[IndentingNewLine]", 
      StyleBox[\( (*Optimal\ policy\ in\ response\ to\ markup\ shocks\ with\ 
            a\ different\ \[Rho]*) \),
        FontColor->RGBColor[1, 0, 1]]}], "\[IndentingNewLine]", \(ClearAll[
      loop, \ Beginloop]\), "\[IndentingNewLine]", \(rhoymopt[
          0] = \[Gamma]zero;\), "\[IndentingNewLine]", \(loop = 
        1;\), "\[IndentingNewLine]", \(\((Label[
          Beginloop]; \[IndentingNewLine]rhoymopt[
            loop] = \(-\((\((\[Alpha]*\[Omega]naught)\)/\((\((\[Alpha]^2)\)*\
\[Omega]naught + \((\((1 - \[Lambda])\)^\((loop + 
                                1)\)/\((1 - \((1 - \[Lambda])\)^\((loop + 
                                    1)\))\))\))\)*\[Rho]^
                  loop)\)\); \[IndentingNewLine]loop = 
          loop + 1; \[IndentingNewLine]If[loop \[LessEqual] maxloop, \ 
          Goto[Beginloop]])\);\), "\[IndentingNewLine]", \(ClearAll[loop, \ 
      Beginloop]\), "\[IndentingNewLine]", \(rhopmopt[
          0] = \[Psi]zero;\), "\[IndentingNewLine]", \(loop = 
        1;\), "\[IndentingNewLine]", 
    RowBox[{\(\((Label[
            Beginloop]; \[IndentingNewLine]rhopmopt[
              loop] = \(-rhoymopt[
                  loop]\)/\((\[Alpha]*\[Omega]naught)\); \
\[IndentingNewLine]loop = loop + 1; \[IndentingNewLine]If[
            loop \[LessEqual] maxloop, \ Goto[Beginloop]])\);\), 
      "\[IndentingNewLine]", 
      StyleBox[\( (*The\ cross - 
            sectional\ dispersion\ of\ \(\(prices\)\(.\)\)*) \),
        FontColor->RGBColor[1, 0, 1]]}], "\[IndentingNewLine]", \(loop = 
        0;\), "\[IndentingNewLine]", \(\((Label[
          Beginloop]; \[IndentingNewLine]rhodmopt[loop] = 
          2*\((rhopmopt[
                  loop]^2)\)*\((\((1/\[CapitalLambda][0, 
                      loop, \[Lambda]])\) - 1)\); \[IndentingNewLine]loop = 
          loop + 1; \[IndentingNewLine]If[loop \[LessEqual] maxloop, \ 
          Goto[Beginloop]])\);\)}], "Input"],

Cell[BoxData[{
    RowBox[{
      StyleBox[\( (*The\ cross - 
            sectional\ dispersion\ of\ \(\(prices\)\(.\)\)*) \),
        FontColor->RGBColor[1, 0, 1]], 
      "\[IndentingNewLine]", \( (*Need\ first\ the\ sequence\ for\ price\ \
level\ in\ each\ case . \ Already\ calcullated\ from\ above*) \), 
      "\[IndentingNewLine]", \( (*the\ cross - 
          sectional\ dispersion\ then\ is*) \), 
      "\[IndentingNewLine]", \(Clear[loop, Beginloop, ddp, ddpi, dmopt, 
          dmp];\)}], "\[IndentingNewLine]", \(loop = 
        0;\), "\[IndentingNewLine]", 
    RowBox[{
      RowBox[{"(", 
        RowBox[{\(Label[Beginloop]\), ";", "\[IndentingNewLine]", " ", 
          RowBox[{\(ddp[loop]\), "=", 
            RowBox[{"2", "*", 
              RowBox[{"(", 
                RowBox[{Cell[""], \(pdp[loop]^2\)}], ")"}], 
              "*", \((\((1/\[CapitalLambda][0, loop, \[Lambda]])\) - 1)\)}]}],
           ";", "\[IndentingNewLine]", \(ddpi[loop] = 
            2*\((pdpi[
                    loop]^2)\)*\((\((1/\[CapitalLambda][0, 
                        loop, \[Lambda]])\) - 1)\)\), ";", 
          "\[IndentingNewLine]", \(dmopt[loop] = 
            2*\((pmopt[
                    loop]^2)\)*\((\((1/\[CapitalLambda][0, 
                        loop, \[Lambda]])\) - 1)\)\), ";", 
          "\[IndentingNewLine]", \(dmp[loop] = 
            2*\((pmp[
                    loop]^2)\)*\((\((1/\[CapitalLambda][0, 
                        loop, \[Lambda]])\) - 1)\)\), ";", 
          "\[IndentingNewLine]", \(loop = loop + 1\), ";", 
          "\[IndentingNewLine]", \(If[loop \[LessEqual] maxloop, \ 
            Goto[Beginloop]]\)}], ")"}], ";"}]}], "Input"],

Cell[BoxData[
    StyleBox[\( (*PLOTTING\  - \ FOR\ FIGURES\ 1\ AND\ 2*) \),
      "Section",
      FontColor->RGBColor[1, 0, 0]]], "Input",
  TextAlignment->Center],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{\(fig1a = 
            ListPlot[Table[{j, ydp[j]}, {j, 0, 15}], 
              PlotRange \[Rule] {0, 1}, PlotJoined \[Rule] True, 
              PlotStyle \[Rule] Hue[ .6], PlotLabel \[Rule] "\<Output\>", 
              DisplayFunction \[Rule] Identity];\), 
        "\[IndentingNewLine]", \(fig1b = 
            ListPlot[Table[{j, pdp[j]}, {j, 0, 15}], 
              PlotRange \[Rule] {0, 0.05}, PlotJoined \[Rule] True, 
              PlotStyle \[Rule] Hue[ .6], 
              PlotLabel \[Rule] "\<Price level\>", 
              DisplayFunction \[Rule] Identity];\), "\[IndentingNewLine]", 
        RowBox[{
          RowBox[{"fig1c", "=", 
            RowBox[{
              StyleBox["ListPlot",
                FontColor->GrayLevel[0]], 
              StyleBox["[",
                FontColor->GrayLevel[0]], 
              RowBox[{
                StyleBox[\(Table[{j, ddp[j]}, {j, 0, 15}]\),
                  FontColor->GrayLevel[0]], 
                StyleBox[",",
                  FontColor->GrayLevel[0]], 
                StyleBox[\(PlotRange \[Rule] {0, 0.008}\),
                  FontColor->GrayLevel[0]], 
                StyleBox[",",
                  FontColor->GrayLevel[0]], 
                StyleBox[\(PlotJoined \[Rule] True\),
                  FontColor->GrayLevel[0]], 
                StyleBox[",",
                  FontColor->GrayLevel[0]], 
                StyleBox[\(PlotStyle \[Rule] Hue[ .6]\),
                  FontColor->GrayLevel[0]], 
                StyleBox[",",
                  FontColor->GrayLevel[
                  0]], \(PlotLabel \[Rule] "\<Cross-sectional variability of \
prices\>"\), ",", \(DisplayFunction \[Rule] Identity\)}], "]"}]}], ";"}], 
        "\[IndentingNewLine]", \(fig1d = 
            ListPlot[Table[{j, ydpi[j]}, {j, 0, 15}], 
              PlotRange \[Rule] {0, 1}, PlotJoined \[Rule] True, 
              PlotStyle \[Rule] Hue[ .6], PlotLabel \[Rule] "\<Output\>", 
              DisplayFunction \[Rule] Identity];\), 
        "\[IndentingNewLine]", \(fig1e = 
            ListPlot[Table[{j, pdpi[j]}, {j, 0, 15}], 
              PlotRange \[Rule] {0, 0.05}, PlotJoined \[Rule] True, 
              PlotStyle \[Rule] Hue[ .6], 
              PlotLabel \[Rule] "\<Price level\>", 
              DisplayFunction \[Rule] Identity];\), "\[IndentingNewLine]", 
        RowBox[{
          RowBox[{"fig1f", "=", 
            
            StyleBox[\(ListPlot[Table[{j, ddpi[j]}, {j, 0, 15}], 
                PlotRange \[Rule] {0, 0.008}, PlotJoined \[Rule] True, 
                PlotStyle \[Rule] Hue[ .6], 
                PlotLabel \[Rule] "\<Cross-sectional variability of \
prices\>", DisplayFunction \[Rule] Identity]\),
              FontColor->GrayLevel[0]]}], 
          StyleBox[";",
            FontColor->GrayLevel[0]]}], "\[IndentingNewLine]", 
        "\[IndentingNewLine]", \( (*Arrange\ themn\ vertically*) \), 
        "\[IndentingNewLine]", \(fig1abc = 
            GraphicsArray[{{fig1b}, {fig1a}, {fig1c}}, 
              PlotLabel \[Rule] 
                FontForm["\<Price-Level Targeting\>", {"\<Courier-Bold\>", \ 
                    10}], GraphicsSpacing \[Rule]  .3];\), 
        "\[IndentingNewLine]", \(fig1def = 
            GraphicsArray[{{fig1e}, {fig1d}, {fig1f}}, 
              PlotLabel \[Rule] 
                FontForm["\<Inflation Targeting\>", {"\<Courier-Bold\>", \ 
                    10}], GraphicsSpacing \[Rule]  .3];\), 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", \(figure1 = 
            GraphicsArray[{fig1abc, fig1def}, GraphicsSpacing \[Rule]  .1];\),
         "\[IndentingNewLine]", 
        RowBox[{"Show", "[", 
          RowBox[{
          "figure1", 
            ",", \(PlotLabel \[Rule] 
              FontForm["\<Figure 1. Impact of a demand shock with price-level \
or inflation targeting\>", \ {"\<Courier-Bold\>", \ 14}]\), ",", 
            StyleBox[\(ImageSize -> 700\),
              "MR"]}], "]"}]}], "\[IndentingNewLine]"}]], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.05949 
%%ImageSize: 700 741.641 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.0252259 0.47619 [
[.5 1.07199 -312.031 0 ]
[.5 1.07199 312.031 17.9375 ]
[ 0 0 0 0 ]
[ 1 1.05949 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
gsave
.5 1.07199 -373.031 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 25.9375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 16.750 moveto
%%IncludeResource: font Courier-Bold
%%IncludeFont: Courier-Bold
/Courier-Bold findfont 14.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 16.750 moveto
%%IncludeResource: font Courier-Bold
%%IncludeFont: Courier-Bold
/Courier-Bold findfont 14.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Figure) show
121.625 16.750 moveto
(1.) show
146.750 16.750 moveto
(Impact) show
205.375 16.750 moveto
(of) show
230.500 16.750 moveto
(a) show
247.250 16.750 moveto
(demand) show
306.063 16.750 moveto
(shock) show
356.313 16.750 moveto
(with) show
398.313 16.750 moveto
(price) show
440.188 16.750 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 14.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
448.563 16.750 moveto
%%IncludeResource: font Courier-Bold
%%IncludeFont: Courier-Bold
/Courier-Bold findfont 14.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(level) show
498.813 16.750 moveto
(or) show
523.938 16.750 moveto
(inflation) show
607.688 16.750 moveto
(targeting) show
683.063 16.750 moveto
%%IncludeResource: font Courier-Bold
%%IncludeFont: Courier-Bold
/Courier-Bold findfont 14.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 1.05949 L
0 1.05949 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0238095 0.0252259 0.477324 1.03426 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.0529743 0.952381 [
[.5 2.23742 -65 0 ]
[.5 2.23742 65 13.4375 ]
[ 0 0 0 0 ]
[ 1 2.22492 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
gsave
.5 2.23742 -126 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.4375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.438 moveto
%%IncludeResource: font Courier-Bold
%%IncludeFont: Courier-Bold
/Courier-Bold findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.438 moveto
%%IncludeResource: font Courier-Bold
%%IncludeFont: Courier-Bold
/Courier-Bold findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Price) show
93.000 13.438 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
99.000 13.438 moveto
%%IncludeResource: font Courier-Bold
%%IncludeFont: Courier-Bold
/Courier-Bold findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Level) show
135.000 13.438 moveto
(Targeting) show
189.000 13.438 moveto
%%IncludeResource: font Courier-Bold
%%IncludeFont: Courier-Bold
/Courier-Bold findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 2.22492 L
0 2.22492 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0238095 0.0529743 0.97619 0.641578 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0634921 2.00577e-018 77.2542 [
[.15079 -0.0125 -3 -9 ]
[.15079 -0.0125 3 0 ]
[.27778 -0.0125 -3 -9 ]
[.27778 -0.0125 3 0 ]
[.40476 -0.0125 -3 -9 ]
[.40476 -0.0125 3 0 ]
[.53175 -0.0125 -3 -9 ]
[.53175 -0.0125 3 0 ]
[.65873 -0.0125 -6 -9 ]
[.65873 -0.0125 6 0 ]
[.78571 -0.0125 -6 -9 ]
[.78571 -0.0125 6 0 ]
[.9127 -0.0125 -6 -9 ]
[.9127 -0.0125 6 0 ]
[.01131 .15451 -30 -4.5 ]
[.01131 .15451 0 4.5 ]
[.01131 .30902 -30 -4.5 ]
[.01131 .30902 0 4.5 ]
[.01131 .46353 -30 -4.5 ]
[.01131 .46353 0 4.5 ]
[.01131 .61803 -30 -4.5 ]
[.01131 .61803 0 4.5 ]
[.5 .63053 -113 0 ]
[.5 .63053 113 12.75 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.15079 0 m
.15079 .00625 L
s
[(2)] .15079 -0.0125 0 1 Mshowa
.27778 0 m
.27778 .00625 L
s
[(4)] .27778 -0.0125 0 1 Mshowa
.40476 0 m
.40476 .00625 L
s
[(6)] .40476 -0.0125 0 1 Mshowa
.53175 0 m
.53175 .00625 L
s
[(8)] .53175 -0.0125 0 1 Mshowa
.65873 0 m
.65873 .00625 L
s
[(10)] .65873 -0.0125 0 1 Mshowa
.78571 0 m
.78571 .00625 L
s
[(12)] .78571 -0.0125 0 1 Mshowa
.9127 0 m
.9127 .00625 L
s
[(14)] .9127 -0.0125 0 1 Mshowa
.125 Mabswid
.05556 0 m
.05556 .00375 L
s
.0873 0 m
.0873 .00375 L
s
.11905 0 m
.11905 .00375 L
s
.18254 0 m
.18254 .00375 L
s
.21429 0 m
.21429 .00375 L
s
.24603 0 m
.24603 .00375 L
s
.30952 0 m
.30952 .00375 L
s
.34127 0 m
.34127 .00375 L
s
.37302 0 m
.37302 .00375 L
s
.43651 0 m
.43651 .00375 L
s
.46825 0 m
.46825 .00375 L
s
.5 0 m
.5 .00375 L
s
.56349 0 m
.56349 .00375 L
s
.59524 0 m
.59524 .00375 L
s
.62698 0 m
.62698 .00375 L
s
.69048 0 m
.69048 .00375 L
s
.72222 0 m
.72222 .00375 L
s
.75397 0 m
.75397 .00375 L
s
.81746 0 m
.81746 .00375 L
s
.84921 0 m
.84921 .00375 L
s
.88095 0 m
.88095 .00375 L
s
.94444 0 m
.94444 .00375 L
s
.97619 0 m
.97619 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
.02381 .15451 m
.03006 .15451 L
s
[(0.002)] .01131 .15451 1 0 Mshowa
.02381 .30902 m
.03006 .30902 L
s
[(0.004)] .01131 .30902 1 0 Mshowa
.02381 .46353 m
.03006 .46353 L
s
[(0.006)] .01131 .46353 1 0 Mshowa
.02381 .61803 m
.03006 .61803 L
s
[(0.008)] .01131 .61803 1 0 Mshowa
.125 Mabswid
.02381 .03863 m
.02756 .03863 L
s
.02381 .07725 m
.02756 .07725 L
s
.02381 .11588 m
.02756 .11588 L
s
.02381 .19314 m
.02756 .19314 L
s
.02381 .23176 m
.02756 .23176 L
s
.02381 .27039 m
.02756 .27039 L
s
.02381 .34764 m
.02756 .34764 L
s
.02381 .38627 m
.02756 .38627 L
s
.02381 .4249 m
.02756 .4249 L
s
.02381 .50215 m
.02756 .50215 L
s
.02381 .54078 m
.02756 .54078 L
s
.02381 .57941 m
.02756 .57941 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.5 .63053 -174 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Cross) show
93.000 13.000 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
99.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(sectional) show
159.000 13.000 moveto
(variability) show
231.000 13.000 moveto
(of) show
249.000 13.000 moveto
(prices) show
285.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 .4 1 r
.5 Mabswid
.02381 .48234 m
.0873 0 L
.15079 0 L
.21429 0 L
.27778 0 L
.34127 0 L
.40476 0 L
.46825 0 L
.53175 0 L
.59524 0 L
.65873 0 L
.72222 0 L
.78571 0 L
.84921 0 L
.9127 0 L
.97619 0 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.0238095 0.818159 0.97619 1.40676 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0634921 0 0.618034 [
[.15079 -0.0125 -3 -9 ]
[.15079 -0.0125 3 0 ]
[.27778 -0.0125 -3 -9 ]
[.27778 -0.0125 3 0 ]
[.40476 -0.0125 -3 -9 ]
[.40476 -0.0125 3 0 ]
[.53175 -0.0125 -3 -9 ]
[.53175 -0.0125 3 0 ]
[.65873 -0.0125 -6 -9 ]
[.65873 -0.0125 6 0 ]
[.78571 -0.0125 -6 -9 ]
[.78571 -0.0125 6 0 ]
[.9127 -0.0125 -6 -9 ]
[.9127 -0.0125 6 0 ]
[.01131 .12361 -18 -4.5 ]
[.01131 .12361 0 4.5 ]
[.01131 .24721 -18 -4.5 ]
[.01131 .24721 0 4.5 ]
[.01131 .37082 -18 -4.5 ]
[.01131 .37082 0 4.5 ]
[.01131 .49443 -18 -4.5 ]
[.01131 .49443 0 4.5 ]
[.01131 .61803 -6 -4.5 ]
[.01131 .61803 0 4.5 ]
[.5 .63053 -20 0 ]
[.5 .63053 20 12.75 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.15079 0 m
.15079 .00625 L
s
[(2)] .15079 -0.0125 0 1 Mshowa
.27778 0 m
.27778 .00625 L
s
[(4)] .27778 -0.0125 0 1 Mshowa
.40476 0 m
.40476 .00625 L
s
[(6)] .40476 -0.0125 0 1 Mshowa
.53175 0 m
.53175 .00625 L
s
[(8)] .53175 -0.0125 0 1 Mshowa
.65873 0 m
.65873 .00625 L
s
[(10)] .65873 -0.0125 0 1 Mshowa
.78571 0 m
.78571 .00625 L
s
[(12)] .78571 -0.0125 0 1 Mshowa
.9127 0 m
.9127 .00625 L
s
[(14)] .9127 -0.0125 0 1 Mshowa
.125 Mabswid
.05556 0 m
.05556 .00375 L
s
.0873 0 m
.0873 .00375 L
s
.11905 0 m
.11905 .00375 L
s
.18254 0 m
.18254 .00375 L
s
.21429 0 m
.21429 .00375 L
s
.24603 0 m
.24603 .00375 L
s
.30952 0 m
.30952 .00375 L
s
.34127 0 m
.34127 .00375 L
s
.37302 0 m
.37302 .00375 L
s
.43651 0 m
.43651 .00375 L
s
.46825 0 m
.46825 .00375 L
s
.5 0 m
.5 .00375 L
s
.56349 0 m
.56349 .00375 L
s
.59524 0 m
.59524 .00375 L
s
.62698 0 m
.62698 .00375 L
s
.69048 0 m
.69048 .00375 L
s
.72222 0 m
.72222 .00375 L
s
.75397 0 m
.75397 .00375 L
s
.81746 0 m
.81746 .00375 L
s
.84921 0 m
.84921 .00375 L
s
.88095 0 m
.88095 .00375 L
s
.94444 0 m
.94444 .00375 L
s
.97619 0 m
.97619 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
.02381 .12361 m
.03006 .12361 L
s
[(0.2)] .01131 .12361 1 0 Mshowa
.02381 .24721 m
.03006 .24721 L
s
[(0.4)] .01131 .24721 1 0 Mshowa
.02381 .37082 m
.03006 .37082 L
s
[(0.6)] .01131 .37082 1 0 Mshowa
.02381 .49443 m
.03006 .49443 L
s
[(0.8)] .01131 .49443 1 0 Mshowa
.02381 .61803 m
.03006 .61803 L
s
[(1)] .01131 .61803 1 0 Mshowa
.125 Mabswid
.02381 .0309 m
.02756 .0309 L
s
.02381 .0618 m
.02756 .0618 L
s
.02381 .09271 m
.02756 .09271 L
s
.02381 .15451 m
.02756 .15451 L
s
.02381 .18541 m
.02756 .18541 L
s
.02381 .21631 m
.02756 .21631 L
s
.02381 .27812 m
.02756 .27812 L
s
.02381 .30902 m
.02756 .30902 L
s
.02381 .33992 m
.02756 .33992 L
s
.02381 .40172 m
.02756 .40172 L
s
.02381 .43262 m
.02756 .43262 L
s
.02381 .46353 m
.02756 .46353 L
s
.02381 .52533 m
.02756 .52533 L
s
.02381 .55623 m
.02756 .55623 L
s
.02381 .58713 m
.02756 .58713 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.5 .63053 -81 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Output) show
99.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 .4 1 r
.5 Mabswid
.02381 .5981 m
.0873 0 L
.15079 0 L
.21429 0 L
.27778 0 L
.34127 0 L
.40476 0 L
.46825 0 L
.53175 0 L
.59524 0 L
.65873 0 L
.72222 0 L
.78571 0 L
.84921 0 L
.9127 0 L
.97619 0 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.0238095 1.58334 0.97619 2.17195 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0634921 1.61546e-017 12.3607 [
[.15079 -0.0125 -3 -9 ]
[.15079 -0.0125 3 0 ]
[.27778 -0.0125 -3 -9 ]
[.27778 -0.0125 3 0 ]
[.40476 -0.0125 -3 -9 ]
[.40476 -0.0125 3 0 ]
[.53175 -0.0125 -3 -9 ]
[.53175 -0.0125 3 0 ]
[.65873 -0.0125 -6 -9 ]
[.65873 -0.0125 6 0 ]
[.78571 -0.0125 -6 -9 ]
[.78571 -0.0125 6 0 ]
[.9127 -0.0125 -6 -9 ]
[.9127 -0.0125 6 0 ]
[.01131 .12361 -24 -4.5 ]
[.01131 .12361 0 4.5 ]
[.01131 .24721 -24 -4.5 ]
[.01131 .24721 0 4.5 ]
[.01131 .37082 -24 -4.5 ]
[.01131 .37082 0 4.5 ]
[.01131 .49443 -24 -4.5 ]
[.01131 .49443 0 4.5 ]
[.01131 .61803 -24 -4.5 ]
[.01131 .61803 0 4.5 ]
[.5 .63053 -35 0 ]
[.5 .63053 35 12.75 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.15079 0 m
.15079 .00625 L
s
[(2)] .15079 -0.0125 0 1 Mshowa
.27778 0 m
.27778 .00625 L
s
[(4)] .27778 -0.0125 0 1 Mshowa
.40476 0 m
.40476 .00625 L
s
[(6)] .40476 -0.0125 0 1 Mshowa
.53175 0 m
.53175 .00625 L
s
[(8)] .53175 -0.0125 0 1 Mshowa
.65873 0 m
.65873 .00625 L
s
[(10)] .65873 -0.0125 0 1 Mshowa
.78571 0 m
.78571 .00625 L
s
[(12)] .78571 -0.0125 0 1 Mshowa
.9127 0 m
.9127 .00625 L
s
[(14)] .9127 -0.0125 0 1 Mshowa
.125 Mabswid
.05556 0 m
.05556 .00375 L
s
.0873 0 m
.0873 .00375 L
s
.11905 0 m
.11905 .00375 L
s
.18254 0 m
.18254 .00375 L
s
.21429 0 m
.21429 .00375 L
s
.24603 0 m
.24603 .00375 L
s
.30952 0 m
.30952 .00375 L
s
.34127 0 m
.34127 .00375 L
s
.37302 0 m
.37302 .00375 L
s
.43651 0 m
.43651 .00375 L
s
.46825 0 m
.46825 .00375 L
s
.5 0 m
.5 .00375 L
s
.56349 0 m
.56349 .00375 L
s
.59524 0 m
.59524 .00375 L
s
.62698 0 m
.62698 .00375 L
s
.69048 0 m
.69048 .00375 L
s
.72222 0 m
.72222 .00375 L
s
.75397 0 m
.75397 .00375 L
s
.81746 0 m
.81746 .00375 L
s
.84921 0 m
.84921 .00375 L
s
.88095 0 m
.88095 .00375 L
s
.94444 0 m
.94444 .00375 L
s
.97619 0 m
.97619 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
.02381 .12361 m
.03006 .12361 L
s
[(0.01)] .01131 .12361 1 0 Mshowa
.02381 .24721 m
.03006 .24721 L
s
[(0.02)] .01131 .24721 1 0 Mshowa
.02381 .37082 m
.03006 .37082 L
s
[(0.03)] .01131 .37082 1 0 Mshowa
.02381 .49443 m
.03006 .49443 L
s
[(0.04)] .01131 .49443 1 0 Mshowa
.02381 .61803 m
.03006 .61803 L
s
[(0.05)] .01131 .61803 1 0 Mshowa
.125 Mabswid
.02381 .02472 m
.02756 .02472 L
s
.02381 .04944 m
.02756 .04944 L
s
.02381 .07416 m
.02756 .07416 L
s
.02381 .09889 m
.02756 .09889 L
s
.02381 .14833 m
.02756 .14833 L
s
.02381 .17305 m
.02756 .17305 L
s
.02381 .19777 m
.02756 .19777 L
s
.02381 .22249 m
.02756 .22249 L
s
.02381 .27193 m
.02756 .27193 L
s
.02381 .29666 m
.02756 .29666 L
s
.02381 .32138 m
.02756 .32138 L
s
.02381 .3461 m
.02756 .3461 L
s
.02381 .39554 m
.02756 .39554 L
s
.02381 .42026 m
.02756 .42026 L
s
.02381 .44498 m
.02756 .44498 L
s
.02381 .46971 m
.02756 .46971 L
s
.02381 .51915 m
.02756 .51915 L
s
.02381 .54387 m
.02756 .54387 L
s
.02381 .56859 m
.02756 .56859 L
s
.02381 .59331 m
.02756 .59331 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.5 .63053 -96 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Price) show
99.000 13.000 moveto
(level) show
129.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 .4 1 r
.5 Mabswid
.02381 .39873 m
.0873 0 L
.15079 0 L
.21429 0 L
.27778 0 L
.34127 0 L
.40476 0 L
.46825 0 L
.53175 0 L
.59524 0 L
.65873 0 L
.72222 0 L
.78571 0 L
.84921 0 L
.9127 0 L
.97619 0 L
s
MathSubEnd
P
% End of sub-graphic
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.522676 0.0252259 0.97619 1.03426 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.0529743 0.952381 [
[.5 2.23742 -59 0 ]
[.5 2.23742 59 13.4375 ]
[ 0 0 0 0 ]
[ 1 2.22492 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
gsave
.5 2.23742 -120 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.4375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.438 moveto
%%IncludeResource: font Courier-Bold
%%IncludeFont: Courier-Bold
/Courier-Bold findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.438 moveto
%%IncludeResource: font Courier-Bold
%%IncludeFont: Courier-Bold
/Courier-Bold findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Inflation) show
123.000 13.438 moveto
(Targeting) show
177.000 13.438 moveto
%%IncludeResource: font Courier-Bold
%%IncludeFont: Courier-Bold
/Courier-Bold findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 2.22492 L
0 2.22492 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0238095 0.0529743 0.97619 0.641578 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0634921 2.00577e-018 77.2542 [
[.15079 -0.0125 -3 -9 ]
[.15079 -0.0125 3 0 ]
[.27778 -0.0125 -3 -9 ]
[.27778 -0.0125 3 0 ]
[.40476 -0.0125 -3 -9 ]
[.40476 -0.0125 3 0 ]
[.53175 -0.0125 -3 -9 ]
[.53175 -0.0125 3 0 ]
[.65873 -0.0125 -6 -9 ]
[.65873 -0.0125 6 0 ]
[.78571 -0.0125 -6 -9 ]
[.78571 -0.0125 6 0 ]
[.9127 -0.0125 -6 -9 ]
[.9127 -0.0125 6 0 ]
[.01131 .15451 -30 -4.5 ]
[.01131 .15451 0 4.5 ]
[.01131 .30902 -30 -4.5 ]
[.01131 .30902 0 4.5 ]
[.01131 .46353 -30 -4.5 ]
[.01131 .46353 0 4.5 ]
[.01131 .61803 -30 -4.5 ]
[.01131 .61803 0 4.5 ]
[.5 .63053 -113 0 ]
[.5 .63053 113 12.75 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.15079 0 m
.15079 .00625 L
s
[(2)] .15079 -0.0125 0 1 Mshowa
.27778 0 m
.27778 .00625 L
s
[(4)] .27778 -0.0125 0 1 Mshowa
.40476 0 m
.40476 .00625 L
s
[(6)] .40476 -0.0125 0 1 Mshowa
.53175 0 m
.53175 .00625 L
s
[(8)] .53175 -0.0125 0 1 Mshowa
.65873 0 m
.65873 .00625 L
s
[(10)] .65873 -0.0125 0 1 Mshowa
.78571 0 m
.78571 .00625 L
s
[(12)] .78571 -0.0125 0 1 Mshowa
.9127 0 m
.9127 .00625 L
s
[(14)] .9127 -0.0125 0 1 Mshowa
.125 Mabswid
.05556 0 m
.05556 .00375 L
s
.0873 0 m
.0873 .00375 L
s
.11905 0 m
.11905 .00375 L
s
.18254 0 m
.18254 .00375 L
s
.21429 0 m
.21429 .00375 L
s
.24603 0 m
.24603 .00375 L
s
.30952 0 m
.30952 .00375 L
s
.34127 0 m
.34127 .00375 L
s
.37302 0 m
.37302 .00375 L
s
.43651 0 m
.43651 .00375 L
s
.46825 0 m
.46825 .00375 L
s
.5 0 m
.5 .00375 L
s
.56349 0 m
.56349 .00375 L
s
.59524 0 m
.59524 .00375 L
s
.62698 0 m
.62698 .00375 L
s
.69048 0 m
.69048 .00375 L
s
.72222 0 m
.72222 .00375 L
s
.75397 0 m
.75397 .00375 L
s
.81746 0 m
.81746 .00375 L
s
.84921 0 m
.84921 .00375 L
s
.88095 0 m
.88095 .00375 L
s
.94444 0 m
.94444 .00375 L
s
.97619 0 m
.97619 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
.02381 .15451 m
.03006 .15451 L
s
[(0.002)] .01131 .15451 1 0 Mshowa
.02381 .30902 m
.03006 .30902 L
s
[(0.004)] .01131 .30902 1 0 Mshowa
.02381 .46353 m
.03006 .46353 L
s
[(0.006)] .01131 .46353 1 0 Mshowa
.02381 .61803 m
.03006 .61803 L
s
[(0.008)] .01131 .61803 1 0 Mshowa
.125 Mabswid
.02381 .03863 m
.02756 .03863 L
s
.02381 .07725 m
.02756 .07725 L
s
.02381 .11588 m
.02756 .11588 L
s
.02381 .19314 m
.02756 .19314 L
s
.02381 .23176 m
.02756 .23176 L
s
.02381 .27039 m
.02756 .27039 L
s
.02381 .34764 m
.02756 .34764 L
s
.02381 .38627 m
.02756 .38627 L
s
.02381 .4249 m
.02756 .4249 L
s
.02381 .50215 m
.02756 .50215 L
s
.02381 .54078 m
.02756 .54078 L
s
.02381 .57941 m
.02756 .57941 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.5 .63053 -174 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Cross) show
93.000 13.000 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
99.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(sectional) show
159.000 13.000 moveto
(variability) show
231.000 13.000 moveto
(of) show
249.000 13.000 moveto
(prices) show
285.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 .4 1 r
.5 Mabswid
.02381 .48234 m
.0873 .20672 L
.15079 .11733 L
.21429 .07442 L
.27778 .05002 L
.34127 .03481 L
.40476 .02477 L
.46825 .01789 L
.53175 .01305 L
.59524 .00959 L
.65873 .00709 L
.72222 .00526 L
.78571 .00391 L
.84921 .00292 L
.9127 .00218 L
.97619 .00163 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.0238095 0.818159 0.97619 1.40676 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0634921 0 0.618034 [
[.15079 -0.0125 -3 -9 ]
[.15079 -0.0125 3 0 ]
[.27778 -0.0125 -3 -9 ]
[.27778 -0.0125 3 0 ]
[.40476 -0.0125 -3 -9 ]
[.40476 -0.0125 3 0 ]
[.53175 -0.0125 -3 -9 ]
[.53175 -0.0125 3 0 ]
[.65873 -0.0125 -6 -9 ]
[.65873 -0.0125 6 0 ]
[.78571 -0.0125 -6 -9 ]
[.78571 -0.0125 6 0 ]
[.9127 -0.0125 -6 -9 ]
[.9127 -0.0125 6 0 ]
[.01131 .12361 -18 -4.5 ]
[.01131 .12361 0 4.5 ]
[.01131 .24721 -18 -4.5 ]
[.01131 .24721 0 4.5 ]
[.01131 .37082 -18 -4.5 ]
[.01131 .37082 0 4.5 ]
[.01131 .49443 -18 -4.5 ]
[.01131 .49443 0 4.5 ]
[.01131 .61803 -6 -4.5 ]
[.01131 .61803 0 4.5 ]
[.5 .63053 -20 0 ]
[.5 .63053 20 12.75 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.15079 0 m
.15079 .00625 L
s
[(2)] .15079 -0.0125 0 1 Mshowa
.27778 0 m
.27778 .00625 L
s
[(4)] .27778 -0.0125 0 1 Mshowa
.40476 0 m
.40476 .00625 L
s
[(6)] .40476 -0.0125 0 1 Mshowa
.53175 0 m
.53175 .00625 L
s
[(8)] .53175 -0.0125 0 1 Mshowa
.65873 0 m
.65873 .00625 L
s
[(10)] .65873 -0.0125 0 1 Mshowa
.78571 0 m
.78571 .00625 L
s
[(12)] .78571 -0.0125 0 1 Mshowa
.9127 0 m
.9127 .00625 L
s
[(14)] .9127 -0.0125 0 1 Mshowa
.125 Mabswid
.05556 0 m
.05556 .00375 L
s
.0873 0 m
.0873 .00375 L
s
.11905 0 m
.11905 .00375 L
s
.18254 0 m
.18254 .00375 L
s
.21429 0 m
.21429 .00375 L
s
.24603 0 m
.24603 .00375 L
s
.30952 0 m
.30952 .00375 L
s
.34127 0 m
.34127 .00375 L
s
.37302 0 m
.37302 .00375 L
s
.43651 0 m
.43651 .00375 L
s
.46825 0 m
.46825 .00375 L
s
.5 0 m
.5 .00375 L
s
.56349 0 m
.56349 .00375 L
s
.59524 0 m
.59524 .00375 L
s
.62698 0 m
.62698 .00375 L
s
.69048 0 m
.69048 .00375 L
s
.72222 0 m
.72222 .00375 L
s
.75397 0 m
.75397 .00375 L
s
.81746 0 m
.81746 .00375 L
s
.84921 0 m
.84921 .00375 L
s
.88095 0 m
.88095 .00375 L
s
.94444 0 m
.94444 .00375 L
s
.97619 0 m
.97619 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
.02381 .12361 m
.03006 .12361 L
s
[(0.2)] .01131 .12361 1 0 Mshowa
.02381 .24721 m
.03006 .24721 L
s
[(0.4)] .01131 .24721 1 0 Mshowa
.02381 .37082 m
.03006 .37082 L
s
[(0.6)] .01131 .37082 1 0 Mshowa
.02381 .49443 m
.03006 .49443 L
s
[(0.8)] .01131 .49443 1 0 Mshowa
.02381 .61803 m
.03006 .61803 L
s
[(1)] .01131 .61803 1 0 Mshowa
.125 Mabswid
.02381 .0309 m
.02756 .0309 L
s
.02381 .0618 m
.02756 .0618 L
s
.02381 .09271 m
.02756 .09271 L
s
.02381 .15451 m
.02756 .15451 L
s
.02381 .18541 m
.02756 .18541 L
s
.02381 .21631 m
.02756 .21631 L
s
.02381 .27812 m
.02756 .27812 L
s
.02381 .30902 m
.02756 .30902 L
s
.02381 .33992 m
.02756 .33992 L
s
.02381 .40172 m
.02756 .40172 L
s
.02381 .43262 m
.02756 .43262 L
s
.02381 .46353 m
.02756 .46353 L
s
.02381 .52533 m
.02756 .52533 L
s
.02381 .55623 m
.02756 .55623 L
s
.02381 .58713 m
.02756 .58713 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.5 .63053 -81 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Output) show
99.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 .4 1 r
.5 Mabswid
.02381 .5981 m
.0873 .25633 L
.15079 .14548 L
.21429 .09228 L
.27778 .06203 L
.34127 .04317 L
.40476 .03071 L
.46825 .02218 L
.53175 .01618 L
.59524 .0119 L
.65873 .00879 L
.72222 .00652 L
.78571 .00485 L
.84921 .00362 L
.9127 .0027 L
.97619 .00202 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.0238095 1.58334 0.97619 2.17195 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0634921 1.61546e-017 12.3607 [
[.15079 -0.0125 -3 -9 ]
[.15079 -0.0125 3 0 ]
[.27778 -0.0125 -3 -9 ]
[.27778 -0.0125 3 0 ]
[.40476 -0.0125 -3 -9 ]
[.40476 -0.0125 3 0 ]
[.53175 -0.0125 -3 -9 ]
[.53175 -0.0125 3 0 ]
[.65873 -0.0125 -6 -9 ]
[.65873 -0.0125 6 0 ]
[.78571 -0.0125 -6 -9 ]
[.78571 -0.0125 6 0 ]
[.9127 -0.0125 -6 -9 ]
[.9127 -0.0125 6 0 ]
[.01131 .12361 -24 -4.5 ]
[.01131 .12361 0 4.5 ]
[.01131 .24721 -24 -4.5 ]
[.01131 .24721 0 4.5 ]
[.01131 .37082 -24 -4.5 ]
[.01131 .37082 0 4.5 ]
[.01131 .49443 -24 -4.5 ]
[.01131 .49443 0 4.5 ]
[.01131 .61803 -24 -4.5 ]
[.01131 .61803 0 4.5 ]
[.5 .63053 -35 0 ]
[.5 .63053 35 12.75 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.15079 0 m
.15079 .00625 L
s
[(2)] .15079 -0.0125 0 1 Mshowa
.27778 0 m
.27778 .00625 L
s
[(4)] .27778 -0.0125 0 1 Mshowa
.40476 0 m
.40476 .00625 L
s
[(6)] .40476 -0.0125 0 1 Mshowa
.53175 0 m
.53175 .00625 L
s
[(8)] .53175 -0.0125 0 1 Mshowa
.65873 0 m
.65873 .00625 L
s
[(10)] .65873 -0.0125 0 1 Mshowa
.78571 0 m
.78571 .00625 L
s
[(12)] .78571 -0.0125 0 1 Mshowa
.9127 0 m
.9127 .00625 L
s
[(14)] .9127 -0.0125 0 1 Mshowa
.125 Mabswid
.05556 0 m
.05556 .00375 L
s
.0873 0 m
.0873 .00375 L
s
.11905 0 m
.11905 .00375 L
s
.18254 0 m
.18254 .00375 L
s
.21429 0 m
.21429 .00375 L
s
.24603 0 m
.24603 .00375 L
s
.30952 0 m
.30952 .00375 L
s
.34127 0 m
.34127 .00375 L
s
.37302 0 m
.37302 .00375 L
s
.43651 0 m
.43651 .00375 L
s
.46825 0 m
.46825 .00375 L
s
.5 0 m
.5 .00375 L
s
.56349 0 m
.56349 .00375 L
s
.59524 0 m
.59524 .00375 L
s
.62698 0 m
.62698 .00375 L
s
.69048 0 m
.69048 .00375 L
s
.72222 0 m
.72222 .00375 L
s
.75397 0 m
.75397 .00375 L
s
.81746 0 m
.81746 .00375 L
s
.84921 0 m
.84921 .00375 L
s
.88095 0 m
.88095 .00375 L
s
.94444 0 m
.94444 .00375 L
s
.97619 0 m
.97619 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
.02381 .12361 m
.03006 .12361 L
s
[(0.01)] .01131 .12361 1 0 Mshowa
.02381 .24721 m
.03006 .24721 L
s
[(0.02)] .01131 .24721 1 0 Mshowa
.02381 .37082 m
.03006 .37082 L
s
[(0.03)] .01131 .37082 1 0 Mshowa
.02381 .49443 m
.03006 .49443 L
s
[(0.04)] .01131 .49443 1 0 Mshowa
.02381 .61803 m
.03006 .61803 L
s
[(0.05)] .01131 .61803 1 0 Mshowa
.125 Mabswid
.02381 .02472 m
.02756 .02472 L
s
.02381 .04944 m
.02756 .04944 L
s
.02381 .07416 m
.02756 .07416 L
s
.02381 .09889 m
.02756 .09889 L
s
.02381 .14833 m
.02756 .14833 L
s
.02381 .17305 m
.02756 .17305 L
s
.02381 .19777 m
.02756 .19777 L
s
.02381 .22249 m
.02756 .22249 L
s
.02381 .27193 m
.02756 .27193 L
s
.02381 .29666 m
.02756 .29666 L
s
.02381 .32138 m
.02756 .32138 L
s
.02381 .3461 m
.02756 .3461 L
s
.02381 .39554 m
.02756 .39554 L
s
.02381 .42026 m
.02756 .42026 L
s
.02381 .44498 m
.02756 .44498 L
s
.02381 .46971 m
.02756 .46971 L
s
.02381 .51915 m
.02756 .51915 L
s
.02381 .54387 m
.02756 .54387 L
s
.02381 .56859 m
.02756 .56859 L
s
.02381 .59331 m
.02756 .59331 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.5 .63053 -96 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Price) show
99.000 13.000 moveto
(level) show
129.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 .4 1 r
.5 Mabswid
.02381 .39873 m
.0873 .39873 L
.15079 .39873 L
.21429 .39873 L
.27778 .39873 L
.34127 .39873 L
.40476 .39873 L
.46825 .39873 L
.53175 .39873 L
.59524 .39873 L
.65873 .39873 L
.72222 .39873 L
.78571 .39873 L
.84921 .39873 L
.9127 .39873 L
.97619 .39873 L
s
MathSubEnd
P
% End of sub-graphic
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{700, 741.625},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000:l0002iB000`400?l00000o`00003oo`3ooooo
0?oookh0oooo003o0?ooool0oooo_P3oool00?l0ooooo`3ooonn0?ooo`00o`3ooooo0?oookh0oooo
003o0?ooool0oooo_P3oool00?l0ooooo`3ooonn0?ooo`00o`3ooooo0?oookh0oooo003o0?ooool0
oooo_P3oool00?l0ooooo`3ooonn0?ooo`00o`3ooooo0?oookh0oooo003o0?ooool0oooo_P3oool0
0?l0ooooo`3ooonn0?ooo`00o`3ooooo0?oookh0oooo003o0?ooool0oooo_P3oool00?l0ooooo`3o
oonn0?ooo`00o`3ooooo0?oookh0oooo003o0?ooool0oooo_P3oool00?l0ooooo`3ooonn0?ooo`00
o`3ooooo0?oookh0oooo003o0?ooool0oooo_P3oool00?l0ooooo`3ooonn0?ooo`00o`3ooooo0?oo
okh0oooo003o0?ooool0oooo_P3oool00?l0ooooo`3ooonn0?ooo`00o`3ooooo0?oookh0oooo003o
0?ooool0oooo_P3oool00?l0ooooo`3ooonn0?ooo`00o`3ooooo0?oookh0oooo003o0?ooool0oooo
_P3oool00?l0ooooo`3ooonn0?ooo`00o`3ooooo0?oookh0oooo003o0?ooool0oooo_P3oool00?l0
ooooo`3ooonn0?ooo`00o`3ooooo0?oookh0oooo001]0?ooo`@00000703oool3000001X0oooo0`00
000L0?ooo`800000603oool500000080oooo0P00000F0?ooo`D0000000<0oooo0000000000000P00
000D0?ooo`D000000`3oool300000980oooo1000000M0?ooo`<000006@3oool3000001`0oooo0P00
000I0?ooo`D000000P3oool2000001D0oooo1@0000000`3oool0000000000002000001@0oooo1@00
00030?ooo`<00000@@3oool006d0oooo00<000000?ooo`3oool07P3oool00`000000oooo0?ooo`0I
0?ooo`040000003oool0oooo000001X0oooo00@000000?ooo`3oool000006@3oool01@000000oooo
0?ooo`3oool000000080oooo00<000000?ooo`3oool05@3oool01@000000oooo0?ooo`3oool00000
01T0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`2A0?ooo`030000003oool0oooo
01l0oooo00<000000?ooo`3oool0603oool010000000oooo0?ooo`00000J0?ooo`040000003oool0
oooo000001X0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo01@0oooo
00D000000?ooo`3oool0oooo0000000I0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3o
ool0@03oool006h0oooo00<000000?ooo`3oool06P3oool5000001X0oooo00@000000?ooo`3oool0
00006P3oool010000000oooo0?ooo`00000I0?ooo`050000003oool0oooo0?ooo`0000000P3oool0
0`000000oooo0?ooo`0E0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool05P3oool0
10000000oooo0?ooo`3oool5000009<0oooo00<000000?ooo`3oool06`3oool5000001T0oooo00@0
00000?ooo`3oool000006P3oool010000000oooo0?ooo`00000J0?ooo`050000003oool0oooo0?oo
o`0000000P3oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo0080oooo00<000000?oo
o`3oool05P3oool010000000oooo0?ooo`3oool500000440oooo001_0?ooo`030000003oool0oooo
01T0oooo00@000000?ooo`3oool000006`3oool3000001`0oooo0P00000J0?ooo`050000003oool0
oooo0?ooo`0000000P3oool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo00<0oooo00<0
00000?ooo`3oool05@3oool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool0
T`3oool00`000000oooo0?ooo`0J0?ooo`040000003oool0oooo000001X0oooo0`00000L0?ooo`80
00006`3oool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool0503oool00`00
0000oooo0?ooo`030?ooo`030000003oool0oooo01D0oooo00D000000?ooo`3oool0oooo00000002
0?ooo`030000003oool0oooo0400oooo001]0?ooo`040000003oool0oooo000001/0oooo00<00000
0?ooo`000000703oool00`000000oooo0?ooo`0J0?ooo`040000003oool0oooo000001T0oooo00D0
00000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo01D0oooo00D000000?ooo`3oool0
oooo000000020?ooo`030000003oool0oooo01@0oooo00<000000?ooo`3oool00P3oool00`000000
oooo0000002C0?ooo`040000003oool0oooo000001`0oooo00<000000?ooo`0000006`3oool00`00
0000oooo0?ooo`0J0?ooo`040000003oool0oooo000001X0oooo00D000000?ooo`3oool0oooo0000
00020?ooo`030000003oool0oooo01@0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000
003oool0oooo01@0oooo00<000000?ooo`3oool00P3oool00`000000oooo000000120?ooo`00KP3o
ool2000001d0oooo0P00000L0?ooo`<000006`3oool2000001T0oooo0P0000040?ooo`8000005`3o
ool2000000@0oooo0P00000F0?ooo`8000001@3oool2000009@0oooo0P00000N0?ooo`8000006`3o
ool3000001/0oooo0P00000J0?ooo`800000103oool2000001H0oooo0P0000040?ooo`8000005P3o
ool2000000D0oooo0P0000120?ooo`00o`3ooooo0?oookh0oooo003o0?ooool0oooo_P3oool00?l0
ooooo`3ooonn0?ooo`00o`3ooooo0?oookh0oooo003o0?ooool0oooo_P3oool004/0oooo5@00003E
001Vo`H00000H03oooo4000002L006Ko1@00000a0?ooo`00D@3oool00`000000oooo0?ooo`040?oo
o`030000003oool0oooo00D0oooo00<006Ko0?ooo`3oool0103oool00`000000oooo0?ooo`050?oo
o`030000003oool0oooo00D0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`050?oo
o`030000003oool0oooo00@0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`040?oo
o`030000003oool0oooo00D0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`040?oo
o`030000003oool0oooo00D0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`050?oo
o`030000003oool0oooo00D0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`050?oo
o`030000003oool0oooo00@0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`050?oo
o`030000003oool0oooo00@0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`040?oo
o`030000003oool0oooo00D0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`050?oo
o`030000003oool0oooo00D0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`1Z0?oo
o`030000003oool0oooo00D0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`050?oo
o`030000003oool0oooo00@0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`040?oo
o`030000003oool0oooo00D0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`040?oo
o`030000003oool0oooo00D0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`050?oo
o`030000003oool0oooo00D0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`050?oo
o`030000003oool0oooo00@0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`050?oo
o`030000003oool0oooo00@0oooo00<00000001Vo`00I_l0:`00I_l00`000000oooo0?ooo`040?oo
o`030000003oool0oooo00D0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`050?oo
o`030000003oool0oooo00D0oooo00<000000?ooo`3oool0=03oool00540oooo00<000000?ooo`3o
ool0303oool00`00I_l0oooo0?ooo`3o0?ooocl0oooo00<000000?ooo`3oool0O`3oool?001VohX0
oooo001A0?ooo`030000003oool0oooo00`0oooo00<006Ko0?ooo`3oool0o`3ooolo0?ooo`030000
003oool0oooo06l0oooo4000I_nI0?ooo`00D@3oool00`000000oooo0?ooo`0;0?ooo`03001Vo`3o
ool0oooo0?l0oooo@03oool00`000000oooo0?ooo`1T0?ooo`/006KoZ@3oool00540oooo00<00000
0?ooo`3oool02`3oool00`00I_l0oooo0?ooo`3o0?oood00oooo00<000000?ooo`3oool0G03oool8
001Vok@0oooo001A0?ooo`030000003oool0oooo00/0oooo00<006Ko0?ooo`3oool0o`3ooom00?oo
o`030000003oool0oooo05D0oooo1`00I_nl0?ooo`00D@3oool00`000000oooo0?ooo`0;0?ooo`03
001Vo`3oool0oooo0?l0oooo@03oool00`000000oooo0?ooo`1=0?ooo`P006Ko``3oool00540oooo
00<000000?ooo`3oool02`3oool00`00I_l0oooo0?ooo`3o0?oood00oooo00<000000?ooo`3oool0
B03oool5001Vol/0oooo001A0?ooo`800000303oool00`00I_l0oooo0?ooo`3o0?oood00oooo0P00
00150?ooo`@006Kod03oool00540oooo00<000000?ooo`3oool02`3oool00`00I_l0oooo0?ooo`3o
0?oood00oooo00<000000?ooo`3oool0@03oool4001Vom@0oooo001A0?ooo`030000003oool0oooo
00/0oooo00<006Ko0?ooo`3oool0o`3ooom00?ooo`030000003oool0oooo03`0oooo1000I_oH0?oo
o`00D@3oool00`000000oooo0?ooo`0:0?ooo`03001Vo`3oool0oooo0?l0oooo@@3oool00`000000
oooo0?ooo`0i0?ooo`<006Kog03oool00540oooo00<000000?ooo`3oool02P3oool00`00I_l0oooo
0?ooo`3o0?oood40oooo00<000000?ooo`3oool0=`3oool2001Voml0oooo001A0?ooo`030000003o
ool0oooo00X0oooo00<006Ko0?ooo`3oool0o`3ooom10?ooo`030000003oool0oooo03@0oooo0`00
I_oQ0?ooo`00D@3oool00`000000oooo0?ooo`0:0?ooo`03001Vo`3oool0oooo0?l0oooo@@3oool0
0`000000oooo0?ooo`0a0?ooo`<006Koi03oool00540oooo00<000000?ooo`3oool02P3oool00`00
I_l0oooo0?ooo`3o0?oood40oooo00<000000?ooo`3oool0;`3oool2001VonL0oooo001A0?ooo`03
0000003oool0oooo00X0oooo00<006Ko0?ooo`3oool0o`3ooom10?ooo`030000003oool0oooo02`0
oooo0`00I_oY0?ooo`00D@3oool2000000/0oooo00<006Ko0?ooo`3oool0o`3ooom10?ooo`800000
:`3oool2001Von`0oooo001A0?ooo`030000003oool0oooo00X0oooo00<006Ko0?ooo`3oool0o`3o
oom10?ooo`030000003oool0oooo02P0oooo0P00I_o^0?ooo`00D@3oool00`000000oooo0?ooo`09
0?ooo`03001Vo`3oool0oooo0?l0oooo@P3oool00`000000oooo0?ooo`0W0?ooo`03001Vo`3oool0
oooo0>h0oooo001A0?ooo`030000003oool0oooo00T0oooo00<006Ko0?ooo`3oool0o`3ooom20?oo
o`030000003oool0oooo02D0oooo0P00I_oa0?ooo`00D@3oool00`000000oooo0?ooo`090?ooo`03
001Vo`3oool0oooo0?l0oooo@P3oool00`000000oooo0?ooo`0T0?ooo`03001Vo`3oool0oooo0?40
oooo001A0?ooo`030000003oool0oooo00T0oooo00<006Ko0?ooo`3oool0o`3ooom20?ooo`030000
003oool0oooo0280oooo0P00I_od0?ooo`00D@3oool00`000000oooo0?ooo`090?ooo`03001Vo`3o
ool0oooo0?l0oooo@P3oool00`000000oooo0?ooo`0Q0?ooo`03001Vo`3oool0oooo0?@0oooo001A
0?ooo`030000003oool0oooo00T0oooo00<006Ko0?ooo`3oool0o`3ooom20?ooo`030000003oool0
oooo01l0oooo0P00I_og0?ooo`00D@3oool00`000000oooo0?ooo`090?ooo`03001Vo`3oool0oooo
0?l0oooo@P3oool00`000000oooo0?ooo`0N0?ooo`03001Vo`3oool0oooo0?L0oooo001A0?ooo`80
00002@3oool00`00I_l0oooo0?ooo`3o0?oood<0oooo0P00000M0?ooo`8006KonP3oool00540oooo
00<000000?ooo`3oool0203oool00`00I_l0oooo0?ooo`3o0?oood<0oooo00<000000?ooo`3oool0
6`3oool00`00I_l0oooo0?ooo`3j0?ooo`00D@3oool00`000000oooo0?ooo`080?ooo`03001Vo`3o
ool0oooo0?l0oooo@`3oool00`000000oooo0?ooo`0J0?ooo`03001Vo`3oool0oooo0?/0oooo001A
0?ooo`030000003oool0oooo00P0oooo00<006Ko0?ooo`3oool0o`3ooom30?ooo`030000003oool0
oooo01X0oooo00<006Ko0?ooo`3oool0n`3oool00540oooo00<000000?ooo`3oool0203oool00`00
I_l0oooo0?ooo`3o0?oood<0oooo00<000000?ooo`3oool06@3oool00`00I_l0oooo0?ooo`3l0?oo
o`00D@3oool00`000000oooo0?ooo`080?ooo`03001Vo`3oool0oooo0?l0oooo@`3oool00`000000
oooo0?ooo`0H0?ooo`03001Vo`3oool0oooo0?d0oooo001A0?ooo`030000003oool0oooo00P0oooo
00<006Ko0?ooo`3oool0o`3ooom30?ooo`030000003oool0oooo01L0oooo00<006Ko0?ooo`3oool0
oP3oool00540oooo00<000000?ooo`3oool0203oool00`00I_l0oooo0?ooo`3o0?oood<0oooo00<0
00000?ooo`3oool05`3oool00`00I_l0oooo0?ooo`3n0?ooo`00<P3oool2000000@0oooo0P000004
0?ooo`800000103oool2000000<0oooo100000040?ooo`030000003oool0oooo00L0oooo00<006Ko
0?ooo`3oool0o`3ooolU0?ooo`800000103oool2000000@0oooo0P0000040?ooo`8000000`3oool4
000000@0oooo00<000000?ooo`3oool05P3oool00`00I_l0oooo0?ooo`3o0?ooo`00<@3oool01000
0000oooo0?ooo`0000080?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool00000
0P3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00L0oooo00<006Ko0?ooo`3oool0
o`3ooolT0?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`3oool000000P3oool01000
0000oooo0?ooo`0000020?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool05@3oool0
0`00I_l0oooo0?ooo`3o0?ooo`40oooo000a0?ooo`040000003oool0oooo000000P0oooo00@00000
0?ooo`3oool000000P3oool010000000oooo0?ooo`0000030?ooo`030000003oool0oooo00@0oooo
0P0000080?ooo`03001Vo`3oool0oooo0?l0oooo903oool010000000oooo0?ooo`0000080?ooo`04
0000003oool0oooo00000080oooo00@000000?ooo`3oool000000`3oool00`000000oooo0?ooo`04
0?ooo`8000005P3oool00`00I_l0oooo0?ooo`3o0?ooo`40oooo000a0?ooo`040000003oool0oooo
000000P0oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000040?ooo`030000
003oool0oooo00<0oooo00<000000?ooo`3oool01`3oool00`00I_l0oooo0?ooo`3o0?ooob@0oooo
00@000000?ooo`3oool00000203oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo
000000@0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0D0?ooo`03001Vo`3oool0
oooo0?l0oooo0P3oool00340oooo00@000000?ooo`3oool00000203oool010000000oooo0?ooo`00
00020?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool00000103oool00`000000
oooo0?ooo`070?ooo`03001Vo`3oool0oooo0?l0oooo903oool010000000oooo0?ooo`0000080?oo
o`040000003oool0oooo00000080oooo00@000000?ooo`3oool000000P3oool010000000oooo0?oo
o`0000040?ooo`030000003oool0oooo01<0oooo00<006Ko0?ooo`3oool0o`3oool30?ooo`00<P3o
ool2000000X0oooo0P0000040?ooo`800000103oool2000000D0oooo00<000000?ooo`3oool01`3o
ool00`00I_l0oooo0?ooo`3o0?ooobD0oooo0P00000:0?ooo`800000103oool2000000@0oooo0P00
00050?ooo`030000003oool0oooo0180oooo00<006Ko0?ooo`3oool0o`3oool40?ooo`00D@3oool0
0`000000oooo0?ooo`070?ooo`03001Vo`3oool0oooo0?l0ooooA03oool00`000000oooo0?ooo`0B
0?ooo`03001Vo`3oool0oooo0?l0oooo103oool00540oooo00<000000?ooo`3oool01`3oool00`00
I_l0oooo0?ooo`3o0?oood@0oooo00<000000?ooo`3oool04@3oool00`00I_l0oooo0?ooo`3o0?oo
o`D0oooo001A0?ooo`030000003oool0oooo00H0oooo00<006Ko0?ooo`3oool0o`3ooom50?ooo`03
0000003oool0oooo0100oooo00<006Ko0?ooo`3oool0o`3oool60?ooo`00D@3oool00`000000oooo
0?ooo`060?ooo`03001Vo`3oool0oooo0?l0ooooA@3oool00`000000oooo0?ooo`0@0?ooo`03001V
o`3oool0oooo0?l0oooo1P3oool00540oooo00<000000?ooo`3oool01P3oool00`00I_l0oooo0?oo
o`3o0?ooodD0oooo00<000000?ooo`3oool03`3oool00`00I_l0oooo0?ooo`3o0?ooo`L0oooo001A
0?ooo`8000001`3oool00`00I_l0oooo0?ooo`3o0?ooodD0oooo0P00000?0?ooo`03001Vo`3oool0
oooo0?l0oooo203oool00540oooo00<000000?ooo`3oool01P3oool00`00I_l0oooo0?ooo`3o0?oo
odD0oooo00<000000?ooo`3oool03@3oool00`00I_l0oooo0?ooo`3o0?ooo`T0oooo001A0?ooo`03
0000003oool0oooo00H0oooo00<006Ko0?ooo`3oool0o`3ooom50?ooo`030000003oool0oooo00d0
oooo00<006Ko0?ooo`3oool0o`3oool90?ooo`00D@3oool00`000000oooo0?ooo`060?ooo`03001V
o`3oool0oooo0?l0ooooA@3oool00`000000oooo0?ooo`0<0?ooo`03001Vo`3oool0oooo0?l0oooo
2P3oool00540oooo00<000000?ooo`3oool01@3oool00`00I_l0oooo0?ooo`3o0?ooodH0oooo00<0
00000?ooo`3oool0303oool00`00I_l0oooo0?ooo`3o0?ooo`X0oooo001A0?ooo`030000003oool0
oooo00D0oooo00<006Ko0?ooo`3oool0o`3ooom60?ooo`030000003oool0oooo00`0oooo00<006Ko
0?ooo`3oool0o`3oool:0?ooo`00D@3oool00`000000oooo0?ooo`050?ooo`03001Vo`3oool0oooo
0?l0ooooAP3oool00`000000oooo0?ooo`0;0?ooo`03001Vo`3oool0oooo0?l0oooo2`3oool00540
oooo00<000000?ooo`3oool01@3oool00`00I_l0oooo0?ooo`3o0?ooodH0oooo00<000000?ooo`3o
ool02`3oool00`00I_l0oooo0?ooo`3o0?ooo`/0oooo001A0?ooo`030000003oool0oooo00D0oooo
00<006Ko0?ooo`3oool0o`3ooom60?ooo`030000003oool0oooo00/0oooo00<006Ko0?ooo`3oool0
o`3oool;0?ooo`00D@3oool2000000H0oooo00<006Ko0?ooo`3oool0o`3ooom60?ooo`800000303o
ool00`00I_l0oooo0?ooo`3o0?ooo`/0oooo001A0?ooo`030000003oool0oooo00D0oooo00<006Ko
0?ooo`3oool0o`3ooom60?ooo`030000003oool0oooo00X0oooo00<006Ko0?ooo`3oool0o`3oool<
0?ooo`00D@3oool00`000000oooo0?ooo`050?ooo`03001Vo`3oool0oooo0?l0ooooAP3oool00`00
0000oooo0?ooo`0:0?ooo`03001Vo`3oool0oooo0?l0oooo303oool00540oooo00<000000?ooo`3o
ool0103oool00`00I_l0oooo0?ooo`3o0?ooodL0oooo00<000000?ooo`3oool02P3oool00`00I_l0
oooo0?ooo`3o0?ooo``0oooo001A0?ooo`030000003oool0oooo00@0oooo00<006Ko0?ooo`3oool0
o`3ooom70?ooo`030000003oool0oooo00X0oooo00<006Ko0?ooo`3oool0o`3oool<0?ooo`00D@3o
ool00`000000oooo0?ooo`040?ooo`03001Vo`3oool0oooo0?l0ooooA`3oool00`000000oooo0?oo
o`090?ooo`03001Vo`3oool0oooo0?l0oooo3@3oool00540oooo00<000000?ooo`3oool0103oool0
0`00I_l0oooo0?ooo`3o0?ooodL0oooo00<000000?ooo`3oool02@3oool00`00I_l0oooo0?ooo`3o
0?ooo`d0oooo001A0?ooo`030000003oool0oooo00@0oooo00<006Ko0?ooo`3oool0o`3ooom70?oo
o`030000003oool0oooo00T0oooo00<006Ko0?ooo`3oool0o`3oool=0?ooo`00D@3oool00`000000
oooo0?ooo`040?ooo`03001Vo`3oool0oooo0?l0ooooA`3oool00`000000oooo0?ooo`090?ooo`03
001Vo`3oool0oooo0?l0oooo3@3oool00540oooo0P0000050?ooo`03001Vo`3oool0oooo0?l0oooo
A`3oool2000000X0oooo00<006Ko0?ooo`3oool0o`3oool=0?ooo`00D@3oool00`000000oooo0?oo
o`040?ooo`03001Vo`3oool0oooo0?l0ooooA`3oool00`000000oooo0?ooo`080?ooo`03001Vo`3o
ool0oooo0?l0oooo3P3oool00540oooo00<000000?ooo`3oool00`3oool00`00I_l0oooo0?ooo`3o
0?ooodP0oooo00<000000?ooo`3oool0203oool00`00I_l0oooo0?ooo`3o0?ooo`h0oooo001A0?oo
o`030000003oool0oooo00<0oooo00<006Ko0?ooo`3oool0o`3ooom80?ooo`030000003oool0oooo
00P0oooo00<006Ko0?ooo`3oool0o`3oool>0?ooo`00D@3oool00`000000oooo0?ooo`030?ooo`03
001Vo`3oool0oooo0?l0ooooB03oool00`000000oooo0?ooo`080?ooo`03001Vo`3oool0oooo0?l0
oooo3P3oool00540oooo00<000000?ooo`3oool00`3oool00`00I_l0oooo0?ooo`3o0?ooodP0oooo
00<000000?ooo`3oool01`3oool00`00I_l0oooo0?ooo`3o0?ooo`l0oooo001A0?ooo`030000003o
ool0oooo00<0oooo00<006Ko0?ooo`3oool0o`3ooom80?ooo`030000003oool0oooo00L0oooo00<0
06Ko0?ooo`3oool0o`3oool?0?ooo`00D@3oool00`000000oooo0?ooo`030?ooo`03001Vo`3oool0
oooo0?l0ooooB03oool00`000000oooo0?ooo`070?ooo`03001Vo`3oool0oooo0?l0oooo3`3oool0
0380oooo0P0000040?ooo`800000103oool2000000@0oooo0P0000050?ooo`<000000`3oool00`00
0000oooo0?ooo`030?ooo`03001Vo`3oool0oooo0?l0oooo:@3oool2000000@0oooo0P0000040?oo
o`800000103oool2000000D0oooo0`0000030?ooo`030000003oool0oooo00L0oooo00<006Ko0?oo
o`3oool0o`3oool?0?ooo`00<@3oool010000000oooo0?ooo`0000080?ooo`040000003oool0oooo
00000080oooo00@000000?ooo`3oool000001@3oool00`000000oooo0?ooo`020?ooo`030000003o
ool0oooo0080oooo00<006Ko0?ooo`3oool0o`3ooolY0?ooo`040000003oool0oooo000000P0oooo
00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000050?ooo`030000003oool0oooo
0080oooo00<000000?ooo`3oool01`3oool00`00I_l0oooo0?ooo`3o0?ooo`l0oooo000a0?ooo`04
0000003oool0oooo000000P0oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`00
00020?ooo`D000000`3oool2000000<0oooo00<006Ko0?ooo`3oool0o`3ooolY0?ooo`040000003o
ool0oooo000000P0oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000020?oo
o`D000000`3oool2000000L0oooo00<006Ko0?ooo`3oool0o`3oool@0?ooo`00<@3oool010000000
oooo0?ooo`0000080?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool000000P3o
ool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo0080oooo00<006Ko0?ooo`3oool0
o`3ooolY0?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`3oool000000P3oool01000
0000oooo0?ooo`0000020?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`3oool01P3o
ool00`00I_l0oooo0?ooo`3o0?oooa00oooo000a0?ooo`040000003oool0oooo000000P0oooo00@0
00000?ooo`3oool000000P3oool010000000oooo0?ooo`0000030?ooo`030000003oool0000000@0
oooo00<000000?ooo`3oool00P3oool00`00I_l0oooo0?ooo`3o0?ooobT0oooo00@000000?ooo`3o
ool00000203oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo000000<0oooo00<0
00000?ooo`000000103oool00`000000oooo0?ooo`060?ooo`03001Vo`3oool0oooo0?l0oooo403o
ool00380oooo0P00000:0?ooo`800000103oool2000000D0oooo0P0000040?ooo`030000003oool0
oooo0080oooo00<006Ko0?ooo`3oool0o`3ooolZ0?ooo`8000002P3oool2000000@0oooo0P000005
0?ooo`800000103oool00`000000oooo0?ooo`060?ooo`03001Vo`3oool0oooo0?l0oooo403oool0
0540oooo00<000000?ooo`3oool00P3oool00`00I_l0oooo0?ooo`3o0?ooodT0oooo00<000000?oo
o`3oool01@3oool00`00I_l0oooo0?ooo`3o0?oooa40oooo001A0?ooo`030000003oool0oooo0080
oooo00<006Ko0?ooo`3oool0o`3ooom90?ooo`030000003oool0oooo00D0oooo00<006Ko0?ooo`3o
ool0o`3ooolA0?ooo`00D@3oool00`000000oooo0?ooo`020?ooo`03001Vo`3oool0oooo0?l0oooo
B@3oool00`000000oooo0?ooo`050?ooo`03001Vo`3oool0oooo0?l0oooo4@3oool00540oooo00D0
00000?ooo`3oool0oooo001Vo`3o0?oood`0oooo00<000000?ooo`3oool01@3oool00`00I_l0oooo
0?ooo`3o0?oooa40oooo001A0?ooo`050000003oool0oooo0?ooo`00I_l0o`3ooom<0?ooo`030000
003oool0oooo00@0oooo00<006Ko0?ooo`3oool0o`3ooolB0?ooo`00D@3oool200000080oooo00<0
06Ko0?ooo`3oool0o`3ooom:0?ooo`8000001@3oool00`00I_l0oooo0?ooo`3o0?oooa80oooo001A
0?ooo`050000003oool0oooo0?ooo`00I_l0o`3ooom<0?ooo`030000003oool0oooo00@0oooo00<0
06Ko0?ooo`3oool0o`3ooolB0?ooo`00D@3oool01@000000oooo0?ooo`3oool006Ko0?l0ooooC03o
ool00`000000oooo0?ooo`040?ooo`03001Vo`3oool0oooo0?l0oooo4P3oool00540oooo00D00000
0?ooo`3oool0oooo001Vo`3o0?oood`0oooo00<000000?ooo`3oool0103oool00`00I_l0oooo0?oo
o`3o0?oooa80oooo001A0?ooo`050000003oool0oooo0?ooo`00I_l0o`3ooom<0?ooo`030000003o
ool0oooo00<0oooo00<006Ko0?ooo`3oool0o`3ooolC0?ooo`00D@3oool01@000000oooo0?ooo`3o
ool006Ko0?l0ooooC03oool00`000000oooo0?ooo`030?ooo`03001Vo`3oool0oooo0?l0oooo4`3o
ool00540oooo00@000000?ooo`3oool006Koo`3ooom=0?ooo`030000003oool0oooo00<0oooo00<0
06Ko0?ooo`3oool0o`3ooolC0?ooo`00D@3oool010000000oooo0?ooo`00I_oo0?ooodd0oooo00<0
00000?ooo`3oool00`3oool00`00I_l0oooo0?ooo`3o0?oooa<0oooo001A0?ooo`040000003oool0
oooo001Vool0ooooC@3oool00`000000oooo0?ooo`020?ooo`03001Vo`3oool0oooo0?l0oooo503o
ool00540oooo0P0000000`3oool006Ko0?ooo`3o0?oood`0oooo0P0000030?ooo`03001Vo`3oool0
oooo0?l0oooo503oool00540oooo00@000000?ooo`3oool006Koo`3ooom=0?ooo`030000003oool0
oooo0080oooo00<006Ko0?ooo`3oool0o`3ooolD0?ooo`00D@3oool010000000oooo0?ooo`00I_oo
0?ooodd0oooo00<000000?ooo`3oool00P3oool00`00I_l0oooo0?ooo`3o0?oooa@0oooo001A0?oo
o`040000003oool0oooo001Vool0ooooC@3oool00`000000oooo0?ooo`020?ooo`03001Vo`3oool0
oooo0?l0oooo503oool00540oooo00<000000?ooo`00I_l0o`3ooom>0?ooo`050000003oool0oooo
0?ooo`00I_l0o`3ooolG0?ooo`00D@3oool00`000000oooo001Vo`3o0?ooodh0oooo00D000000?oo
o`3oool0oooo001Vo`3o0?oooaL0oooo001A0?ooo`030000003oool006Ko0?l0ooooCP3oool01@00
0000oooo0?ooo`3oool006Ko0?l0oooo5`3oool00540oooo00<000000?ooo`00I_l0o`3ooom>0?oo
o`050000003oool0oooo0?ooo`00I_l0o`3ooolG0?ooo`00D@3oool00`000000oooo001Vo`3o0?oo
odh0oooo00@000000?ooo`3oool006Koo`3ooolH0?ooo`00D@3oool200000003001Vo`3oool0oooo
0?l0ooooC03oool2000000030?ooo`00I_l0oooo0?l0oooo5`3oool00540oooo00<000000?ooo`00
I_l0o`3ooom>0?ooo`040000003oool0oooo001Vool0oooo603oool00540oooo00<000000?ooo`00
I_l0o`3ooom>0?ooo`040000003oool0oooo001Vool0oooo603oool00540oooo00<00000001Vo`3o
ool0o`3ooom>0?ooo`030000003oool006Ko0?l0oooo6@3oool00540oooo00<00000001Vo`3oool0
o`3ooom>0?ooo`030000003oool006Ko0?l0oooo6@3oool00540oooo00<00000001Vo`3oool0o`3o
oom>0?ooo`030000003oool006Ko0?l0oooo6@3oool00540oooo00<00000001Vo`3oool0o`3ooom>
0?ooo`030000003oool006Ko0?l0oooo6@3oool00540oooo00<00000001Vo`3oool0o`3ooom>0?oo
o`030000003oool006Ko0?l0oooo6@3oool00380oooo0P0000040?ooo`800000103oool2000000@0
oooo0P0000030?ooo`<000001@3oool00`00000006Ko0?ooo`3o0?ooobl0oooo0P0000040?ooo`80
0000103oool2000000@0oooo0P0000030?ooo`<000001@3oool00`00000006Ko0?ooo`3o0?oooaT0
oooo000a0?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`3oool000000P3oool01000
0000oooo0?ooo`0000020?ooo`040000003oool0oooo000000@0oooo00<00000001Vo`3oool0o`3o
ool^0?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`3oool000000P3oool010000000
oooo0?ooo`0000020?ooo`040000003oool0oooo000000@0oooo00<00000001Vo`3oool0o`3ooolI
0?ooo`00<@3oool010000000oooo0?ooo`0000080?ooo`040000003oool0oooo00000080oooo00@0
00000?ooo`3oool000000P3oool010000000oooo0?ooo`0000040?ooo`0300000000I_l0oooo0?l0
oooo;P3oool010000000oooo0?ooo`0000080?ooo`040000003oool0oooo00000080oooo00@00000
0?ooo`3oool000000P3oool010000000oooo0?ooo`0000040?ooo`0300000000I_l0oooo0?l0oooo
6@3oool00340oooo00@000000?ooo`3oool00000203oool010000000oooo0?ooo`0000020?ooo`04
0000003oool0oooo00000080oooo0`0000050?ooo`03001Vo`3oool0oooo0?l0oooo;P3oool01000
0000oooo0?ooo`0000080?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool00000
0P3oool3000000D0oooo00<00000001Vo`3oool0o`3ooolI0?ooo`00<@3oool010000000oooo0?oo
o`0000080?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool000000`3oool00`00
0000oooo0?ooo`040?ooo`03001Vo`3oool0oooo0?l0oooo;P3oool010000000oooo0?ooo`000008
0?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool000000`3oool00`000000oooo
0?ooo`040?ooo`03001Vo`3oool0oooo0?l0oooo6@3oool00380oooo0P00000:0?ooo`800000103o
ool2000000@0oooo0`0000040?ooo`03001Vo`3oool0oooo0?l0oooo;`3oool2000000X0oooo0P00
00040?ooo`800000103oool3000000@0oooo00<006Ko0?ooo`3oool0o`3ooolI0?ooo`00D@3oool0
0`00I_l0oooo0?ooo`3o0?ooodh0oooo00<006Ko0?ooo`3oool0o`3ooolI0?ooo`00D@3oool00`00
0000oooo0?ooo`3o0?ooodh0oooo00<000000?ooo`3oool0o`3ooolI0?ooo`00D@3oool00`000000
oooo0?ooo`3o0?ooodh0oooo00<000000?ooo`3oool0o`3ooolI0?ooo`00D@3oool00`000000oooo
0?ooo`3o0?ooodh0oooo00<000000?ooo`3oool0o`3ooolI0?ooo`00D@3oool00`000000oooo0?oo
o`3o0?ooodh0oooo00<000000?ooo`3oool0o`3ooolI0?ooo`00D@3oool200000?l0ooooC`3oool2
00000?l0oooo6P3oool00540oooo00<000000?ooo`3oool0o`3ooom>0?ooo`030000003oool0oooo
0?l0oooo6@3oool00540oooo00<000000?ooo`3oool0o`3ooom>0?ooo`030000003oool0oooo0?l0
oooo6@3oool00540oooo00<000000?ooo`3oool0o`3ooom>0?ooo`030000003oool0oooo0?l0oooo
6@3oool00540oooo00<000000?ooo`3oool0o`3ooom>0?ooo`030000003oool0oooo0?l0oooo6@3o
ool00540oooo00<000000?ooo`3oool0o`3ooom>0?ooo`030000003oool0oooo0?l0oooo6@3oool0
0540oooo00<000000?ooo`3oool0o`3ooom>0?ooo`030000003oool0oooo0?l0oooo6@3oool00540
oooo00<000000?ooo`3oool0o`3ooom>0?ooo`030000003oool0oooo0?l0oooo6@3oool00540oooo
00<000000?ooo`3oool0o`3ooom>0?ooo`030000003oool0oooo0?l0oooo6@3oool00540oooo0P00
003o0?ooodl0oooo0P00003o0?oooaX0oooo001A0?ooo`030000003oool0oooo0?l0ooooCP3oool0
0`000000oooo0?ooo`3o0?oooaT0oooo001A0?ooo`030000003oool0oooo0?l0ooooCP3oool00`00
0000oooo0?ooo`3o0?oooaT0oooo001A0?ooo`030000003oool0oooo0?l0ooooCP3oool00`000000
oooo0?ooo`3o0?oooaT0oooo001A0?ooo`030000003oool0oooo0?l0ooooCP3oool00`000000oooo
0?ooo`3o0?oooaT0oooo001A0?ooo`030000003oool0oooo0?l0ooooCP3oool00`000000oooo0?oo
o`3o0?oooaT0oooo001A0?ooo`030000003oool0oooo0?l0ooooCP3oool00`000000oooo0?ooo`3o
0?oooaT0oooo001A0?ooo`030000003oool0oooo0?l0ooooCP3oool00`000000oooo0?ooo`3o0?oo
oaT0oooo001A0?ooo`030000003oool0oooo0?l0ooooCP3oool00`000000oooo0?ooo`3o0?oooaT0
oooo001A0?ooo`800000o`3ooom?0?ooo`800000o`3ooolJ0?ooo`00D@3oool00`000000oooo0?oo
o`3o0?ooodh0oooo00<000000?ooo`3oool0o`3ooolI0?ooo`00D@3oool00`000000oooo0?ooo`3o
0?ooodh0oooo00<000000?ooo`3oool0o`3ooolI0?ooo`00D@3oool00`000000oooo0?ooo`3o0?oo
odh0oooo00<000000?ooo`3oool0o`3ooolI0?ooo`00D@3oool00`000000oooo0?ooo`3o0?ooodh0
oooo00<000000?ooo`3oool0o`3ooolI0?ooo`00D@3oool00`000000oooo0?ooo`3o0?ooodh0oooo
00<000000?ooo`3oool0o`3ooolI0?ooo`00D@3oool00`000000oooo0?ooo`3o0?ooodh0oooo00<0
00000?ooo`3oool0o`3ooolI0?ooo`00<P3oool2000000@0oooo0P0000040?ooo`800000103oool2
000000@0oooo0P0000050?ooo`030000003oool0oooo0?l0oooo;`3oool2000000@0oooo0P000004
0?ooo`800000103oool2000000@0oooo0P0000050?ooo`030000003oool0oooo0?l0oooo6@3oool0
0340oooo00@000000?ooo`3oool00000203oool010000000oooo0?ooo`0000020?ooo`040000003o
ool0oooo00000080oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`3o0?ooobh0
oooo00@000000?ooo`3oool00000203oool010000000oooo0?ooo`0000020?ooo`040000003oool0
oooo00000080oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`3o0?oooaT0oooo
000a0?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`3oool000000P3oool010000000
oooo0?ooo`0000020?ooo`040000003oool0oooo000000@0oooo0P00003o0?ooobl0oooo00@00000
0?ooo`3oool00000203oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo00000080
oooo00@000000?ooo`3oool00000103oool200000?l0oooo6P3oool00340oooo00@000000?ooo`3o
ool00000203oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo000000<0oooo0P00
003o0?ooocH0oooo00@000000?ooo`3oool00000203oool010000000oooo0?ooo`0000020?ooo`04
0000003oool0oooo000000<0oooo0P00003o0?ooob40oooo000a0?ooo`040000003oool0oooo0000
00P0oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000020?ooo`040000003o
ool0oooo00000?l0oooo=@3oool010000000oooo0?ooo`0000080?ooo`040000003oool0oooo0000
0080oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`00003o0?ooob00oooo000b
0?ooo`8000002P3oool2000000@0oooo0P0000040?ooo`800000o`3ooolg0?ooo`8000002P3oool2
000000@0oooo0P0000040?ooo`800000o`3ooolQ0?ooo`00o`3ooooo0?oookh0oooo003o0?ooool0
oooo_P3oool00?00oooo0P00000K0?ooo`<00000o`3ooolb0?ooo`8000006`3oool3000005/0oooo
003a0?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool0o`3ooolb0?ooo`030000003o
ool0oooo01X0oooo00<000000?ooo`3oool0FP3oool005D0oooo0`0000020?ooo`@000000`3oool2
000000<0oooo0`0000030?ooo`<000002@3oool3000000@0oooo0`0000030?ooo`<000000`3oool2
000000@0oooo0`0000030?ooo`8000000P3oool200000080oooo0P0000000`3oool0000000000003
000000040?ooo`0000000000000000X0oooo0P0000030?ooo`D0000000<0oooo0000000000000P00
00030?ooo`<000000P3oool9000000@0oooo0`0000020?ooo`<00000103oool3000000<0oooo0P00
00050?ooo`030000003oool0oooo00P0oooo0P0000030?ooo`@00000203oool3000000<0oooo1000
00030?ooo`<000000`3oool3000000<0oooo0`0000020?ooo`<00000M`3oool300000080oooo1000
00030?ooo`8000000`3oool3000000<0oooo0`0000090?ooo`<00000103oool3000000<0oooo0`00
00030?ooo`800000103oool3000000<0oooo0P0000020?ooo`8000000P3oool2000000030?ooo`00
0000000000<0000000@0oooo00000000000000002P3oool2000000<0oooo1@0000000`3oool00000
00000002000000<0oooo0`0000020?ooo`T00000103oool300000080oooo0`0000040?ooo`<00000
0`3oool2000000D0oooo00<000000?ooo`3oool0203oool2000000<0oooo100000080?ooo`<00000
0`3oool4000000<0oooo0`0000030?ooo`<000000`3oool300000080oooo0`00000l0?ooo`00E03o
ool00`000000oooo0?ooo`040?ooo`030000003oool0oooo0080oooo00@000000?ooo`3oool00000
1@3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00@000001@3oool010000000oooo
0?ooo`0000050?ooo`030000003oool0oooo00<0oooo00@000000?ooo`3oool00000103oool01@00
0000oooo0?ooo`3oool000000080oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?oo
o`04000000<0oooo00<000000?ooo`3oool02@3oool2000000<0oooo100000030?ooo`030000003o
ool0oooo00@0oooo00@000000?ooo`3oool0oooo100000020?ooo`040000003oool0oooo000000@0
oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`040?ooo`050000003oool0oooo0?oo
o`0000000P3oool01`000000oooo0?ooo`3oool000000?ooo`000000203oool010000000oooo0?oo
o`0000030?ooo`030000003oool0oooo00P0oooo00@000000?ooo`3oool000000`3oool00`000000
oooo0?ooo`040?ooo`050000003oool0oooo0?ooo`0000001@3oool00`000000oooo0?ooo`060?oo
o`030000003oool0oooo07<0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`020?oo
o`040000003oool0oooo000000D0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`04
000000D0oooo00@000000?ooo`3oool000001@3oool00`000000oooo0?ooo`030?ooo`040000003o
ool0oooo000000@0oooo00D000000?ooo`3oool0oooo000000020?ooo`040000003oool0oooo0000
0080oooo00<000000?ooo`3oool0100000030?ooo`030000003oool0oooo00T0oooo0P0000030?oo
o`@000000`3oool00`000000oooo0?ooo`040?ooo`040000003oool0oooo0?ooo`@000000P3oool0
10000000oooo0?ooo`0000040?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0103o
ool01@000000oooo0?ooo`3oool000000080oooo00L000000?ooo`3oool0oooo0000003oool00000
00P0oooo00@000000?ooo`3oool000000`3oool00`000000oooo0?ooo`080?ooo`040000003oool0
oooo000000<0oooo00<000000?ooo`3oool0103oool01@000000oooo0?ooo`3oool0000000D0oooo
00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0i0?ooo`00E03oool00`000000oooo0?oo
o`040?ooo`030000003oool0oooo0080oooo00@000000?ooo`3oool000000P3oool3000000<0oooo
0`0000090?ooo`<000000`3oool400000080oooo00<000000?ooo`3oool00`3oool00`000000oooo
0?ooo`050?ooo`050000003oool0oooo0?ooo`0000000P3oool010000000oooo0?ooo`0000020?oo
o`030000003oool0oooo00<0oooo00D000000?ooo`3oool0oooo0000000:0?ooo`040000003oool0
oooo000000D0oooo00D000000?ooo`3oool0oooo000000060?ooo`030000003oool0oooo00@0oooo
00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0080
oooo00<000000?ooo`3oool0103oool01@000000oooo0?ooo`3oool0000000D0oooo00@000000?oo
o`3oool00000203oool010000000oooo0?ooo`0000030?ooo`030000003oool0oooo00P0oooo00@0
00000?ooo`3oool000000`3oool00`000000oooo0?ooo`040?ooo`050000003oool0oooo0?ooo`00
00001@3oool400000080oooo0`00001f0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3o
ool00P3oool010000000oooo0?ooo`0000020?ooo`<000000`3oool3000000T0oooo0`0000030?oo
o`@000000P3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00D0oooo00D000000?oo
o`3oool0oooo000000020?ooo`040000003oool0oooo00000080oooo00<000000?ooo`3oool00`3o
ool01@000000oooo0?ooo`3oool0000000X0oooo00@000000?ooo`3oool000001@3oool01@000000
oooo0?ooo`3oool0000000H0oooo00<000000?ooo`3oool0103oool010000000oooo0?ooo`000002
0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`04
0?ooo`050000003oool0oooo0?ooo`0000001@3oool010000000oooo0?ooo`0000080?ooo`040000
003oool0oooo000000<0oooo00<000000?ooo`3oool0203oool010000000oooo0?ooo`0000030?oo
o`030000003oool0oooo00@0oooo00D000000?ooo`3oool0oooo000000050?ooo`@000000P3oool3
000003`0oooo001D0?ooo`030000003oool0oooo00<0oooo100000030?ooo`8000000`3oool40000
0080oooo100000080?ooo`@000000`3oool2000000@0oooo0`0000000`3oool00000000000030000
00<0oooo0P0000040?ooo`8000000P3oool4000000@0oooo0`0000030?ooo`030000003oool0oooo
00L0oooo0P0000020?ooo`8000000P3oool300000080oooo100000030?ooo`800000103oool30000
0080oooo0`0000040?ooo`800000103oool00`000000oooo0?ooo`030?ooo`8000000P3oool50000
00050?ooo`00000000000000003oool00P0000080?ooo`8000000`3oool4000000L0oooo10000003
0?ooo`@000000`3oool2000000@0oooo0`0000030?ooo`8000000`3oool4000007D0oooo00<00000
0?ooo`3oool00`3oool4000000<0oooo0P0000030?ooo`@000000P3oool4000000P0oooo10000003
0?ooo`800000103oool3000000030?ooo`000000000000<000000`3oool2000000@0oooo0P000002
0?ooo`@00000103oool3000000<0oooo00<000000?ooo`3oool01`3oool200000080oooo0P000002
0?ooo`<000000P3oool4000000<0oooo0P0000040?ooo`<000000P3oool3000000@0oooo0P000004
0?ooo`030000003oool0oooo00<0oooo0P0000020?ooo`D0000000D0oooo00000000000000000?oo
o`02000000P0oooo0P0000030?ooo`@000001`3oool4000000<0oooo100000030?ooo`800000103o
ool3000000<0oooo0P0000030?ooo`@00000>`3oool005@0oooo00@000000?ooo`3oool00000<P3o
ool00`000000oooo0?ooo`0L0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool02P3o
ool00`000000oooo0?ooo`080?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3oool0W`3o
ool010000000oooo0?ooo`00000b0?ooo`030000003oool0oooo01`0oooo00<000000?ooo`3oool0
9P3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0
5P3oool00`000000oooo0?ooo`1U0?ooo`00E@3oool3000003X0oooo00<000000?ooo`3oool04`3o
ool2000001h0oooo00<000000?ooo`3oool01P3oool2000000L0oooo00@000000?ooo`3oool0oooo
0P0000060?ooo`030000003oool0oooo01/0oooo0P00000F0?ooo`030000003oool0oooo08L0oooo
0`00000j0?ooo`030000003oool0oooo01<0oooo0P00000N0?ooo`030000003oool0oooo00H0oooo
0P0000070?ooo`040000003oool0oooo0?ooo`8000001P3oool00`000000oooo0?ooo`0K0?ooo`80
00005P3oool00`000000oooo0?ooo`1<0?ooo`00o`3ooooo0?oookh0oooo003o0?ooool0oooo_P3o
ool00?l0ooooo`3ooonn0?ooo`00o`3ooooo0?oookh0oooo003o0?ooool0oooo_P3oool00?l0oooo
o`3ooonn0?ooo`00o`3ooooo0?oookh0oooo003o0?ooool0oooo_P3oool00?l0ooooo`3ooonn0?oo
o`00o`3ooooo0?oookh0oooo003o0?ooool0oooo_P3oool00?l0ooooo`3ooonn0?ooo`00o`3ooooo
0?oookh0oooo003o0?ooool0oooo_P3oool00?l0ooooo`3ooonn0?ooo`00o`3ooooo0?oookh0oooo
003o0?ooool0oooo_P3oool00?l0ooooo`3ooonn0?ooo`00o`3ooooo0?oookh0oooo003o0?ooool0
oooo_P3oool00?l0ooooo`3ooonn0?ooo`00o`3ooooo0?oookh0oooo003o0?ooool0oooo_P3oool0
0?l0ooooo`3ooonn0?ooo`00o`3ooooo0?oookh0oooo003o0?ooool0oooo_P3oool00?l0ooooo`3o
oonn0?ooo`00o`3ooooo0?oookh0oooo003o0?ooool0oooo_P3oool00?l0ooooo`3ooonn0?ooo`00
o`3ooooo0?oookh0oooo003o0?ooool0oooo_P3oool00?l0ooooo`3ooonn0?ooo`00o`3ooooo0?oo
okh0oooo003o0?ooool0oooo_P3oool00?l0ooooo`3ooonn0?ooo`00o`3ooooo0?oookh0oooo003o
0?ooool0oooo_P3oool00?l0ooooo`3ooonn0?ooo`00o`3ooooo0?oookh0oooo003o0?ooool0oooo
_P3oool00?l0ooooo`3ooonn0?ooo`00o`3ooooo0?oookh0oooo003o0?ooool0oooo_P3oool00?l0
ooooo`3ooonn0?ooo`00o`3ooooo0?oookh0oooo003o0?ooool0oooo_P3oool00?l0ooooo`3ooonn
0?ooo`00o`3ooooo0?oookh0oooo003o0?ooool0oooo_P3oool00?l0ooooo`3ooonn0?ooo`00o`3o
oooo0?oookh0oooo003o0?ooool0oooo_P3oool00?l0ooooo`3ooonn0?ooo`00o`3ooooo0?oookh0
oooo003o0?ooool0oooo_P3oool006L0oooo1000000L0?ooo`<000006P3oool3000001`0oooo0P00
000H0?ooo`D000000P3oool2000001H0oooo1@0000000`3oool0000000000002000001@0oooo1@00
00030?ooo`<00000TP3oool4000001d0oooo0`00000I0?ooo`<00000703oool2000001T0oooo1@00
00020?ooo`8000005@3oool5000000030?ooo`000000000000800000503oool5000000<0oooo0`00
00170?ooo`00I`3oool00`000000oooo0?ooo`0N0?ooo`030000003oool0oooo01T0oooo00@00000
0?ooo`3oool000006P3oool010000000oooo0?ooo`00000I0?ooo`050000003oool0oooo0?ooo`00
00000P3oool00`000000oooo0?ooo`0E0?ooo`050000003oool0oooo0?ooo`0000006@3oool00`00
0000oooo0?ooo`040?ooo`030000003oool0oooo0940oooo00<000000?ooo`3oool07`3oool00`00
0000oooo0?ooo`0H0?ooo`040000003oool0oooo000001X0oooo00@000000?ooo`3oool000006P3o
ool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool0503oool01@000000oooo
0?ooo`3oool0000001T0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`160?ooo`00
J03oool00`000000oooo0?ooo`0J0?ooo`D000006P3oool010000000oooo0?ooo`00000J0?ooo`04
0000003oool0oooo000001T0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0
oooo01D0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0F0?ooo`040000003oool0
oooo0?ooo`D00000T`3oool00`000000oooo0?ooo`0K0?ooo`D000006@3oool010000000oooo0?oo
o`00000J0?ooo`040000003oool0oooo000001X0oooo00D000000?ooo`3oool0oooo000000020?oo
o`030000003oool0oooo01@0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0F0?oo
o`040000003oool0oooo0?ooo`D00000A`3oool006T0oooo00<000000?ooo`3oool06@3oool01000
0000oooo0?ooo`00000K0?ooo`<00000703oool2000001X0oooo00D000000?ooo`3oool0oooo0000
00020?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?oo
o`0E0?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`2C0?ooo`030000
003oool0oooo01X0oooo00@000000?ooo`3oool000006P3oool3000001`0oooo0P00000K0?ooo`05
0000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo
00<0oooo00<000000?ooo`3oool05@3oool01@000000oooo0?ooo`3oool000000080oooo00<00000
0?ooo`3oool0AP3oool006L0oooo00@000000?ooo`3oool000006`3oool00`000000oooo0000000L
0?ooo`030000003oool0oooo01X0oooo00@000000?ooo`3oool000006@3oool01@000000oooo0?oo
o`3oool000000080oooo00<000000?ooo`3oool05@3oool01@000000oooo0?ooo`3oool000000080
oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`020?ooo`030000003oool0000009<0
oooo00@000000?ooo`3oool00000703oool00`000000oooo0000000K0?ooo`030000003oool0oooo
01X0oooo00@000000?ooo`3oool000006P3oool01@000000oooo0?ooo`3oool000000080oooo00<0
00000?ooo`3oool0503oool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool0
503oool00`000000oooo0?ooo`020?ooo`030000003oool0000004P0oooo001X0?ooo`8000007@3o
ool2000001`0oooo0`00000K0?ooo`8000006@3oool2000000@0oooo0P00000G0?ooo`800000103o
ool2000001H0oooo0P0000050?ooo`800000U03oool2000001h0oooo0P00000K0?ooo`<000006`3o
ool2000001X0oooo0P0000040?ooo`8000005P3oool2000000@0oooo0P00000F0?ooo`8000001@3o
ool2000004P0oooo003o0?ooool0oooo_P3oool00?l0ooooo`3ooonn0?ooo`00o`3ooooo0?oookh0
oooo003o0?ooool0oooo_P3oool00?l0ooooo`3ooonn0?ooo`00A@3ooolE00000=D006Ko1P00001P
0?ooom<000006000I_l5000003L0oooo001;0?ooo`030000003oool0oooo00@0oooo00<000000?oo
o`3oool01@3oool00`00I_l0oooo0?ooo`040?ooo`030000003oool0oooo00D0oooo00<000000?oo
o`3oool01@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00D0oooo00<000000?oo
o`3oool0103oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00@0oooo00<000000?oo
o`3oool01@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00@0oooo00<000000?oo
o`3oool01@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00D0oooo00<000000?oo
o`3oool01@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00D0oooo00<000000?oo
o`3oool0103oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo00<000000?oo
o`3oool0103oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00@0oooo00<000000?oo
o`3oool01@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00D0oooo00<000000?oo
o`3oool01@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo06X0oooo00<000000?oo
o`3oool01@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00D0oooo00<000000?oo
o`3oool0103oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00@0oooo00<000000?oo
o`3oool01@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00@0oooo00<000000?oo
o`3oool01@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00D0oooo00<000000?oo
o`3oool01@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00D0oooo00<000000?oo
o`3oool0103oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo00<000000?oo
o`3oool0103oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00@0oooo00<00000001V
o`00I_l0:`00I_l00`000000oooo0?ooo`040?ooo`030000003oool0oooo00D0oooo00<000000?oo
o`3oool01@3oool00`000000oooo0?ooo`0j0?ooo`00B`3oool00`000000oooo0?ooo`0<0?ooo`03
001Vo`3oool0oooo0?l0oooo?`3oool00`000000oooo0?ooo`2>0?ooo`l006KoP@3oool004/0oooo
00<000000?ooo`3oool0303oool00`00I_l0oooo0?ooo`3o0?ooocl0oooo00<000000?ooo`3oool0
O`3oool?001Voi00oooo001;0?ooo`030000003oool0oooo00`0oooo00<006Ko0?ooo`3oool0o`3o
oolo0?ooo`030000003oool0oooo06l0oooo4000I_nO0?ooo`00B`3oool00`000000oooo0?ooo`0;
0?ooo`03001Vo`3oool0oooo0?l0oooo@03oool00`000000oooo0?ooo`1T0?ooo`/006Ko[`3oool0
04/0oooo00<000000?ooo`3oool02`3oool00`00I_l0oooo0?ooo`3o0?oood00oooo00<000000?oo
o`3oool0G03oool8001VokX0oooo001;0?ooo`800000303oool00`00I_l0oooo0?ooo`3o0?oood00
oooo0P00001G0?ooo`H006Ko`P3oool004/0oooo00<000000?ooo`3oool02`3oool00`00I_l0oooo
0?ooo`3o0?oood00oooo00<000000?ooo`3oool0D@3oool5001VolP0oooo001;0?ooo`030000003o
ool0oooo00/0oooo00<006Ko0?ooo`3oool0o`3ooom00?ooo`030000003oool0oooo04`0oooo1@00
I_o=0?ooo`00B`3oool00`000000oooo0?ooo`0;0?ooo`03001Vo`3oool0oooo0?l0oooo@03oool0
0`000000oooo0?ooo`180?ooo`@006KodP3oool004/0oooo00<000000?ooo`3oool02`3oool00`00
I_l0oooo0?ooo`3o0?oood00oooo00<000000?ooo`3oool0A@3oool3001VomH0oooo001;0?ooo`03
0000003oool0oooo00/0oooo00<006Ko0?ooo`3oool0o`3ooom00?ooo`030000003oool0oooo0480
oooo0`00I_oI0?ooo`00B`3oool00`000000oooo0?ooo`0;0?ooo`03001Vo`3oool0oooo0?l0oooo
@03oool00`000000oooo0?ooo`0o0?ooo`<006Kog03oool004/0oooo00<000000?ooo`3oool02`3o
ool00`00I_l0oooo0?ooo`3o0?oood00oooo00<000000?ooo`3oool0?03oool3001Voml0oooo001;
0?ooo`8000002`3oool00`00I_l0oooo0?ooo`3o0?oood40oooo0P00000j0?ooo`<006KohP3oool0
04/0oooo00<000000?ooo`3oool02P3oool00`00I_l0oooo0?ooo`3o0?oood40oooo00<000000?oo
o`3oool0=`3oool2001VonD0oooo001;0?ooo`030000003oool0oooo00X0oooo00<006Ko0?ooo`3o
ool0o`3ooom10?ooo`030000003oool0oooo03D0oooo0P00I_oW0?ooo`00B`3oool00`000000oooo
0?ooo`0:0?ooo`03001Vo`3oool0oooo0?l0oooo@@3oool00`000000oooo0?ooo`0c0?ooo`8006Ko
j@3oool004/0oooo00<000000?ooo`3oool02P3oool00`00I_l0oooo0?ooo`3o0?oood40oooo00<0
00000?ooo`3oool0<03oool3001Von/0oooo001;0?ooo`030000003oool0oooo00X0oooo00<006Ko
0?ooo`3oool0o`3ooom10?ooo`030000003oool0oooo02h0oooo0P00I_o^0?ooo`00B`3oool00`00
0000oooo0?ooo`0:0?ooo`03001Vo`3oool0oooo0?l0oooo@@3oool00`000000oooo0?ooo`0/0?oo
o`8006Kol03oool004/0oooo0P00000;0?ooo`03001Vo`3oool0oooo0?l0oooo@@3oool2000002/0
oooo0P00I_ob0?ooo`00B`3oool00`000000oooo0?ooo`0:0?ooo`03001Vo`3oool0oooo0?l0oooo
@@3oool00`000000oooo0?ooo`0Y0?ooo`03001Vo`3oool0oooo0?80oooo001;0?ooo`030000003o
ool0oooo00T0oooo00<006Ko0?ooo`3oool0o`3ooom20?ooo`030000003oool0oooo02P0oooo00<0
06Ko0?ooo`3oool0l`3oool004/0oooo00<000000?ooo`3oool02@3oool00`00I_l0oooo0?ooo`3o
0?oood80oooo00<000000?ooo`3oool09P3oool2001VooH0oooo001;0?ooo`030000003oool0oooo
00T0oooo00<006Ko0?ooo`3oool0o`3ooom20?ooo`030000003oool0oooo02D0oooo00<006Ko0?oo
o`3oool0mP3oool003P0oooo0P0000040?ooo`8000000`3oool4000000@0oooo00<000000?ooo`3o
ool02@3oool00`00I_l0oooo0?ooo`3o0?ooobl0oooo0P0000040?ooo`8000000`3oool4000000@0
oooo00<000000?ooo`3oool0903oool00`00I_l0oooo0?ooo`3g0?ooo`00=`3oool010000000oooo
0?ooo`0000080?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool02@3oool00`00I_l0
oooo0?ooo`3o0?ooobh0oooo00@000000?ooo`3oool00000203oool00`000000oooo0?ooo`050?oo
o`030000003oool0oooo02<0oooo00<006Ko0?ooo`3oool0n03oool003L0oooo00@000000?ooo`3o
ool000002@3oool00`000000oooo0?ooo`040?ooo`8000002P3oool00`00I_l0oooo0?ooo`3o0?oo
obh0oooo00@000000?ooo`3oool000002@3oool00`000000oooo0?ooo`040?ooo`8000008`3oool0
0`00I_l0oooo0?ooo`3i0?ooo`00=`3oool010000000oooo0?ooo`00000:0?ooo`030000003oool0
oooo00<0oooo00<000000?ooo`3oool02@3oool00`00I_l0oooo0?ooo`3o0?ooobh0oooo00@00000
0?ooo`3oool000002P3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0240oooo00<0
06Ko0?ooo`3oool0nP3oool003L0oooo00@000000?ooo`3oool00000203oool010000000oooo0?oo
o`0000040?ooo`030000003oool0oooo00T0oooo00<006Ko0?ooo`3oool0o`3oool^0?ooo`040000
003oool0oooo000000P0oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`0P0?oo
o`03001Vo`3oool0oooo0?/0oooo000h0?ooo`8000002P3oool2000000D0oooo00<000000?ooo`3o
ool02@3oool00`00I_l0oooo0?ooo`3o0?ooobl0oooo0P00000:0?ooo`8000001@3oool00`000000
oooo0?ooo`0N0?ooo`8006KooP3oool004/0oooo00<000000?ooo`3oool02@3oool00`00I_l0oooo
0?ooo`3o0?oood80oooo00<000000?ooo`3oool07@3oool00`00I_l0oooo0?ooo`3n0?ooo`00B`3o
ool00`000000oooo0?ooo`080?ooo`03001Vo`3oool0oooo0?l0oooo@`3oool00`000000oooo0?oo
o`0L0?ooo`03001Vo`3oool0oooo0?l0oooo001;0?ooo`030000003oool0oooo00P0oooo00<006Ko
0?ooo`3oool0o`3ooom30?ooo`030000003oool0oooo01/0oooo00<006Ko0?ooo`3oool0o`3oool1
0?ooo`00B`3oool00`000000oooo0?ooo`080?ooo`03001Vo`3oool0oooo0?l0oooo@`3oool00`00
0000oooo0?ooo`0J0?ooo`03001Vo`3oool0oooo0?l0oooo0P3oool004/0oooo0P0000090?ooo`03
001Vo`3oool0oooo0?l0oooo@`3oool2000001/0oooo00<006Ko0?ooo`3oool0o`3oool20?ooo`00
B`3oool00`000000oooo0?ooo`080?ooo`03001Vo`3oool0oooo0?l0oooo@`3oool00`000000oooo
0?ooo`0I0?ooo`03001Vo`3oool0oooo0?l0oooo0`3oool004/0oooo00<000000?ooo`3oool0203o
ool00`00I_l0oooo0?ooo`3o0?oood<0oooo00<000000?ooo`3oool06@3oool00`00I_l0oooo0?oo
o`3o0?ooo`<0oooo001;0?ooo`030000003oool0oooo00P0oooo00<006Ko0?ooo`3oool0o`3ooom3
0?ooo`030000003oool0oooo01P0oooo00<006Ko0?ooo`3oool0o`3oool40?ooo`00B`3oool00`00
0000oooo0?ooo`080?ooo`03001Vo`3oool0oooo0?l0oooo@`3oool00`000000oooo0?ooo`0H0?oo
o`03001Vo`3oool0oooo0?l0oooo103oool004/0oooo00<000000?ooo`3oool0203oool00`00I_l0
oooo0?ooo`3o0?oood<0oooo00<000000?ooo`3oool05`3oool00`00I_l0oooo0?ooo`3o0?ooo`D0
oooo001;0?ooo`030000003oool0oooo00L0oooo00<006Ko0?ooo`3oool0o`3ooom40?ooo`030000
003oool0oooo01H0oooo00<006Ko0?ooo`3oool0o`3oool60?ooo`00B`3oool2000000P0oooo00<0
06Ko0?ooo`3oool0o`3ooom40?ooo`8000005`3oool00`00I_l0oooo0?ooo`3o0?ooo`H0oooo001;
0?ooo`030000003oool0oooo00L0oooo00<006Ko0?ooo`3oool0o`3ooom40?ooo`030000003oool0
oooo01D0oooo00<006Ko0?ooo`3oool0o`3oool70?ooo`00B`3oool00`000000oooo0?ooo`070?oo
o`03001Vo`3oool0oooo0?l0ooooA03oool00`000000oooo0?ooo`0E0?ooo`03001Vo`3oool0oooo
0?l0oooo1`3oool004/0oooo00<000000?ooo`3oool01`3oool00`00I_l0oooo0?ooo`3o0?oood@0
oooo00<000000?ooo`3oool0503oool00`00I_l0oooo0?ooo`3o0?ooo`P0oooo001;0?ooo`030000
003oool0oooo00L0oooo00<006Ko0?ooo`3oool0o`3ooom40?ooo`030000003oool0oooo01<0oooo
00<006Ko0?ooo`3oool0o`3oool90?ooo`00B`3oool00`000000oooo0?ooo`070?ooo`03001Vo`3o
ool0oooo0?l0ooooA03oool00`000000oooo0?ooo`0C0?ooo`03001Vo`3oool0oooo0?l0oooo2@3o
ool004/0oooo00<000000?ooo`3oool01`3oool00`00I_l0oooo0?ooo`3o0?oood@0oooo00<00000
0?ooo`3oool04P3oool00`00I_l0oooo0?ooo`3o0?ooo`X0oooo001;0?ooo`800000203oool00`00
I_l0oooo0?ooo`3o0?oood@0oooo0P00000C0?ooo`03001Vo`3oool0oooo0?l0oooo2P3oool004/0
oooo00<000000?ooo`3oool01`3oool00`00I_l0oooo0?ooo`3o0?oood@0oooo00<000000?ooo`3o
ool04@3oool00`00I_l0oooo0?ooo`3o0?ooo`/0oooo001;0?ooo`030000003oool0oooo00H0oooo
00<006Ko0?ooo`3oool0o`3ooom50?ooo`030000003oool0oooo0140oooo00<006Ko0?ooo`3oool0
o`3oool;0?ooo`00B`3oool00`000000oooo0?ooo`060?ooo`03001Vo`3oool0oooo0?l0ooooA@3o
ool00`000000oooo0?ooo`0@0?ooo`03001Vo`3oool0oooo0?l0oooo303oool004/0oooo00<00000
0?ooo`3oool01P3oool00`00I_l0oooo0?ooo`3o0?ooodD0oooo00<000000?ooo`3oool03`3oool0
0`00I_l0oooo0?ooo`3o0?ooo`d0oooo001;0?ooo`030000003oool0oooo00H0oooo00<006Ko0?oo
o`3oool0o`3ooom50?ooo`030000003oool0oooo00l0oooo00<006Ko0?ooo`3oool0o`3oool=0?oo
o`00>03oool2000000@0oooo0P0000050?ooo`<000000`3oool00`000000oooo0?ooo`060?ooo`03
001Vo`3oool0oooo0?l0oooo<P3oool2000000@0oooo0P0000050?ooo`<000000`3oool00`000000
oooo0?ooo`0>0?ooo`03001Vo`3oool0oooo0?l0oooo3P3oool003L0oooo00@000000?ooo`3oool0
00002`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00H0oooo00<006Ko0?ooo`3o
ool0o`3ooola0?ooo`040000003oool0oooo000000/0oooo00<000000?ooo`3oool00P3oool00`00
0000oooo0?ooo`0>0?ooo`03001Vo`3oool0oooo0?l0oooo3P3oool003L0oooo00@000000?ooo`3o
ool00000203oool5000000<0oooo0P0000070?ooo`03001Vo`3oool0oooo0?l0oooo<@3oool01000
0000oooo0?ooo`0000080?ooo`D000000`3oool2000000h0oooo00<006Ko0?ooo`3oool0o`3oool?
0?ooo`00=`3oool010000000oooo0?ooo`0000080?ooo`040000003oool0oooo000000@0oooo00<0
00000?ooo`3oool01P3oool00`00I_l0oooo0?ooo`3o0?oooc40oooo00@000000?ooo`3oool00000
203oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo00d0oooo00<006Ko0?ooo`3o
ool0o`3oool?0?ooo`00=`3oool010000000oooo0?ooo`0000090?ooo`030000003oool0000000@0
oooo00<000000?ooo`3oool01P3oool00`00I_l0oooo0?ooo`3o0?oooc40oooo00@000000?ooo`3o
ool000002@3oool00`000000oooo000000040?ooo`030000003oool0oooo00`0oooo00<006Ko0?oo
o`3oool0o`3oool@0?ooo`00>03oool2000000/0oooo0P0000040?ooo`030000003oool0oooo00D0
oooo00<006Ko0?ooo`3oool0o`3ooolc0?ooo`8000002`3oool2000000@0oooo00<000000?ooo`3o
ool0303oool00`00I_l0oooo0?ooo`3o0?oooa00oooo001;0?ooo`030000003oool0oooo00D0oooo
00<006Ko0?ooo`3oool0o`3ooom60?ooo`030000003oool0oooo00`0oooo00<006Ko0?ooo`3oool0
o`3oool@0?ooo`00B`3oool00`000000oooo0?ooo`050?ooo`03001Vo`3oool0oooo0?l0ooooAP3o
ool00`000000oooo0?ooo`0;0?ooo`03001Vo`3oool0oooo0?l0oooo4@3oool004/0oooo00<00000
0?ooo`3oool01@3oool00`00I_l0oooo0?ooo`3o0?ooodH0oooo00<000000?ooo`3oool02`3oool0
0`00I_l0oooo0?ooo`3o0?oooa40oooo001;0?ooo`8000001P3oool00`00I_l0oooo0?ooo`3o0?oo
odH0oooo0P00000<0?ooo`03001Vo`3oool0oooo0?l0oooo4@3oool004/0oooo00<000000?ooo`3o
ool01@3oool00`00I_l0oooo0?ooo`3o0?ooodH0oooo00<000000?ooo`3oool02`3oool00`00I_l0
oooo0?ooo`3o0?oooa40oooo001;0?ooo`030000003oool0oooo00D0oooo00<006Ko0?ooo`3oool0
o`3ooom60?ooo`030000003oool0oooo00/0oooo00<006Ko0?ooo`3oool0o`3ooolA0?ooo`00B`3o
ool00`000000oooo0?ooo`050?ooo`03001Vo`3oool0oooo0?l0ooooAP3oool00`000000oooo0?oo
o`0;0?ooo`03001Vo`3oool0oooo0?l0oooo4@3oool004/0oooo00<000000?ooo`3oool01@3oool0
0`00I_l0oooo0?ooo`3o0?ooodH0oooo00<000000?ooo`3oool02P3oool00`00I_l0oooo0?ooo`3o
0?oooa80oooo001;0?ooo`030000003oool0oooo00D0oooo00<006Ko0?ooo`3oool0o`3ooom60?oo
o`030000003oool0oooo00X0oooo00<006Ko0?ooo`3oool0o`3ooolB0?ooo`00B`3oool00`000000
oooo0?ooo`040?ooo`03001Vo`3oool0oooo0?l0ooooA`3oool00`000000oooo0?ooo`0:0?ooo`03
001Vo`3oool0oooo0?l0oooo4P3oool004/0oooo00<000000?ooo`3oool0103oool00`00I_l0oooo
0?ooo`3o0?ooodL0oooo00<000000?ooo`3oool02P3oool00`00I_l0oooo0?ooo`3o0?oooa80oooo
001;0?ooo`8000001@3oool00`00I_l0oooo0?ooo`3o0?ooodL0oooo0P00000;0?ooo`03001Vo`3o
ool0oooo0?l0oooo4P3oool004/0oooo00<000000?ooo`3oool0103oool00`00I_l0oooo0?ooo`3o
0?ooodL0oooo00<000000?ooo`3oool02@3oool00`00I_l0oooo0?ooo`3o0?oooa<0oooo001;0?oo
o`030000003oool0oooo00@0oooo00<006Ko0?ooo`3oool0o`3ooom70?ooo`030000003oool0oooo
00T0oooo00<006Ko0?ooo`3oool0o`3ooolC0?ooo`00B`3oool00`000000oooo0?ooo`040?ooo`03
001Vo`3oool0oooo0?l0ooooA`3oool00`000000oooo0?ooo`090?ooo`03001Vo`3oool0oooo0?l0
oooo4`3oool004/0oooo00<000000?ooo`3oool0103oool00`00I_l0oooo0?ooo`3o0?ooodL0oooo
00<000000?ooo`3oool02@3oool00`00I_l0oooo0?ooo`3o0?oooa<0oooo001;0?ooo`030000003o
ool0oooo00@0oooo00<006Ko0?ooo`3oool0o`3ooom70?ooo`030000003oool0oooo00T0oooo00<0
06Ko0?ooo`3oool0o`3ooolC0?ooo`00B`3oool00`000000oooo0?ooo`040?ooo`03001Vo`3oool0
oooo0?l0ooooA`3oool00`000000oooo0?ooo`090?ooo`03001Vo`3oool0oooo0?l0oooo4`3oool0
04/0oooo0P0000050?ooo`03001Vo`3oool0oooo0?l0ooooA`3oool2000000T0oooo00<006Ko0?oo
o`3oool0o`3ooolD0?ooo`00B`3oool00`000000oooo0?ooo`030?ooo`03001Vo`3oool0oooo0?l0
ooooB03oool00`000000oooo0?ooo`080?ooo`03001Vo`3oool0oooo0?l0oooo503oool004/0oooo
00<000000?ooo`3oool00`3oool00`00I_l0oooo0?ooo`3o0?ooodP0oooo00<000000?ooo`3oool0
203oool00`00I_l0oooo0?ooo`3o0?oooa@0oooo001;0?ooo`030000003oool0oooo00<0oooo00<0
06Ko0?ooo`3oool0o`3ooom80?ooo`030000003oool0oooo00P0oooo00<006Ko0?ooo`3oool0o`3o
oolD0?ooo`00B`3oool00`000000oooo0?ooo`030?ooo`03001Vo`3oool0oooo0?l0ooooB03oool0
0`000000oooo0?ooo`080?ooo`03001Vo`3oool0oooo0?l0oooo503oool003P0oooo0P0000040?oo
o`8000000`3oool3000000D0oooo00<000000?ooo`3oool00`3oool00`00I_l0oooo0?ooo`3o0?oo
ocD0oooo0P0000040?ooo`8000000`3oool3000000D0oooo00<000000?ooo`3oool01`3oool00`00
I_l0oooo0?ooo`3o0?oooaD0oooo000g0?ooo`040000003oool0oooo000000P0oooo00@000000?oo
o`3oool00000103oool00`000000oooo0?ooo`030?ooo`03001Vo`3oool0oooo0?l0oooo=03oool0
10000000oooo0?ooo`0000080?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`3oool0
1`3oool00`00I_l0oooo0?ooo`3o0?oooaD0oooo000g0?ooo`040000003oool0oooo000000P0oooo
00@000000?ooo`3oool00000103oool2000000@0oooo00<006Ko0?ooo`3oool0o`3ooold0?ooo`04
0000003oool0oooo000000P0oooo00@000000?ooo`3oool00000103oool2000000P0oooo00<006Ko
0?ooo`3oool0o`3ooolE0?ooo`00=`3oool010000000oooo0?ooo`0000080?ooo`<000001@3oool0
0`000000oooo0?ooo`030?ooo`03001Vo`3oool0oooo0?l0oooo=03oool010000000oooo0?ooo`00
00080?ooo`<000001@3oool00`000000oooo0?ooo`070?ooo`03001Vo`3oool0oooo0?l0oooo5@3o
ool003L0oooo00@000000?ooo`3oool000002@3oool00`000000oooo0?ooo`040?ooo`030000003o
ool0oooo00<0oooo00<006Ko0?ooo`3oool0o`3ooold0?ooo`040000003oool0oooo000000T0oooo
00<000000?ooo`3oool0103oool00`000000oooo0?ooo`070?ooo`03001Vo`3oool0oooo0?l0oooo
5@3oool003P0oooo0P00000:0?ooo`<00000103oool00`000000oooo0?ooo`020?ooo`03001Vo`3o
ool0oooo0?l0oooo=P3oool2000000X0oooo0`0000040?ooo`030000003oool0oooo00L0oooo00<0
06Ko0?ooo`3oool0o`3ooolE0?ooo`00B`3oool00`000000oooo0?ooo`020?ooo`03001Vo`3oool0
oooo0?l0ooooB@3oool00`000000oooo0?ooo`060?ooo`03001Vo`3oool0oooo0?l0oooo5P3oool0
04/0oooo00<000000?ooo`3oool00P3oool00`00I_l0oooo0?ooo`3o0?ooodT0oooo00<000000?oo
o`3oool01P3oool00`00I_l0oooo0?ooo`3o0?oooaH0oooo001;0?ooo`030000003oool0oooo0080
oooo00<006Ko0?ooo`3oool0o`3ooom90?ooo`030000003oool0oooo00H0oooo00<006Ko0?ooo`3o
ool0o`3ooolF0?ooo`00B`3oool00`000000oooo0?ooo`020?ooo`03001Vo`3oool0oooo0?l0oooo
B@3oool00`000000oooo0?ooo`060?ooo`03001Vo`3oool0oooo0?l0oooo5P3oool004/0oooo0P00
00030?ooo`03001Vo`3oool0oooo0?l0ooooB@3oool2000000L0oooo00<006Ko0?ooo`3oool0o`3o
oolF0?ooo`00B`3oool00`000000oooo0?ooo`020?ooo`03001Vo`3oool0oooo0?l0ooooB@3oool0
0`000000oooo0?ooo`050?ooo`03001Vo`3oool0oooo0?l0oooo5`3oool004/0oooo00<000000?oo
o`3oool00P3oool00`00I_l0oooo0?ooo`3o0?ooodT0oooo00<000000?ooo`3oool01@3oool00`00
I_l0oooo0?ooo`3o0?oooaL0oooo001;0?ooo`030000003oool0oooo0080oooo00<006Ko0?ooo`3o
ool0o`3ooom90?ooo`030000003oool0oooo00D0oooo00<006Ko0?ooo`3oool0o`3ooolG0?ooo`00
B`3oool00`000000oooo0?ooo`020?ooo`03001Vo`3oool0oooo0?l0ooooB@3oool00`000000oooo
0?ooo`050?ooo`03001Vo`3oool0oooo0?l0oooo5`3oool004/0oooo00D000000?ooo`3oool0oooo
001Vo`3o0?oood`0oooo00<000000?ooo`3oool01@3oool00`00I_l0oooo0?ooo`3o0?oooaL0oooo
001;0?ooo`050000003oool0oooo0?ooo`00I_l0o`3ooom<0?ooo`030000003oool0oooo00@0oooo
00<006Ko0?ooo`3oool0o`3ooolH0?ooo`00B`3oool200000080oooo00<006Ko0?ooo`3oool0o`3o
oom:0?ooo`8000001@3oool00`00I_l0oooo0?ooo`3o0?oooaP0oooo001;0?ooo`050000003oool0
oooo0?ooo`00I_l0o`3ooom<0?ooo`030000003oool0oooo00@0oooo00<006Ko0?ooo`3oool0o`3o
oolH0?ooo`00B`3oool01@000000oooo0?ooo`3oool006Ko0?l0ooooC03oool00`000000oooo0?oo
o`040?ooo`03001Vo`3oool0oooo0?l0oooo603oool004/0oooo00D000000?ooo`3oool0oooo001V
o`3o0?oood`0oooo00<000000?ooo`3oool0103oool00`00I_l0oooo0?ooo`3o0?oooaP0oooo001;
0?ooo`050000003oool0oooo0?ooo`00I_l0o`3ooom<0?ooo`030000003oool0oooo00@0oooo00<0
06Ko0?ooo`3oool0o`3ooolH0?ooo`00B`3oool01@000000oooo0?ooo`3oool006Ko0?l0ooooC03o
ool00`000000oooo0?ooo`030?ooo`03001Vo`3oool0oooo0?l0oooo6@3oool004/0oooo00D00000
0?ooo`3oool0oooo001Vo`3o0?oood`0oooo00<000000?ooo`3oool00`3oool00`00I_l0oooo0?oo
o`3o0?oooaT0oooo001;0?ooo`040000003oool0oooo001Vool0ooooC@3oool00`000000oooo0?oo
o`030?ooo`03001Vo`3oool0oooo0?l0oooo6@3oool004/0oooo0P0000000`3oool006Ko0?ooo`3o
0?oood`0oooo0P0000040?ooo`03001Vo`3oool0oooo0?l0oooo6@3oool004/0oooo00@000000?oo
o`3oool006Koo`3ooom=0?ooo`030000003oool0oooo00<0oooo00<006Ko0?ooo`3oool0o`3ooolI
0?ooo`00B`3oool010000000oooo0?ooo`00I_oo0?ooodd0oooo00<000000?ooo`3oool00P3oool0
0`00I_l0oooo0?ooo`3o0?oooaX0oooo001;0?ooo`040000003oool0oooo001Vool0ooooC@3oool0
0`000000oooo0?ooo`020?ooo`03001Vo`3oool0oooo0?l0oooo6P3oool004/0oooo00@000000?oo
o`3oool006Koo`3ooom=0?ooo`030000003oool0oooo0080oooo00<006Ko0?ooo`3oool0o`3ooolJ
0?ooo`00>03oool2000000@0oooo0P0000040?ooo`8000001@3oool010000000oooo0?ooo`00I_oo
0?ooocX0oooo0P0000040?ooo`800000103oool2000000D0oooo00<000000?ooo`3oool00P3oool0
0`00I_l0oooo0?ooo`3o0?oooaX0oooo000g0?ooo`040000003oool0oooo000000P0oooo00@00000
0?ooo`3oool00000103oool010000000oooo0?ooo`00I_oo0?ooocT0oooo00@000000?ooo`3oool0
0000203oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo0080oooo00<006Ko0?oo
o`3oool0o`3ooolJ0?ooo`00=`3oool010000000oooo0?ooo`0000080?ooo`040000003oool0oooo
000000@0oooo0P0000000`3oool006Ko0?ooo`3o0?ooocP0oooo00@000000?ooo`3oool00000203o
ool010000000oooo0?ooo`0000040?ooo`8000000`3oool00`00I_l0oooo0?ooo`3o0?oooaX0oooo
000g0?ooo`040000003oool0oooo000000T0oooo0P0000050?ooo`040000003oool0oooo001Vool0
oooo>@3oool010000000oooo0?ooo`0000090?ooo`8000001@3oool01@000000oooo0?ooo`3oool0
06Ko0?l0oooo7@3oool003L0oooo00@000000?ooo`3oool00000203oool010000000oooo0?ooo`00
00040?ooo`030000003oool006Ko0?l0oooo>P3oool010000000oooo0?ooo`0000080?ooo`040000
003oool0oooo000000@0oooo00D000000?ooo`3oool0oooo001Vo`3o0?oooad0oooo000h0?ooo`80
00002P3oool2000000D0oooo00<000000?ooo`00I_l0o`3ooolk0?ooo`8000002P3oool2000000D0
oooo00D000000?ooo`3oool0oooo001Vo`3o0?oooad0oooo001;0?ooo`030000003oool006Ko0?l0
ooooCP3oool01@000000oooo0?ooo`3oool006Ko0?l0oooo7@3oool004/0oooo00<000000?ooo`00
I_l0o`3ooom>0?ooo`050000003oool0oooo0?ooo`00I_l0o`3ooolM0?ooo`00B`3oool00`000000
oooo001Vo`3o0?ooodh0oooo00@000000?ooo`3oool006Koo`3ooolN0?ooo`00B`3oool200000003
001Vo`3oool0oooo0?l0ooooC03oool2000000030?ooo`00I_l0oooo0?l0oooo7@3oool004/0oooo
00<000000?ooo`00I_l0o`3ooom>0?ooo`040000003oool0oooo001Vool0oooo7P3oool004/0oooo
00<000000?ooo`00I_l0o`3ooom>0?ooo`040000003oool0oooo001Vool0oooo7P3oool004/0oooo
00<000000?ooo`00I_l0o`3ooom>0?ooo`040000003oool0oooo001Vool0oooo7P3oool004/0oooo
00<00000001Vo`3oool0o`3ooom>0?ooo`040000003oool0oooo001Vool0oooo7P3oool004/0oooo
00<00000001Vo`3oool0o`3ooom>0?ooo`030000003oool006Ko0?l0oooo7`3oool004/0oooo00<0
0000001Vo`3oool0o`3ooom>0?ooo`030000003oool006Ko0?l0oooo7`3oool004/0oooo00<00000
001Vo`3oool0o`3ooom>0?ooo`030000003oool006Ko0?l0oooo7`3oool004/0oooo00<00000001V
o`3oool0o`3ooom>0?ooo`80000000<006Ko0?ooo`3oool0o`3ooolM0?ooo`00B`3oool00`000000
06Ko0?ooo`3o0?ooodh0oooo00<000000?ooo`00I_l0o`3ooolO0?ooo`00B`3oool00`00000006Ko
0?ooo`3o0?ooodh0oooo00<00000001Vo`3oool0o`3ooolO0?ooo`00B`3oool00`00000006Ko0?oo
o`3o0?ooodh0oooo00<00000001Vo`3oool0o`3ooolO0?ooo`00B`3oool00`00000006Ko0?ooo`3o
0?ooodh0oooo00<00000001Vo`3oool0o`3ooolO0?ooo`00B`3oool00`00000006Ko0?ooo`3o0?oo
odh0oooo00<00000001Vo`3oool0o`3ooolO0?ooo`00B`3oool00`00I_l0oooo0?ooo`3o0?ooodh0
oooo00<00000001Vo`3oool0o`3ooolO0?ooo`00B`3oool00`00I_l000000?ooo`3o0?ooodh0oooo
00<00000001Vo`3oool0o`3ooolO0?ooo`00B`3oool00`00I_l0oooo0?ooo`3o0?ooodh0oooo00<0
06Ko0?ooo`3oool0o`3ooolO0?ooo`00B`3oool00`00I_l0oooo0?ooo`3o0?ooodh0oooo00<006Ko
0?ooo`3oool0o`3ooolO0?ooo`00B`3oool00`00I_l0oooo0?ooo`3o0?ooodh0oooo00<006Ko0?oo
o`3oool0o`3ooolO0?ooo`00B`3oool00`000000oooo0?ooo`3o0?ooodh0oooo00<000000?ooo`3o
ool0o`3ooolO0?ooo`00@`3oool5000000<0oooo00<000000?ooo`3oool0o`3ooom60?ooo`D00000
0`3oool00`000000oooo0?ooo`3o0?oooal0oooo00150?ooo`030000003oool0oooo00<0oooo00<0
00000?ooo`3oool0o`3ooom80?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0o`3o
oolO0?ooo`00A@3oool00`000000oooo0?ooo`030?ooo`800000o`3ooom90?ooo`030000003oool0
oooo00<0oooo0P00003o0?ooob00oooo00150?ooo`030000003oool0oooo0?l0ooooCP3oool00`00
0000oooo0?ooo`3o0?ooobD0oooo00150?ooo`030000003oool0oooo0?l0ooooCP3oool00`000000
oooo0?ooo`3o0?ooobD0oooo00140?ooo`800000o`3ooom?0?ooo`800000o`3ooolW0?ooo`00o`3o
oooo0?oookh0oooo003o0?ooool0oooo_P3oool00;`0oooo0`00003o0?ooodl0oooo0`00002/0?oo
o`00_@3oool00`000000oooo0?ooo`3o0?ooodl0oooo00<000000?ooo`3oool0Z`3oool00:`0oooo
0P0000040?ooo`@000000P3oool2000000<0oooo0`0000040?ooo`@000000P3oool200000?l0oooo
<P3oool2000000@0oooo100000020?ooo`8000000`3oool3000000@0oooo100000020?ooo`800000
W`3oool00:/0oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000020?ooo`04
0000003oool0oooo00000080oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`00
00020?ooo`040000003oool0oooo00000?l0oooo<03oool010000000oooo0?ooo`0000020?ooo`04
0000003oool0oooo00000080oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`00
00020?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool00000WP3oool00:/0oooo
00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000020?ooo`030000003oool0oooo
00<0oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000020?ooo`030000003o
ool0oooo0?l0oooo<@3oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo00000080
oooo00<000000?ooo`3oool00`3oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo
00000080oooo00<000000?ooo`3oool0W`3oool00:/0oooo00D000000?ooo`3oool000000?ooo`02
000000040?ooo`00000000000?ooo`D0000000<0oooo0000000000000P0000020?ooo`80000000@0
oooo000000000000oooo1@00003o0?oooc00oooo00D000000?ooo`3oool000000?ooo`0200000004
0?ooo`00000000000?ooo`D0000000<0oooo0000000000000P0000020?ooo`80000000@0oooo0000
00000000oooo1@00002N0?ooo`00Z`3oool010000000oooo0?ooo`0000080?ooo`030000003oool0
oooo00l0oooo00<000000?ooo`3oool0o`3ooola0?ooo`040000003oool0oooo000000P0oooo00<0
00000?ooo`3oool03`3oool00`000000oooo0?ooo`2O0?ooo`00[03oool200000?l0ooooD03oool2
00000;d0oooo003o0?ooool0oooo_P3oool00?l0ooooo`3ooonn0?ooo`00o`3ooooo0?oookh0oooo
003o0?ooool0oooo_P3oool00?l0ooooo`3ooonn0?ooo`00o`3ooooo0?oookh0oooo003o0?ooool0
oooo_P3oool00?l0ooooo`3ooonn0?ooo`00o`3ooooo0?oookh0oooo003o0?ooool0oooo_P3oool0
0?l0ooooo`3ooonn0?ooo`00o`3ooooo0?oookh0oooo003o0?ooool0oooo_P3oool00?l0ooooo`3o
oonn0?ooo`00o`3ooooo0?oookh0oooo003o0?ooool0oooo_P3oool00?l0ooooo`3ooonn0?ooo`00
o`3ooooo0?oookh0oooo003o0?ooool0oooo_P3oool00?l0ooooo`3ooonn0?ooo`00o`3ooooo0?oo
okh0oooo003o0?ooool0oooo_P3oool00?l0ooooo`3ooonn0?ooo`00o`3ooooo0?oookh0oooo003o
0?ooool0oooo_P3oool00?l0ooooo`3ooonn0?ooo`00o`3ooooo0?oookh0oooo003o0?ooool0oooo
_P3oool00?l0ooooo`3ooonn0?ooo`00o`3ooooo0?oookh0oooo003o0?ooool0oooo_P3oool00?l0
ooooo`3ooonn0?ooo`00o`3ooooo0?oookh0oooo003o0?ooool0oooo_P3oool00?l0ooooo`3ooonn
0?ooo`00o`3ooooo0?oookh0oooo003o0?ooool0oooo_P3oool00?l0ooooo`3ooonn0?ooo`00o`3o
oooo0?oookh0oooo003o0?ooool0oooo_P3oool00?l0ooooo`3ooonn0?ooo`00o`3ooooo0?oookh0
oooo003o0?ooool0oooo_P3oool00?l0ooooo`3ooonn0?ooo`00o`3ooooo0?oookh0oooo003o0?oo
ool0oooo_P3oool00?l0ooooo`3ooonn0?ooo`00o`3ooooo0?oookh0oooo003o0?ooool0oooo_P3o
ool00?l0ooooo`3ooonn0?ooo`00o`3ooooo0?oookh0oooo003o0?ooool0oooo_P3oool00?l0oooo
o`3ooonn0?ooo`00o`3ooooo0?oookh0oooo003o0?ooool0oooo_P3oool00?l0ooooo`3ooonn0?oo
o`00JP3oool4000001`0oooo0`00000J0?ooo`<00000703oool2000001P0oooo1@0000020?ooo`80
00005P3oool5000000030?ooo`000000000000800000503oool5000000<0oooo0`00002B0?ooo`@0
00007@3oool3000001T0oooo0`00000L0?ooo`8000006@3oool500000080oooo0P00000E0?ooo`D0
000000<0oooo0000000000000P00000D0?ooo`D000000`3oool3000004@0oooo001Z0?ooo`030000
003oool0oooo01h0oooo00<000000?ooo`3oool06@3oool010000000oooo0?ooo`00000J0?ooo`04
0000003oool0oooo000001T0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0
oooo01D0oooo00D000000?ooo`3oool0oooo0000000I0?ooo`030000003oool0oooo00@0oooo00<0
00000?ooo`3oool0T@3oool00`000000oooo0?ooo`0O0?ooo`030000003oool0oooo01P0oooo00@0
00000?ooo`3oool000006P3oool010000000oooo0?ooo`00000J0?ooo`050000003oool0oooo0?oo
o`0000000P3oool00`000000oooo0?ooo`0D0?ooo`050000003oool0oooo0?ooo`0000006@3oool0
0`000000oooo0?ooo`040?ooo`030000003oool0oooo04<0oooo001[0?ooo`030000003oool0oooo
01X0oooo1@00000J0?ooo`040000003oool0oooo000001X0oooo00@000000?ooo`3oool000006@3o
ool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool05@3oool00`000000oooo
0?ooo`020?ooo`030000003oool0oooo01H0oooo00@000000?ooo`3oool0oooo1@00002C0?ooo`03
0000003oool0oooo01/0oooo1@00000I0?ooo`040000003oool0oooo000001X0oooo00@000000?oo
o`3oool000006P3oool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool0503o
ool00`000000oooo0?ooo`020?ooo`030000003oool0oooo01H0oooo00@000000?ooo`3oool0oooo
1@0000140?ooo`00K03oool00`000000oooo0?ooo`0I0?ooo`040000003oool0oooo000001/0oooo
0`00000L0?ooo`8000006P3oool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3o
ool05@3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo01D0oooo00D000000?ooo`3o
ool0oooo000000020?ooo`030000003oool0oooo09<0oooo00<000000?ooo`3oool06P3oool01000
0000oooo0?ooo`00000J0?ooo`<00000703oool2000001/0oooo00D000000?ooo`3oool0oooo0000
00020?ooo`030000003oool0oooo01@0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?oo
o`0E0?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`130?ooo`00JP3o
ool010000000oooo0?ooo`00000K0?ooo`030000003oool0000001`0oooo00<000000?ooo`3oool0
6P3oool010000000oooo0?ooo`00000I0?ooo`050000003oool0oooo0?ooo`0000000P3oool00`00
0000oooo0?ooo`0E0?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`0D
0?ooo`030000003oool0oooo0080oooo00<000000?ooo`000000T`3oool010000000oooo0?ooo`00
000L0?ooo`030000003oool0000001/0oooo00<000000?ooo`3oool06P3oool010000000oooo0?oo
o`00000J0?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`0D0?ooo`05
0000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo
0080oooo00<000000?ooo`000000A@3oool006/0oooo0P00000M0?ooo`800000703oool3000001/0
oooo0P00000I0?ooo`800000103oool2000001L0oooo0P0000040?ooo`8000005P3oool2000000D0
oooo0P00002D0?ooo`8000007P3oool2000001/0oooo0`00000K0?ooo`8000006P3oool2000000@0
oooo0P00000F0?ooo`800000103oool2000001H0oooo0P0000050?ooo`800000A@3oool00?l0oooo
o`3ooonn0?ooo`00o`3ooooo0?oookh0oooo003o0?ooool0oooo_P3oool00?l0ooooo`3ooonn0?oo
o`00o`3ooooo0?oookh0oooo00180?oooaD00000e@00I_l600000600ooool000000d0?ooo`00CP3o
ool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00D0oooo00<006Ko0?ooo`3oool0103o
ool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0103o
ool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool01@3o
ool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool01@3o
ool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0103o
ool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0103o
ool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool01@3o
ool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool01@3o
ool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0103o
ool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0103o
ool00`000000oooo0?ooo`1Z0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0103o
ool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool01@3o
ool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool01@3o
ool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0103o
ool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0103o
ool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool01@3o
ool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool01@3o
ool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0103o
ool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0103o
ool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool01@3o
ool00`000000oooo0?ooo`050?ooo`030000003oool0oooo03L0oooo001>0?ooo`030000003oool0
oooo00`0oooo00<006Ko0?ooo`3oool0o`3ooolo0?ooo`030000003oool0oooo0?l0oooo703oool0
04h0oooo00<000000?ooo`3oool0303oool00`00I_l0oooo0?ooo`3o0?ooocl0oooo00<000000?oo
o`3oool0o`3ooolL0?ooo`00CP3oool00`000000oooo0?ooo`0;0?ooo`03001Vo`3oool0oooo0?l0
oooo@03oool00`000000oooo0?ooo`3o0?oooa`0oooo001>0?ooo`030000003oool0oooo00/0oooo
00<006Ko0?ooo`3oool0o`3ooom00?ooo`030000003oool0oooo0?l0oooo703oool004h0oooo0P00
000<0?ooo`03001Vo`3oool0oooo0?l0oooo@03oool200000?l0oooo7@3oool004h0oooo00<00000
0?ooo`3oool02`3oool00`00I_l0oooo0?ooo`3o0?oood00oooo00<000000?ooo`3oool0o`3ooolL
0?ooo`00CP3oool00`000000oooo0?ooo`0;0?ooo`03001Vo`3oool0oooo0?l0oooo@03oool00`00
0000oooo0?ooo`3o0?oooa`0oooo001>0?ooo`030000003oool0oooo00/0oooo00<006Ko0?ooo`3o
ool0o`3ooom00?ooo`030000003oool0oooo0?l0oooo703oool004h0oooo00<000000?ooo`3oool0
2P3oool00`00I_l0oooo0?ooo`3o0?oood40oooo00<000000?ooo`3oool0o`3ooolL0?ooo`00CP3o
ool00`000000oooo0?ooo`0:0?ooo`03001Vo`3oool0oooo0?l0oooo@@3oool00`000000oooo0?oo
o`3o0?oooa`0oooo001>0?ooo`8000002`3oool00`00I_l0oooo0?ooo`3o0?oood40oooo0P00003o
0?oooad0oooo001>0?ooo`030000003oool0oooo00X0oooo00<006Ko0?ooo`3oool0o`3ooom10?oo
o`030000003oool0oooo0?l0oooo703oool004h0oooo00<000000?ooo`3oool02P3oool00`00I_l0
oooo0?ooo`3o0?oood40oooo00<000000?ooo`3oool0o`3ooolL0?ooo`00CP3oool00`000000oooo
0?ooo`0:0?ooo`03001Vo`3oool0oooo0?l0oooo@@3oool00`000000oooo0?ooo`3o0?oooa`0oooo
001>0?ooo`030000003oool0oooo00T0oooo00<006Ko0?ooo`3oool0o`3ooom20?ooo`030000003o
ool0oooo0?l0oooo703oool004h0oooo00<000000?ooo`3oool02@3oool00`00I_l0oooo0?ooo`3o
0?oood80oooo00<000000?ooo`3oool0o`3ooolL0?ooo`00CP3oool2000000X0oooo00<006Ko0?oo
o`3oool0o`3ooom20?ooo`800000o`3ooolM0?ooo`00CP3oool00`000000oooo0?ooo`090?ooo`03
001Vo`3oool0oooo0?l0oooo@P3oool00`000000oooo0?ooo`3o0?oooa`0oooo001>0?ooo`030000
003oool0oooo00T0oooo00<006Ko0?ooo`3oool0o`3ooom20?ooo`030000003oool0oooo0?l0oooo
703oool004h0oooo00<000000?ooo`3oool02@3oool00`00I_l0oooo0?ooo`3o0?oood80oooo00<0
00000?ooo`3oool0o`3ooolL0?ooo`00CP3oool00`000000oooo0?ooo`090?ooo`03001Vo`3oool0
oooo0?l0oooo@P3oool00`000000oooo0?ooo`3o0?oooa`0oooo001>0?ooo`8000002@3oool00`00
I_l0oooo0?ooo`3o0?oood<0oooo0P00003o0?oooad0oooo001>0?ooo`030000003oool0oooo00P0
oooo00<006Ko0?ooo`3oool0o`3ooom30?ooo`030000003oool0oooo0?l0oooo703oool004h0oooo
00<000000?ooo`3oool0203oool00`00I_l0oooo0?ooo`3o0?oood<0oooo00<000000?ooo`3oool0
o`3ooolL0?ooo`00CP3oool00`000000oooo0?ooo`080?ooo`03001Vo`3oool0oooo0?l0oooo@`3o
ool00`000000oooo0?ooo`3o0?oooa`0oooo000e0?ooo`800000103oool2000000@0oooo0P000003
0?ooo`D000000`3oool00`000000oooo0?ooo`080?ooo`03001Vo`3oool0oooo0?l0oooo:P3oool2
000000@0oooo0P0000040?ooo`8000000`3oool5000000<0oooo00<000000?ooo`3oool0o`3ooolL
0?ooo`00=03oool010000000oooo0?ooo`0000080?ooo`040000003oool0oooo000000@0oooo00<0
00000?ooo`3oool00`3oool00`000000oooo0?ooo`080?ooo`03001Vo`3oool0oooo0?l0oooo:@3o
ool010000000oooo0?ooo`0000080?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`3o
ool00`3oool00`000000oooo0?ooo`3o0?oooa`0oooo000d0?ooo`040000003oool0oooo000000P0
oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`030?ooo`800000203oool00`00
I_l0oooo0?ooo`3o0?ooobX0oooo00@000000?ooo`3oool00000203oool010000000oooo0?ooo`00
00040?ooo`030000003oool0oooo00<0oooo0P00003o0?oooad0oooo000d0?ooo`040000003oool0
oooo000000P0oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`030?ooo`030000
003oool0oooo00L0oooo00<006Ko0?ooo`3oool0o`3ooolZ0?ooo`040000003oool0oooo000000P0
oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo
0?l0oooo703oool003@0oooo00@000000?ooo`3oool00000203oool010000000oooo0?ooo`000004
0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool01`3oool00`00I_l0oooo0?ooo`3o
0?ooobX0oooo00@000000?ooo`3oool00000203oool010000000oooo0?ooo`0000040?ooo`030000
003oool0oooo00<0oooo00<000000?ooo`3oool0o`3ooolL0?ooo`00=@3oool2000000X0oooo0P00
00040?ooo`8000001@3oool00`000000oooo0?ooo`070?ooo`03001Vo`3oool0oooo0?l0oooo:`3o
ool2000000X0oooo0P0000040?ooo`8000001@3oool00`000000oooo0?ooo`3o0?oooa`0oooo001>
0?ooo`030000003oool0oooo00L0oooo00<006Ko0?ooo`3oool0o`3ooom40?ooo`030000003oool0
oooo0?l0oooo703oool004h0oooo00<000000?ooo`3oool01`3oool00`00I_l0oooo0?ooo`3o0?oo
od@0oooo00<000000?ooo`3oool0o`3ooolL0?ooo`00CP3oool2000000L0oooo00<006Ko0?ooo`3o
ool0o`3ooom50?ooo`800000o`3ooolM0?ooo`00CP3oool00`000000oooo0?ooo`060?ooo`03001V
o`3oool0oooo0?l0ooooA@3oool00`000000oooo0?ooo`3o0?oooa`0oooo001>0?ooo`030000003o
ool0oooo00H0oooo00<006Ko0?ooo`3oool0o`3ooom50?ooo`030000003oool0oooo0?l0oooo703o
ool004h0oooo00<000000?ooo`3oool01P3oool00`00I_l0oooo0?ooo`3o0?ooodD0oooo00<00000
0?ooo`3oool0o`3ooolL0?ooo`00CP3oool00`000000oooo0?ooo`060?ooo`03001Vo`3oool0oooo
0?l0ooooA@3oool00`000000oooo0?ooo`3o0?oooa`0oooo001>0?ooo`030000003oool0oooo00H0
oooo00<006Ko0?ooo`3oool0o`3ooom50?ooo`030000003oool0oooo0?l0oooo703oool004h0oooo
0P0000070?ooo`03001Vo`3oool0oooo0?l0ooooA@3oool200000?l0oooo7@3oool004h0oooo00<0
00000?ooo`3oool01@3oool00`00I_l0oooo0?ooo`3o0?ooodH0oooo00<000000?ooo`3oool0o`3o
oolL0?ooo`00CP3oool00`000000oooo0?ooo`050?ooo`03001Vo`3oool0oooo0?l0ooooAP3oool0
0`000000oooo0?ooo`3o0?oooa`0oooo001>0?ooo`030000003oool0oooo00D0oooo00<006Ko0?oo
o`3oool0o`3ooom60?ooo`030000003oool0oooo0?l0oooo703oool004h0oooo00<000000?ooo`3o
ool01@3oool00`00I_l0oooo0?ooo`3o0?ooodH0oooo00<000000?ooo`3oool0o`3ooolL0?ooo`00
CP3oool00`000000oooo0?ooo`050?ooo`03001Vo`3oool0oooo0?l0ooooAP3oool00`000000oooo
0?ooo`3o0?oooa`0oooo001>0?ooo`8000001P3oool00`00I_l0oooo0?ooo`3o0?ooodH0oooo0P00
003o0?oooad0oooo001>0?ooo`030000003oool0oooo00@0oooo00<006Ko0?ooo`3oool0o`3ooom7
0?ooo`030000003oool0oooo0?l0oooo703oool004h0oooo00<000000?ooo`3oool0103oool00`00
I_l0oooo0?ooo`3o0?ooodL0oooo00<000000?ooo`3oool0o`3ooolL0?ooo`00CP3oool00`000000
oooo0?ooo`040?ooo`03001Vo`3oool0oooo0?l0ooooA`3oool00`000000oooo0?ooo`3o0?oooa`0
oooo001>0?ooo`030000003oool0oooo00@0oooo00<006Ko0?ooo`3oool0o`3ooom70?ooo`030000
003oool0oooo0?l0oooo703oool004h0oooo00<000000?ooo`3oool0103oool00`00I_l0oooo0?oo
o`3o0?ooodL0oooo00<000000?ooo`3oool0o`3ooolL0?ooo`00CP3oool2000000D0oooo00<006Ko
0?ooo`3oool0o`3ooom70?ooo`800000o`3ooolM0?ooo`00CP3oool00`000000oooo0?ooo`030?oo
o`03001Vo`3oool0oooo0?l0ooooB03oool00`000000oooo0?ooo`3o0?oooa`0oooo001>0?ooo`03
0000003oool0oooo00<0oooo00<006Ko0?ooo`3oool0o`3ooom80?ooo`030000003oool0oooo0?l0
oooo703oool004h0oooo00<000000?ooo`3oool00`3oool00`00I_l0oooo0?ooo`3o0?ooodP0oooo
00<000000?ooo`3oool0o`3ooolL0?ooo`00=@3oool2000000@0oooo0P0000040?ooo`8000000`3o
ool4000000@0oooo00<000000?ooo`3oool00`3oool00`00I_l0oooo0?ooo`3o0?ooobl0oooo0P00
00040?ooo`800000103oool2000000<0oooo100000040?ooo`030000003oool0oooo0?l0oooo703o
ool003@0oooo00@000000?ooo`3oool00000203oool010000000oooo0?ooo`0000020?ooo`030000
003oool0oooo00D0oooo00<000000?ooo`3oool00`3oool00`00I_l0oooo0?ooo`3o0?ooobh0oooo
00@000000?ooo`3oool00000203oool010000000oooo0?ooo`0000020?ooo`030000003oool0oooo
00D0oooo00<000000?ooo`3oool0o`3ooolL0?ooo`00=03oool010000000oooo0?ooo`0000080?oo
o`040000003oool0oooo000000<0oooo00<000000?ooo`3oool0103oool2000000@0oooo00<006Ko
0?ooo`3oool0o`3oool^0?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`3oool00000
0`3oool00`000000oooo0?ooo`040?ooo`800000o`3ooolM0?ooo`00=03oool010000000oooo0?oo
o`0000080?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`3oool00`3oool00`000000
oooo0?ooo`030?ooo`03001Vo`3oool0oooo0?l0oooo;P3oool010000000oooo0?ooo`0000080?oo
o`040000003oool0oooo000000@0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`3o
0?oooa`0oooo000d0?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`3oool000000P3o
ool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo0080oooo00<006Ko0?ooo`3oool0
o`3oool_0?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`3oool000000P3oool01000
0000oooo0?ooo`0000040?ooo`030000003oool0oooo0?l0oooo703oool003D0oooo0P00000:0?oo
o`800000103oool2000000D0oooo00<000000?ooo`3oool00P3oool00`00I_l0oooo0?ooo`3o0?oo
oc00oooo0P00000:0?ooo`800000103oool2000000D0oooo00<000000?ooo`3oool0o`3ooolL0?oo
o`00CP3oool00`000000oooo0?ooo`020?ooo`03001Vo`3oool0oooo0?l0ooooB@3oool00`000000
oooo0?ooo`3o0?oooa`0oooo001>0?ooo`030000003oool0oooo0080oooo00<006Ko0?ooo`3oool0
o`3ooom90?ooo`030000003oool0oooo0?l0oooo703oool004h0oooo0P0000030?ooo`03001Vo`3o
ool0oooo0?l0ooooB@3oool200000?l0oooo7@3oool004h0oooo00<000000?ooo`3oool00P3oool0
0`00I_l0oooo0?ooo`3o0?ooodT0oooo00<000000?ooo`3oool0o`3ooolL0?ooo`00CP3oool01@00
0000oooo0?ooo`3oool006Ko0?l0ooooC03oool00`000000oooo0?ooo`3o0?oooa`0oooo001>0?oo
o`050000003oool0oooo0?ooo`00I_l0o`3ooom<0?ooo`030000003oool0oooo0?l0oooo703oool0
04h0oooo00D000000?ooo`3oool0oooo001Vo`3o0?oood`0oooo00<000000?ooo`3oool0o`3ooolL
0?ooo`00CP3oool01@000000oooo0?ooo`3oool006Ko0?l0ooooC03oool00`000000oooo0?ooo`3o
0?oooa`0oooo001>0?ooo`8000000P3oool00`00I_l0oooo0?ooo`3o0?ooodX0oooo0P00003o0?oo
oad0oooo001>0?ooo`050000003oool0oooo0?ooo`00I_l0o`3ooom<0?ooo`030000003oool0oooo
0?l0oooo703oool004h0oooo00@000000?ooo`3oool006Koo`3ooom=0?ooo`030000003oool0oooo
0?l0oooo703oool004h0oooo00@000000?ooo`3oool006Koo`3ooom=0?ooo`030000003oool0oooo
0?l0oooo703oool004h0oooo00@000000?ooo`3oool006Koo`3ooom=0?ooo`030000003oool0oooo
0?l0oooo703oool004h0oooo00@000000?ooo`3oool006Koo`3ooom=0?ooo`030000003oool0oooo
0?l0oooo703oool004h0oooo0P0000000`3oool006Ko0?ooo`3o0?oood`0oooo0P00003o0?oooad0
oooo001>0?ooo`040000003oool0oooo001Vool0ooooC@3oool00`000000oooo0?ooo`3o0?oooa`0
oooo001>0?ooo`040000003oool0oooo001Vool0ooooC@3oool00`000000oooo0?ooo`3o0?oooa`0
oooo001>0?ooo`030000003oool006Ko0?l0ooooCP3oool00`000000oooo0?ooo`3o0?oooa`0oooo
001>0?ooo`030000003oool006Ko0?l0ooooCP3oool00`000000oooo0?ooo`3o0?oooa`0oooo001>
0?ooo`80000000<006Ko0?ooo`3oool0o`3ooom<0?ooo`800000o`3ooolM0?ooo`00CP3oool00`00
0000oooo001Vo`3o0?ooodh0oooo00<000000?ooo`3oool0o`3ooolL0?ooo`00CP3oool00`000000
oooo001Vo`3o0?ooodh0oooo00<000000?ooo`3oool0o`3ooolL0?ooo`00CP3oool00`000000oooo
001Vo`3o0?ooodh0oooo00<000000?ooo`3oool0o`3ooolL0?ooo`00=@3oool2000000@0oooo0P00
00040?ooo`800000103oool2000000D0oooo00<00000001Vo`3oool0o`3ooole0?ooo`800000103o
ool2000000@0oooo0P0000040?ooo`8000001@3oool00`000000oooo0?ooo`3o0?oooa`0oooo000d
0?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`3oool000000P3oool010000000oooo
0?ooo`0000040?ooo`0300000000I_l0oooo0?l0oooo=03oool010000000oooo0?ooo`0000080?oo
o`040000003oool0oooo00000080oooo00@000000?ooo`3oool00000103oool00`000000oooo0?oo
o`3o0?oooa`0oooo000d0?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`3oool00000
103oool00`000000oooo0?ooo`030?ooo`0300000000I_l0oooo0?l0oooo=03oool010000000oooo
0?ooo`0000080?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`3oool00`3oool20000
0?l0oooo7@3oool003@0oooo00@000000?ooo`3oool00000203oool010000000oooo0?ooo`000005
0?ooo`030000003oool0oooo0080oooo00<00000001Vo`3oool0o`3ooold0?ooo`040000003oool0
oooo000000P0oooo00@000000?ooo`3oool000001@3oool00`000000oooo0?ooo`020?ooo`030000
003oool0oooo0?l0oooo703oool003@0oooo00@000000?ooo`3oool00000203oool010000000oooo
0?ooo`0000020?ooo`040000003oool0oooo000000@0oooo00<00000001Vo`3oool0o`3ooold0?oo
o`040000003oool0oooo000000P0oooo00@000000?ooo`3oool000000P3oool010000000oooo0?oo
o`0000040?ooo`030000003oool0oooo0?l0oooo703oool003D0oooo0P00000:0?ooo`800000103o
ool2000000D0oooo00<00000001Vo`3oool0o`3ooole0?ooo`8000002P3oool2000000@0oooo0P00
00050?ooo`030000003oool0oooo0?l0oooo703oool004h0oooo00<006Ko0?ooo`3oool0o`3ooom>
0?ooo`030000003oool0oooo0?l0oooo703oool004h0oooo00<006Ko0?ooo`3oool0o`3ooom>0?oo
o`030000003oool0oooo0?l0oooo703oool004h0oooo00<006Ko0000003oool0o`3ooom>0?ooo`80
0000o`3ooolM0?ooo`00CP3oool00`00I_l0oooo0?ooo`3o0?ooodh0ooooi@00I_li0?ooo`00CP3o
ool00`000000oooo0?ooo`3o0?ooodh0oooo00<000000?ooo`3oool0o`3ooolL0?ooo`00CP3oool0
0`000000oooo0?ooo`3o0?ooodh0oooo00<000000?ooo`3oool0o`3ooolL0?ooo`00CP3oool00`00
0000oooo0?ooo`3o0?ooodh0oooo00<000000?ooo`3oool0o`3ooolL0?ooo`00CP3oool00`000000
oooo0?ooo`3o0?ooodh0oooo00<000000?ooo`3oool0o`3ooolL0?ooo`00CP3oool200000?l0oooo
C`3oool200000?l0oooo7@3oool004h0oooo00<000000?ooo`3oool0o`3ooom>0?ooo`030000003o
ool0oooo0?l0oooo703oool004h0oooo00<000000?ooo`3oool0o`3ooom>0?ooo`030000003oool0
oooo0?l0oooo703oool004h0oooo00<000000?ooo`3oool0o`3ooom>0?ooo`030000003oool0oooo
0?l0oooo703oool004h0oooo00<000000?ooo`3oool0o`3ooom>0?ooo`030000003oool0oooo0?l0
oooo703oool004h0oooo00<000000?ooo`3oool0o`3ooom>0?ooo`030000003oool0oooo0?l0oooo
703oool004h0oooo0P00003o0?ooodl0oooo0P00003o0?oooad0oooo001>0?ooo`030000003oool0
oooo0?l0ooooCP3oool00`000000oooo0?ooo`3o0?oooa`0oooo001>0?ooo`030000003oool0oooo
0?l0ooooCP3oool00`000000oooo0?ooo`3o0?oooa`0oooo001>0?ooo`030000003oool0oooo0?l0
ooooCP3oool00`000000oooo0?ooo`3o0?oooa`0oooo001>0?ooo`030000003oool0oooo0?l0oooo
CP3oool00`000000oooo0?ooo`3o0?oooa`0oooo001>0?ooo`030000003oool0oooo0?l0ooooCP3o
ool00`000000oooo0?ooo`3o0?oooa`0oooo001>0?ooo`800000o`3ooom?0?ooo`800000o`3ooolM
0?ooo`00CP3oool00`000000oooo0?ooo`3o0?ooodh0oooo00<000000?ooo`3oool0o`3ooolL0?oo
o`00CP3oool00`000000oooo0?ooo`3o0?ooodh0oooo00<000000?ooo`3oool0o`3ooolL0?ooo`00
CP3oool00`000000oooo0?ooo`3o0?ooodh0oooo00<000000?ooo`3oool0o`3ooolL0?ooo`00=@3o
ool2000000@0oooo0P0000040?ooo`8000001@3oool3000000<0oooo00<000000?ooo`3oool0o`3o
oole0?ooo`800000103oool2000000@0oooo0P0000050?ooo`<000000`3oool00`000000oooo0?oo
o`3o0?oooa`0oooo000d0?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`3oool00000
1@3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0?l0oooo=03oool010000000oooo
0?ooo`0000080?ooo`040000003oool0oooo000000D0oooo00<000000?ooo`3oool00P3oool00`00
0000oooo0?ooo`3o0?oooa`0oooo000d0?ooo`040000003oool0oooo000000P0oooo00@000000?oo
o`3oool000000P3oool5000000<0oooo0P00003o0?ooocD0oooo00@000000?ooo`3oool00000203o
ool010000000oooo0?ooo`0000020?ooo`D000000`3oool200000?l0oooo7@3oool003@0oooo00@0
00000?ooo`3oool00000203oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo0000
00@0oooo00<000000?ooo`3oool0o`3ooold0?ooo`040000003oool0oooo000000P0oooo00@00000
0?ooo`3oool000000P3oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo0?l0oooo
703oool003@0oooo00@000000?ooo`3oool00000203oool010000000oooo0?ooo`0000030?ooo`03
0000003oool0000000@0oooo00<000000?ooo`3oool0o`3ooold0?ooo`040000003oool0oooo0000
00P0oooo00@000000?ooo`3oool000000`3oool00`000000oooo000000040?ooo`030000003oool0
oooo0?l0oooo703oool003D0oooo0P00000:0?ooo`8000001@3oool2000000@0oooo00<000000?oo
o`3oool0o`3ooole0?ooo`8000002P3oool2000000D0oooo0P0000040?ooo`030000003oool0oooo
0?l0oooo703oool004h0oooo00<000000?ooo`3oool0o`3ooom>0?ooo`030000003oool0oooo0?l0
oooo703oool004h0oooo00<000000?ooo`3oool0o`3ooom>0?ooo`030000003oool0oooo0?l0oooo
703oool004h0oooo0P00003o0?ooodl0oooo0P00003o0?oooad0oooo001>0?ooo`030000003oool0
oooo0?l0ooooCP3oool00`000000oooo0?ooo`3o0?oooa`0oooo001>0?ooo`030000003oool0oooo
0?l0ooooCP3oool00`000000oooo0?ooo`3o0?oooa`0oooo001>0?ooo`030000003oool0oooo0?l0
ooooCP3oool00`000000oooo0?ooo`3o0?oooa`0oooo001>0?ooo`030000003oool0oooo0?l0oooo
CP3oool00`000000oooo0?ooo`3o0?oooa`0oooo001>0?ooo`030000003oool0oooo0?l0ooooCP3o
ool00`000000oooo0?ooo`3o0?oooa`0oooo001>0?ooo`800000o`3ooom?0?ooo`800000o`3ooolM
0?ooo`00CP3oool00`000000oooo0?ooo`3o0?ooodh0oooo00<000000?ooo`3oool0o`3ooolL0?oo
o`00CP3oool00`000000oooo0?ooo`3o0?ooodh0oooo00<000000?ooo`3oool0o`3ooolL0?ooo`00
CP3oool00`000000oooo0?ooo`3o0?ooodh0oooo00<000000?ooo`3oool0o`3ooolL0?ooo`00CP3o
ool00`000000oooo0?ooo`3o0?ooodh0oooo00<000000?ooo`3oool0o`3ooolL0?ooo`00CP3oool0
0`000000oooo0?ooo`3o0?ooodh0oooo00<000000?ooo`3oool0o`3ooolL0?ooo`00CP3oool20000
0?l0ooooC`3oool200000?l0oooo7@3oool004h0oooo00<000000?ooo`3oool0o`3ooom>0?ooo`03
0000003oool0oooo0?l0oooo703oool004h0oooo00<000000?ooo`3oool0o`3ooom>0?ooo`030000
003oool0oooo0?l0oooo703oool004h0oooo00<000000?ooo`3oool0o`3ooom>0?ooo`030000003o
ool0oooo0?l0oooo703oool004h0oooo00<000000?ooo`3oool0o`3ooom>0?ooo`030000003oool0
oooo0?l0oooo703oool004h0oooo00<000000?ooo`3oool0o`3ooom>0?ooo`030000003oool0oooo
0?l0oooo703oool004h0oooo0P00003o0?ooodl0oooo0P00003o0?oooad0oooo001>0?ooo`030000
003oool0oooo0?l0ooooCP3oool00`000000oooo0?ooo`3o0?oooa`0oooo001>0?ooo`030000003o
ool0oooo0?l0ooooCP3oool00`000000oooo0?ooo`3o0?oooa`0oooo000e0?ooo`800000103oool2
000000@0oooo0P0000040?ooo`8000001@3oool00`000000oooo0?ooo`3o0?ooocD0oooo0P000004
0?ooo`800000103oool2000000@0oooo0P0000050?ooo`030000003oool0oooo0?l0oooo703oool0
03@0oooo00@000000?ooo`3oool00000203oool010000000oooo0?ooo`0000020?ooo`040000003o
ool0oooo000000@0oooo00<000000?ooo`3oool0o`3ooold0?ooo`040000003oool0oooo000000P0
oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000040?ooo`030000003oool0
oooo0?l0oooo703oool003@0oooo00@000000?ooo`3oool00000203oool010000000oooo0?ooo`00
00050?ooo`030000003oool0oooo0080oooo0P00003o0?ooocD0oooo00@000000?ooo`3oool00000
203oool010000000oooo0?ooo`0000050?ooo`030000003oool0oooo0080oooo0P00003o0?oooad0
oooo000d0?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`3oool000000`3oool20000
0?l0oooo?03oool010000000oooo0?ooo`0000080?ooo`040000003oool0oooo000000<0oooo0P00
003o0?ooob@0oooo000d0?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`3oool00000
0`3oool00`000000oooo0?ooo`3o0?oooc/0oooo00@000000?ooo`3oool00000203oool010000000
oooo0?ooo`0000030?ooo`030000003oool0oooo0?l0oooo8`3oool003D0oooo0P00000:0?ooo`80
0000103oool300000?l0oooo?03oool2000000X0oooo0P0000040?ooo`<00000o`3ooolS0?ooo`00
o`3ooooo0?oookh0oooo003o0?ooool0oooo_P3oool00?l0ooooo`3ooonn0?ooo`00o`3ooooo0?oo
okh0oooo002N0?ooo`<00000103oool4000000<0oooo0`0000030?ooo`<000000`3oool3000000P0
oooo0`0000040?ooo`<000000`3oool2000000@0oooo0`0000020?ooo`<00000o`3ooolB0?ooo`<0
0000103oool4000000<0oooo0`0000030?ooo`<000000`3oool3000000P0oooo0`0000040?ooo`<0
00000`3oool2000000@0oooo0`0000020?ooo`<00000S@3oool009l0oooo00<000000?ooo`3oool0
103oool00`000000oooo0?ooo`040?ooo`050000003oool0oooo0?ooo`0000001@3oool00`000000
oooo0?ooo`0:0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0103oool2000000<0
oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`3o0?oooa80oooo00<000000?ooo`3o
ool0103oool00`000000oooo0?ooo`040?ooo`050000003oool0oooo0?ooo`0000001@3oool00`00
0000oooo0?ooo`0:0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0103oool20000
00<0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`2<0?ooo`00W`3oool3000000@0
oooo00<000000?ooo`3oool0103oool01@000000oooo0?ooo`3oool0000000D0oooo100000090?oo
o`030000003oool0oooo0080oooo100000020?ooo`040000003oool0oooo00000080oooo10000003
0?ooo`030000003oool0oooo0?l0oooo4P3oool3000000@0oooo00<000000?ooo`3oool0103oool0
1@000000oooo0?ooo`3oool0000000D0oooo100000090?ooo`030000003oool0oooo0080oooo1000
00020?ooo`040000003oool0oooo00000080oooo100000030?ooo`030000003oool0oooo08`0oooo
002O0?ooo`040000003oool0oooo00000080oooo100000030?ooo`800000103oool3000000<0oooo
0P00000:0?ooo`030000003oool0oooo00<0oooo0P0000020?ooo`8000000P3oool200000080oooo
0P0000040?ooo`030000003oool0oooo0?l0oooo4P3oool010000000oooo0?ooo`0000020?ooo`@0
00000`3oool2000000@0oooo0`0000030?ooo`8000002P3oool00`000000oooo0?ooo`030?ooo`80
00000P3oool200000080oooo0P0000020?ooo`800000103oool00`000000oooo0?ooo`2<0?ooo`00
W`3oool010000000oooo0?ooo`00000Q0?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3o
ool0o`3ooolB0?ooo`040000003oool0oooo00000240oooo00<000000?ooo`3oool05@3oool00`00
0000oooo0?ooo`2<0?ooo`00WP3oool4000000/0oooo00<000000?ooo`3oool04`3oool2000001H0
oooo0P00003o0?oooa<0oooo1000000;0?ooo`030000003oool0oooo01<0oooo0P00000F0?ooo`80
0000SP3oool00?l0ooooo`3ooonn0?ooo`00o`3ooooo0?oookh0oooo003o0?ooool0oooo_P3oool0
0?l0ooooo`3ooonn0?ooo`00o`3ooooo0?oookh0oooo003o0?ooool0oooo_P3oool00?l0ooooo`3o
oonn0?ooo`00o`3ooooo0?oookh0oooo003o0?ooool0oooo_P3oool00?l0ooooo`3ooonn0?ooo`00
o`3ooooo0?oookh0oooo003o0?ooool0oooo_P3oool00?l0ooooo`3ooonn0?ooo`00o`3ooooo0?oo
okh0oooo003o0?ooool0oooo_P3oool00?l0ooooo`3ooonn0?ooo`00o`3ooooo0?oookh0oooo003o
0?ooool0oooo_P3oool00?l0ooooo`3ooonn0?ooo`00o`3ooooo0?oookh0oooo003o0?ooool0oooo
_P3oool00?l0ooooo`3ooonn0?ooo`00o`3ooooo0?oookh0oooo003o0?ooool0oooo_P3oool00?l0
ooooo`3ooonn0?ooo`00dP3oool2000001`0oooo0P00003o0?ooob/0oooo0P00000L0?ooo`800000
P03oool00=@0oooo00<000000?ooo`3oool06`3oool00`000000oooo0?ooo`3o0?ooobX0oooo00<0
00000?ooo`3oool06`3oool00`000000oooo0?ooo`1m0?ooo`00MP3oool3000000@0oooo10000000
0`3oool0000000000003000000<0oooo0`0000030?ooo`<000001`3oool5000000<0oooo0`000003
0?ooo`800000103oool3000000030?ooo`000000000000<00000203oool3000000<0oooo1@000000
0`3oool0000000000002000000<0oooo0`0000030?ooo`<00000103oool2000000030?ooo`000000
000000<0000000D0oooo00000000000000000?ooo`0200000080oooo0`00003I0?ooo`D0000000D0
oooo00000000000000000?ooo`02000000030?ooo`00000000000080000000<0oooo000000000000
0`0000020?ooo`D000000`3oool2000000030?ooo`000000000000<000000`3oool200000080oooo
0`0000000`3oool00000000000070?ooo`<000000`3oool5000000030?ooo`000000000000800000
0`3oool3000000<0oooo0`0000040?ooo`80000000<0oooo0000000000000`0000001@3oool00000
000000000000oooo008000000P3oool3000007l0oooo001g0?ooo`030000003oool0oooo00@0oooo
00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00<0oooo
00<000000?ooo`3oool00`3oool400000080oooo00@000000?ooo`3oool000000P3oool00`000000
oooo0?ooo`030?ooo`040000003oool0oooo00000080oooo00<000000?ooo`3oool0103oool00`00
0000oooo0?ooo`090?ooo`030000003oool0oooo0080oooo00@000000?ooo`3oool000000`3oool0
0`000000oooo0?ooo`020?ooo`040000003oool0oooo00000080oooo00<000000?ooo`3oool0103o
ool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0080oooo00@000000?ooo`3oool00000
0P3oool010000000oooo0?ooo`00003K0?ooo`030000003oool0oooo0080oooo00@000000?ooo`3o
ool000000`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0080oooo00@000000?oo
o`3oool000000`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0080oooo00@00000
0?ooo`3oool000000P3oool010000000oooo0?ooo`0000090?ooo`030000003oool0oooo0080oooo
00@000000?ooo`3oool000000`3oool00`000000oooo0?ooo`020?ooo`040000003oool0oooo0000
0080oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo
0080oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`00001o0?ooo`00M`3oool3
000000@0oooo0P0000040?ooo`030000003oool0oooo0080oooo00@000000?ooo`3oool000000P3o
ool4000000P0oooo00<000000?ooo`3oool00`3oool400000080oooo00@000000?ooo`3oool00000
0P3oool4000000<0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`030?ooo`<00000
0`3oool2000000<0oooo00@000000?ooo`3oool000000P3oool4000000<0oooo00<000000?ooo`3o
ool00`3oool00`000000oooo0?ooo`020?ooo`040000003oool0oooo00000080oooo00@000000?oo
o`3oool00000f`3oool00`000000oooo0?ooo`020?ooo`040000003oool0oooo000000<0oooo00<0
00000?ooo`3oool00`3oool00`000000oooo0?ooo`030?ooo`<000000`3oool00`000000oooo0?oo
o`030?ooo`030000003oool0oooo0080oooo00@000000?ooo`3oool000000P3oool010000000oooo
0?ooo`0000090?ooo`030000003oool0oooo00<0oooo0`0000030?ooo`8000000`3oool010000000
oooo0?ooo`0000020?ooo`@000000`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo
0080oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`00001o0?ooo`00M`3oool0
10000000oooo0?ooo`0000020?ooo`80000000<0oooo0000000000000`0000050?ooo`<000000`3o
ool2000000T0oooo00<000000?ooo`3oool0103oool200000080oooo0P0000020?ooo`8000000P3o
ool2000000@0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`020?ooo`<000000`3o
ool2000000030?ooo`00000000000080oooo100000020?ooo`8000000`3oool4000000040?ooo`00
00000000000000<0oooo100000040?ooo`@00000fP3oool010000000oooo0?ooo`3oool4000000<0
oooo100000030?ooo`030000003oool0oooo0080oooo0`0000030?ooo`@0000000@0oooo00000000
000000001@3oool200000080oooo1000000:0?ooo`030000003oool0oooo0080oooo0`0000030?oo
o`80000000<0oooo0000000000000P3oool400000080oooo0P0000030?ooo`@0000000@0oooo0000
0000000000000`3oool4000000@0oooo1000001n0?ooo`00M`3oool010000000oooo0?ooo`00000P
0?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3oool01`3oool01@000000oooo0000003o
ool0000001/0oooo00<000000?ooo`3oool0k@3oool00`000000oooo0?ooo`090?ooo`030000003o
ool0oooo00<0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0I0?ooo`050000003o
ool000000?ooo`0000006`3oool00`000000oooo0?ooo`2A0?ooo`00MP3oool4000000X0oooo00<0
00000?ooo`3oool04`3oool3000001D0oooo0`0000090?ooo`D000006`3oool00`000000oooo0?oo
o`030?ooo`030000003oool0oooo0>D0oooo1@00000:0?ooo`H000002`3oool00`000000oooo0?oo
o`030?ooo`030000003oool0oooo01<0oooo1@00000K0?ooo`030000003oool0oooo00<0oooo00<0
00000?ooo`3oool0R`3oool00?l0ooooo`3ooonn0?ooo`00o`3ooooo0?oookh0oooo003o0?ooool0
oooo_P3oool00?l0ooooo`3ooonn0?ooo`00o`3ooooo0?oookh0oooo003o0?ooool0oooo_P3oool0
0?l0ooooo`3ooonn0?ooo`00o`3ooooo0?oookh0oooo003o0?ooool0oooo_P3oool00?l0ooooo`3o
oonn0?ooo`00o`3ooooo0?oookh0oooo003o0?ooool0oooo_P3oool00?l0ooooo`3ooonn0?ooo`00
o`3ooooo0?oookh0oooo003o0?ooool0oooo_P3oool00?l0ooooo`3ooonn0?ooo`00o`3ooooo0?oo
okh0oooo003o0?ooool0oooo_P3oool00?l0ooooo`3ooonn0?ooo`00o`3ooooo0?oookh0oooo003o
0?ooool0oooo_P3oool00?l0ooooo`3ooonn0?ooo`00o`3ooooo0?oookh0oooo003o0?ooool0oooo
_P3oool00?l0ooooo`3ooonn0?ooo`00o`3ooooo0?oookh0oooo003o0?ooool0oooo_P3oool00?l0
ooooo`3ooonn0?ooo`00o`3ooooo0?oookh0oooo003o0?ooool0oooo_P3oool00?l0ooooo`3ooonn
0?ooo`00>@3oool4000004h0oooo1@00003V0?ooo`D00000i`3oool4000002@0oooo1000000^0?oo
o`00?03oool2000004h0oooo0P00003Y0?ooo`800000k03oool2000002H0oooo0P00000]0?ooo`00
?03oool2000004h0oooo0P00003Y0?ooo`800000k03oool2000002H0oooo0P00000]0?ooo`009`3o
ool5000000@0oooo1P0000030?ooo`80000000<0oooo0000000000000`3oool=000000<0oooo1000
000>0?ooo`H00000103oool2000000d0oooo2@000000103oool000000000003oool5000000030?oo
o`000000000000@0oooo1P0000020?ooo`@000001@3oool3000000h0oooo100000020?ooo`L00000
3@3oool6000000X0oooo0P000000103oool000000000000000020?ooo`@0000000D0oooo00000000
000000000?ooo`02000000050?ooo`00000000000000003oool02@0000020?ooo`<000000P3oool2
000000040?ooo`0000000000000000`0oooo1@0000020?ooo`<000000P3oool300000080oooo1000
00040?ooo`@000000P3oool3000000030?ooo`0000000000008000002`3oool01@000000oooo0?oo
o`3oool0000000<0oooo1P0000040?ooo`<000000P3oool300000080oooo0`00000;0?ooo`800000
00<0oooo0000000000000P3oool700000080oooo1P0000030?ooo`@00000103oool4000000d0oooo
200000020?ooo`@00000103oool3000000D0oooo100000020?ooo`P00000303oool400000080oooo
1`00000;0?ooo`H0000000@0oooo00000000000000000P3oool:000000030?ooo`000000000000H0
00000P3oool6000000<0oooo0`0000030?ooo`H000000`3oool400000080oooo0`0000020?ooo`<0
00003`3oool3000000@0oooo3@0000030?ooo`80000000<0oooo0000000000000`3oool4000000D0
oooo0`0000030?ooo`H0000000@0oooo00000000000000000P3oool300000080oooo0P0000000`3o
ool000000000000]0?ooo`00:03oool2000000P0oooo0P0000040?ooo`80000000@0oooo00000000
000000000P3oool200000080oooo0P0000030?ooo`8000001@3oool2000000<0oooo00<000000?oo
o`3oool03@3oool2000000H0oooo0P00000?0?ooo`8000000`3oool2000000040?ooo`0000000000
0?ooo`80000000D0oooo00000000000000000?ooo`0200000080oooo0P0000020?ooo`8000000P3o
ool2000000<0oooo00@000000?ooo`3oool0oooo0P0000020?ooo`030000003oool0oooo00X0oooo
0P0000020?ooo`8000000`3oool2000000l0oooo0P0000020?ooo`8000002P3oool2000000040?oo
o`000000000000000080oooo0P0000030?ooo`050000003oool000000000003oool00P000000103o
ool000000000003oool200000080oooo0P0000020?ooo`8000000P3oool200000080oooo0P000000
103oool0000000000000000=0?ooo`8000000P3oool200000080oooo0P0000020?ooo`8000000P3o
ool200000080oooo0P0000020?ooo`8000000`3oool00`000000oooo0?ooo`0200000080oooo0P00
000<0?ooo`80000000<0oooo0000000000001@3oool2000000D0oooo0P0000020?ooo`030000003o
ool0oooo008000000P3oool2000000`0oooo0`0000000`3oool00000000000030?ooo`8000001`3o
ool2000000@0oooo0P0000030?ooo`030000003oool0oooo008000000`3oool00`000000oooo0?oo
o`0=0?ooo`800000103oool2000000<0oooo00@000000?ooo`3oool0oooo0`0000040?ooo`800000
0`3oool00`000000oooo0?ooo`020?ooo`8000003P3oool200000080oooo0P0000030?ooo`800000
403oool2000000@0oooo0P0000020?ooo`8000000`3oool2000000L0oooo0P0000040?ooo`800000
0P3oool2000000<0oooo0P0000020?ooo`030000003oool0oooo0080oooo0P0000040?ooo`800000
0P3oool200000080oooo0P0000020?ooo`8000003`3oool200000080oooo00<000000?ooo`3oool0
0P0000020?ooo`8000000`3oool2000000D0oooo0P000000103oool000000000000000020?ooo`80
00000`3oool010000000oooo0?ooo`3oool200000080oooo00<000000?ooo`3oool00P3oool20000
00@0oooo0P0000020?ooo`8000000P3oool2000000040?ooo`0000000000000002d0oooo000X0?oo
o`800000203oool2000000@0oooo0P0000020?ooo`8000000P3oool200000080oooo0P0000030?oo
o`8000001@3oool2000001<0oooo0P00000G0?ooo`8000000`3oool2000000040?ooo`0000000000
0?ooo`80000000<0oooo0000000000000P3oool200000080oooo0P0000020?ooo`8000000P3oool2
000000L0oooo0P00000?0?ooo`8000000P3oool2000000<0oooo0P00000?0?ooo`8000000P3oool2
000000X0oooo0P0000020?ooo`8000000P3oool2000000D0oooo0P000000103oool000000000003o
ool2000000030?ooo`00000000000080oooo0P0000020?ooo`8000000P3oool200000080oooo0P00
00020?ooo`8000003`3oool400000080oooo0P0000020?ooo`8000000P3oool200000080oooo0P00
00020?ooo`8000001P3oool5000000d0oooo0P0000000`3oool00000000000050?ooo`8000001@3o
ool2000000D0oooo0P0000020?ooo`800000303oool200000080oooo0P0000030?ooo`8000001`3o
ool2000000@0oooo0P0000060?ooo`800000203oool6000000D0oooo0P0000040?ooo`8000001`3o
ool00`000000oooo000000040?ooo`800000203oool2000000h0oooo0P0000020?ooo`8000000`3o
ool200000100oooo0P0000040?ooo`8000000P3oool2000000<0oooo0P0000070?ooo`800000103o
ool200000080oooo0P0000030?ooo`8000001`3oool2000000@0oooo0P0000020?ooo`8000000P3o
ool200000080oooo0P00000?0?ooo`8000001@3oool200000080oooo0P0000030?ooo`8000001@3o
ool200000080oooo0P0000020?ooo`8000001`3oool2000000L0oooo0P0000040?ooo`8000000P3o
ool200000080oooo0P0000020?ooo`800000;@3oool002P0oooo0P0000000`3oool000000?ooo`05
0?ooo`800000103oool200000080oooo0P0000020?ooo`8000000P3oool2000000<0oooo0P000005
0?ooo`H000003`3oool2000001L0oooo0P0000030?ooo`80000000@0oooo000000000000oooo0P00
00000`3oool00000000000020?ooo`8000000`3oool500000080oooo0P0000030?ooo`040000003o
ool0oooo0?ooo`8000003`3oool200000080oooo0P0000030?ooo`800000403oool5000000X0oooo
0P0000020?ooo`8000000P3oool6000000040?ooo`00000000000?ooo`80000000<0oooo00000000
00000P3oool500000080oooo0P0000020?ooo`8000000P3oool200000080oooo0P00000=0?ooo`@0
0000103oool200000080oooo0P0000020?ooo`8000000P3oool200000080oooo0P0000030?ooo`03
0000003oool0oooo00@000003@3oool7000000@0oooo0P0000050?ooo`8000001@3oool200000080
oooo0P00000<0?ooo`8000000P3oool2000000<0oooo0P0000070?ooo`800000103oool2000000<0
oooo00<000000?ooo`3oool01P00000?0?ooo`800000103oool600000080oooo0P0000000`3oool0
0000000000030?ooo`H00000103oool2000000h0oooo0P0000020?ooo`8000000`3oool200000100
oooo0P0000040?ooo`8000000P3oool2000000<0oooo0P0000070?ooo`8000001@3oool5000000<0
oooo0P0000070?ooo`800000103oool200000080oooo0P0000020?ooo`8000000P3oool2000000l0
oooo0P0000060?ooo`D000000`3oool2000000D0oooo0P0000020?ooo`8000000P3oool6000000<0
oooo0P0000070?ooo`800000103oool200000080oooo0P0000020?ooo`8000000P3oool2000002d0
oooo000X0?ooo`@000001P3oool2000000@0oooo0P000000103oool000000000000000020?ooo`80
00000P3oool2000000<0oooo0`000000103oool000000?ooo`3oool200000080oooo0P00000?0?oo
o`8000005`3oool2000000<0oooo0P000000103oool000000000003oool2000000050?ooo`000000
00000000003oool00P0000060?ooo`8000000P3oool2000000<0oooo00@000000?ooo`3oool0oooo
0P00000?0?ooo`8000000P3oool2000000<0oooo0P00000C0?ooo`8000002P3oool2000000040?oo
o`000000000000000080oooo0P0000020?ooo`80000000@0oooo000000000000oooo0P0000000`3o
ool00000000000050?ooo`8000000P3oool200000080oooo0P0000020?ooo`80000000@0oooo0000
0000000000003@3oool200000080oooo0P0000020?ooo`8000000P3oool200000080oooo0P000002
0?ooo`8000000P3oool2000000<0oooo00<000000?ooo`3oool00P0000000`3oool000000000000<
0?ooo`80000000<0oooo0000003oool00P0000040?ooo`8000001@3oool2000000D0oooo0P000002
0?ooo`800000303oool3000000030?ooo`000000000000<0oooo0`0000000`3oool000000?ooo`03
0?ooo`800000103oool2000000<0oooo00<000000?ooo`3oool00P0000020?ooo`8000003`3oool2
000000@0oooo0P0000020?ooo`8000000P3oool2000000030?ooo`000000000000<0oooo0P000002
0?ooo`800000103oool2000000h0oooo0P0000020?ooo`8000000`3oool3000000030?ooo`000000
oooo00`0oooo0P0000040?ooo`8000000P3oool2000000<0oooo0P0000070?ooo`800000203oool2
000000<0oooo0P0000070?ooo`800000103oool200000080oooo0P0000020?ooo`8000000P3oool2
000000l0oooo0P0000090?ooo`8000000`3oool3000000040?ooo`000000oooo0?ooo`80000000@0
oooo00000000000000000P3oool200000080oooo0P0000030?ooo`8000001`3oool2000000@0oooo
0P0000020?ooo`8000000P3oool2000000040?ooo`0000000000000002d0oooo000X0?ooo`800000
00@0oooo0000003oool000000P3oool4000000D0oooo0P0000000`3oool000000000000400000005
0?ooo`00000000000000003oool0100000000`3oool00000000000030?ooo`@00000403oool20000
01L0oooo0P0000020?ooo`P0000000D0oooo00000000000000000?ooo`02000000@0oooo10000004
0?ooo`D000000P3oool5000000h0oooo100000020?ooo`L000003@3oool4000000`0oooo0P000000
0`3oool00000000000030?ooo`@0000000<0oooo0000000000001P0000030?ooo`@000000P3oool6
000000@0oooo0P0000000`3oool000000000000>0?ooo`D000000P3oool5000000@0oooo10000004
0?ooo`D000000P3oool2000000040?ooo`0000000000000000X0oooo0`0000030?ooo`<0000000<0
oooo0000000000000P0000040?ooo`D000000`3oool5000000`0oooo0`0000000`3oool000000000
00020?ooo`@0000000<0oooo0000000000000P3oool4000000D0oooo1@0000030?ooo`@00000403o
ool2000000D0oooo100000020?ooo`<0000000@0oooo00000000000000000`3oool4000000D0oooo
0P00000?0?ooo`@000000P3oool4000000030?ooo`000000000000/0oooo100000030?ooo`H00000
0P3oool7000000@0oooo0P0000050?ooo`@000000`3oool5000000<0oooo100000050?ooo`@00000
0P3oool6000000l0oooo1@0000040?ooo`@000000P3oool4000000030?ooo`000000000000<0oooo
0P000000103oool000000000000000020?ooo`@000000`3oool5000000<0oooo100000030?ooo`H0
0000103oool2000000040?ooo`0000000000000002`0oooo000X0?ooo`8000000`3oool00`000000
oooo0?ooo`0e0?ooo`8000005`3oool2000002D0oooo0P00000H0?ooo`8000008`3oool2000002H0
oooo0P00000E0?ooo`8000005P3oool200000240oooo0P0000050?ooo`800000A@3oool2000001h0
oooo0P00000h0?ooo`8000001`3oool2000000d0oooo0P00000Z0?ooo`8000009P3oool2000004P0
oooo000W0?ooo`L00000103oool2000002l0oooo1000000E0?ooo`H000008`3oool2000001P0oooo
0P00000S0?ooo`8000009P3oool2000001D0oooo0P00000F0?ooo`8000006P3oool2000000D0oooo
0P0000050?ooo`8000008P3oool200000240oooo0P00000N0?ooo`800000:@3oool2000000d0oooo
0P0000070?ooo`8000003@3oool2000000L0oooo0P00000Q0?ooo`8000009P3oool2000000L0oooo
0P00000o0?ooo`00<P3oool200000340oooo0P00001I0?ooo`D000007P3oool3000002D0oooo0`00
000D0?ooo`<000005@3oool3000001X0oooo0P00000;0?ooo`<000008P3oool2000001l0oooo1000
000L0?ooo`@00000:@3oool2000000h0oooo1@0000000`3oool0000000000002000001H0oooo0P00
001B0?ooo`800000?`3oool00?l0ooooo`3ooonn0?ooo`00o`3ooooo0?oookh0oooo003o0?ooool0
oooo_P3oool00001\
\>"],
  ImageRangeCache->{{{0, 699}, {740.625, 0}} -> {-0.088707, -0.0529857, \
0.00311504, 0.00311504}, {{28.4375, 334.188}, {723.563, 43.375}} -> \
{-0.13886, -0.115755, 0.00352353, 0.00352353}, {{39.375, 323.188}, {707.75, \
532.313}} -> {-5.34563, -0.00242978, 0.0658988, 5.41595*^-05}, {{39.375, \
323.188}, {479.75, 304.313}} -> {-4.95024, -1.84727, 0.0658988, 0.00676994}, \
{{39.375, 323.188}, {251.688, 76.3125}} -> {-5.15312, -0.16963, 0.0659256, \
0.000338634}, {{364.75, 670.5}, {723.563, 43.375}} -> {-1.32387, -0.115755, \
0.00352353, 0.00352353}, {{375.688, 659.5}, {707.75, 532.313}} -> {-27.5082, \
-0.00242978, 0.0658988, 5.41595*^-05}, {{375.688, 659.5}, {479.75, 304.313}} -> \
{-27.1128, -1.84727, 0.0658988, 0.00676994}, {{375.688, 659.5}, {251.688, \
76.3125}} -> {-27.3247, -0.16963, 0.0659256, 0.000338634}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  GraphicsArray  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{\(fig2a = 
            ListPlot[Table[{j, ymopt[j]}, {j, 0, maxloop}], 
              PlotRange \[Rule] {\(-0.4\), 0}, PlotJoined \[Rule] True, 
              PlotStyle \[Rule] Hue[ .6], PlotLabel \[Rule] "\<Output\>", 
              DisplayFunction \[Rule] Identity];\), 
        "\[IndentingNewLine]", \(fig2b = 
            ListPlot[Table[{j, pmopt[j]}, {j, 0, maxloop}], 
              PlotRange \[Rule] {0, 3}, PlotJoined \[Rule] True, 
              PlotStyle \[Rule] Hue[ .6], 
              PlotLabel \[Rule] "\<Price level\>", 
              DisplayFunction \[Rule] Identity];\), "\[IndentingNewLine]", 
        RowBox[{
          RowBox[{"fig2c", "=", 
            
            StyleBox[\(ListPlot[Table[{j, dmopt[j]}, {j, 0, maxloop}], 
                PlotRange \[Rule] {0, 1.2}, PlotJoined \[Rule] True, 
                PlotStyle \[Rule] Hue[ .6], 
                PlotLabel \[Rule] "\<Cross-sectional variability of \
prices\>", DisplayFunction \[Rule] Identity]\),
              FontColor->GrayLevel[0]]}], 
          StyleBox[";",
            FontColor->GrayLevel[0]]}], 
        "\[IndentingNewLine]", \(fig2d = 
            ListPlot[Table[{j, rhoymopt[j]}, {j, 0, maxloop}], 
              PlotRange \[Rule] {\(-0.4\), 0}, PlotJoined \[Rule] True, 
              PlotStyle \[Rule] Hue[ .6], PlotLabel \[Rule] "\<Output\>", 
              DisplayFunction \[Rule] Identity];\), 
        "\[IndentingNewLine]", \(fig2e = 
            ListPlot[Table[{j, rhopmopt[j]}, {j, 0, maxloop}], 
              PlotRange \[Rule] {0, 3}, PlotJoined \[Rule] True, 
              PlotStyle \[Rule] Hue[ .6], 
              PlotLabel \[Rule] "\<Price level\>", 
              DisplayFunction \[Rule] Identity];\), "\[IndentingNewLine]", 
        RowBox[{
          RowBox[{"fig2f", "=", 
            
            StyleBox[\(ListPlot[Table[{j, rhodmopt[j]}, {j, 0, maxloop}], 
                PlotRange \[Rule] {0, 1.2}, PlotJoined \[Rule] True, 
                PlotStyle \[Rule] Hue[ .6], 
                PlotLabel \[Rule] "\<Cross-sectional variability of \
prices\>", DisplayFunction \[Rule] Identity]\),
              FontColor->GrayLevel[0]]}], 
          StyleBox[";",
            FontColor->GrayLevel[0]]}], "\[IndentingNewLine]", 
        "\[IndentingNewLine]", \( (*Arrange\ themn\ vertically*) \), 
        "\[IndentingNewLine]", \(fig2abc = 
            GraphicsArray[{{fig2b}, {fig2a}, {fig2c}}, 
              PlotLabel \[Rule] 
                FontForm["\<If serial correlation of shock is 0.8\>", \
{"\<Courier-Bold\>", \ 10}], GraphicsSpacing \[Rule]  .3];\), 
        "\[IndentingNewLine]", \(fig2def = 
            GraphicsArray[{{fig2e}, {fig2d}, {fig2f}}, 
              PlotLabel \[Rule] 
                FontForm["\<If serial correlation of shock is 0.4\>", \
{"\<Courier-Bold\>", \ 10}], GraphicsSpacing \[Rule]  .3];\), 
        "\[IndentingNewLine]", \(figure2 = 
            GraphicsArray[{fig2abc, fig2def}, GraphicsSpacing \[Rule]  .1];\),
         "\[IndentingNewLine]", 
        RowBox[{"Show", "[", 
          RowBox[{
          "figure2", 
            ",", \(PlotLabel \[Rule] 
              FontForm["\<Figure 2. Impact of a markup shock under the \
optimal policy\>", \ {"\<Courier-Bold\>", \ 14}]\), ",", 
            StyleBox[\(ImageSize -> 700\),
              "MR"]}], "]"}]}], "\[IndentingNewLine]", 
      "\[IndentingNewLine]"}]], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.05949 
%%ImageSize: 700 741.641 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.0252259 0.47619 [
[.5 1.07199 -249.281 0 ]
[.5 1.07199 249.281 17.9375 ]
[ 0 0 0 0 ]
[ 1 1.05949 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
gsave
.5 1.07199 -310.281 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 25.9375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 16.750 moveto
%%IncludeResource: font Courier-Bold
%%IncludeFont: Courier-Bold
/Courier-Bold findfont 14.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 16.750 moveto
%%IncludeResource: font Courier-Bold
%%IncludeFont: Courier-Bold
/Courier-Bold findfont 14.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Figure) show
121.625 16.750 moveto
(2.) show
146.750 16.750 moveto
(Impact) show
205.375 16.750 moveto
(of) show
230.500 16.750 moveto
(a) show
247.563 16.750 moveto
(markup) show
306.188 16.750 moveto
(shock) show
356.438 16.750 moveto
(under) show
406.688 16.750 moveto
(the) show
440.188 16.750 moveto
(optimal) show
507.313 16.750 moveto
(policy) show
557.563 16.750 moveto
%%IncludeResource: font Courier-Bold
%%IncludeFont: Courier-Bold
/Courier-Bold findfont 14.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 1.05949 L
0 1.05949 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0238095 0.0252259 0.477324 1.03426 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.0529743 0.952381 [
[.5 2.23742 -113 0 ]
[.5 2.23742 113 13.4375 ]
[ 0 0 0 0 ]
[ 1 2.22492 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
gsave
.5 2.23742 -174 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.4375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.438 moveto
%%IncludeResource: font Courier-Bold
%%IncludeFont: Courier-Bold
/Courier-Bold findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.438 moveto
%%IncludeResource: font Courier-Bold
%%IncludeFont: Courier-Bold
/Courier-Bold findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(If) show
81.000 13.438 moveto
(serial) show
123.000 13.438 moveto
(correlation) show
195.000 13.438 moveto
(of) show
213.000 13.438 moveto
(shock) show
249.000 13.438 moveto
(is) show
267.000 13.438 moveto
(0.8) show
285.000 13.438 moveto
%%IncludeResource: font Courier-Bold
%%IncludeFont: Courier-Bold
/Courier-Bold findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 2.22492 L
0 2.22492 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0238095 0.0529743 0.97619 0.641578 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.031746 -2.18738e-017 0.515028 [
[.18254 -0.0125 -3 -9 ]
[.18254 -0.0125 3 0 ]
[.34127 -0.0125 -6 -9 ]
[.34127 -0.0125 6 0 ]
[.5 -0.0125 -6 -9 ]
[.5 -0.0125 6 0 ]
[.65873 -0.0125 -6 -9 ]
[.65873 -0.0125 6 0 ]
[.81746 -0.0125 -6 -9 ]
[.81746 -0.0125 6 0 ]
[.97619 -0.0125 -6 -9 ]
[.97619 -0.0125 6 0 ]
[.01131 .10301 -18 -4.5 ]
[.01131 .10301 0 4.5 ]
[.01131 .20601 -18 -4.5 ]
[.01131 .20601 0 4.5 ]
[.01131 .30902 -18 -4.5 ]
[.01131 .30902 0 4.5 ]
[.01131 .41202 -18 -4.5 ]
[.01131 .41202 0 4.5 ]
[.01131 .51503 -6 -4.5 ]
[.01131 .51503 0 4.5 ]
[.5 .63053 -113 0 ]
[.5 .63053 113 12.75 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.18254 0 m
.18254 .00625 L
s
[(5)] .18254 -0.0125 0 1 Mshowa
.34127 0 m
.34127 .00625 L
s
[(10)] .34127 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(15)] .5 -0.0125 0 1 Mshowa
.65873 0 m
.65873 .00625 L
s
[(20)] .65873 -0.0125 0 1 Mshowa
.81746 0 m
.81746 .00625 L
s
[(25)] .81746 -0.0125 0 1 Mshowa
.97619 0 m
.97619 .00625 L
s
[(30)] .97619 -0.0125 0 1 Mshowa
.125 Mabswid
.05556 0 m
.05556 .00375 L
s
.0873 0 m
.0873 .00375 L
s
.11905 0 m
.11905 .00375 L
s
.15079 0 m
.15079 .00375 L
s
.21429 0 m
.21429 .00375 L
s
.24603 0 m
.24603 .00375 L
s
.27778 0 m
.27778 .00375 L
s
.30952 0 m
.30952 .00375 L
s
.37302 0 m
.37302 .00375 L
s
.40476 0 m
.40476 .00375 L
s
.43651 0 m
.43651 .00375 L
s
.46825 0 m
.46825 .00375 L
s
.53175 0 m
.53175 .00375 L
s
.56349 0 m
.56349 .00375 L
s
.59524 0 m
.59524 .00375 L
s
.62698 0 m
.62698 .00375 L
s
.69048 0 m
.69048 .00375 L
s
.72222 0 m
.72222 .00375 L
s
.75397 0 m
.75397 .00375 L
s
.78571 0 m
.78571 .00375 L
s
.84921 0 m
.84921 .00375 L
s
.88095 0 m
.88095 .00375 L
s
.9127 0 m
.9127 .00375 L
s
.94444 0 m
.94444 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
.02381 .10301 m
.03006 .10301 L
s
[(0.2)] .01131 .10301 1 0 Mshowa
.02381 .20601 m
.03006 .20601 L
s
[(0.4)] .01131 .20601 1 0 Mshowa
.02381 .30902 m
.03006 .30902 L
s
[(0.6)] .01131 .30902 1 0 Mshowa
.02381 .41202 m
.03006 .41202 L
s
[(0.8)] .01131 .41202 1 0 Mshowa
.02381 .51503 m
.03006 .51503 L
s
[(1)] .01131 .51503 1 0 Mshowa
.125 Mabswid
.02381 .02575 m
.02756 .02575 L
s
.02381 .0515 m
.02756 .0515 L
s
.02381 .07725 m
.02756 .07725 L
s
.02381 .12876 m
.02756 .12876 L
s
.02381 .15451 m
.02756 .15451 L
s
.02381 .18026 m
.02756 .18026 L
s
.02381 .23176 m
.02756 .23176 L
s
.02381 .25751 m
.02756 .25751 L
s
.02381 .28327 m
.02756 .28327 L
s
.02381 .33477 m
.02756 .33477 L
s
.02381 .36052 m
.02756 .36052 L
s
.02381 .38627 m
.02756 .38627 L
s
.02381 .43777 m
.02756 .43777 L
s
.02381 .46353 m
.02756 .46353 L
s
.02381 .48928 m
.02756 .48928 L
s
.02381 .54078 m
.02756 .54078 L
s
.02381 .56653 m
.02756 .56653 L
s
.02381 .59228 m
.02756 .59228 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.5 .63053 -174 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Cross) show
93.000 13.000 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
99.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(sectional) show
159.000 13.000 moveto
(variability) show
231.000 13.000 moveto
(of) show
249.000 13.000 moveto
(prices) show
285.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 .4 1 r
.5 Mabswid
.02381 .32156 m
.05556 .50486 L
.0873 .56265 L
.11905 .55897 L
.15079 .52137 L
.18254 .46672 L
.21429 .40519 L
.24603 .34281 L
.27778 .28311 L
.30952 .2281 L
.34127 .17895 L
.37302 .13628 L
.40476 .10041 L
.43651 .07132 L
.46825 .04868 L
.5 .03188 L
.53175 .02001 L
.56349 .01206 L
.59524 .00699 L
.62698 .00392 L
.65873 .00213 L
.69048 .00113 L
.72222 .00058 L
.75397 .0003 L
.78571 .00015 L
.81746 7e-005 L
.84921 4e-005 L
.88095 2e-005 L
.9127 1e-005 L
.94444 0 L
.97619 0 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.0238095 0.818159 0.97619 1.40676 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.031746 0.618034 1.54508 [
[.18254 .60553 -3 -9 ]
[.18254 .60553 3 0 ]
[.34127 .60553 -6 -9 ]
[.34127 .60553 6 0 ]
[.5 .60553 -6 -9 ]
[.5 .60553 6 0 ]
[.65873 .60553 -6 -9 ]
[.65873 .60553 6 0 ]
[.81746 .60553 -6 -9 ]
[.81746 .60553 6 0 ]
[.97619 .60553 -6 -9 ]
[.97619 .60553 6 0 ]
[.01131 0 -24 -4.5 ]
[.01131 0 0 4.5 ]
[.01131 .15451 -24 -4.5 ]
[.01131 .15451 0 4.5 ]
[.01131 .30902 -24 -4.5 ]
[.01131 .30902 0 4.5 ]
[.01131 .46353 -24 -4.5 ]
[.01131 .46353 0 4.5 ]
[.5 .63053 -20 0 ]
[.5 .63053 20 12.75 ]
[ 0 0 0 0 ]
[ 1 .62428 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.18254 .61803 m
.18254 .62428 L
s
[(5)] .18254 .60553 0 1 Mshowa
.34127 .61803 m
.34127 .62428 L
s
[(10)] .34127 .60553 0 1 Mshowa
.5 .61803 m
.5 .62428 L
s
[(15)] .5 .60553 0 1 Mshowa
.65873 .61803 m
.65873 .62428 L
s
[(20)] .65873 .60553 0 1 Mshowa
.81746 .61803 m
.81746 .62428 L
s
[(25)] .81746 .60553 0 1 Mshowa
.97619 .61803 m
.97619 .62428 L
s
[(30)] .97619 .60553 0 1 Mshowa
.125 Mabswid
.05556 .61803 m
.05556 .62178 L
s
.0873 .61803 m
.0873 .62178 L
s
.11905 .61803 m
.11905 .62178 L
s
.15079 .61803 m
.15079 .62178 L
s
.21429 .61803 m
.21429 .62178 L
s
.24603 .61803 m
.24603 .62178 L
s
.27778 .61803 m
.27778 .62178 L
s
.30952 .61803 m
.30952 .62178 L
s
.37302 .61803 m
.37302 .62178 L
s
.40476 .61803 m
.40476 .62178 L
s
.43651 .61803 m
.43651 .62178 L
s
.46825 .61803 m
.46825 .62178 L
s
.53175 .61803 m
.53175 .62178 L
s
.56349 .61803 m
.56349 .62178 L
s
.59524 .61803 m
.59524 .62178 L
s
.62698 .61803 m
.62698 .62178 L
s
.69048 .61803 m
.69048 .62178 L
s
.72222 .61803 m
.72222 .62178 L
s
.75397 .61803 m
.75397 .62178 L
s
.78571 .61803 m
.78571 .62178 L
s
.84921 .61803 m
.84921 .62178 L
s
.88095 .61803 m
.88095 .62178 L
s
.9127 .61803 m
.9127 .62178 L
s
.94444 .61803 m
.94444 .62178 L
s
.25 Mabswid
0 .61803 m
1 .61803 L
s
.02381 0 m
.03006 0 L
s
[(-0.4)] .01131 0 1 0 Mshowa
.02381 .15451 m
.03006 .15451 L
s
[(-0.3)] .01131 .15451 1 0 Mshowa
.02381 .30902 m
.03006 .30902 L
s
[(-0.2)] .01131 .30902 1 0 Mshowa
.02381 .46353 m
.03006 .46353 L
s
[(-0.1)] .01131 .46353 1 0 Mshowa
.125 Mabswid
.02381 .0309 m
.02756 .0309 L
s
.02381 .0618 m
.02756 .0618 L
s
.02381 .09271 m
.02756 .09271 L
s
.02381 .12361 m
.02756 .12361 L
s
.02381 .18541 m
.02756 .18541 L
s
.02381 .21631 m
.02756 .21631 L
s
.02381 .24721 m
.02756 .24721 L
s
.02381 .27812 m
.02756 .27812 L
s
.02381 .33992 m
.02756 .33992 L
s
.02381 .37082 m
.02756 .37082 L
s
.02381 .40172 m
.02756 .40172 L
s
.02381 .43262 m
.02756 .43262 L
s
.02381 .49443 m
.02756 .49443 L
s
.02381 .52533 m
.02756 .52533 L
s
.02381 .55623 m
.02756 .55623 L
s
.02381 .58713 m
.02756 .58713 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.5 .63053 -81 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Output) show
99.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 .4 1 r
.5 Mabswid
.02381 .11962 m
.05556 .52264 L
.0873 .48436 L
.11905 .45074 L
.15079 .42096 L
.18254 .39452 L
.21429 .37113 L
.24603 .3508 L
.27778 .33374 L
.30952 .32039 L
.34127 .31136 L
.37302 .3073 L
.40476 .3088 L
.43651 .31619 L
.46825 .32942 L
.5 .3479 L
.53175 .37056 L
.56349 .396 L
.59524 .42266 L
.62698 .44911 L
.65873 .47419 L
.69048 .49713 L
.72222 .5175 L
.75397 .53515 L
.78571 .55018 L
.81746 .56278 L
.84921 .57323 L
.88095 .58183 L
.9127 .58884 L
.94444 .59454 L
.97619 .59916 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.0238095 1.58334 0.97619 2.17195 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.031746 0 0.206011 [
[.18254 -0.0125 -3 -9 ]
[.18254 -0.0125 3 0 ]
[.34127 -0.0125 -6 -9 ]
[.34127 -0.0125 6 0 ]
[.5 -0.0125 -6 -9 ]
[.5 -0.0125 6 0 ]
[.65873 -0.0125 -6 -9 ]
[.65873 -0.0125 6 0 ]
[.81746 -0.0125 -6 -9 ]
[.81746 -0.0125 6 0 ]
[.97619 -0.0125 -6 -9 ]
[.97619 -0.0125 6 0 ]
[.01131 .10301 -18 -4.5 ]
[.01131 .10301 0 4.5 ]
[.01131 .20601 -6 -4.5 ]
[.01131 .20601 0 4.5 ]
[.01131 .30902 -18 -4.5 ]
[.01131 .30902 0 4.5 ]
[.01131 .41202 -6 -4.5 ]
[.01131 .41202 0 4.5 ]
[.01131 .51503 -18 -4.5 ]
[.01131 .51503 0 4.5 ]
[.01131 .61803 -6 -4.5 ]
[.01131 .61803 0 4.5 ]
[.5 .63053 -35 0 ]
[.5 .63053 35 12.75 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.18254 0 m
.18254 .00625 L
s
[(5)] .18254 -0.0125 0 1 Mshowa
.34127 0 m
.34127 .00625 L
s
[(10)] .34127 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(15)] .5 -0.0125 0 1 Mshowa
.65873 0 m
.65873 .00625 L
s
[(20)] .65873 -0.0125 0 1 Mshowa
.81746 0 m
.81746 .00625 L
s
[(25)] .81746 -0.0125 0 1 Mshowa
.97619 0 m
.97619 .00625 L
s
[(30)] .97619 -0.0125 0 1 Mshowa
.125 Mabswid
.05556 0 m
.05556 .00375 L
s
.0873 0 m
.0873 .00375 L
s
.11905 0 m
.11905 .00375 L
s
.15079 0 m
.15079 .00375 L
s
.21429 0 m
.21429 .00375 L
s
.24603 0 m
.24603 .00375 L
s
.27778 0 m
.27778 .00375 L
s
.30952 0 m
.30952 .00375 L
s
.37302 0 m
.37302 .00375 L
s
.40476 0 m
.40476 .00375 L
s
.43651 0 m
.43651 .00375 L
s
.46825 0 m
.46825 .00375 L
s
.53175 0 m
.53175 .00375 L
s
.56349 0 m
.56349 .00375 L
s
.59524 0 m
.59524 .00375 L
s
.62698 0 m
.62698 .00375 L
s
.69048 0 m
.69048 .00375 L
s
.72222 0 m
.72222 .00375 L
s
.75397 0 m
.75397 .00375 L
s
.78571 0 m
.78571 .00375 L
s
.84921 0 m
.84921 .00375 L
s
.88095 0 m
.88095 .00375 L
s
.9127 0 m
.9127 .00375 L
s
.94444 0 m
.94444 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
.02381 .10301 m
.03006 .10301 L
s
[(0.5)] .01131 .10301 1 0 Mshowa
.02381 .20601 m
.03006 .20601 L
s
[(1)] .01131 .20601 1 0 Mshowa
.02381 .30902 m
.03006 .30902 L
s
[(1.5)] .01131 .30902 1 0 Mshowa
.02381 .41202 m
.03006 .41202 L
s
[(2)] .01131 .41202 1 0 Mshowa
.02381 .51503 m
.03006 .51503 L
s
[(2.5)] .01131 .51503 1 0 Mshowa
.02381 .61803 m
.03006 .61803 L
s
[(3)] .01131 .61803 1 0 Mshowa
.125 Mabswid
.02381 .0206 m
.02756 .0206 L
s
.02381 .0412 m
.02756 .0412 L
s
.02381 .0618 m
.02756 .0618 L
s
.02381 .0824 m
.02756 .0824 L
s
.02381 .12361 m
.02756 .12361 L
s
.02381 .14421 m
.02756 .14421 L
s
.02381 .16481 m
.02756 .16481 L
s
.02381 .18541 m
.02756 .18541 L
s
.02381 .22661 m
.02756 .22661 L
s
.02381 .24721 m
.02756 .24721 L
s
.02381 .26781 m
.02756 .26781 L
s
.02381 .28842 m
.02756 .28842 L
s
.02381 .32962 m
.02756 .32962 L
s
.02381 .35022 m
.02756 .35022 L
s
.02381 .37082 m
.02756 .37082 L
s
.02381 .39142 m
.02756 .39142 L
s
.02381 .43262 m
.02756 .43262 L
s
.02381 .45322 m
.02756 .45322 L
s
.02381 .47383 m
.02756 .47383 L
s
.02381 .49443 m
.02756 .49443 L
s
.02381 .53563 m
.02756 .53563 L
s
.02381 .55623 m
.02756 .55623 L
s
.02381 .57683 m
.02756 .57683 L
s
.02381 .59743 m
.02756 .59743 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.5 .63053 -96 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Price) show
99.000 13.000 moveto
(level) show
129.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 .4 1 r
.5 Mabswid
.02381 .06646 m
.05556 .1272 L
.0873 .17824 L
.11905 .22306 L
.15079 .26276 L
.18254 .29802 L
.21429 .3292 L
.24603 .35632 L
.27778 .37906 L
.30952 .39685 L
.34127 .4089 L
.37302 .41431 L
.40476 .41231 L
.43651 .40246 L
.46825 .38482 L
.5 .36018 L
.53175 .32996 L
.56349 .29605 L
.59524 .2605 L
.62698 .22524 L
.65873 .19179 L
.69048 .1612 L
.72222 .13405 L
.75397 .11051 L
.78571 .09047 L
.81746 .07367 L
.84921 .05973 L
.88095 .04828 L
.9127 .03892 L
.94444 .03132 L
.97619 .02517 L
s
MathSubEnd
P
% End of sub-graphic
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.522676 0.0252259 0.97619 1.03426 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.0529743 0.952381 [
[.5 2.23742 -113 0 ]
[.5 2.23742 113 13.4375 ]
[ 0 0 0 0 ]
[ 1 2.22492 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
gsave
.5 2.23742 -174 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.4375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.438 moveto
%%IncludeResource: font Courier-Bold
%%IncludeFont: Courier-Bold
/Courier-Bold findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.438 moveto
%%IncludeResource: font Courier-Bold
%%IncludeFont: Courier-Bold
/Courier-Bold findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(If) show
81.000 13.438 moveto
(serial) show
123.000 13.438 moveto
(correlation) show
195.000 13.438 moveto
(of) show
213.000 13.438 moveto
(shock) show
249.000 13.438 moveto
(is) show
267.000 13.438 moveto
(0.4) show
285.000 13.438 moveto
%%IncludeResource: font Courier-Bold
%%IncludeFont: Courier-Bold
/Courier-Bold findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 2.22492 L
0 2.22492 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0238095 0.0529743 0.97619 0.641578 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.031746 -2.18738e-017 0.515028 [
[.18254 -0.0125 -3 -9 ]
[.18254 -0.0125 3 0 ]
[.34127 -0.0125 -6 -9 ]
[.34127 -0.0125 6 0 ]
[.5 -0.0125 -6 -9 ]
[.5 -0.0125 6 0 ]
[.65873 -0.0125 -6 -9 ]
[.65873 -0.0125 6 0 ]
[.81746 -0.0125 -6 -9 ]
[.81746 -0.0125 6 0 ]
[.97619 -0.0125 -6 -9 ]
[.97619 -0.0125 6 0 ]
[.01131 .10301 -18 -4.5 ]
[.01131 .10301 0 4.5 ]
[.01131 .20601 -18 -4.5 ]
[.01131 .20601 0 4.5 ]
[.01131 .30902 -18 -4.5 ]
[.01131 .30902 0 4.5 ]
[.01131 .41202 -18 -4.5 ]
[.01131 .41202 0 4.5 ]
[.01131 .51503 -6 -4.5 ]
[.01131 .51503 0 4.5 ]
[.5 .63053 -113 0 ]
[.5 .63053 113 12.75 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.18254 0 m
.18254 .00625 L
s
[(5)] .18254 -0.0125 0 1 Mshowa
.34127 0 m
.34127 .00625 L
s
[(10)] .34127 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(15)] .5 -0.0125 0 1 Mshowa
.65873 0 m
.65873 .00625 L
s
[(20)] .65873 -0.0125 0 1 Mshowa
.81746 0 m
.81746 .00625 L
s
[(25)] .81746 -0.0125 0 1 Mshowa
.97619 0 m
.97619 .00625 L
s
[(30)] .97619 -0.0125 0 1 Mshowa
.125 Mabswid
.05556 0 m
.05556 .00375 L
s
.0873 0 m
.0873 .00375 L
s
.11905 0 m
.11905 .00375 L
s
.15079 0 m
.15079 .00375 L
s
.21429 0 m
.21429 .00375 L
s
.24603 0 m
.24603 .00375 L
s
.27778 0 m
.27778 .00375 L
s
.30952 0 m
.30952 .00375 L
s
.37302 0 m
.37302 .00375 L
s
.40476 0 m
.40476 .00375 L
s
.43651 0 m
.43651 .00375 L
s
.46825 0 m
.46825 .00375 L
s
.53175 0 m
.53175 .00375 L
s
.56349 0 m
.56349 .00375 L
s
.59524 0 m
.59524 .00375 L
s
.62698 0 m
.62698 .00375 L
s
.69048 0 m
.69048 .00375 L
s
.72222 0 m
.72222 .00375 L
s
.75397 0 m
.75397 .00375 L
s
.78571 0 m
.78571 .00375 L
s
.84921 0 m
.84921 .00375 L
s
.88095 0 m
.88095 .00375 L
s
.9127 0 m
.9127 .00375 L
s
.94444 0 m
.94444 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
.02381 .10301 m
.03006 .10301 L
s
[(0.2)] .01131 .10301 1 0 Mshowa
.02381 .20601 m
.03006 .20601 L
s
[(0.4)] .01131 .20601 1 0 Mshowa
.02381 .30902 m
.03006 .30902 L
s
[(0.6)] .01131 .30902 1 0 Mshowa
.02381 .41202 m
.03006 .41202 L
s
[(0.8)] .01131 .41202 1 0 Mshowa
.02381 .51503 m
.03006 .51503 L
s
[(1)] .01131 .51503 1 0 Mshowa
.125 Mabswid
.02381 .02575 m
.02756 .02575 L
s
.02381 .0515 m
.02756 .0515 L
s
.02381 .07725 m
.02756 .07725 L
s
.02381 .12876 m
.02756 .12876 L
s
.02381 .15451 m
.02756 .15451 L
s
.02381 .18026 m
.02756 .18026 L
s
.02381 .23176 m
.02756 .23176 L
s
.02381 .25751 m
.02756 .25751 L
s
.02381 .28327 m
.02756 .28327 L
s
.02381 .33477 m
.02756 .33477 L
s
.02381 .36052 m
.02756 .36052 L
s
.02381 .38627 m
.02756 .38627 L
s
.02381 .43777 m
.02756 .43777 L
s
.02381 .46353 m
.02756 .46353 L
s
.02381 .48928 m
.02756 .48928 L
s
.02381 .54078 m
.02756 .54078 L
s
.02381 .56653 m
.02756 .56653 L
s
.02381 .59228 m
.02756 .59228 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.5 .63053 -174 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Cross) show
93.000 13.000 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
99.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(sectional) show
159.000 13.000 moveto
(variability) show
231.000 13.000 moveto
(of) show
249.000 13.000 moveto
(prices) show
285.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 .4 1 r
.5 Mabswid
.02381 .32156 m
.05556 .12621 L
.0873 .03517 L
.11905 .00873 L
.15079 .00204 L
.18254 .00046 L
.21429 .0001 L
.24603 2e-005 L
.27778 0 L
.30952 0 L
.34127 0 L
.37302 0 L
.40476 0 L
.43651 0 L
.46825 0 L
.5 0 L
.53175 0 L
.56349 0 L
.59524 0 L
.62698 0 L
.65873 0 L
.69048 0 L
.72222 0 L
.75397 0 L
.78571 0 L
.81746 0 L
.84921 0 L
.88095 0 L
.9127 0 L
.94444 0 L
.97619 0 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.0238095 0.818159 0.97619 1.40676 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.031746 0.618034 1.54508 [
[.18254 .60553 -3 -9 ]
[.18254 .60553 3 0 ]
[.34127 .60553 -6 -9 ]
[.34127 .60553 6 0 ]
[.5 .60553 -6 -9 ]
[.5 .60553 6 0 ]
[.65873 .60553 -6 -9 ]
[.65873 .60553 6 0 ]
[.81746 .60553 -6 -9 ]
[.81746 .60553 6 0 ]
[.97619 .60553 -6 -9 ]
[.97619 .60553 6 0 ]
[.01131 0 -24 -4.5 ]
[.01131 0 0 4.5 ]
[.01131 .15451 -24 -4.5 ]
[.01131 .15451 0 4.5 ]
[.01131 .30902 -24 -4.5 ]
[.01131 .30902 0 4.5 ]
[.01131 .46353 -24 -4.5 ]
[.01131 .46353 0 4.5 ]
[.5 .63053 -20 0 ]
[.5 .63053 20 12.75 ]
[ 0 0 0 0 ]
[ 1 .62428 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.18254 .61803 m
.18254 .62428 L
s
[(5)] .18254 .60553 0 1 Mshowa
.34127 .61803 m
.34127 .62428 L
s
[(10)] .34127 .60553 0 1 Mshowa
.5 .61803 m
.5 .62428 L
s
[(15)] .5 .60553 0 1 Mshowa
.65873 .61803 m
.65873 .62428 L
s
[(20)] .65873 .60553 0 1 Mshowa
.81746 .61803 m
.81746 .62428 L
s
[(25)] .81746 .60553 0 1 Mshowa
.97619 .61803 m
.97619 .62428 L
s
[(30)] .97619 .60553 0 1 Mshowa
.125 Mabswid
.05556 .61803 m
.05556 .62178 L
s
.0873 .61803 m
.0873 .62178 L
s
.11905 .61803 m
.11905 .62178 L
s
.15079 .61803 m
.15079 .62178 L
s
.21429 .61803 m
.21429 .62178 L
s
.24603 .61803 m
.24603 .62178 L
s
.27778 .61803 m
.27778 .62178 L
s
.30952 .61803 m
.30952 .62178 L
s
.37302 .61803 m
.37302 .62178 L
s
.40476 .61803 m
.40476 .62178 L
s
.43651 .61803 m
.43651 .62178 L
s
.46825 .61803 m
.46825 .62178 L
s
.53175 .61803 m
.53175 .62178 L
s
.56349 .61803 m
.56349 .62178 L
s
.59524 .61803 m
.59524 .62178 L
s
.62698 .61803 m
.62698 .62178 L
s
.69048 .61803 m
.69048 .62178 L
s
.72222 .61803 m
.72222 .62178 L
s
.75397 .61803 m
.75397 .62178 L
s
.78571 .61803 m
.78571 .62178 L
s
.84921 .61803 m
.84921 .62178 L
s
.88095 .61803 m
.88095 .62178 L
s
.9127 .61803 m
.9127 .62178 L
s
.94444 .61803 m
.94444 .62178 L
s
.25 Mabswid
0 .61803 m
1 .61803 L
s
.02381 0 m
.03006 0 L
s
[(-0.4)] .01131 0 1 0 Mshowa
.02381 .15451 m
.03006 .15451 L
s
[(-0.3)] .01131 .15451 1 0 Mshowa
.02381 .30902 m
.03006 .30902 L
s
[(-0.2)] .01131 .30902 1 0 Mshowa
.02381 .46353 m
.03006 .46353 L
s
[(-0.1)] .01131 .46353 1 0 Mshowa
.125 Mabswid
.02381 .0309 m
.02756 .0309 L
s
.02381 .0618 m
.02756 .0618 L
s
.02381 .09271 m
.02756 .09271 L
s
.02381 .12361 m
.02756 .12361 L
s
.02381 .18541 m
.02756 .18541 L
s
.02381 .21631 m
.02756 .21631 L
s
.02381 .24721 m
.02756 .24721 L
s
.02381 .27812 m
.02756 .27812 L
s
.02381 .33992 m
.02756 .33992 L
s
.02381 .37082 m
.02756 .37082 L
s
.02381 .40172 m
.02756 .40172 L
s
.02381 .43262 m
.02756 .43262 L
s
.02381 .49443 m
.02756 .49443 L
s
.02381 .52533 m
.02756 .52533 L
s
.02381 .55623 m
.02756 .55623 L
s
.02381 .58713 m
.02756 .58713 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.5 .63053 -81 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Output) show
99.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 .4 1 r
.5 Mabswid
.02381 .11962 m
.05556 .57034 L
.0873 .58461 L
.11905 .59712 L
.15079 .60572 L
.18254 .61105 L
.21429 .61418 L
.24603 .61595 L
.27778 .61692 L
.30952 .61745 L
.34127 .61773 L
.37302 .61788 L
.40476 .61796 L
.43651 .618 L
.46825 .61802 L
.5 .61803 L
.53175 .61803 L
.56349 .61803 L
.59524 .61803 L
.62698 .61803 L
.65873 .61803 L
.69048 .61803 L
.72222 .61803 L
.75397 .61803 L
.78571 .61803 L
.81746 .61803 L
.84921 .61803 L
.88095 .61803 L
.9127 .61803 L
.94444 .61803 L
.97619 .61803 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.0238095 1.58334 0.97619 2.17195 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.031746 0 0.206011 [
[.18254 -0.0125 -3 -9 ]
[.18254 -0.0125 3 0 ]
[.34127 -0.0125 -6 -9 ]
[.34127 -0.0125 6 0 ]
[.5 -0.0125 -6 -9 ]
[.5 -0.0125 6 0 ]
[.65873 -0.0125 -6 -9 ]
[.65873 -0.0125 6 0 ]
[.81746 -0.0125 -6 -9 ]
[.81746 -0.0125 6 0 ]
[.97619 -0.0125 -6 -9 ]
[.97619 -0.0125 6 0 ]
[.01131 .10301 -18 -4.5 ]
[.01131 .10301 0 4.5 ]
[.01131 .20601 -6 -4.5 ]
[.01131 .20601 0 4.5 ]
[.01131 .30902 -18 -4.5 ]
[.01131 .30902 0 4.5 ]
[.01131 .41202 -6 -4.5 ]
[.01131 .41202 0 4.5 ]
[.01131 .51503 -18 -4.5 ]
[.01131 .51503 0 4.5 ]
[.01131 .61803 -6 -4.5 ]
[.01131 .61803 0 4.5 ]
[.5 .63053 -35 0 ]
[.5 .63053 35 12.75 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.18254 0 m
.18254 .00625 L
s
[(5)] .18254 -0.0125 0 1 Mshowa
.34127 0 m
.34127 .00625 L
s
[(10)] .34127 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(15)] .5 -0.0125 0 1 Mshowa
.65873 0 m
.65873 .00625 L
s
[(20)] .65873 -0.0125 0 1 Mshowa
.81746 0 m
.81746 .00625 L
s
[(25)] .81746 -0.0125 0 1 Mshowa
.97619 0 m
.97619 .00625 L
s
[(30)] .97619 -0.0125 0 1 Mshowa
.125 Mabswid
.05556 0 m
.05556 .00375 L
s
.0873 0 m
.0873 .00375 L
s
.11905 0 m
.11905 .00375 L
s
.15079 0 m
.15079 .00375 L
s
.21429 0 m
.21429 .00375 L
s
.24603 0 m
.24603 .00375 L
s
.27778 0 m
.27778 .00375 L
s
.30952 0 m
.30952 .00375 L
s
.37302 0 m
.37302 .00375 L
s
.40476 0 m
.40476 .00375 L
s
.43651 0 m
.43651 .00375 L
s
.46825 0 m
.46825 .00375 L
s
.53175 0 m
.53175 .00375 L
s
.56349 0 m
.56349 .00375 L
s
.59524 0 m
.59524 .00375 L
s
.62698 0 m
.62698 .00375 L
s
.69048 0 m
.69048 .00375 L
s
.72222 0 m
.72222 .00375 L
s
.75397 0 m
.75397 .00375 L
s
.78571 0 m
.78571 .00375 L
s
.84921 0 m
.84921 .00375 L
s
.88095 0 m
.88095 .00375 L
s
.9127 0 m
.9127 .00375 L
s
.94444 0 m
.94444 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
.02381 .10301 m
.03006 .10301 L
s
[(0.5)] .01131 .10301 1 0 Mshowa
.02381 .20601 m
.03006 .20601 L
s
[(1)] .01131 .20601 1 0 Mshowa
.02381 .30902 m
.03006 .30902 L
s
[(1.5)] .01131 .30902 1 0 Mshowa
.02381 .41202 m
.03006 .41202 L
s
[(2)] .01131 .41202 1 0 Mshowa
.02381 .51503 m
.03006 .51503 L
s
[(2.5)] .01131 .51503 1 0 Mshowa
.02381 .61803 m
.03006 .61803 L
s
[(3)] .01131 .61803 1 0 Mshowa
.125 Mabswid
.02381 .0206 m
.02756 .0206 L
s
.02381 .0412 m
.02756 .0412 L
s
.02381 .0618 m
.02756 .0618 L
s
.02381 .0824 m
.02756 .0824 L
s
.02381 .12361 m
.02756 .12361 L
s
.02381 .14421 m
.02756 .14421 L
s
.02381 .16481 m
.02756 .16481 L
s
.02381 .18541 m
.02756 .18541 L
s
.02381 .22661 m
.02756 .22661 L
s
.02381 .24721 m
.02756 .24721 L
s
.02381 .26781 m
.02756 .26781 L
s
.02381 .28842 m
.02756 .28842 L
s
.02381 .32962 m
.02756 .32962 L
s
.02381 .35022 m
.02756 .35022 L
s
.02381 .37082 m
.02756 .37082 L
s
.02381 .39142 m
.02756 .39142 L
s
.02381 .43262 m
.02756 .43262 L
s
.02381 .45322 m
.02756 .45322 L
s
.02381 .47383 m
.02756 .47383 L
s
.02381 .49443 m
.02756 .49443 L
s
.02381 .53563 m
.02756 .53563 L
s
.02381 .55623 m
.02756 .55623 L
s
.02381 .57683 m
.02756 .57683 L
s
.02381 .59743 m
.02756 .59743 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.5 .63053 -96 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Price) show
99.000 13.000 moveto
(level) show
129.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 .4 1 r
.5 Mabswid
.02381 .06646 m
.05556 .0636 L
.0873 .04456 L
.11905 .02788 L
.15079 .01642 L
.18254 .00931 L
.21429 .00514 L
.24603 .00278 L
.27778 .00148 L
.30952 .00078 L
.34127 .0004 L
.37302 .0002 L
.40476 .0001 L
.43651 5e-005 L
.46825 2e-005 L
.5 1e-005 L
.53175 1e-005 L
.56349 0 L
.59524 0 L
.62698 0 L
.65873 0 L
.69048 0 L
.72222 0 L
.75397 0 L
.78571 0 L
.81746 0 L
.84921 0 L
.88095 0 L
.9127 0 L
.94444 0 L
.97619 0 L
s
MathSubEnd
P
% End of sub-graphic
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{700, 741.625},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000:l0002iB000`400?l00000o`00003oo`3ooooo
0?oookh0oooo003o0?ooool0oooo_P3oool00?l0ooooo`3ooonn0?ooo`00o`3ooooo0?oookh0oooo
003o0?ooool0oooo_P3oool00?l0ooooo`3ooonn0?ooo`00o`3ooooo0?oookh0oooo003o0?ooool0
oooo_P3oool00?l0ooooo`3ooonn0?ooo`00o`3ooooo0?oookh0oooo003o0?ooool0oooo_P3oool0
0?l0ooooo`3ooonn0?ooo`00o`3ooooo0?oookh0oooo003o0?ooool0oooo_P3oool00?l0ooooo`3o
oonn0?ooo`00o`3ooooo0?oookh0oooo003o0?ooool0oooo_P3oool00?l0ooooo`3ooonn0?ooo`00
o`3ooooo0?oookh0oooo003o0?ooool0oooo_P3oool00?l0ooooo`3ooonn0?ooo`00o`3ooooo0?oo
okh0oooo003o0?ooool0oooo_P3oool00?l0ooooo`3ooonn0?ooo`00o`3ooooo0?oookh0oooo003o
0?ooool0oooo_P3oool00?l0ooooo`3ooonn0?ooo`00o`3ooooo0?oookh0oooo003o0?ooool0oooo
_P3oool00?l0ooooo`3ooonn0?ooo`00o`3ooooo0?oookh0oooo003o0?ooool0oooo_P3oool00?l0
ooooo`3ooonn0?ooo`00o`3ooooo0?oookh0oooo001_0?ooo`800000803oool500000080oooo0P00
000M0?ooo`D000000P3oool2000001d0oooo100000030?ooo`8000007@3oool4000000<0oooo0P00
000N0?ooo`800000103oool2000008h0oooo0P00000P0?ooo`D000000P3oool2000001d0oooo1@00
00020?ooo`8000007@3oool4000000<0oooo0P00000L0?ooo`@000000`3oool2000001h0oooo0P00
00040?ooo`800000>P3oool006h0oooo00@000000?ooo`3oool000008@3oool01@000000oooo0?oo
o`3oool000000080oooo00<000000?ooo`3oool0703oool01@000000oooo0?ooo`3oool000000080
oooo00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`030?ooo`040000003oool0oooo0000
01`0oooo00<000000?ooo`3oool00`3oool010000000oooo0?ooo`00000L0?ooo`040000003oool0
oooo00000080oooo00@000000?ooo`3oool00000S03oool010000000oooo0?ooo`00000Q0?ooo`05
0000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`0L0?ooo`050000003oool0oooo
0?ooo`0000000P3oool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo00<0oooo00@00000
0?ooo`3oool000006`3oool00`000000oooo0?ooo`030?ooo`040000003oool0oooo000001`0oooo
00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`00000i0?ooo`00L@3oool00`000000
oooo0?ooo`0O0?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`0L0?oo
o`030000003oool0oooo00@0oooo00<000000?ooo`3oool06`3oool00`000000oooo0?ooo`020?oo
o`040000003oool0oooo000001d0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0L
0?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`2=0?ooo`030000003o
ool0oooo01l0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo01`0oooo
00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo0080oooo
00@000000?ooo`3oool00000703oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo01`0
oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo03L0oooo001_0?ooo`80
00008P3oool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool0703oool00`00
0000oooo0?ooo`020?ooo`8000007`3oool01@000000oooo0?ooo`3oool000000080oooo00<00000
0?ooo`3oool0703oool00`000000oooo0?ooo`020?ooo`800000803oool010000000oooo0?ooo`00
00020?ooo`030000003oool0oooo08/0oooo0P00000R0?ooo`050000003oool0oooo0?ooo`000000
0P3oool00`000000oooo0?ooo`0L0?ooo`030000003oool0oooo0080oooo0P00000O0?ooo`050000
003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo0080
oooo0P00000P0?ooo`040000003oool0oooo00000080oooo00<000000?ooo`3oool0=`3oool006l0
oooo00<000000?ooo`3oool08@3oool01@000000oooo0?ooo`3oool000000080oooo00<000000?oo
o`3oool0703oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo01`0oooo00@000000?oo
o`3oool000000P3oool010000000oooo0?ooo`00000L0?ooo`040000003oool0oooo000000<0oooo
00<000000?ooo`3oool0703oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo0000
08d0oooo00<000000?ooo`3oool08@3oool01@000000oooo0?ooo`3oool000000080oooo00<00000
0?ooo`3oool0703oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo01`0oooo00@00000
0?ooo`3oool000000P3oool010000000oooo0?ooo`00000K0?ooo`040000003oool0oooo000000<0
oooo00<000000?ooo`3oool0703oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo
000003T0oooo001_0?ooo`<00000803oool2000000@0oooo0P00000N0?ooo`800000103oool30000
01d0oooo0P0000040?ooo`8000007P3oool2000000@0oooo0`00000M0?ooo`800000103oool20000
08h0oooo0`00000P0?ooo`800000103oool2000001h0oooo0P0000040?ooo`<000007@3oool20000
00@0oooo0P00000M0?ooo`800000103oool3000001d0oooo0P0000040?ooo`800000>P3oool00?l0
ooooo`3ooonn0?ooo`00o`3ooooo0?oookh0oooo003o0?ooool0oooo_P3oool00?l0ooooo`3ooonn
0?ooo`00o`3ooooo0?oookh0oooo00150?oooiX00000D000I_l600000600oooo8`000037001Vo`H0
0000=`3oool004X0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`050?ooo`030000
003oool0oooo00@0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`040?ooo`030000
003oool0oooo00D0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`040?ooo`030000
003oool0oooo00D0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`050?ooo`030000
003oool0oooo00D0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`050?ooo`030000
003oool0oooo00@0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`040?ooo`030000
003oool0oooo00@0oooo3@00I_l30?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0
103oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0
103oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0
1@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0
JP3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0
1@3oool00`000000oooo001Vo`03001Vo`030?ooo`000000oooo00H0oooo00<000000?ooo`3oool0
103oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0
1@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0
1@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0
1@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0
103oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0
103oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0
1@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0
1@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0
103oool00`000000oooo0?ooo`0k0?ooo`00BP3oool00`000000oooo0?ooo`210?ooo`@006Kob@3o
ool00`000000oooo0?ooo`0D0?ooo`8006Koo`3oool90?ooo`00BP3oool00`000000oooo0?ooo`1m
0?ooo`@006Koc@3oool00`000000oooo0?ooo`0C0?ooo`03001Vo`3oool0oooo0?l0oooo2@3oool0
04X0oooo00<000000?ooo`3oool0N@3oool4001Vom40oooo00<000000?ooo`3oool04@3oool2001V
ool0oooo303oool004X0oooo00<000000?ooo`3oool0MP3oool3001VomD0oooo00<000000?ooo`3o
ool0403oool00`00I_l0oooo0?ooo`3o0?ooo``0oooo001:0?ooo`800000L`3oool4001VomP0oooo
0P00000@0?ooo`03001Vo`3oool0oooo0?l0oooo3@3oool004X0oooo00<000000?ooo`3oool0K`3o
ool3001Vom`0oooo00<000000?ooo`3oool03@3oool2001Vool0oooo403oool004X0oooo00<00000
0?ooo`3oool0K@3oool2001Voml0oooo00<000000?ooo`3oool0303oool00`00I_l0oooo0?ooo`3o
0?oooa00oooo001:0?ooo`030000003oool0oooo06/0oooo0P00I_oQ0?ooo`030000003oool0oooo
00`0oooo00<006Ko0?ooo`3oool0o`3oool@0?ooo`00BP3oool00`000000oooo0?ooo`1Y0?ooo`80
06Koh`3oool00`000000oooo0?ooo`0;0?ooo`03001Vo`3oool0oooo0?l0oooo4@3oool004X0oooo
00<000000?ooo`3oool0J03oool00`00I_l0oooo0?ooo`3S0?ooo`030000003oool0oooo00/0oooo
00<006Ko0?ooo`3oool0o`3ooolA0?ooo`00BP3oool2000006P0oooo00<006Ko0?ooo`3oool0i03o
ool2000000`0oooo00<006Ko0?ooo`3oool0o`3ooolA0?ooo`00BP3oool00`000000oooo0?ooo`1U
0?ooo`8006Koi`3oool00`000000oooo0?ooo`0:0?ooo`03001Vo`3oool0oooo0?l0oooo4P3oool0
04X0oooo00<000000?ooo`3oool0I03oool00`00I_l0oooo0?ooo`3W0?ooo`030000003oool0oooo
00X0oooo00<006Ko0?ooo`3oool0o`3ooolB0?ooo`00BP3oool00`000000oooo0?ooo`1S0?ooo`03
001Vo`3oool0oooo0>P0oooo00<000000?ooo`3oool02@3oool00`00I_l0oooo0?ooo`3o0?oooa<0
oooo001:0?ooo`030000003oool0oooo0640oooo0P00I_o[0?ooo`030000003oool0oooo00T0oooo
00<006Ko0?ooo`3oool0o`3ooolC0?ooo`00BP3oool00`000000oooo0?ooo`1P0?ooo`03001Vo`3o
ool0oooo0>/0oooo00<000000?ooo`3oool02@3oool00`00I_l0oooo0?ooo`3o0?oooa<0oooo001:
0?ooo`800000H03oool00`00I_l0oooo0?ooo`3/0?ooo`8000002@3oool00`00I_l0oooo0?ooo`3o
0?oooa@0oooo001:0?ooo`030000003oool0oooo05h0oooo00<006Ko0?ooo`3oool0k@3oool00`00
0000oooo0?ooo`080?ooo`03001Vo`3oool0oooo0?l0oooo503oool004X0oooo00<000000?ooo`3o
ool0G@3oool00`00I_l0oooo0?ooo`3^0?ooo`030000003oool0oooo00P0oooo00<006Ko0?ooo`3o
ool0o`3ooolD0?ooo`00BP3oool00`000000oooo0?ooo`1L0?ooo`03001Vo`3oool0oooo0>l0oooo
00<000000?ooo`3oool01`3oool00`00I_l0oooo0?ooo`3o0?oooaD0oooo000g0?ooo`800000103o
ool2000000<0oooo100000040?ooo`030000003oool0oooo05/0oooo00<006Ko0?ooo`3oool0g@3o
ool2000000@0oooo0P0000030?ooo`@00000103oool00`000000oooo0?ooo`070?ooo`03001Vo`3o
ool0oooo0?l0oooo5@3oool003H0oooo00@000000?ooo`3oool00000203oool00`000000oooo0?oo
o`050?ooo`030000003oool0oooo05X0oooo00<006Ko0?ooo`3oool0g@3oool010000000oooo0?oo
o`0000080?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool01`3oool00`00I_l0oooo
0?ooo`3o0?oooaD0oooo000f0?ooo`040000003oool0oooo000000T0oooo00<000000?ooo`3oool0
103oool3000005T0oooo00<006Ko0?ooo`3oool0gP3oool010000000oooo0?ooo`0000090?ooo`03
0000003oool0oooo00@0oooo0P0000070?ooo`03001Vo`3oool0oooo0?l0oooo5P3oool003H0oooo
00@000000?ooo`3oool000002P3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo05P0
oooo00<006Ko0?ooo`3oool0g`3oool010000000oooo0?ooo`00000:0?ooo`030000003oool0oooo
00<0oooo00<000000?ooo`3oool01P3oool00`00I_l0oooo0?ooo`3o0?oooaH0oooo000f0?ooo`04
0000003oool0oooo000000P0oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`1G
0?ooo`03001Vo`3oool0oooo0>00oooo00@000000?ooo`3oool00000203oool010000000oooo0?oo
o`0000040?ooo`030000003oool0oooo00D0oooo00<006Ko0?ooo`3oool0o`3ooolG0?ooo`00=`3o
ool2000000X0oooo0P0000050?ooo`030000003oool0oooo05H0oooo00<006Ko0?ooo`3oool0hP3o
ool2000000X0oooo0P0000050?ooo`030000003oool0oooo00D0oooo00<006Ko0?ooo`3oool0o`3o
oolG0?ooo`00BP3oool00`000000oooo0?ooo`1E0?ooo`03001Vo`3oool0oooo0?H0oooo00<00000
0?ooo`3oool01@3oool00`00I_l0oooo0?ooo`3o0?oooaL0oooo001:0?ooo`030000003oool0oooo
05@0oooo00<006Ko0?ooo`3oool0m`3oool00`000000oooo0?ooo`040?ooo`03001Vo`3oool0oooo
0?l0oooo603oool004X0oooo00<000000?ooo`3oool0D`3oool00`00I_l0oooo0?ooo`3h0?ooo`03
0000003oool0oooo00@0oooo00<006Ko0?ooo`3oool0o`3ooolH0?ooo`00BP3oool2000005<0oooo
00<006Ko0?ooo`3oool0n@3oool2000000D0oooo00<006Ko0?ooo`3oool0o`3ooolH0?ooo`00BP3o
ool00`000000oooo0?ooo`1A0?ooo`03001Vo`3oool0oooo0?X0oooo00<000000?ooo`3oool0103o
ool00`00I_l0oooo0?ooo`3o0?oooaP0oooo001:0?ooo`030000003oool0oooo0500oooo00<006Ko
0?ooo`3oool0n`3oool00`000000oooo0?ooo`040?ooo`03001Vo`3oool0oooo0?l0oooo603oool0
04X0oooo00<000000?ooo`3oool0D03oool00`00I_l0oooo0?ooo`3k0?ooo`030000003oool0oooo
00<0oooo00<006Ko0?ooo`3oool0o`3ooolI0?ooo`00BP3oool00`000000oooo0?ooo`1?0?ooo`03
001Vo`3oool0oooo0?`0oooo00<000000?ooo`3oool00`3oool00`00I_l0oooo0?ooo`3o0?oooaT0
oooo001:0?ooo`030000003oool0oooo04h0oooo00<006Ko0?ooo`3oool0o@3oool00`000000oooo
0?ooo`030?ooo`03001Vo`3oool0oooo0?l0oooo6@3oool004X0oooo0P00001>0?ooo`03001Vo`3o
ool0oooo0?h0oooo0P0000040?ooo`03001Vo`3oool0oooo0?l0oooo6@3oool004X0oooo00<00000
0?ooo`3oool0C@3oool00`00I_l0oooo0?ooo`3n0?ooo`030000003oool0oooo00<0oooo00<006Ko
0?ooo`3oool0o`3ooolI0?ooo`00BP3oool00`000000oooo0?ooo`1<0?ooo`03001Vo`3oool0oooo
0?l0oooo00<000000?ooo`3oool00`3oool00`00I_l0oooo0?ooo`3o0?oooaT0oooo001:0?ooo`03
0000003oool0oooo04/0oooo00<006Ko0?ooo`3oool0o`3oool10?ooo`030000003oool0oooo00<0
oooo00<006Ko0?ooo`3oool0o`3ooolI0?ooo`00BP3oool00`000000oooo0?ooo`1:0?ooo`03001V
o`3oool0oooo0?l0oooo0P3oool00`000000oooo0?ooo`020?ooo`03001Vo`3oool0oooo0?l0oooo
6P3oool004X0oooo00<000000?ooo`3oool0BP3oool00`00I_l0oooo0?ooo`3o0?ooo`80oooo00<0
00000?ooo`3oool00P3oool00`00I_l0oooo0?ooo`3o0?oooaX0oooo001:0?ooo`800000BP3oool0
0`00I_l0oooo0?ooo`3o0?ooo`<0oooo0P0000030?ooo`03001Vo`3oool0oooo0?l0oooo6P3oool0
04X0oooo00<000000?ooo`3oool0B03oool00`00I_l0oooo0?ooo`3o0?ooo`@0oooo00<000000?oo
o`3oool00P3oool00`00I_l0oooo0?ooo`3o0?oooaX0oooo001:0?ooo`030000003oool0oooo04P0
oooo00<006Ko0?ooo`3oool0o`3oool40?ooo`030000003oool0oooo0080oooo00<006Ko0?ooo`3o
ool0o`3ooolJ0?ooo`00BP3oool00`000000oooo0?ooo`170?ooo`03001Vo`3oool0oooo0?l0oooo
1@3oool00`000000oooo0?ooo`020?ooo`03001Vo`3oool0oooo0?l0oooo6P3oool003L0oooo0P00
00040?ooo`8000001@3oool3000000<0oooo00<000000?ooo`3oool0AP3oool00`00I_l0oooo0?oo
o`3b0?ooo`800000103oool2000000D0oooo0`0000030?ooo`050000003oool0oooo0?ooo`00I_l0
o`3ooolM0?ooo`00=P3oool010000000oooo0?ooo`00000;0?ooo`030000003oool0oooo0080oooo
00<000000?ooo`3oool0AP3oool00`00I_l0oooo0?ooo`3a0?ooo`040000003oool0oooo000000/0
oooo00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool006Ko0?l0oooo7@3oool003H0
oooo00@000000?ooo`3oool00000203oool5000000<0oooo0`0000150?ooo`03001Vo`3oool0oooo
0?80oooo00@000000?ooo`3oool00000203oool5000000<0oooo0P0000020?ooo`03001Vo`3oool0
oooo0?l0oooo6`3oool003H0oooo00@000000?ooo`3oool00000203oool010000000oooo0?ooo`00
00040?ooo`030000003oool0oooo04D0oooo00<006Ko0?ooo`3oool0lP3oool010000000oooo0?oo
o`0000080?ooo`040000003oool0oooo000000@0oooo00D000000?ooo`3oool0oooo001Vo`3o0?oo
oad0oooo000f0?ooo`040000003oool0oooo000000T0oooo00<000000?ooo`000000103oool00`00
0000oooo0?ooo`140?ooo`03001Vo`3oool0oooo0?<0oooo00@000000?ooo`3oool000002@3oool0
0`000000oooo000000040?ooo`050000003oool0oooo0?ooo`00I_l0o`3ooolM0?ooo`00=`3oool2
000000/0oooo0P0000040?ooo`030000003oool0oooo04<0oooo00<006Ko0?ooo`3oool0m@3oool2
000000/0oooo0P0000040?ooo`050000003oool0oooo0?ooo`00I_l0o`3ooolM0?ooo`00BP3oool0
0`000000oooo0?ooo`130?ooo`03001Vo`3oool0oooo0?l0oooo2@3oool01@000000oooo0?ooo`3o
ool006Ko0?l0oooo7@3oool004X0oooo00<000000?ooo`3oool0@P3oool00`00I_l0oooo0?ooo`3o
0?ooo`X0oooo00@000000?ooo`3oool006Koo`3ooolN0?ooo`00BP3oool200000480oooo00<006Ko
0?ooo`3oool0o`3oool;0?ooo`80000000<0oooo001Vo`3oool0o`3ooolM0?ooo`00BP3oool00`00
0000oooo0?ooo`110?ooo`03001Vo`3oool0oooo0?l0oooo2`3oool010000000oooo0?ooo`00I_oo
0?oooah0oooo001:0?ooo`030000003oool0oooo0400oooo00<006Ko0?ooo`3oool0o`3oool<0?oo
o`040000003oool0oooo001Vool0oooo7P3oool004X0oooo00<000000?ooo`3oool0@03oool00`00
I_l0oooo0?ooo`3o0?ooo``0oooo00@000000?ooo`3oool006Koo`3ooolN0?ooo`00BP3oool00`00
0000oooo0?ooo`0o0?ooo`03001Vo`3oool0oooo0?l0oooo3@3oool010000000oooo0?ooo`00I_oo
0?oooah0oooo001:0?ooo`030000003oool0oooo03h0oooo00<006Ko0?ooo`3oool0o`3oool>0?oo
o`040000003oool0oooo001Vool0oooo7P3oool004X0oooo0P00000o0?ooo`03001Vo`3oool0oooo
0?l0oooo3P3oool200000003001Vo`3oool0oooo0?l0oooo7@3oool004X0oooo00<000000?ooo`3o
ool0?@3oool00`00I_l0oooo0?ooo`3o0?ooo`l0oooo00<000000?ooo`00I_l0o`3ooolO0?ooo`00
BP3oool00`000000oooo0?ooo`0l0?ooo`03001Vo`3oool0oooo0?l0oooo403oool00`000000oooo
001Vo`3o0?oooal0oooo001:0?ooo`030000003oool0oooo03`0oooo00<006Ko0?ooo`3oool0o`3o
ool@0?ooo`030000003oool006Ko0?l0oooo7`3oool004X0oooo00<000000?ooo`3oool0>`3oool0
0`00I_l0oooo0?ooo`3o0?oooa40oooo00<000000?ooo`00I_l0o`3ooolO0?ooo`00BP3oool00`00
0000oooo0?ooo`0k0?ooo`03001Vo`3oool0oooo0?l0oooo4@3oool00`000000oooo001Vo`3o0?oo
oal0oooo001:0?ooo`800000>`3oool00`00I_l0oooo0?ooo`3o0?oooa80oooo00<00000001Vo`3o
ool0o`3ooolO0?ooo`00BP3oool00`000000oooo0?ooo`0j0?ooo`03001Vo`3oool0oooo0?l0oooo
4P3oool00`00000006Ko0?ooo`3o0?oooal0oooo001:0?ooo`030000003oool0oooo03T0oooo00<0
06Ko0?ooo`3oool0o`3ooolC0?ooo`0300000000I_l0oooo0?l0oooo7`3oool004X0oooo00<00000
0?ooo`3oool0>@3oool00`00I_l0oooo0?ooo`3o0?oooa<0oooo00<00000001Vo`3oool0o`3ooolO
0?ooo`00BP3oool00`000000oooo0?ooo`0h0?ooo`03001Vo`3oool0oooo0?l0oooo503oool00`00
000006Ko0?ooo`3o0?oooal0oooo000g0?ooo`800000103oool2000000<0oooo0`0000050?ooo`03
0000003oool0oooo03P0oooo00<006Ko0?ooo`3oool0o`3oool10?ooo`800000103oool2000000<0
oooo0`0000050?ooo`0300000000I_l0oooo0?l0oooo7`3oool003H0oooo00@000000?ooo`3oool0
0000203oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo03L0oooo00<006Ko0?oo
o`3oool0o`3oool10?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`3oool00000103o
ool00`00000006Ko0?ooo`3o0?oooal0oooo000f0?ooo`040000003oool0oooo000000P0oooo00@0
00000?ooo`3oool00000103oool3000003L0oooo00<006Ko0?ooo`3oool0o`3oool10?ooo`040000
003oool0oooo000000P0oooo00@000000?ooo`3oool00000103oool00`00I_l000000?ooo`3o0?oo
oal0oooo000f0?ooo`040000003oool0oooo000000P0oooo0`0000050?ooo`030000003oool0oooo
03H0oooo00<006Ko0?ooo`3oool0o`3oool20?ooo`040000003oool0oooo000000P0oooo0`000005
0?ooo`03001Vo`3oool0oooo0?l0oooo7`3oool003H0oooo00@000000?ooo`3oool000002@3oool0
0`000000oooo0?ooo`040?ooo`030000003oool0oooo03H0oooo00<006Ko0?ooo`3oool0o`3oool2
0?ooo`040000003oool0oooo000000T0oooo00<000000?ooo`3oool0103oool00`00I_l0oooo0?oo
o`3o0?oooal0oooo000g0?ooo`8000002P3oool3000000@0oooo00<006Ko0?ooo`3oool0=@3oool0
0`00I_l0oooo0?ooo`3o0?ooo`@0oooo0P00000:0?ooo`<00000103oool00`00I_l0oooo0?ooo`3o
0?oooal0oooo001:0?ooo`03001Vo`3oool0oooo03D0oooo00<006Ko0?ooo`3oool0o`3ooolG0?oo
o`030000003oool0oooo0?l0oooo7`3oool004X0oooo00<006Ko0?ooo`3oool0=03oool00`00I_l0
oooo0?ooo`3o0?oooaP0oooo00<000000?ooo`3oool0o`3ooolO0?ooo`00BP3oool00`00000006Ko
0?ooo`0d0?ooo`03001Vo`3oool0oooo0?l0oooo603oool200000?l0oooo803oool004X0oooo00<0
0000001Vo`3oool0<`3oool00`00I_l0oooo0?ooo`3o0?oooaT0oooo00<000000?ooo`3oool0o`3o
oolO0?ooo`00BP3oool00`00000006Ko0?ooo`0c0?ooo`03001Vo`3oool0oooo0?l0oooo6@3oool0
0`000000oooo0?ooo`3o0?oooal0oooo001:0?ooo`0300000000I_l0oooo0380oooo00<006Ko0?oo
o`3oool0o`3ooolJ0?ooo`030000003oool0oooo0?l0oooo7`3oool004X0oooo00<00000001Vo`3o
ool0<P3oool00`00I_l0oooo0?ooo`3o0?oooaX0oooo00<000000?ooo`3oool0o`3ooolO0?ooo`00
BP3oool00`00000006Ko0?ooo`0a0?ooo`03001Vo`3oool0oooo0?l0oooo6`3oool00`000000oooo
0?ooo`3o0?oooal0oooo001:0?ooo`80000000<006Ko0?ooo`3oool0;`3oool00`00I_l0oooo0?oo
o`3o0?oooa/0oooo0P00003o0?ooob00oooo001:0?ooo`030000003oool006Ko0300oooo00<006Ko
0?ooo`3oool0o`3ooolL0?ooo`030000003oool0oooo0?l0oooo7`3oool004X0oooo00<000000?oo
o`00I_l0<03oool00`00I_l0oooo0?ooo`3o0?oooa`0oooo00<000000?ooo`3oool0o`3ooolO0?oo
o`00BP3oool00`000000oooo001Vo`0_0?ooo`03001Vo`3oool0oooo0?l0oooo7@3oool00`000000
oooo0?ooo`3o0?oooal0oooo001:0?ooo`030000003oool006Ko02l0oooo00<006Ko0?ooo`3oool0
o`3ooolM0?ooo`030000003oool0oooo0?l0oooo7`3oool004X0oooo00@000000?ooo`3oool006Ko
;@3oool00`00I_l0oooo0?ooo`3o0?oooah0oooo00<000000?ooo`3oool0o`3ooolO0?ooo`00BP3o
ool2000000030?ooo`00I_l0oooo02`0oooo00<006Ko0?ooo`3oool0o`3ooolN0?ooo`800000o`3o
oolP0?ooo`00BP3oool010000000oooo0?ooo`00I_l/0?ooo`03001Vo`3oool0oooo0?l0oooo7`3o
ool00`000000oooo0?ooo`3o0?oooal0oooo001:0?ooo`040000003oool0oooo001Vob`0oooo00<0
06Ko0?ooo`3oool0o`3ooolO0?ooo`030000003oool0oooo0?l0oooo7`3oool004X0oooo00@00000
0?ooo`3oool006Ko:`3oool00`00I_l0oooo0?ooo`3o0?ooob00oooo00<000000?ooo`3oool0o`3o
oolO0?ooo`00=`3oool2000000@0oooo0P0000040?ooo`8000001@3oool01@000000oooo0?ooo`3o
ool006Ko02X0oooo00<006Ko0?ooo`3oool0o`3oool=0?ooo`800000103oool2000000@0oooo0P00
00050?ooo`030000003oool0oooo0?l0oooo7`3oool003H0oooo00@000000?ooo`3oool00000203o
ool010000000oooo0?ooo`0000040?ooo`050000003oool0oooo0?ooo`00I_l0:@3oool00`00I_l0
oooo0?ooo`3o0?ooo`d0oooo00@000000?ooo`3oool00000203oool010000000oooo0?ooo`000004
0?ooo`030000003oool0oooo0?l0oooo7`3oool003H0oooo00@000000?ooo`3oool00000203oool0
10000000oooo0?ooo`0000040?ooo`<0000000<0oooo001Vo`3oool09`3oool00`00I_l0oooo0?oo
o`3o0?ooo`h0oooo00@000000?ooo`3oool00000203oool010000000oooo0?ooo`0000040?ooo`80
0000o`3ooolP0?ooo`00=P3oool010000000oooo0?ooo`0000090?ooo`8000001@3oool01@000000
oooo0?ooo`3oool006Ko02P0oooo00<006Ko0?ooo`3oool0o`3oool>0?ooo`040000003oool0oooo
000000T0oooo0P0000050?ooo`030000003oool0oooo0?l0oooo7`3oool003H0oooo00@000000?oo
o`3oool00000203oool010000000oooo0?ooo`0000040?ooo`050000003oool0oooo0?ooo`00I_l0
9`3oool00`00I_l0oooo0?ooo`3o0?ooo`l0oooo00@000000?ooo`3oool00000203oool010000000
oooo0?ooo`0000040?ooo`030000003oool0oooo0?l0oooo7`3oool003L0oooo0P00000:0?ooo`80
00001@3oool01@000000oooo0?ooo`3oool006Ko02L0oooo00<006Ko0?ooo`3oool0o`3oool@0?oo
o`8000002P3oool2000000D0oooo00<000000?ooo`3oool0o`3ooolO0?ooo`00BP3oool00`000000
oooo0?ooo`020?ooo`03001Vo`3oool0oooo02<0oooo00<006Ko0?ooo`3oool0o`3ooolT0?ooo`03
0000003oool0oooo0?l0oooo7`3oool004X0oooo00<000000?ooo`3oool00P3oool00`00I_l0oooo
0?ooo`0S0?ooo`03001Vo`3oool0oooo0?l0oooo903oool00`000000oooo0?ooo`3o0?oooal0oooo
001:0?ooo`8000000`3oool00`00I_l0oooo0?ooo`0R0?ooo`03001Vo`3oool0oooo0?l0oooo9@3o
ool200000?l0oooo803oool004X0oooo00<000000?ooo`3oool00P3oool00`00I_l0oooo0?ooo`0Q
0?ooo`03001Vo`3oool0oooo0?l0oooo9P3oool00`000000oooo0?ooo`3o0?oooal0oooo001:0?oo
o`030000003oool0oooo0080oooo00<006Ko0?ooo`3oool08@3oool00`00I_l0oooo0?ooo`3o0?oo
obH0oooo00<000000?ooo`3oool0o`3ooolO0?ooo`00BP3oool00`000000oooo0?ooo`030?ooo`03
001Vo`3oool0oooo01l0oooo00<006Ko0?ooo`3oool0o`3ooolW0?ooo`030000003oool0oooo0?l0
oooo7`3oool004X0oooo00<000000?ooo`3oool00`3oool00`00I_l0oooo0?ooo`0O0?ooo`03001V
o`3oool0oooo0?l0oooo9`3oool00`000000oooo0?ooo`3o0?oooal0oooo001:0?ooo`030000003o
ool0oooo00<0oooo00<006Ko0?ooo`3oool07P3oool00`00I_l0oooo0?ooo`3o0?ooobP0oooo00<0
00000?ooo`3oool0o`3ooolO0?ooo`00BP3oool00`000000oooo0?ooo`030?ooo`03001Vo`3oool0
oooo01h0oooo00<006Ko0?ooo`3oool0o`3ooolX0?ooo`030000003oool0oooo0?l0oooo7`3oool0
04X0oooo0P0000040?ooo`03001Vo`3oool0oooo01d0oooo00<006Ko0?ooo`3oool0o`3ooolY0?oo
o`800000o`3ooolP0?ooo`00BP3oool00`000000oooo0?ooo`040?ooo`03001Vo`3oool0oooo01/0
oooo00<006Ko0?ooo`3oool0o`3ooolZ0?ooo`030000003oool0oooo0?l0oooo7`3oool004X0oooo
00<000000?ooo`3oool0103oool00`00I_l0oooo0?ooo`0K0?ooo`03001Vo`3oool0oooo0?l0oooo
:P3oool00`000000oooo0?ooo`3o0?oooal0oooo001:0?ooo`030000003oool0oooo00@0oooo00<0
06Ko0?ooo`3oool06P3oool00`00I_l0oooo0?ooo`3o0?ooob/0oooo00<000000?ooo`3oool0o`3o
oolO0?ooo`00BP3oool00`000000oooo0?ooo`040?ooo`03001Vo`3oool0oooo01X0oooo00<006Ko
0?ooo`3oool0o`3oool[0?ooo`030000003oool0oooo0?l0oooo7`3oool004X0oooo00<000000?oo
o`3oool0103oool00`00I_l0oooo0?ooo`0I0?ooo`03001Vo`3oool0oooo0?l0oooo;03oool00`00
0000oooo0?ooo`3o0?oooal0oooo001:0?ooo`8000001@3oool00`00I_l0oooo0?ooo`0I0?ooo`03
001Vo`3oool0oooo0?l0oooo;03oool200000?l0oooo803oool004X0oooo00<000000?ooo`3oool0
1@3oool00`00I_l0oooo0?ooo`0G0?ooo`03001Vo`3oool0oooo0?l0oooo;@3oool00`000000oooo
0?ooo`3o0?oooal0oooo001:0?ooo`030000003oool0oooo00D0oooo00<006Ko0?ooo`3oool05`3o
ool00`00I_l0oooo0?ooo`3o0?ooobd0oooo00<000000?ooo`3oool0o`3ooolO0?ooo`00BP3oool0
0`000000oooo0?ooo`050?ooo`03001Vo`3oool0oooo01H0oooo00<006Ko0?ooo`3oool0o`3oool^
0?ooo`030000003oool0oooo0?l0oooo7`3oool00480oooo1@0000030?ooo`030000003oool0oooo
00H0oooo00<006Ko0?ooo`3oool05@3oool00`00I_l0oooo0?ooo`3o0?ooobH0oooo1@0000030?oo
o`030000003oool0oooo0?l0oooo7`3oool004@0oooo00<000000?ooo`3oool00`3oool00`000000
oooo0?ooo`060?ooo`03001Vo`3oool0oooo01@0oooo00<006Ko0?ooo`3oool0o`3ooolY0?ooo`03
0000003oool0oooo00<0oooo00<000000?ooo`3oool0o`3ooolO0?ooo`00A03oool00`000000oooo
0?ooo`030?ooo`<000001`3oool00`00I_l0oooo0?ooo`0C0?ooo`03001Vo`3oool0oooo0?l0oooo
:@3oool00`000000oooo0?ooo`030?ooo`800000o`3ooolP0?ooo`00A03oool00`000000oooo0?oo
o`030?ooo`030000003oool0oooo00L0oooo00<006Ko0?ooo`3oool04P3oool00`00I_l0oooo0?oo
o`3o0?ooobX0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`3o0?oooal0oooo0014
0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0203oool00`00I_l0oooo0?ooo`0@
0?ooo`03001Vo`3oool0oooo0?l0oooo:`3oool00`000000oooo0?ooo`030?ooo`030000003oool0
oooo0?l0oooo7`3oool004<0oooo0P0000050?ooo`030000003oool0oooo00P0oooo00<006Ko0?oo
o`3oool03`3oool00`00I_l0oooo0?ooo`3o0?ooob/0oooo0P0000050?ooo`030000003oool0oooo
0?l0oooo7`3oool004X0oooo00<000000?ooo`3oool02@3oool00`00I_l0oooo0?ooo`0=0?ooo`03
001Vo`3oool0oooo0?l0oooo<`3oool00`000000oooo0?ooo`3o0?oooal0oooo001:0?ooo`030000
003oool0oooo00X0oooo00<006Ko0?ooo`3oool02`3oool00`00I_l0oooo0?ooo`3o0?oooc@0oooo
00<000000?ooo`3oool0o`3ooolO0?ooo`00BP3oool2000000/0oooo00<006Ko0?ooo`3oool02`3o
ool00`00I_l0oooo0?ooo`3o0?oooc@0oooo0P00003o0?ooob00oooo001:0?ooo`030000003oool0
oooo00/0oooo00<006Ko0?ooo`3oool02@3oool00`00I_l0oooo0?ooo`3o0?ooocD0oooo00<00000
0?ooo`3oool0o`3ooolO0?ooo`00BP3oool00`000000oooo0?ooo`0;0?ooo`03001Vo`3oool0oooo
00P0oooo00<006Ko0?ooo`3oool0o`3ooolf0?ooo`030000003oool0oooo0?l0oooo7`3oool004X0
oooo00<000000?ooo`3oool0303oool00`00I_l0oooo0?ooo`060?ooo`03001Vo`3oool0oooo0?l0
oooo=`3oool00`000000oooo0?ooo`3o0?oooal0oooo001:0?ooo`030000003oool0oooo00`0oooo
00<006Ko0?ooo`3oool00P3oool4001Vool0oooo>P3oool00`000000oooo0?ooo`3o0?oooal0oooo
001:0?ooo`030000003oool0oooo00d0oooo1000I_oo0?oooch0oooo00<000000?ooo`3oool0o`3o
oolO0?ooo`00BP3oool200000?l0ooooD03oool200000?l0oooo803oool004X0oooo00<000000?oo
o`3oool0o`3ooom?0?ooo`030000003oool0oooo0?l0oooo7`3oool004X0oooo00<000000?ooo`3o
ool0o`3ooom?0?ooo`030000003oool0oooo0?l0oooo7`3oool004X0oooo00<000000?ooo`3oool0
o`3ooom?0?ooo`030000003oool0oooo0?l0oooo7`3oool004X0oooo00<000000?ooo`3oool0o`3o
oom?0?ooo`030000003oool0oooo0?l0oooo7`3oool004X0oooo00<000000?ooo`3oool0o`3ooom?
0?ooo`030000003oool0oooo0?l0oooo7`3oool004X0oooo0P00003o0?oooe00oooo0P00003o0?oo
ob00oooo001:0?ooo`030000003oool0oooo0?l0ooooC`3oool00`000000oooo0?ooo`3o0?oooal0
oooo001:0?ooo`030000003oool0oooo0?l0ooooC`3oool00`000000oooo0?ooo`3o0?oooal0oooo
001:0?ooo`030000003oool0oooo0?l0ooooC`3oool00`000000oooo0?ooo`3o0?oooal0oooo001:
0?ooo`030000003oool0oooo0?l0ooooC`3oool00`000000oooo0?ooo`3o0?oooal0oooo001:0?oo
o`030000003oool0oooo0?l0ooooC`3oool00`000000oooo0?ooo`3o0?oooal0oooo001:0?ooo`03
0000003oool0oooo0?l0ooooC`3oool00`000000oooo0?ooo`3o0?oooal0oooo003o0?ooool0oooo
_P3oool00?l0ooooo`3ooonn0?ooo`00o`3ooooo0?oookh0oooo003o0?ooool0oooo_P3oool00?l0
ooooo`3ooonn0?ooo`00jP3oool2000001/0oooo0`00003o0?oooc80oooo0P00000K0?ooo`<00000
H@3oool00>/0oooo00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`3o0?oooc80oooo00<0
00000?ooo`3oool06P3oool00`000000oooo0?ooo`1P0?ooo`00C`3oool300000080oooo10000003
0?ooo`8000000`3oool3000000<0oooo0`0000090?ooo`<00000103oool3000000<0oooo0`000003
0?ooo`800000103oool3000000<0oooo0P0000020?ooo`8000000P3oool2000000030?ooo`000000
000000<0000000@0oooo00000000000000002P3oool2000000<0oooo1@0000000`3oool000000000
0002000000<0oooo0`0000020?ooo`T00000103oool300000080oooo0`0000040?ooo`<000000`3o
ool2000000D0oooo00<000000?ooo`3oool0203oool2000000<0oooo100000080?ooo`<000000`3o
ool4000000<0oooo0`0000030?ooo`<000000`3oool300000080oooo0`00001g0?ooo`<000000P3o
ool4000000<0oooo0P0000030?ooo`<000000`3oool3000000T0oooo0`0000040?ooo`<000000`3o
ool3000000<0oooo0P0000040?ooo`<000000`3oool200000080oooo0P0000020?ooo`80000000<0
oooo0000000000000`000000103oool0000000000000000:0?ooo`8000000`3oool5000000030?oo
o`0000000000008000000`3oool300000080oooo2@0000040?ooo`<000000P3oool3000000@0oooo
0`0000030?ooo`8000001@3oool00`000000oooo0?ooo`080?ooo`8000000`3oool4000000P0oooo
0`0000030?ooo`@000000`3oool3000000<0oooo0`0000030?ooo`<000000P3oool300000480oooo
001>0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool00P3oool010000000oooo0?oo
o`0000050?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0100000050?ooo`040000
003oool0oooo000000D0oooo00<000000?ooo`3oool00`3oool010000000oooo0?ooo`0000040?oo
o`050000003oool0oooo0?ooo`0000000P3oool010000000oooo0?ooo`0000020?ooo`030000003o
ool0oooo00@000000`3oool00`000000oooo0?ooo`090?ooo`8000000`3oool4000000<0oooo00<0
00000?ooo`3oool0103oool010000000oooo0?ooo`3oool400000080oooo00@000000?ooo`3oool0
0000103oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00@0oooo00D000000?ooo`3o
ool0oooo000000020?ooo`070000003oool0oooo0?ooo`000000oooo000000080?ooo`040000003o
ool0oooo000000<0oooo00<000000?ooo`3oool0203oool010000000oooo0?ooo`0000030?ooo`03
0000003oool0oooo00@0oooo00D000000?ooo`3oool0oooo000000050?ooo`030000003oool0oooo
00H0oooo00<000000?ooo`3oool0L`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo
0080oooo00@000000?ooo`3oool000001@3oool00`000000oooo0?ooo`030?ooo`030000003oool0
oooo00@000001@3oool010000000oooo0?ooo`0000050?ooo`030000003oool0oooo00<0oooo00@0
00000?ooo`3oool00000103oool01@000000oooo0?ooo`3oool000000080oooo00@000000?ooo`3o
ool000000P3oool00`000000oooo0?ooo`04000000<0oooo00<000000?ooo`3oool02@3oool20000
00<0oooo100000030?ooo`030000003oool0oooo00@0oooo00@000000?ooo`3oool0oooo10000002
0?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?oo
o`040?ooo`050000003oool0oooo0?ooo`0000000P3oool01`000000oooo0?ooo`3oool000000?oo
o`000000203oool010000000oooo0?ooo`0000030?ooo`030000003oool0oooo00P0oooo00@00000
0?ooo`3oool000000`3oool00`000000oooo0?ooo`040?ooo`050000003oool0oooo0?ooo`000000
1@3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo03l0oooo001>0?ooo`030000003o
ool0oooo00@0oooo00<000000?ooo`3oool00P3oool010000000oooo0?ooo`0000020?ooo`<00000
0`3oool3000000T0oooo0`0000030?ooo`@000000P3oool00`000000oooo0?ooo`030?ooo`030000
003oool0oooo00D0oooo00D000000?ooo`3oool0oooo000000020?ooo`040000003oool0oooo0000
0080oooo00<000000?ooo`3oool00`3oool01@000000oooo0?ooo`3oool0000000X0oooo00@00000
0?ooo`3oool000001@3oool01@000000oooo0?ooo`3oool0000000H0oooo00<000000?ooo`3oool0
103oool010000000oooo0?ooo`0000020?ooo`030000003oool0oooo0080oooo00<000000?ooo`3o
ool00P3oool00`000000oooo0?ooo`040?ooo`050000003oool0oooo0?ooo`0000001@3oool01000
0000oooo0?ooo`0000080?ooo`040000003oool0oooo000000<0oooo00<000000?ooo`3oool0203o
ool010000000oooo0?ooo`0000030?ooo`030000003oool0oooo00@0oooo00D000000?ooo`3oool0
oooo000000050?ooo`@000000P3oool3000007H0oooo00<000000?ooo`3oool0103oool00`000000
oooo0?ooo`020?ooo`040000003oool0oooo00000080oooo0`0000030?ooo`<000002@3oool30000
00<0oooo100000020?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool01@3oool01@00
0000oooo0?ooo`3oool000000080oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?oo
o`030?ooo`050000003oool0oooo0?ooo`0000002P3oool010000000oooo0?ooo`0000050?ooo`05
0000003oool0oooo0?ooo`0000001P3oool00`000000oooo0?ooo`040?ooo`040000003oool0oooo
00000080oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`020?ooo`030000003oool0
oooo00@0oooo00D000000?ooo`3oool0oooo000000050?ooo`040000003oool0oooo000000P0oooo
00@000000?ooo`3oool000000`3oool00`000000oooo0?ooo`080?ooo`040000003oool0oooo0000
00<0oooo00<000000?ooo`3oool0103oool01@000000oooo0?ooo`3oool0000000D0oooo10000002
0?ooo`<00000@P3oool004h0oooo00<000000?ooo`3oool00`3oool4000000<0oooo0P0000030?oo
o`@000000P3oool4000000P0oooo100000030?ooo`800000103oool3000000030?ooo`0000000000
00<000000`3oool2000000@0oooo0P0000020?ooo`@00000103oool3000000<0oooo00<000000?oo
o`3oool01`3oool200000080oooo0P0000020?ooo`<000000P3oool4000000<0oooo0P0000040?oo
o`<000000P3oool3000000@0oooo0P0000040?ooo`030000003oool0oooo00<0oooo0P0000020?oo
o`D0000000D0oooo00000000000000000?ooo`02000000P0oooo0P0000030?ooo`@000001`3oool4
000000<0oooo100000030?ooo`800000103oool3000000<0oooo0P0000030?ooo`@00000M@3oool0
0`000000oooo0?ooo`030?ooo`@000000`3oool2000000<0oooo100000020?ooo`@00000203oool4
000000<0oooo0P0000040?ooo`<0000000<0oooo0000000000000`0000030?ooo`800000103oool2
00000080oooo100000040?ooo`<000000`3oool00`000000oooo0?ooo`070?ooo`8000000P3oool2
00000080oooo0`0000020?ooo`@000000`3oool2000000@0oooo0`0000020?ooo`<00000103oool2
000000@0oooo00<000000?ooo`3oool00`3oool200000080oooo1@0000001@3oool0000000000000
0000oooo00800000203oool2000000<0oooo100000070?ooo`@000000`3oool4000000<0oooo0P00
00040?ooo`<000000`3oool2000000<0oooo100000110?ooo`00CP3oool010000000oooo0?ooo`00
000b0?ooo`030000003oool0oooo01`0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?oo
o`0:0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?oo
o`2O0?ooo`040000003oool0oooo00000380oooo00<000000?ooo`3oool0703oool00`000000oooo
0?ooo`0V0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0203oool00`000000oooo
0?ooo`0F0?ooo`030000003oool0oooo06/0oooo001?0?ooo`<00000>P3oool00`000000oooo0?oo
o`0C0?ooo`8000007P3oool00`000000oooo0?ooo`060?ooo`8000001`3oool010000000oooo0?oo
o`3oool2000000H0oooo00<000000?ooo`3oool06`3oool2000001H0oooo00<000000?ooo`3oool0
Q`3oool3000003X0oooo00<000000?ooo`3oool04`3oool2000001h0oooo00<000000?ooo`3oool0
1P3oool2000000L0oooo00@000000?ooo`3oool0oooo0P0000060?ooo`030000003oool0oooo01/0
oooo0P00000F0?ooo`030000003oool0oooo0580oooo003o0?ooool0oooo_P3oool00?l0ooooo`3o
oonn0?ooo`00o`3ooooo0?oookh0oooo003o0?ooool0oooo_P3oool00?l0ooooo`3ooonn0?ooo`00
o`3ooooo0?oookh0oooo003o0?ooool0oooo_P3oool00?l0ooooo`3ooonn0?ooo`00o`3ooooo0?oo
okh0oooo003o0?ooool0oooo_P3oool00?l0ooooo`3ooonn0?ooo`00o`3ooooo0?oookh0oooo003o
0?ooool0oooo_P3oool00?l0ooooo`3ooonn0?ooo`00o`3ooooo0?oookh0oooo003o0?ooool0oooo
_P3oool00?l0ooooo`3ooonn0?ooo`00o`3ooooo0?oookh0oooo003o0?ooool0oooo_P3oool00?l0
ooooo`3ooonn0?ooo`00o`3ooooo0?oookh0oooo003o0?ooool0oooo_P3oool00?l0ooooo`3ooonn
0?ooo`00o`3ooooo0?oookh0oooo003o0?ooool0oooo_P3oool00?l0ooooo`3ooonn0?ooo`00o`3o
oooo0?oookh0oooo003o0?ooool0oooo_P3oool00?l0ooooo`3ooonn0?ooo`00o`3ooooo0?oookh0
oooo003o0?ooool0oooo_P3oool00?l0ooooo`3ooonn0?ooo`00o`3ooooo0?oookh0oooo003o0?oo
ool0oooo_P3oool00?l0ooooo`3ooonn0?ooo`00o`3ooooo0?oookh0oooo003o0?ooool0oooo_P3o
ool00?l0ooooo`3ooonn0?ooo`00o`3ooooo0?oookh0oooo003o0?ooool0oooo_P3oool00?l0oooo
o`3ooonn0?ooo`00o`3ooooo0?oookh0oooo003o0?ooool0oooo_P3oool00?l0ooooo`3ooonn0?oo
o`00o`3ooooo0?oookh0oooo003o0?ooool0oooo_P3oool00?l0ooooo`3ooonn0?ooo`00o`3ooooo
0?oookh0oooo003o0?ooool0oooo_P3oool00?l0ooooo`3ooonn0?ooo`00o`3ooooo0?oookh0oooo
003o0?ooool0oooo_P3oool00?l0ooooo`3ooonn0?ooo`00o`3ooooo0?oookh0oooo003o0?ooool0
oooo_P3oool00?l0ooooo`3ooonn0?ooo`00o`3ooooo0?oookh0oooo000e0?ooo`800000103oool2
000000D0oooo0`00003o0?oood40oooo0P0000040?ooo`8000001@3oool300000?l0oooo:03oool0
03@0oooo00@000000?ooo`3oool000002`3oool00`000000oooo0?ooo`3o0?ooocl0oooo00@00000
0?ooo`3oool000002`3oool00`000000oooo0?ooo`3o0?ooobL0oooo000d0?ooo`040000003oool0
oooo000000P0oooo1@0000030?ooo`800000o`3ooolk0?ooo`040000003oool0oooo000000P0oooo
1@0000030?ooo`<00000o`3ooolR0?ooo`00;P3oool400000080oooo00@000000?ooo`3oool00000
203oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo0?l0oooo=03oool400000080
oooo00@000000?ooo`3oool00000203oool010000000oooo0?ooo`0000040?ooo`030000003oool0
oooo0?l0oooo8P3oool003@0oooo00@000000?ooo`3oool000002@3oool00`000000oooo00000004
0?ooo`030000003oool0oooo0?l0oooo>P3oool010000000oooo0?ooo`0000090?ooo`030000003o
ool0000000@0oooo00<000000?ooo`3oool0o`3ooolR0?ooo`00=@3oool2000000/0oooo0P000004
0?ooo`030000003oool0oooo0?l0oooo>`3oool2000000/0oooo0P0000040?ooo`030000003oool0
oooo0?l0oooo8P3oool004P0oooo00<000000?ooo`3oool0o`3ooom>0?ooo`030000003oool0oooo
0?l0oooo8P3oool004P0oooo00<000000?ooo`3oool0o`3ooom>0?ooo`030000003oool0oooo0?l0
oooo8P3oool004P0oooo00<000000?ooo`3oool0o`3ooom>0?ooo`030000003oool0oooo0?l0oooo
8P3oool004P0oooo00<000000?ooo`3oool0o`3ooom>0?ooo`030000003oool0oooo0?l0oooo8P3o
ool004P0oooo0P00003o0?ooodl0oooo0P00003o0?ooob<0oooo00180?ooo`030000003oool0oooo
0?l0ooooCP3oool00`000000oooo0?ooo`3o0?ooob80oooo00180?ooo`030000003oool0oooo0?l0
ooooCP3oool00`000000oooo0?ooo`3o0?ooob80oooo00180?ooo`030000003oool0oooo0?l0oooo
CP3oool00`000000oooo0?ooo`3o0?ooob80oooo00180?ooo`030000003oool0oooo0?l0ooooCP3o
ool00`000000oooo0?ooo`3o0?ooob80oooo00180?ooo`030000003oool0oooo0?l0ooooCP3oool0
0`000000oooo0?ooo`3o0?ooob80oooo00180?ooo`030000003oool0oooo0?l0ooooCP3oool00`00
0000oooo0?ooo`3o0?ooob80oooo00180?ooo`030000003oool0oooo0?l0ooooCP3oool00`000000
oooo0?ooo`3o0?ooob80oooo00180?ooo`800000o`3ooom?0?ooo`800000o`3ooolS0?ooo`00B03o
ool00`000000oooo0?ooo`3o0?ooodh0oooo00<000000?ooo`3oool0o`3ooolR0?ooo`00B03oool0
0`000000oooo0?ooo`3o0?ooodh0oooo00<000000?ooo`3oool0o`3ooolR0?ooo`00B03oool00`00
0000oooo0?ooo`3o0?ooodh0oooo00<000000?ooo`3oool0o`3ooolR0?ooo`00B03oool00`000000
oooo0?ooo`3o0?ooodh0oooo00<000000?ooo`3oool0o`3ooolR0?ooo`00B03oool00`000000oooo
0?ooo`3o0?ooodh0oooo00<000000?ooo`3oool0o`3ooolR0?ooo`00B03oool00`000000oooo0?oo
o`3o0?ooodh0oooo00<000000?ooo`3oool0o`3ooolR0?ooo`00B03oool00`000000oooo0?ooo`3o
0?ooodh0oooo00<000000?ooo`3oool0o`3ooolR0?ooo`00B03oool200000?l0ooooC`3oool20000
0?l0oooo8`3oool004P0oooo00<000000?ooo`3oool0o`3ooom>0?ooo`030000003oool0oooo0?l0
oooo8P3oool004P0oooo00<000000?ooo`3oool0o`3ooom>0?ooo`030000003oool0oooo0?l0oooo
8P3oool004P0oooo00<000000?ooo`3oool0o`3ooom>0?ooo`030000003oool0oooo0?l0oooo8P3o
ool004P0oooo00<000000?ooo`3oool0o`3ooom>0?ooo`030000003oool0oooo0?l0oooo8P3oool0
04P0oooo00<000000?ooo`3oool0o`3ooom>0?ooo`030000003oool0oooo0?l0oooo8P3oool004P0
oooo00<006Ko0?ooo`3oool0o`3ooom>0?ooo`03001Vo`3oool0oooo0?l0oooo8P3oool004P0oooo
00<006Ko0000003oool0o`3ooom>0?ooo`03001Vo`000000oooo0?l0oooo8P3oool004P0oooo00<0
06Ko0?ooo`3oool0o`3ooom>0?ooo`03001Vo`3oool0oooo0?l0oooo8P3oool004P0oooo00<006Ko
0?ooo`3oool0o`3ooom>0?ooo`03001Vo`3oool0oooo0?l0oooo8P3oool004P0oooo00<006Ko0?oo
o`3oool0o`3ooom>0?ooo`03001Vo`3oool0oooo0?l0oooo8P3oool004P0oooo00<006Ko0?ooo`3o
ool0o`3ooom>0?ooo`03001Vo`3oool0oooo0?l0oooo8P3oool004P0oooo00<006Ko0?ooo`3oool0
o`3ooom>0?ooo`03001Vo`3oool0oooo0?l0oooo8P3oool003D0oooo0P0000040?ooo`800000103o
ool2000000D0oooo00<00000001Vo`3oool0o`3ooolk0?ooo`800000103oool2000000@0oooo0P00
00050?ooo`03001Vo`3oool0oooo0?l0oooo8P3oool003@0oooo00@000000?ooo`3oool00000203o
ool010000000oooo0?ooo`0000040?ooo`0300000000I_l0oooo0?l0oooo>P3oool010000000oooo
0?ooo`0000080?ooo`040000003oool0oooo000000@0oooo00<00000001Vo`3oool0o`3ooolR0?oo
o`00=03oool010000000oooo0?ooo`00000:0?ooo`030000003oool0oooo00<0oooo00<00000001V
o`3oool0o`3ooolj0?ooo`040000003oool0oooo000000X0oooo00<000000?ooo`3oool00`3oool0
0`00000006Ko0000003o0?ooob80oooo000^0?ooo`@000000P3oool010000000oooo0?ooo`00000;
0?ooo`030000003oool0oooo0080oooo00<00000001Vo`3oool0o`3ooold0?ooo`@000000P3oool0
10000000oooo0?ooo`00000;0?ooo`030000003oool0oooo0080oooo00<00000001Vo`3oool0o`3o
oolR0?ooo`00=03oool010000000oooo0?ooo`0000080?ooo`040000003oool0oooo000000@0oooo
00<00000001Vo`3oool0o`3ooolj0?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`3o
ool00000103oool00`00000006Ko0?ooo`3o0?ooob80oooo000e0?ooo`8000002P3oool2000000D0
oooo00<00000001Vo`3oool0o`3ooolk0?ooo`8000002P3oool2000000D0oooo00<00000001Vo`3o
ool0o`3ooolR0?ooo`00B03oool00`00000006Ko0?ooo`3o0?ooodh0oooo00<00000001Vo`3oool0
o`3ooolR0?ooo`00B03oool00`00000006Ko0?ooo`3o0?ooodh0oooo00<00000001Vo`3oool0o`3o
oolR0?ooo`00B03oool00`00000006Ko0?ooo`3o0?ooodh0oooo00<00000001Vo`3oool0o`3ooolR
0?ooo`00B03oool00`00000006Ko0?ooo`3o0?ooodh0oooo00<00000001Vo`3oool0o`3ooolR0?oo
o`00B03oool00`00000006Ko0?ooo`3o0?ooodh0oooo00<00000001Vo`3oool0o`3ooolR0?ooo`00
B03oool00`00000006Ko0?ooo`3o0?ooodh0oooo00<00000001Vo`3oool0o`3ooolR0?ooo`00B03o
ool00`000000oooo001Vo`3o0?ooodh0oooo00<00000001Vo`3oool0o`3ooolR0?ooo`00B03oool0
0`000000oooo001Vo`3o0?ooodh0oooo00<00000001Vo`3oool0o`3ooolR0?ooo`00B03oool00`00
0000oooo001Vo`3o0?ooodh0oooo00<00000001Vo`3oool0o`3ooolR0?ooo`00B03oool00`000000
oooo001Vo`3o0?ooodh0oooo00<000000?ooo`00I_l0o`3ooolR0?ooo`00B03oool00`000000oooo
001Vo`3o0?ooodh0oooo00<000000?ooo`00I_l0o`3ooolR0?ooo`00B03oool00`000000oooo001V
o`3o0?ooodh0oooo00<000000?ooo`00I_l0o`3ooolR0?ooo`00B03oool200000003001Vo`3oool0
oooo0?l0ooooC03oool200000003001Vo`3oool0oooo0?l0oooo803oool004P0oooo00<000000?oo
o`00I_l0o`3ooom>0?ooo`030000003oool006Ko0?l0oooo8P3oool004P0oooo00<000000?ooo`00
I_l0o`3ooom>0?ooo`030000003oool006Ko0?l0oooo8P3oool004P0oooo00<000000?ooo`00I_l0
o`3ooom>0?ooo`030000003oool006Ko0?l0oooo8P3oool004P0oooo00<000000?ooo`00I_l0o`3o
oom>0?ooo`030000003oool006Ko0?l0oooo8P3oool004P0oooo00<000000?ooo`00I_l0o`3ooom>
0?ooo`030000003oool006Ko0?l0oooo8P3oool004P0oooo00<000000?ooo`00I_l0o`3ooom>0?oo
o`030000003oool006Ko0?l0oooo8P3oool004P0oooo0P0000000`3oool006Ko0?ooo`3o0?oood`0
oooo0P0000000`00I_l0oooo0?ooo`3o0?ooob00oooo00180?ooo`040000003oool0oooo001Vool0
ooooC@3oool00`000000oooo001Vo`3o0?ooob80oooo00180?ooo`040000003oool0oooo001Vool0
ooooC@3oool00`000000oooo001Vo`3o0?ooob80oooo00180?ooo`040000003oool0oooo001Vool0
ooooC@3oool00`000000oooo001Vo`3o0?ooob80oooo00180?ooo`040000003oool0oooo001Vool0
ooooC@3oool010000000oooo0?ooo`00I_oo0?ooob40oooo00180?ooo`040000003oool0oooo001V
ool0ooooC@3oool010000000oooo0?ooo`00I_oo0?ooob40oooo00180?ooo`040000003oool0oooo
001Vool0ooooC@3oool010000000oooo0?ooo`00I_oo0?ooob40oooo00180?ooo`040000003oool0
oooo001Vool0ooooC@3oool010000000oooo0?ooo`00I_oo0?ooob40oooo00180?ooo`80000000<0
oooo001Vo`3oool0o`3ooom<0?ooo`80000000<0oooo001Vo`3oool0o`3ooolP0?ooo`00B03oool0
10000000oooo0?ooo`00I_oo0?ooodd0oooo00@000000?ooo`3oool006Koo`3ooolQ0?ooo`00B03o
ool010000000oooo0?ooo`00I_oo0?ooodd0oooo00@000000?ooo`3oool006Koo`3ooolQ0?ooo`00
B03oool010000000oooo0?ooo`00I_oo0?ooodd0oooo00@000000?ooo`3oool006Koo`3ooolQ0?oo
o`00B03oool010000000oooo0?ooo`00I_oo0?ooodd0oooo00@000000?ooo`3oool006Koo`3ooolQ
0?ooo`00B03oool01@000000oooo0?ooo`3oool006Ko0?l0ooooC03oool010000000oooo0?ooo`00
I_oo0?ooob40oooo000e0?ooo`800000103oool2000000<0oooo100000040?ooo`050000003oool0
oooo0?ooo`00I_l0o`3oooli0?ooo`800000103oool2000000<0oooo100000040?ooo`040000003o
ool0oooo001Vool0oooo8@3oool003@0oooo00@000000?ooo`3oool00000203oool00`000000oooo
0?ooo`050?ooo`050000003oool0oooo0?ooo`00I_l0C`3oool7001Von40oooo00@000000?ooo`3o
ool00000203oool00`000000oooo0?ooo`050?ooo`040000003oool0oooo001Vool0oooo8@3oool0
03@0oooo00@000000?ooo`3oool000002@3oool00`000000oooo0?ooo`040?ooo`8000000P3oool0
0`00I_l0oooo0?ooo`180?ooo`D006Ko1`3oool6001Vom/0oooo00@000000?ooo`3oool000002@3o
ool00`000000oooo0?ooo`040?ooo`<0000000<006Ko0?ooo`3oool0o`3ooolO0?ooo`00;P3oool4
00000080oooo00@000000?ooo`3oool000002P3oool00`000000oooo0?ooo`030?ooo`050000003o
ool0oooo0?ooo`00I_l0B03oool2001Voa80oooo1000I_oA0?ooo`@000000P3oool010000000oooo
0?ooo`00000:0?ooo`030000003oool0oooo00<0oooo00@000000?ooo`3oool006Koo`3ooolQ0?oo
o`00=03oool010000000oooo0?ooo`0000080?ooo`040000003oool0oooo000000@0oooo00D00000
0?ooo`3oool0oooo001Vo`150?ooo`<006Ko603oool4001Vom<0oooo00@000000?ooo`3oool00000
203oool010000000oooo0?ooo`0000040?ooo`050000003oool0oooo0?ooo`00I_l0o`3ooolP0?oo
o`00=@3oool2000000X0oooo0P0000050?ooo`050000003oool0oooo0?ooo`00I_l0@P3oool3001V
oal0oooo0P00I_oB0?ooo`8000002P3oool2000000D0oooo00D000000?ooo`3oool0oooo001Vo`3o
0?ooob00oooo00180?ooo`050000003oool0oooo0?ooo`00I_l0@03oool2001Vob@0oooo0`00I_oR
0?ooo`050000003oool0oooo0?ooo`00I_l0o`3ooolP0?ooo`00B03oool01@000000oooo0?ooo`3o
ool006Ko03d0oooo0`00I_lY0?ooo`8006Koh03oool01@000000oooo0?ooo`3oool006Ko0?l0oooo
803oool004P0oooo00D000000?ooo`3oool0oooo001Vo`0k0?ooo`8006Ko;P3oool2001Vomh0oooo
00D000000?ooo`3oool0oooo001Vo`3o0?ooob00oooo00180?ooo`050000003oool0oooo0?ooo`00
I_l0>@3oool2001Voc80oooo00<006Ko0?ooo`3oool0f`3oool01@000000oooo0?ooo`3oool006Ko
0?l0oooo803oool004P0oooo0P0000020?ooo`03001Vo`3oool0oooo03D0oooo0P00I_le0?ooo`80
06Kof`3oool200000080oooo00<006Ko0?ooo`3oool0o`3ooolN0?ooo`00B03oool00`000000oooo
0?ooo`020?ooo`03001Vo`3oool0oooo0380oooo0P00I_li0?ooo`8006Kof@3oool01@000000oooo
0?ooo`3oool006Ko0?l0oooo803oool004P0oooo00<000000?ooo`3oool00P3oool00`00I_l0oooo
0?ooo`0`0?ooo`8006Ko?@3oool00`00I_l0oooo0?ooo`3F0?ooo`050000003oool0oooo0?ooo`00
I_l0o`3ooolP0?ooo`00B03oool00`000000oooo0?ooo`020?ooo`03001Vo`3oool0oooo02h0oooo
0P00I_m00?ooo`8006KoeP3oool01@000000oooo0?ooo`3oool006Ko0?l0oooo803oool004P0oooo
00<000000?ooo`3oool00P3oool00`00I_l0oooo0?ooo`0]0?ooo`03001Vo`3oool0oooo0480oooo
00<006Ko0?ooo`3oool0d`3oool01@000000oooo0?ooo`3oool006Ko0?l0oooo803oool004P0oooo
00<000000?ooo`3oool00P3oool00`00I_l0oooo0?ooo`0[0?ooo`8006KoAP3oool2001Vom<0oooo
00D000000?ooo`3oool0oooo001Vo`3o0?ooob00oooo00180?ooo`030000003oool0oooo0080oooo
00<006Ko0?ooo`3oool0:@3oool2001VodX0oooo0P00I_oA0?ooo`050000003oool0oooo0?ooo`00
I_l0o`3ooolP0?ooo`00B03oool2000000<0oooo00<006Ko0?ooo`3oool0:03oool00`00I_l0oooo
0?ooo`1<0?ooo`03001Vo`3oool0oooo0<h0oooo0P0000020?ooo`03001Vo`3oool0oooo0?l0oooo
7P3oool004P0oooo00<000000?ooo`3oool00P3oool00`00I_l0oooo0?ooo`0W0?ooo`03001Vo`3o
ool0oooo04h0oooo00<006Ko0?ooo`3oool0c@3oool00`000000oooo0?ooo`020?ooo`03001Vo`3o
ool0oooo0?l0oooo7@3oool004P0oooo00<000000?ooo`3oool00P3oool00`00I_l0oooo0?ooo`0U
0?ooo`8006KoDP3oool00`00I_l0oooo0?ooo`3<0?ooo`030000003oool0oooo0080oooo00<006Ko
0?ooo`3oool0o`3ooolM0?ooo`00B03oool00`000000oooo0?ooo`020?ooo`03001Vo`3oool0oooo
02@0oooo00<006Ko0?ooo`3oool0D`3oool00`00I_l0oooo0?ooo`3;0?ooo`030000003oool0oooo
0080oooo00<006Ko0?ooo`3oool0o`3ooolM0?ooo`00B03oool00`000000oooo0?ooo`020?ooo`03
001Vo`3oool0oooo02<0oooo00<006Ko0?ooo`3oool0E@3oool2001Vol/0oooo00<000000?ooo`3o
ool00P3oool00`00I_l0oooo0?ooo`3o0?oooad0oooo00180?ooo`030000003oool0oooo0080oooo
00<006Ko0?ooo`3oool08@3oool2001VoeX0oooo00<006Ko0?ooo`3oool0b03oool00`000000oooo
0?ooo`020?ooo`03001Vo`3oool0oooo0?l0oooo7@3oool004P0oooo00<000000?ooo`3oool00P3o
ool00`00I_l0oooo0?ooo`0P0?ooo`03001Vo`3oool0oooo05/0oooo00<006Ko0?ooo`3oool0a`3o
ool00`000000oooo0?ooo`020?ooo`03001Vo`3oool0oooo0?l0oooo7@3oool004P0oooo00<00000
0?ooo`3oool00`3oool00`00I_l0oooo0?ooo`0N0?ooo`03001Vo`3oool0oooo05d0oooo00<006Ko
0?ooo`3oool0aP3oool00`000000oooo0?ooo`020?ooo`03001Vo`3oool0oooo0?l0oooo7@3oool0
04P0oooo0P0000040?ooo`03001Vo`3oool0oooo01d0oooo00<006Ko0?ooo`3oool0G`3oool00`00
I_l0oooo0?ooo`350?ooo`8000000`3oool00`00I_l0oooo0?ooo`3o0?oooad0oooo00180?ooo`03
0000003oool0oooo00<0oooo00<006Ko0?ooo`3oool0703oool00`00I_l0oooo0?ooo`1Q0?ooo`80
06Koa@3oool00`000000oooo0?ooo`020?ooo`03001Vo`3oool0oooo0?l0oooo7@3oool004P0oooo
00<000000?ooo`3oool00`3oool00`00I_l0oooo0?ooo`0J0?ooo`8006KoIP3oool00`00I_l0oooo
0?ooo`320?ooo`030000003oool0oooo0080oooo00<006Ko0?ooo`3oool0o`3ooolM0?ooo`00B03o
ool00`000000oooo0?ooo`030?ooo`03001Vo`3oool0oooo01T0oooo00<006Ko0?ooo`3oool0I`3o
ool00`00I_l0oooo0?ooo`310?ooo`030000003oool0oooo0080oooo00<006Ko0?ooo`3oool0o`3o
oolM0?ooo`00B03oool00`000000oooo0?ooo`030?ooo`03001Vo`3oool0oooo01P0oooo00<006Ko
0?ooo`3oool0J@3oool2001Vol40oooo00<000000?ooo`3oool00P3oool00`00I_l0oooo0?ooo`3o
0?oooad0oooo00180?ooo`030000003oool0oooo00<0oooo00<006Ko0?ooo`3oool05`3oool00`00
I_l0oooo0?ooo`1/0?ooo`03001Vo`3oool0oooo0;h0oooo00<000000?ooo`3oool00P3oool00`00
I_l0oooo0?ooo`3o0?oooad0oooo00180?ooo`030000003oool0oooo00<0oooo00<006Ko0?ooo`3o
ool05P3oool00`00I_l0oooo0?ooo`1^0?ooo`03001Vo`3oool0oooo0;d0oooo00<000000?ooo`3o
ool00P3oool00`00I_l0oooo0?ooo`3o0?oooad0oooo00180?ooo`030000003oool0oooo00<0oooo
00<006Ko0?ooo`3oool05@3oool00`00I_l0oooo0?ooo`1`0?ooo`03001Vo`3oool0oooo0;`0oooo
00<000000?ooo`3oool00`3oool00`00I_l0oooo0?ooo`3o0?oooa`0oooo00180?ooo`800000103o
ool00`00I_l0oooo0?ooo`0D0?ooo`03001Vo`3oool0oooo0780oooo00<006Ko0?ooo`3oool0^`3o
ool2000000@0oooo00<006Ko0?ooo`3oool0o`3ooolL0?ooo`00B03oool00`000000oooo0?ooo`03
0?ooo`03001Vo`3oool0oooo0180oooo0P00I_mf0?ooo`8006Ko^`3oool00`000000oooo0?ooo`03
0?ooo`03001Vo`3oool0oooo0?l0oooo703oool004P0oooo00<000000?ooo`3oool00`3oool00`00
I_l0oooo0?ooo`0A0?ooo`03001Vo`3oool0oooo07P0oooo00<006Ko0?ooo`3oool0^03oool00`00
0000oooo0?ooo`030?ooo`03001Vo`3oool0oooo0?l0oooo703oool004P0oooo00<000000?ooo`3o
ool00`3oool00`00I_l0oooo0?ooo`0@0?ooo`03001Vo`3oool0oooo07X0oooo00<006Ko0?ooo`3o
ool0]`3oool00`000000oooo0?ooo`030?ooo`03001Vo`3oool0oooo0?l0oooo703oool004P0oooo
00<000000?ooo`3oool0103oool00`00I_l0oooo0?ooo`0>0?ooo`03001Vo`3oool0oooo07`0oooo
00<006Ko0?ooo`3oool0]P3oool00`000000oooo0?ooo`030?ooo`03001Vo`3oool0oooo0?l0oooo
703oool004P0oooo00<000000?ooo`3oool0103oool00`00I_l0oooo0?ooo`0=0?ooo`03001Vo`3o
ool0oooo07h0oooo00<006Ko0?ooo`3oool0]@3oool00`000000oooo0?ooo`030?ooo`03001Vo`3o
ool0oooo0?l0oooo703oool003D0oooo0P0000040?ooo`8000000`3oool5000000<0oooo00<00000
0?ooo`3oool0103oool00`00I_l0oooo0?ooo`0<0?ooo`03001Vo`3oool0oooo0800oooo0P00I_nR
0?ooo`800000103oool2000000<0oooo1@0000030?ooo`030000003oool0oooo00<0oooo00<006Ko
0?ooo`3oool0o`3ooolL0?ooo`00=03oool010000000oooo0?ooo`00000:0?ooo`030000003oool0
oooo00<0oooo00<000000?ooo`3oool0103oool00`00I_l0oooo0?ooo`0;0?ooo`03001Vo`3oool0
oooo08<0oooo00<006Ko0?ooo`3oool0WP3oool010000000oooo0?ooo`00000:0?ooo`030000003o
ool0oooo00<0oooo00<000000?ooo`3oool00`3oool00`00I_l0oooo0?ooo`3o0?oooa`0oooo000d
0?ooo`040000003oool0oooo000000X0oooo00<000000?ooo`3oool00`3oool2000000D0oooo00<0
06Ko0?ooo`3oool02P3oool00`00I_l0oooo0?ooo`250?ooo`03001Vo`3oool0oooo09d0oooo00@0
00000?ooo`3oool000002P3oool00`000000oooo0?ooo`030?ooo`<000000`3oool00`00I_l0oooo
0?ooo`3o0?oooa`0oooo000^0?ooo`@000000P3oool010000000oooo0?ooo`00000:0?ooo`030000
003oool0oooo00<0oooo00<000000?ooo`3oool0103oool00`00I_l0oooo0?ooo`0:0?ooo`03001V
o`3oool0oooo08H0oooo0P00I_nG0?ooo`@000000P3oool010000000oooo0?ooo`00000:0?ooo`03
0000003oool0oooo00<0oooo00<000000?ooo`3oool00`3oool00`00I_l0oooo0?ooo`3o0?oooa`0
oooo000d0?ooo`040000003oool0oooo000000X0oooo00<000000?ooo`3oool00`3oool00`000000
oooo0?ooo`040?ooo`03001Vo`3oool0oooo00T0oooo00<006Ko0?ooo`3oool0R@3oool00`00I_l0
oooo0?ooo`2J0?ooo`040000003oool0oooo000000X0oooo00<000000?ooo`3oool00`3oool00`00
0000oooo0?ooo`030?ooo`03001Vo`3oool0oooo0?l0oooo703oool003D0oooo0P00000:0?ooo`80
00001@3oool00`000000oooo0?ooo`040?ooo`03001Vo`3oool0oooo00P0oooo00<006Ko0?ooo`3o
ool0R`3oool00`00I_l0oooo0?ooo`2J0?ooo`8000002P3oool2000000D0oooo00<000000?ooo`3o
ool00`3oool00`00I_l0oooo0?ooo`3o0?oooa`0oooo00180?ooo`030000003oool0oooo00@0oooo
00<006Ko0?ooo`3oool01`3oool00`00I_l0oooo0?ooo`2=0?ooo`8006Ko[@3oool00`000000oooo
0?ooo`030?ooo`03001Vo`3oool0oooo0?l0oooo703oool004P0oooo00<000000?ooo`3oool0103o
ool00`00I_l0oooo0?ooo`060?ooo`03001Vo`3oool0oooo0900oooo00<006Ko0?ooo`3oool0ZP3o
ool00`000000oooo0?ooo`040?ooo`03001Vo`3oool0oooo0?l0oooo6`3oool004P0oooo00<00000
0?ooo`3oool0103oool00`00I_l0oooo0?ooo`050?ooo`03001Vo`3oool0oooo0980oooo00<006Ko
0?ooo`3oool0Z@3oool00`000000oooo0?ooo`040?ooo`03001Vo`3oool0oooo0?l0oooo6`3oool0
04P0oooo0P0000050?ooo`03001Vo`3oool0oooo00@0oooo00<006Ko0?ooo`3oool0U03oool2001V
ojT0oooo0P0000050?ooo`03001Vo`3oool0oooo0?l0oooo6`3oool004P0oooo00<000000?ooo`3o
ool01@3oool00`00I_l0oooo0?ooo`020?ooo`03001Vo`3oool0oooo09L0oooo00<006Ko0?ooo`3o
ool0YP3oool00`000000oooo0?ooo`040?ooo`03001Vo`3oool0oooo0?l0oooo6`3oool004P0oooo
00<000000?ooo`3oool01@3oool01@00I_l0oooo0?ooo`3oool006Ko09/0oooo0P00I_nV0?ooo`03
0000003oool0oooo00@0oooo00<006Ko0?ooo`3oool0o`3ooolK0?ooo`00B03oool00`000000oooo
0?ooo`050?ooo`05001Vo`3oool0oooo0?ooo`00I_l0W@3oool00`00I_l0oooo0?ooo`2S0?ooo`03
0000003oool0oooo00@0oooo00<006Ko0?ooo`3oool0o`3ooolK0?ooo`00B03oool00`000000oooo
0?ooo`050?ooo`04001Vo`3oool0oooo001Voil0oooo0P00I_nS0?ooo`030000003oool0oooo00@0
oooo00<006Ko0?ooo`3oool0o`3ooolK0?ooo`00B03oool00`000000oooo0?ooo`050?ooo`03001V
o`3oool006Ko0:80oooo0P00I_nQ0?ooo`030000003oool0oooo00@0oooo00<006Ko0?ooo`3oool0
o`3ooolK0?ooo`00B03oool00`000000oooo0?ooo`050?ooo`8006KoY@3oool00`00I_l0oooo0?oo
o`2N0?ooo`030000003oool0oooo00@0oooo00<006Ko0?ooo`3oool0o`3ooolK0?ooo`00B03oool0
0`000000oooo0?ooo`050?ooo`03001Vo`3oool0oooo0:D0oooo0P00I_nN0?ooo`030000003oool0
oooo00@0oooo00<006Ko0?ooo`3oool0o`3ooolK0?ooo`00B03oool200000;00oooo00<006Ko0?oo
o`3oool0V`3oool2000000D0oooo00<006Ko0?ooo`3oool0o`3ooolK0?ooo`00B03oool00`000000
oooo0?ooo`2`0?ooo`8006KoV`3oool00`000000oooo0?ooo`040?ooo`03001Vo`3oool0oooo0?l0
oooo6`3oool004P0oooo00<000000?ooo`3oool0/P3oool2001VoiT0oooo00<000000?ooo`3oool0
103oool00`00I_l0oooo0?ooo`3o0?oooa/0oooo00180?ooo`030000003oool0oooo0;@0oooo0P00
I_nG0?ooo`030000003oool0oooo00@0oooo00<006Ko0?ooo`3oool0o`3ooolK0?ooo`00B03oool0
0`000000oooo0?ooo`2f0?ooo`8006KoU@3oool00`000000oooo0?ooo`050?ooo`03001Vo`3oool0
oooo0?l0oooo6P3oool004P0oooo00<000000?ooo`3oool0^03oool3001Voi80oooo00<000000?oo
o`3oool01@3oool00`00I_l0oooo0?ooo`3o0?oooaX0oooo00180?ooo`030000003oool0oooo0;/0
oooo0`00I_n?0?ooo`030000003oool0oooo00D0oooo00<006Ko0?ooo`3oool0o`3ooolJ0?ooo`00
B03oool00`000000oooo0?ooo`2n0?ooo`8006KoS@3oool00`000000oooo0?ooo`050?ooo`03001V
o`3oool0oooo0?l0oooo6P3oool004P0oooo0P0000310?ooo`<006KoRP3oool2000000H0oooo00<0
06Ko0?ooo`3oool0o`3ooolJ0?ooo`00B03oool00`000000oooo0?ooo`330?ooo`<006KoQ`3oool0
0`000000oooo0?ooo`050?ooo`03001Vo`3oool0oooo0?l0oooo6P3oool004P0oooo00<000000?oo
o`3oool0aP3oool2001VohD0oooo00<000000?ooo`3oool01@3oool00`00I_l0oooo0?ooo`3o0?oo
oaX0oooo00180?ooo`030000003oool0oooo0<P0oooo0`00I_n20?ooo`030000003oool0oooo00D0
oooo00<006Ko0?ooo`3oool0o`3ooolJ0?ooo`00B03oool00`000000oooo0?ooo`0T0?ooo`800000
8P3oool500000080oooo0P00000N0?ooo`D000000P3oool2000001l0oooo100000030?ooo`800000
7`3oool4000000<0oooo0P0000030?ooo`<006Ko6P3oool2000000@0oooo0P00001M0?ooo`030000
003oool0oooo00H0oooo0P00I_lL0?ooo`8000008P3oool500000080oooo0P00000O0?ooo`D00000
0P3oool2000001h0oooo100000030?ooo`8000007`3oool4000000<0oooo0P00000P0?ooo`800000
103oool200000340oooo00180?ooo`030000003oool0oooo02<0oooo00@000000?ooo`3oool00000
8`3oool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool07@3oool01@000000
oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool0703oool00`000000oooo0?ooo`030?oo
o`040000003oool0oooo000001h0oooo00<000000?ooo`3oool00`3oool010000000oooo0?ooo`00
00050?ooo`@006Ko5@3oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo000005`0
oooo00<000000?ooo`3oool0203oool2001VoaT0oooo00@000000?ooo`3oool000008`3oool01@00
0000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool07P3oool01@000000oooo0?ooo`3o
ool000000080oooo00<000000?ooo`3oool06`3oool00`000000oooo0?ooo`030?ooo`040000003o
ool0oooo000001h0oooo00<000000?ooo`3oool00`3oool010000000oooo0?ooo`00000N0?ooo`04
0000003oool0oooo00000080oooo00@000000?ooo`3oool00000<03oool004P0oooo00<000000?oo
o`3oool09P3oool00`000000oooo0?ooo`0Q0?ooo`050000003oool0oooo0?ooo`0000000P3oool0
0`000000oooo0?ooo`0M0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool07@3oool0
0`000000oooo0?ooo`020?ooo`040000003oool0oooo000001l0oooo00<000000?ooo`3oool01@3o
ool00`000000oooo0?ooo`070?ooo`@006Ko4`3oool01@000000oooo0?ooo`3oool000000080oooo
00<000000?ooo`3oool0FP3oool00`000000oooo0?ooo`0:0?ooo`8006Ko6P3oool00`000000oooo
0?ooo`0Q0?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`0N0?ooo`03
0000003oool0oooo00@0oooo00<000000?ooo`3oool0703oool00`000000oooo0?ooo`020?ooo`04
0000003oool0oooo000001l0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0N0?oo
o`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`0^0?ooo`00B03oool00`00
0000oooo0?ooo`0T0?ooo`800000903oool01@000000oooo0?ooo`3oool000000080oooo00<00000
0?ooo`3oool07@3oool00`000000oooo0?ooo`020?ooo`8000008@3oool01@000000oooo0?ooo`3o
ool000000080oooo00<000000?ooo`3oool07P3oool00`000000oooo0?ooo`020?ooo`8000003P3o
ool4001Voa00oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`1J0?ooo`030000
003oool0oooo00`0oooo0`00I_lE0?ooo`800000903oool01@000000oooo0?ooo`3oool000000080
oooo00<000000?ooo`3oool07P3oool00`000000oooo0?ooo`020?ooo`800000803oool01@000000
oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool07P3oool00`000000oooo0?ooo`020?oo
o`8000008P3oool010000000oooo0?ooo`0000020?ooo`030000003oool0oooo02h0oooo00180?oo
o`8000009@3oool00`000000oooo0?ooo`0S0?ooo`050000003oool0oooo0?ooo`0000000P3oool0
0`000000oooo0?ooo`0M0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool07P3oool0
10000000oooo0?ooo`0000020?ooo`040000003oool0oooo000001h0oooo00@000000?ooo`3oool0
00000`3oool00`000000oooo0?ooo`0A0?ooo`H006Ko1`3oool010000000oooo0?ooo`0000020?oo
o`040000003oool0oooo000005`0oooo0P00000@0?ooo`8006Ko4`3oool00`000000oooo0?ooo`0S
0?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`0N0?ooo`030000003o
ool0oooo0080oooo00<000000?ooo`3oool07@3oool010000000oooo0?ooo`0000020?ooo`040000
003oool0oooo000001h0oooo00@000000?ooo`3oool000000`3oool00`000000oooo0?ooo`0N0?oo
o`040000003oool0oooo00000080oooo00@000000?ooo`3oool00000<03oool004P0oooo00<00000
0?ooo`3oool0903oool300000280oooo0P0000040?ooo`8000007`3oool2000000@0oooo0`00000O
0?ooo`800000103oool200000200oooo0P0000040?ooo`<000005`3oool6001Vo`80oooo0P000004
0?ooo`800000G@3oool00`000000oooo0?ooo`0A0?ooo`<006Ko403oool300000280oooo0P000004
0?ooo`800000803oool2000000@0oooo0`00000N0?ooo`800000103oool200000200oooo0P000004
0?ooo`<000007`3oool2000000@0oooo0P00000a0?ooo`00B03oool00`000000oooo0?ooo`3V0?oo
o`@006KoH`3oool00`000000oooo0?ooo`0D0?ooo`<006Koo`3oool;0?ooo`00B03oool00`000000
oooo0?ooo`3Z0?ooo`<006KoH03oool00`000000oooo0?ooo`0G0?ooo`@006Koo`3oool70?ooo`00
B03oool00`000000oooo0?ooo`3o0?ooodh0oooo00<000000?ooo`3oool06`3oool4001Vool0oooo
0`3oool004P0oooo00<000000?ooo`3oool0o`3ooom>0?ooo`030000003oool0oooo01l0oooo1000
I_on0?ooo`00B03oool00`000000oooo0?ooo`3o0?ooodh0oooo00<000000?ooo`3oool08`3oool>
001Voo00oooo00120?oooo`00000E03ooolj00000;`006Ko1P00000^0?ooo`00D03oool00`000000
oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool01@3oool00`000000
oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool01@3oool00`000000
oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool01@3oool00`000000
oooo0?ooo`040?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool01@3oool00`000000
oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool01@3oool00`000000
oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool01@3oool00`000000
oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool01@3oool00`000000
oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool01@3oool00`000000
oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool01@3oool00`000000
oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0IP3oool00`000000
oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool01@3oool00`000000
oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool01@3oool00`000000
oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool01@3oool00`000000
oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool01@3oool00`000000
oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool01@3oool00`000000
oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool01@3oool00`000000
oooo0?ooo`040?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool01@3oool00`000000
oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool01@3oool00`000000
oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool01@3oool00`000000
oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0<P3oool00700oooo
00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`0T0?ooo`030000003oool0oooo02D0oooo
00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo08H0oooo
00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo02@0oooo
00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo0380oooo
003o0?ooool0oooo_P3oool00?l0ooooo`3ooonn0?ooo`00o`3ooooo0?oookh0oooo002o0?ooo`<0
0000o`3ooom?0?ooo`<00000Z@3oool00<00oooo00<000000?ooo`3oool0o`3ooom?0?ooo`030000
003oool0oooo0:P0oooo002_0?ooo`800000103oool400000080oooo0P0000030?ooo`<00000103o
ool400000080oooo0P00003o0?oooc80oooo0P0000040?ooo`@000000P3oool2000000<0oooo0`00
00040?ooo`@000000P3oool2000009`0oooo002^0?ooo`040000003oool0oooo00000080oooo00@0
00000?ooo`3oool000000P3oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo0000
0080oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`00003o0?oooc00oooo00@0
00000?ooo`3oool000000P3oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo0000
0080oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000020?ooo`040000003o
ool0oooo000009/0oooo002^0?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool0
00000P3oool00`000000oooo0?ooo`030?ooo`040000003oool0oooo00000080oooo00@000000?oo
o`3oool000000P3oool00`000000oooo0?ooo`3o0?oooc40oooo00@000000?ooo`3oool000000P3o
ool010000000oooo0?ooo`0000020?ooo`030000003oool0oooo00<0oooo00@000000?ooo`3oool0
00000P3oool010000000oooo0?ooo`0000020?ooo`030000003oool0oooo09`0oooo002^0?ooo`05
0000003oool0oooo0000003oool00P000000103oool000000000003oool5000000030?ooo`000000
0000008000000P3oool2000000040?ooo`00000000000?ooo`D00000o`3oool`0?ooo`050000003o
ool0oooo0000003oool00P000000103oool000000000003oool5000000030?ooo`00000000000080
00000P3oool2000000040?ooo`00000000000?ooo`D00000V`3oool00:h0oooo00@000000?ooo`3o
ool00000203oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo0?l0oooo<@3oool01000
0000oooo0?ooo`0000080?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool0W03oool0
0:l0oooo0P00003o0?oooe00oooo0P00002j0?ooo`00o`3ooooo0?oookh0oooo003o0?ooool0oooo
_P3oool00?l0ooooo`3ooonn0?ooo`00o`3ooooo0?oookh0oooo003o0?ooool0oooo_P3oool00?l0
ooooo`3ooonn0?ooo`00o`3ooooo0?oookh0oooo003o0?ooool0oooo_P3oool00?l0ooooo`3ooonn
0?ooo`00o`3ooooo0?oookh0oooo003o0?ooool0oooo_P3oool00?l0ooooo`3ooonn0?ooo`00o`3o
oooo0?oookh0oooo003o0?ooool0oooo_P3oool00?l0ooooo`3ooonn0?ooo`00o`3ooooo0?oookh0
oooo003o0?ooool0oooo_P3oool00?l0ooooo`3ooonn0?ooo`00o`3ooooo0?oookh0oooo003o0?oo
ool0oooo_P3oool00?l0ooooo`3ooonn0?ooo`00o`3ooooo0?oookh0oooo003o0?ooool0oooo_P3o
ool00?l0ooooo`3ooonn0?ooo`00o`3ooooo0?oookh0oooo003o0?ooool0oooo_P3oool00?l0oooo
o`3ooonn0?ooo`00o`3ooooo0?oookh0oooo003o0?ooool0oooo_P3oool00?l0ooooo`3ooonn0?oo
o`00o`3ooooo0?oookh0oooo003o0?ooool0oooo_P3oool00?l0ooooo`3ooonn0?ooo`00o`3ooooo
0?oookh0oooo003o0?ooool0oooo_P3oool00?l0ooooo`3ooonn0?ooo`00o`3ooooo0?oookh0oooo
003o0?ooool0oooo_P3oool00?l0ooooo`3ooonn0?ooo`00o`3ooooo0?oookh0oooo003o0?ooool0
oooo_P3oool00?l0ooooo`3ooonn0?ooo`00o`3ooooo0?oookh0oooo003o0?ooool0oooo_P3oool0
0?l0ooooo`3ooonn0?ooo`00o`3ooooo0?oookh0oooo003o0?ooool0oooo_P3oool00?l0ooooo`3o
oonn0?ooo`00o`3ooooo0?oookh0oooo003o0?ooool0oooo_P3oool00?l0ooooo`3ooonn0?ooo`00
o`3ooooo0?oookh0oooo003o0?ooool0oooo_P3oool00?l0ooooo`3ooonn0?ooo`00o`3ooooo0?oo
okh0oooo003o0?ooool0oooo_P3oool006l0oooo0P00000P0?ooo`D000000P3oool2000001d0oooo
1@0000020?ooo`8000007@3oool4000000<0oooo0P00000M0?ooo`@000000`3oool2000001h0oooo
0P0000040?ooo`800000SP3oool200000200oooo1@0000020?ooo`8000007@3oool500000080oooo
0P00000M0?ooo`@000000`3oool2000001`0oooo100000030?ooo`8000007P3oool2000000@0oooo
0P00000j0?ooo`00KP3oool010000000oooo0?ooo`00000Q0?ooo`050000003oool0oooo0?ooo`00
00000P3oool00`000000oooo0?ooo`0L0?ooo`050000003oool0oooo0?ooo`0000000P3oool00`00
0000oooo0?ooo`0J0?ooo`030000003oool0oooo00<0oooo00@000000?ooo`3oool00000703oool0
0`000000oooo0?ooo`030?ooo`040000003oool0oooo000001`0oooo00@000000?ooo`3oool00000
0P3oool010000000oooo0?ooo`00002<0?ooo`040000003oool0oooo00000240oooo00D000000?oo
o`3oool0oooo000000020?ooo`030000003oool0oooo01`0oooo00D000000?ooo`3oool0oooo0000
00020?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool00`3oool010000000oooo0?oo
o`00000K0?ooo`030000003oool0oooo00<0oooo00@000000?ooo`3oool00000703oool010000000
oooo0?ooo`0000020?ooo`040000003oool0oooo000003T0oooo001a0?ooo`030000003oool0oooo
01l0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo01`0oooo00<00000
0?ooo`3oool0103oool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo0080oooo00@00000
0?ooo`3oool000007@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo01`0oooo00D0
00000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo08d0oooo00<000000?ooo`3oool0
7`3oool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool0703oool00`000000
oooo0?ooo`040?ooo`030000003oool0oooo01/0oooo00<000000?ooo`3oool00P3oool010000000
oooo0?ooo`00000L0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0703oool01@00
0000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool0=`3oool006l0oooo0P00000R0?oo
o`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`0L0?ooo`030000003oool0
oooo0080oooo0P00000O0?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?oo
o`0L0?ooo`030000003oool0oooo0080oooo0P00000P0?ooo`040000003oool0oooo00000080oooo
00<000000?ooo`3oool0R`3oool200000280oooo00D000000?ooo`3oool0oooo000000020?ooo`03
0000003oool0oooo01`0oooo00<000000?ooo`3oool00P3oool2000001l0oooo00D000000?ooo`3o
ool0oooo000000020?ooo`030000003oool0oooo01/0oooo00<000000?ooo`3oool00P3oool20000
0200oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`0g0?ooo`00K`3oool00`00
0000oooo0?ooo`0Q0?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`0L
0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0703oool010000000oooo0?ooo`00
00020?ooo`040000003oool0oooo000001`0oooo00@000000?ooo`3oool000000`3oool00`000000
oooo0?ooo`0L0?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool00000S@3oool0
0`000000oooo0?ooo`0Q0?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?oo
o`0L0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0703oool010000000oooo0?oo
o`0000020?ooo`040000003oool0oooo000001/0oooo00@000000?ooo`3oool000000`3oool00`00
0000oooo0?ooo`0L0?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool00000>@3o
ool006l0oooo0`00000P0?ooo`800000103oool2000001h0oooo0P0000040?ooo`<000007@3oool2
000000@0oooo0P00000N0?ooo`800000103oool3000001d0oooo0P0000040?ooo`800000SP3oool3
00000200oooo0P0000040?ooo`8000007P3oool2000000@0oooo0`00000M0?ooo`800000103oool2
000001d0oooo0P0000040?ooo`<000007@3oool2000000@0oooo0P00000j0?ooo`00o`3ooooo0?oo
okh0oooo003o0?ooool0oooo_P3oool00?l0ooooo`3ooonn0?ooo`00o`3ooooo0?oookh0oooo003o
0?ooool0oooo_P3oool004D0ooool000001P0?ooocP00000/P00I_l6000003L0oooo001;0?ooo`03
0000003oool0oooo00@0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`040?ooo`03
0000003oool0oooo00D0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo00D0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo00@0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo00@0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`040?ooo`03
0000003oool0oooo00D0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo00D0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo00@0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo00@0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`040?ooo`03
0000003oool0oooo00D0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo06X0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo00D0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`050?ooo`04
0000003oool0oooo0?ooo`P006Ko0`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo
00D0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo
00D0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo
00D0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo
00@0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo
00@0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo
00D0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo
00D0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo
00@0oooo00<000000?ooo`3oool0>`3oool004/0oooo00<000000?ooo`3oool0o`3ooom>0?ooo`03
0000003oool0oooo0280oooo1@00I_og0?ooo`00B`3oool00`000000oooo0?ooo`3o0?ooodh0oooo
00<000000?ooo`3oool07P3oool4001Voo`0oooo001;0?ooo`030000003oool0oooo0?l0ooooCP3o
ool00`000000oooo0?ooo`0J0?ooo`@006Koo`3oool10?ooo`00B`3oool00`000000oooo0?ooo`3o
0?ooodh0oooo0P00000G0?ooo`@006Koo`3oool50?ooo`00B`3oool00`000000oooo0?ooo`3M0?oo
o`@006KoK03oool00`000000oooo0?ooo`0D0?ooo`8006Koo`3oool90?ooo`00B`3oool00`000000
oooo0?ooo`3G0?ooo`H006KoL03oool00`000000oooo0?ooo`0B0?ooo`8006Koo`3oool;0?ooo`00
B`3oool00`000000oooo0?ooo`3C0?ooo`@006KoMP3oool00`000000oooo0?ooo`0@0?ooo`8006Ko
o`3oool=0?ooo`00B`3oool00`000000oooo0?ooo`3@0?ooo`<006KoNP3oool00`000000oooo0?oo
o`0>0?ooo`8006Koo`3oool?0?ooo`00B`3oool00`000000oooo0?ooo`3<0?ooo`@006KoO@3oool2
000000d0oooo0P00I_oo0?oooa40oooo001;0?ooo`030000003oool0oooo0<P0oooo1000I_n10?oo
o`030000003oool0oooo00X0oooo0P00I_oo0?oooa<0oooo001;0?ooo`030000003oool0oooo0<H0
oooo0P00I_n50?ooo`030000003oool0oooo00T0oooo00<006Ko0?ooo`3oool0o`3ooolC0?ooo`00
B`3oool00`000000oooo0?ooo`340?ooo`8006KoQ`3oool00`000000oooo0?ooo`070?ooo`8006Ko
o`3ooolF0?ooo`00B`3oool00`000000oooo0?ooo`310?ooo`<006KoR@3oool00`000000oooo0?oo
o`050?ooo`8006Koo`3ooolH0?ooo`00B`3oool00`000000oooo0?ooo`2o0?ooo`8006KoS03oool2
00000080oooo1000I_oo0?oooaX0oooo001;0?ooo`03001Vo`3oool0oooo0;`0oooo0`00I_n>0?oo
o`@006Koo`3ooolN0?ooo`00B`3oool00`00I_l0oooo0?ooo`2j0?ooo`8006KoT@3oool00`000000
oooo0?ooo`3o0?oooal0oooo001;0?ooo`0300000000I_l0oooo0;P0oooo0P00I_nC0?ooo`030000
003oool0oooo0?l0oooo7`3oool004/0oooo00<00000001Vo`3oool0]P3oool2001VoiD0oooo0P00
003o0?ooob00oooo001;0?ooo`030000003oool006Ko0;@0oooo0P00I_nG0?ooo`030000003oool0
oooo0?l0oooo7`3oool004/0oooo00<000000?ooo`00I_l0/`3oool00`00I_l0oooo0?ooo`2G0?oo
o`030000003oool0oooo0?l0oooo7`3oool003P0oooo0P0000040?ooo`800000103oool2000000D0
oooo00@000000?ooo`3oool006Ko/03oool2001VohL0oooo0P0000040?ooo`800000103oool20000
00D0oooo00<000000?ooo`3oool0o`3ooolO0?ooo`00=`3oool010000000oooo0?ooo`0000080?oo
o`040000003oool0oooo000000@0oooo00@000000?ooo`3oool006Ko[`3oool00`00I_l0oooo0?oo
o`260?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`3oool00000103oool00`000000
oooo0?ooo`3o0?oooal0oooo000g0?ooo`040000003oool0oooo000000/0oooo00<000000?ooo`3o
ool00P3oool200000080oooo00<006Ko0?ooo`3oool0ZP3oool2001VohT0oooo00@000000?ooo`3o
ool000002`3oool00`000000oooo0?ooo`020?ooo`800000o`3ooolP0?ooo`00=`3oool010000000
oooo0?ooo`0000090?ooo`8000001@3oool01@000000oooo0?ooo`3oool006Ko0:X0oooo0P00I_n;
0?ooo`040000003oool0oooo000000T0oooo0P0000050?ooo`030000003oool0oooo0?l0oooo7`3o
ool003L0oooo00@000000?ooo`3oool000002@3oool00`000000oooo0?ooo`040?ooo`030000003o
ool0oooo0080oooo00<006Ko0?ooo`3oool0YP3oool00`00I_l0oooo0?ooo`2;0?ooo`040000003o
ool0oooo000000T0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`3o0?oooal0oooo
000h0?ooo`8000002P3oool3000000@0oooo00<000000?ooo`3oool00P3oool00`00I_l0oooo0?oo
o`2U0?ooo`03001Vo`3oool0oooo08d0oooo0P00000:0?ooo`<00000103oool00`000000oooo0?oo
o`3o0?oooal0oooo001;0?ooo`030000003oool0oooo00<0oooo00<006Ko0?ooo`3oool0XP3oool2
001Voj<0oooo00<000000?ooo`3oool0o`3ooolO0?ooo`00B`3oool00`000000oooo0?ooo`030?oo
o`03001Vo`3oool0oooo0:40oooo00<006Ko0?ooo`3oool0X`3oool200000?l0oooo803oool004/0
oooo00<000000?ooo`3oool0103oool00`00I_l0oooo0?ooo`2O0?ooo`03001Vo`3oool0oooo0:@0
oooo00<000000?ooo`3oool0o`3ooolO0?ooo`00B`3oool00`000000oooo0?ooo`050?ooo`03001V
o`3oool0oooo09`0oooo0P00I_nW0?ooo`030000003oool0oooo0?l0oooo7`3oool004/0oooo00<0
00000?ooo`3oool01@3oool00`00I_l0oooo0?ooo`2K0?ooo`03001Vo`3oool0oooo0:L0oooo00<0
00000?ooo`3oool0o`3ooolO0?ooo`00B`3oool00`000000oooo0?ooo`060?ooo`03001Vo`3oool0
oooo09T0oooo00<006Ko0?ooo`3oool0Z03oool00`000000oooo0?ooo`3o0?oooal0oooo001;0?oo
o`030000003oool0oooo00L0oooo00<006Ko0?ooo`3oool0U`3oool00`00I_l0oooo0?ooo`2Y0?oo
o`800000o`3ooolP0?ooo`00B`3oool00`000000oooo0?ooo`070?ooo`03001Vo`3oool0oooo09D0
oooo0P00I_n/0?ooo`030000003oool0oooo0?l0oooo7`3oool004/0oooo00<000000?ooo`3oool0
203oool00`00I_l0oooo0?ooo`2C0?ooo`03001Vo`3oool0oooo0:`0oooo00<000000?ooo`3oool0
o`3ooolO0?ooo`00B`3oool00`000000oooo0?ooo`090?ooo`03001Vo`3oool0oooo0940oooo00<0
06Ko0?ooo`3oool0[@3oool00`000000oooo0?ooo`3o0?oooal0oooo001;0?ooo`030000003oool0
oooo00T0oooo00<006Ko0?ooo`3oool0T03oool00`00I_l0oooo0?ooo`2^0?ooo`030000003oool0
oooo0?l0oooo7`3oool004/0oooo00<000000?ooo`3oool02P3oool00`00I_l0oooo0?ooo`2>0?oo
o`03001Vo`3oool0oooo0:l0oooo0P00003o0?ooob00oooo001;0?ooo`030000003oool0oooo00/0
oooo00<006Ko0?ooo`3oool0S03oool00`00I_l0oooo0?ooo`2`0?ooo`030000003oool0oooo0?l0
oooo7`3oool004/0oooo00<000000?ooo`3oool02`3oool00`00I_l0oooo0?ooo`2;0?ooo`03001V
o`3oool0oooo0;40oooo00<000000?ooo`3oool0o`3ooolO0?ooo`00B`3oool00`000000oooo0?oo
o`0<0?ooo`03001Vo`3oool0oooo08T0oooo00<006Ko0?ooo`3oool0/P3oool00`000000oooo0?oo
o`3o0?oooal0oooo001;0?ooo`030000003oool0oooo00d0oooo00<006Ko0?ooo`3oool0Q`3oool0
0`00I_l0oooo0?ooo`2c0?ooo`030000003oool0oooo0?l0oooo7`3oool004/0oooo00<000000?oo
o`3oool03@3oool00`00I_l0oooo0?ooo`260?ooo`03001Vo`3oool0oooo0;@0oooo0P00003o0?oo
ob00oooo001;0?ooo`030000003oool0oooo00h0oooo00<006Ko0?ooo`3oool0Q03oool00`00I_l0
oooo0?ooo`2e0?ooo`030000003oool0oooo0?l0oooo7`3oool004/0oooo00<000000?ooo`3oool0
3`3oool00`00I_l0oooo0?ooo`220?ooo`03001Vo`3oool0oooo0;H0oooo00<000000?ooo`3oool0
o`3ooolO0?ooo`00@`3oool5000000<0oooo00<000000?ooo`3oool03`3oool00`00I_l0oooo0?oo
o`210?ooo`03001Vo`3oool0oooo0:l0oooo1@0000030?ooo`030000003oool0oooo0?l0oooo7`3o
ool004D0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0@0?ooo`03001Vo`3oool0
oooo07l0oooo00<006Ko0?ooo`3oool0/P3oool00`000000oooo0?ooo`030?ooo`030000003oool0
oooo0?l0oooo7`3oool004D0oooo00<000000?ooo`3oool00`3oool200000140oooo00<006Ko0?oo
o`3oool0OP3oool00`00I_l0oooo0?ooo`2c0?ooo`030000003oool0oooo00<0oooo0P00003o0?oo
ob00oooo00150?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool04@3oool00`00I_l0
oooo0?ooo`1l0?ooo`03001Vo`3oool0oooo0;@0oooo00<000000?ooo`3oool00`3oool00`000000
oooo0?ooo`3o0?oooal0oooo00150?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0
4P3oool00`00I_l0oooo0?ooo`1k0?ooo`03001Vo`3oool0oooo0;@0oooo00<000000?ooo`3oool0
0`3oool00`000000oooo0?ooo`3o0?oooal0oooo00140?ooo`8000001@3oool00`000000oooo0?oo
o`0B0?ooo`03001Vo`3oool0oooo07X0oooo00<006Ko0?ooo`3oool0]03oool2000000D0oooo00<0
00000?ooo`3oool0o`3ooolO0?ooo`00B`3oool00`000000oooo0?ooo`0C0?ooo`03001Vo`3oool0
oooo07P0oooo00<006Ko0?ooo`3oool0_03oool00`000000oooo0?ooo`3o0?oooal0oooo001;0?oo
o`030000003oool0oooo01@0oooo00<006Ko0?ooo`3oool0MP3oool00`00I_l0oooo0?ooo`2m0?oo
o`800000o`3ooolP0?ooo`00B`3oool00`000000oooo0?ooo`0E0?ooo`03001Vo`3oool0oooo07@0
oooo00<006Ko0?ooo`3oool0_P3oool00`000000oooo0?ooo`3o0?oooal0oooo001;0?ooo`030000
003oool0oooo01D0oooo00<006Ko0?ooo`3oool0L`3oool00`00I_l0oooo0?ooo`2o0?ooo`030000
003oool0oooo0?l0oooo7`3oool004/0oooo00<000000?ooo`3oool05P3oool00`00I_l0oooo0?oo
o`1a0?ooo`03001Vo`3oool0oooo0<00oooo00<000000?ooo`3oool0o`3ooolO0?ooo`00B`3oool0
0`000000oooo0?ooo`0G0?ooo`03001Vo`3oool0oooo06l0oooo00<006Ko0?ooo`3oool0`@3oool0
0`000000oooo0?ooo`3o0?oooal0oooo001;0?ooo`030000003oool0oooo01P0oooo00<006Ko0?oo
o`3oool0K@3oool00`00I_l0oooo0?ooo`320?ooo`800000o`3ooolP0?ooo`00B`3oool00`000000
oooo0?ooo`0I0?ooo`03001Vo`3oool0oooo06/0oooo00<006Ko0?ooo`3oool0``3oool00`000000
oooo0?ooo`3o0?oooal0oooo001;0?ooo`030000003oool0oooo01T0oooo00<006Ko0?ooo`3oool0
JP3oool00`00I_l0oooo0?ooo`340?ooo`030000003oool0oooo0?l0oooo7`3oool004/0oooo00<0
00000?ooo`3oool06P3oool00`00I_l0oooo0?ooo`1X0?ooo`03001Vo`3oool0oooo0<D0oooo00<0
00000?ooo`3oool0o`3ooolO0?ooo`00B`3oool00`000000oooo0?ooo`0K0?ooo`03001Vo`3oool0
oooo06H0oooo00<006Ko0?ooo`3oool0aP3oool00`000000oooo0?ooo`3o0?oooal0oooo001;0?oo
o`030000003oool0oooo01`0oooo00<006Ko0?ooo`3oool0I03oool00`00I_l0oooo0?ooo`370?oo
o`800000o`3ooolP0?ooo`00B`3oool00`000000oooo0?ooo`0M0?ooo`03001Vo`3oool0oooo0680
oooo00<006Ko0?ooo`3oool0b03oool00`000000oooo0?ooo`3o0?oooal0oooo001;0?ooo`030000
003oool0oooo01h0oooo00<006Ko0?ooo`3oool0H03oool00`00I_l0oooo0?ooo`390?ooo`030000
003oool0oooo0?l0oooo7`3oool004/0oooo00<000000?ooo`3oool07P3oool00`00I_l0oooo0?oo
o`1P0?ooo`03001Vo`3oool0oooo0<T0oooo00<000000?ooo`3oool0o`3ooolO0?ooo`00B`3oool0
0`000000oooo0?ooo`0O0?ooo`03001Vo`3oool0oooo05h0oooo00<006Ko0?ooo`3oool0bP3oool0
0`000000oooo0?ooo`3o0?oooal0oooo001;0?ooo`030000003oool0oooo0200oooo00<006Ko0?oo
o`3oool0G03oool00`00I_l0oooo0?ooo`3;0?ooo`800000o`3ooolP0?ooo`00B`3oool00`000000
oooo0?ooo`0Q0?ooo`03001Vo`3oool0oooo05X0oooo00<006Ko0?ooo`3oool0c03oool00`000000
oooo0?ooo`3o0?oooal0oooo001;0?ooo`030000003oool0oooo0280oooo00<006Ko0?ooo`3oool0
F03oool00`00I_l0oooo0?ooo`3=0?ooo`030000003oool0oooo0?l0oooo7`3oool003L0oooo1@00
00020?ooo`800000103oool2000000D0oooo00<000000?ooo`3oool08`3oool00`00I_l0oooo0?oo
o`1F0?ooo`03001Vo`3oool0oooo0;X0oooo1@0000020?ooo`800000103oool2000000D0oooo00<0
00000?ooo`3oool0o`3ooolO0?ooo`00>@3oool00`000000oooo0?ooo`070?ooo`040000003oool0
oooo000000@0oooo00<000000?ooo`3oool0903oool00`00I_l0oooo0?ooo`1D0?ooo`03001Vo`3o
ool0oooo0;d0oooo00<000000?ooo`3oool01`3oool010000000oooo0?ooo`0000040?ooo`030000
003oool0oooo0?l0oooo7`3oool003T0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?oo
o`020?ooo`8000009P3oool00`00I_l0oooo0?ooo`1B0?ooo`03001Vo`3oool0oooo0;h0oooo00<0
00000?ooo`3oool02P3oool00`000000oooo0?ooo`020?ooo`800000o`3ooolP0?ooo`00>@3oool0
0`000000oooo0?ooo`080?ooo`8000001@3oool00`000000oooo0?ooo`0V0?ooo`8006KoD@3oool0
0`00I_l0oooo0?ooo`2o0?ooo`030000003oool0oooo00P0oooo0P0000050?ooo`030000003oool0
oooo0?l0oooo7`3oool003T0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`040?oo
o`030000003oool0oooo02P0oooo00<006Ko0?ooo`3oool0CP3oool00`00I_l0oooo0?ooo`2o0?oo
o`030000003oool0oooo00P0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`3o0?oo
oal0oooo000h0?ooo`8000002P3oool3000000@0oooo00<000000?ooo`3oool0:@3oool00`00I_l0
oooo0?ooo`1<0?ooo`03001Vo`3oool0oooo0;l0oooo0P00000:0?ooo`<00000103oool00`000000
oooo0?ooo`3o0?oooal0oooo001;0?ooo`030000003oool0oooo02X0oooo00<006Ko0?ooo`3oool0
BP3oool00`00I_l0oooo0?ooo`3C0?ooo`030000003oool0oooo0?l0oooo7`3oool004/0oooo00<0
00000?ooo`3oool0:`3oool00`00I_l0oooo0?ooo`180?ooo`03001Vo`3oool0oooo0=@0oooo0P00
003o0?ooob00oooo001;0?ooo`030000003oool0oooo02`0oooo00<006Ko0?ooo`3oool0AP3oool0
0`00I_l0oooo0?ooo`3E0?ooo`030000003oool0oooo0?l0oooo7`3oool004/0oooo00<000000?oo
o`3oool0;@3oool00`00I_l0oooo0?ooo`140?ooo`03001Vo`3oool0oooo0=H0oooo00<000000?oo
o`3oool0o`3ooolO0?ooo`00B`3oool00`000000oooo0?ooo`0^0?ooo`8006Ko@`3oool00`00I_l0
oooo0?ooo`3G0?ooo`030000003oool0oooo0?l0oooo7`3oool004/0oooo00<000000?ooo`3oool0
<03oool00`00I_l0oooo0?ooo`0n0?ooo`8006KofP3oool200000?l0oooo803oool004/0oooo00<0
00000?ooo`3oool0<@3oool00`00I_l0oooo0?ooo`0l0?ooo`03001Vo`3oool0oooo0=X0oooo00<0
00000?ooo`3oool0o`3ooolO0?ooo`00B`3oool00`000000oooo0?ooo`0b0?ooo`03001Vo`3oool0
oooo03X0oooo00<006Ko0?ooo`3oool0f`3oool00`000000oooo0?ooo`3o0?oooal0oooo001;0?oo
o`030000003oool0oooo03<0oooo0P00I_li0?ooo`03001Vo`3oool0oooo0=`0oooo00<000000?oo
o`3oool0o`3ooolO0?ooo`00B`3oool00`000000oooo0?ooo`0e0?ooo`03001Vo`3oool0oooo03D0
oooo00<006Ko0?ooo`3oool0g@3oool00`000000oooo0?ooo`3o0?oooal0oooo001;0?ooo`030000
003oool0oooo03H0oooo00<006Ko0?ooo`3oool0<`3oool00`00I_l0oooo0?ooo`3N0?ooo`800000
o`3ooolP0?ooo`00B`3oool00`000000oooo0?ooo`0g0?ooo`8006Ko<@3oool2001Von40oooo00<0
00000?ooo`3oool0o`3ooolO0?ooo`00B`3oool00`000000oooo0?ooo`0i0?ooo`03001Vo`3oool0
oooo02d0oooo00<006Ko0?ooo`3oool0h@3oool00`000000oooo0?ooo`3o0?oooal0oooo001;0?oo
o`030000003oool0oooo03X0oooo0P00I_l/0?ooo`03001Vo`3oool0oooo0>80oooo00<000000?oo
o`3oool0o`3ooolO0?ooo`00B`3oool00`000000oooo0?ooo`0l0?ooo`03001Vo`3oool0oooo02P0
oooo00<006Ko0?ooo`3oool0h`3oool00`000000oooo0?ooo`3o0?oooal0oooo001;0?ooo`030000
003oool0oooo03d0oooo0P00I_lV0?ooo`8006KoiP3oool200000?l0oooo803oool004/0oooo00<0
00000?ooo`3oool0?`3oool2001Vob80oooo0P00I_oX0?ooo`030000003oool0oooo0?l0oooo7`3o
ool004/0oooo00<000000?ooo`3oool0@@3oool2001Voah0oooo0P00I_oZ0?ooo`030000003oool0
oooo0?l0oooo7`3oool004<0oooo100000040?ooo`030000003oool0oooo04<0oooo1000I_lG0?oo
o`<006Koi03oool4000000@0oooo00<000000?ooo`3oool0o`3ooolO0?ooo`00@`3oool00`000000
oooo0?ooo`050?ooo`030000003oool0oooo04L0oooo0`00I_l@0?ooo`@006Koi`3oool00`000000
oooo0?ooo`050?ooo`030000003oool0oooo0?l0oooo7`3oool004@0oooo00<000000?ooo`3oool0
103oool2000004/0oooo1000I_l70?ooo`D006Kok03oool00`000000oooo0?ooo`040?ooo`800000
o`3ooolP0?ooo`00A@3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo04h0oooo1`00
I_ob0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0o`3ooolO0?ooo`00@`3oool0
10000000oooo0?ooo`0000040?ooo`030000003oool0oooo0?l0ooooAP3oool010000000oooo0?oo
o`0000040?ooo`030000003oool0oooo0?l0oooo7`3oool004@0oooo0P0000050?ooo`030000003o
ool0oooo0?l0ooooA`3oool2000000D0oooo00<000000?ooo`3oool0o`3ooolO0?ooo`00B`3oool0
0`000000oooo0?ooo`3o0?ooodh0oooo00<000000?ooo`3oool0o`3ooolO0?ooo`00B`3oool00`00
0000oooo0?ooo`3o0?ooodh0oooo0P00003o0?ooob00oooo001;0?ooo`030000003oool0oooo0?l0
ooooCP3oool00`000000oooo0?ooo`3o0?oooal0oooo001;0?ooo`030000003oool0oooo0?l0oooo
CP3oool00`000000oooo0?ooo`3o0?oooal0oooo001;0?ooo`030000003oool0oooo0?l0ooooCP3o
ool00`000000oooo0?ooo`3o0?oooal0oooo001;0?ooo`030000003oool0oooo0?l0ooooCP3oool0
0`000000oooo0?ooo`3o0?oooal0oooo001;0?ooo`030000003oool0oooo0?l0ooooCP3oool20000
0?l0oooo803oool004/0oooo00<000000?ooo`3oool0o`3ooom>0?ooo`030000003oool0oooo0?l0
oooo7`3oool004/0oooo00<000000?ooo`3oool0o`3ooom>0?ooo`030000003oool0oooo0?l0oooo
7`3oool004/0oooo00<000000?ooo`3oool0o`3ooom>0?ooo`030000003oool0oooo0?l0oooo7`3o
ool004/0oooo00<000000?ooo`3oool0o`3ooom>0?ooo`030000003oool0oooo0?l0oooo7`3oool0
04/0oooo00<000000?ooo`3oool0o`3ooom>0?ooo`800000o`3ooolP0?ooo`00B`3oool00`000000
oooo0?ooo`3o0?ooodh0oooo00<000000?ooo`3oool0o`3ooolO0?ooo`00B`3oool00`000000oooo
0?ooo`3o0?ooodh0oooo00<000000?ooo`3oool0o`3ooolO0?ooo`00B`3oool00`000000oooo0?oo
o`3o0?ooodh0oooo00<000000?ooo`3oool0o`3ooolO0?ooo`00B`3oool00`000000oooo0?ooo`3o
0?ooodh0oooo00<000000?ooo`3oool0o`3ooolO0?ooo`00B`3oool00`000000oooo0?ooo`3o0?oo
odh0oooo0P00003o0?ooob00oooo001;0?ooo`030000003oool0oooo0?l0ooooCP3oool00`000000
oooo0?ooo`3o0?oooal0oooo001;0?ooo`030000003oool0oooo0?l0ooooCP3oool00`000000oooo
0?ooo`3o0?oooal0oooo000g0?ooo`@000000`3oool2000000@0oooo0P0000050?ooo`030000003o
ool0oooo0?l0oooo>P3oool4000000<0oooo0P0000040?ooo`8000001@3oool00`000000oooo0?oo
o`3o0?oooal0oooo000g0?ooo`030000003oool0oooo00T0oooo00@000000?ooo`3oool00000103o
ool00`000000oooo0?ooo`3o0?ooocX0oooo00<000000?ooo`3oool02@3oool010000000oooo0?oo
o`0000040?ooo`030000003oool0oooo0?l0oooo7`3oool003P0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`020?ooo`800000o`3oooll0?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool00P3oool200000?l0oooo803oool003T0oooo00<000000?ooo`3oool0203oool2
000000D0oooo00<000000?ooo`3oool0o`3oooll0?ooo`030000003oool0oooo00P0oooo0P000005
0?ooo`030000003oool0oooo0?l0oooo7`3oool003L0oooo00@000000?ooo`3oool000002@3oool0
0`000000oooo0?ooo`040?ooo`030000003oool0oooo0?l0oooo>P3oool010000000oooo0?ooo`00
00090?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0o`3ooolO0?ooo`00>03oool2
000000X0oooo0`0000040?ooo`030000003oool0oooo0?l0oooo>`3oool2000000X0oooo0`000004
0?ooo`030000003oool0oooo0?l0oooo7`3oool004/0oooo00<000000?ooo`3oool0o`3ooom>0?oo
o`030000003oool0oooo0?l0oooo7`3oool004/0oooo00<000000?ooo`3oool0o`3ooom>0?ooo`80
0000o`3ooolP0?ooo`00B`3oool00`000000oooo0?ooo`3o0?ooodh0oooo00<000000?ooo`3oool0
o`3ooolO0?ooo`00B`3oool00`000000oooo0?ooo`3o0?ooodh0oooo00<000000?ooo`3oool0o`3o
oolO0?ooo`00B`3oool00`000000oooo0?ooo`3o0?ooodh0oooo00<000000?ooo`3oool0o`3ooolO
0?ooo`00B`3oool00`000000oooo0?ooo`3o0?ooodh0oooo00<000000?ooo`3oool0o`3ooolO0?oo
o`00B`3oool00`000000oooo0?ooo`3o0?ooodh0oooo0P00003o0?ooob00oooo001;0?ooo`030000
003oool0oooo0?l0ooooCP3oool00`000000oooo0?ooo`3o0?oooal0oooo001;0?ooo`030000003o
ool0oooo0?l0ooooCP3oool00`000000oooo0?ooo`3o0?oooal0oooo001;0?ooo`030000003oool0
oooo0?l0ooooCP3oool00`000000oooo0?ooo`3o0?oooal0oooo001;0?ooo`030000003oool0oooo
0?l0ooooCP3oool00`000000oooo0?ooo`3o0?oooal0oooo001;0?ooo`030000003oool0oooo0?l0
ooooCP3oool200000?l0oooo803oool004/0oooo00<000000?ooo`3oool0o`3ooom>0?ooo`030000
003oool0oooo0?l0oooo7`3oool004/0oooo00<000000?ooo`3oool0o`3ooom>0?ooo`030000003o
ool0oooo0?l0oooo7`3oool004/0oooo00<000000?ooo`3oool0o`3ooom>0?ooo`030000003oool0
oooo0?l0oooo7`3oool004/0oooo00<000000?ooo`3oool0o`3ooom>0?ooo`030000003oool0oooo
0?l0oooo7`3oool004/0oooo00<000000?ooo`3oool0o`3ooom>0?ooo`800000o`3ooolP0?ooo`00
B`3oool00`000000oooo0?ooo`3o0?ooodh0oooo00<000000?ooo`3oool0o`3ooolO0?ooo`00A03o
ool2000000D0oooo00<000000?ooo`3oool0o`3ooom70?ooo`8000001@3oool00`000000oooo0?oo
o`3o0?oooal0oooo00130?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`3oool0o`3o
oom60?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`3oool0o`3ooolO0?ooo`00A@3o
ool00`000000oooo0?ooo`030?ooo`800000o`3ooom90?ooo`030000003oool0oooo00<0oooo0P00
003o0?ooob00oooo00160?ooo`030000003oool0oooo0?l0ooooCP3oool00`000000oooo0?ooo`3o
0?ooob@0oooo00130?ooo`040000003oool0oooo00000?l0ooooC@3oool010000000oooo0?ooo`00
003o0?ooobH0oooo00140?ooo`800000o`3ooom?0?ooo`800000o`3ooolW0?ooo`00o`3ooooo0?oo
okh0oooo003o0?ooool0oooo_P3oool00?l0ooooo`3ooonn0?ooo`00o`3ooooo0?oookh0oooo002K
0?ooo`<00000103oool4000000<0oooo0`0000030?ooo`<000000`3oool3000000P0oooo0`000004
0?ooo`<000000`3oool2000000@0oooo0`0000020?ooo`<00000o`3ooolB0?ooo`<00000103oool4
000000<0oooo0`0000030?ooo`<000000`3oool3000000P0oooo0`0000040?ooo`<000000`3oool2
000000@0oooo0`0000020?ooo`<00000T03oool009`0oooo00<000000?ooo`3oool0103oool00`00
0000oooo0?ooo`040?ooo`050000003oool0oooo0?ooo`0000001@3oool00`000000oooo0?ooo`0:
0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0103oool2000000<0oooo00<00000
0?ooo`3oool0103oool00`000000oooo0?ooo`3o0?oooa80oooo00<000000?ooo`3oool0103oool0
0`000000oooo0?ooo`040?ooo`050000003oool0oooo0?ooo`0000001@3oool00`000000oooo0?oo
o`0:0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0103oool2000000<0oooo00<0
00000?ooo`3oool0103oool00`000000oooo0?ooo`2?0?ooo`00W03oool3000000@0oooo00<00000
0?ooo`3oool0103oool01@000000oooo0?ooo`3oool0000000D0oooo100000090?ooo`030000003o
ool0oooo0080oooo100000020?ooo`040000003oool0oooo00000080oooo100000030?ooo`030000
003oool0oooo0?l0oooo4P3oool3000000@0oooo00<000000?ooo`3oool0103oool01@000000oooo
0?ooo`3oool0000000D0oooo100000090?ooo`030000003oool0oooo0080oooo100000020?ooo`04
0000003oool0oooo00000080oooo100000030?ooo`030000003oool0oooo08l0oooo002L0?ooo`04
0000003oool0oooo00000080oooo100000030?ooo`800000103oool3000000<0oooo0P00000:0?oo
o`030000003oool0oooo00<0oooo0P0000020?ooo`8000000P3oool200000080oooo0P0000040?oo
o`030000003oool0oooo0?l0oooo4P3oool010000000oooo0?ooo`0000020?ooo`@000000`3oool2
000000@0oooo0`0000030?ooo`8000002P3oool00`000000oooo0?ooo`030?ooo`8000000P3oool2
00000080oooo0P0000020?ooo`800000103oool00`000000oooo0?ooo`2?0?ooo`00W03oool01000
0000oooo0?ooo`00000Q0?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3oool0o`3ooolB
0?ooo`040000003oool0oooo00000240oooo00<000000?ooo`3oool05@3oool00`000000oooo0?oo
o`2?0?ooo`00V`3oool4000000/0oooo00<000000?ooo`3oool04`3oool2000001H0oooo0P00003o
0?oooa<0oooo1000000;0?ooo`030000003oool0oooo01<0oooo0P00000F0?ooo`800000T@3oool0
0?l0ooooo`3ooonn0?ooo`00o`3ooooo0?oookh0oooo003o0?ooool0oooo_P3oool00?l0ooooo`3o
oonn0?ooo`00o`3ooooo0?oookh0oooo003o0?ooool0oooo_P3oool00?l0ooooo`3ooonn0?ooo`00
o`3ooooo0?oookh0oooo003o0?ooool0oooo_P3oool00?l0ooooo`3ooonn0?ooo`00o`3ooooo0?oo
okh0oooo003o0?ooool0oooo_P3oool00?l0ooooo`3ooonn0?ooo`00o`3ooooo0?oookh0oooo003o
0?ooool0oooo_P3oool00?l0ooooo`3ooonn0?ooo`00o`3ooooo0?oookh0oooo003o0?ooool0oooo
_P3oool00?l0ooooo`3ooonn0?ooo`00o`3ooooo0?oookh0oooo003o0?ooool0oooo_P3oool00?l0
ooooo`3ooonn0?ooo`00o`3ooooo0?oookh0oooo003o0?ooool0oooo_P3oool00?l0ooooo`3ooonn
0?ooo`00o`3ooooo0?oookh0oooo003o0?ooool0oooo_P3oool004H0oooo1@0000020?ooo`@00000
203oool3000000@0oooo0`0000020?ooo`@0000000<0oooo0000000000000`0000020?ooo`X00000
2@3oool3000000<0oooo0P0000030?ooo`@000000P3oool4000000<0oooo0`0000000`3oool00000
0000000300000080oooo1@0000030?ooo`80000000<0oooo0000000000000`0000030?ooo`800000
0P3oool3000000030?ooo`000000000000P0oooo0P0000030?ooo`@00000203oool300000080oooo
0`0000000`3oool00000000000020?ooo`800000103oool3000000040?ooo`00000000000?ooo`80
00001`3oool500000080oooo0`00000:0?ooo`800000103oool00`000000oooo0?ooo`030?ooo`80
0000M03oool500000080oooo100000080?ooo`<00000103oool300000080oooo100000000`3oool0
00000000000300000080oooo2P0000090?ooo`<000000`3oool2000000<0oooo100000020?ooo`@0
00000`3oool3000000030?ooo`000000000000<000000P3oool5000000<0oooo0P0000000`3oool0
000000000003000000<0oooo0P0000020?ooo`<0000000<0oooo000000000000203oool2000000<0
oooo100000080?ooo`<000000P3oool3000000030?ooo`00000000000080oooo0P0000040?ooo`<0
000000@0oooo000000000000oooo0P0000070?ooo`D000000P3oool3000000X0oooo0P0000040?oo
o`030000003oool0oooo00<0oooo0`0000190?ooo`00B03oool00`000000oooo0?ooo`030?ooo`03
0000003oool0oooo00X0oooo0P0000020?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3o
ool00`3oool00`000000oooo0?ooo`020?ooo`040000003oool0oooo000000<0oooo00<000000?oo
o`3oool0203oool00`000000oooo0?ooo`030?ooo`040000003oool0oooo000000<0oooo00<00000
0?ooo`3oool00`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00@0oooo00<00000
0?ooo`3oool00P3oool010000000oooo0?ooo`0000030?ooo`030000003oool0oooo00<0oooo00<0
00000?ooo`3oool00P3oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo000000P0
oooo00@000000?ooo`3oool000000`3oool00`000000oooo0?ooo`0:0?ooo`8000000P3oool01000
0000oooo0?ooo`0000020?ooo`040000003oool0oooo00000080oooo00<000000?ooo`3oool00`3o
ool00`000000oooo0000000:0?ooo`030000003oool0oooo00@0oooo0P0000080?ooo`040000003o
ool0oooo000000P0oooo00@000000?ooo`3oool00000M@3oool00`000000oooo0?ooo`030?ooo`03
0000003oool0oooo00X0oooo0P0000020?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3o
ool00`3oool00`000000oooo0?ooo`020?ooo`040000003oool0oooo000000<0oooo00<000000?oo
o`3oool0203oool00`000000oooo0?ooo`030?ooo`040000003oool0oooo000000<0oooo00<00000
0?ooo`3oool00`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00@0oooo00<00000
0?ooo`3oool00P3oool010000000oooo0?ooo`0000030?ooo`030000003oool0oooo00<0oooo00<0
00000?ooo`3oool00P3oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo000000P0
oooo00@000000?ooo`3oool000000`3oool00`000000oooo0?ooo`0:0?ooo`8000000P3oool01000
0000oooo0?ooo`0000020?ooo`040000003oool0oooo00000080oooo00<000000?ooo`3oool00`3o
ool00`000000oooo0000000:0?ooo`030000003oool0oooo00@0oooo0P0000080?ooo`040000003o
ool0oooo000000X0oooo00<000000?ooo`3oool0B03oool004P0oooo00<000000?ooo`3oool00`3o
ool00`000000oooo0?ooo`080?ooo`800000103oool4000000<0oooo0P0000040?ooo`030000003o
ool0oooo00<0oooo0`0000030?ooo`030000003oool0oooo00P0oooo00@000000?ooo`3oool00000
0P3oool010000000oooo0?ooo`0000030?ooo`800000103oool2000000<0oooo100000030?ooo`03
0000003oool0oooo00<0oooo0`0000030?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3o
ool00P3oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo000000P0oooo00@00000
0?ooo`3oool000000`3oool00`000000oooo0?ooo`080?ooo`800000103oool010000000oooo0?oo
o`0000020?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool000000P3oool20000
00/0oooo00<000000?ooo`3oool00P3oool2000000X0oooo00@000000?ooo`3oool00000203oool0
10000000oooo0?ooo`00001e0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0203o
ool2000000@0oooo100000030?ooo`800000103oool00`000000oooo0?ooo`030?ooo`<000000`3o
ool00`000000oooo0?ooo`080?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool0
00000`3oool2000000@0oooo0P0000030?ooo`@000000`3oool00`000000oooo0?ooo`030?ooo`<0
00000`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0080oooo00@000000?ooo`3o
ool000000P3oool010000000oooo0?ooo`0000080?ooo`040000003oool0oooo000000<0oooo00<0
00000?ooo`3oool0203oool2000000@0oooo00@000000?ooo`3oool000000P3oool010000000oooo
0?ooo`0000020?ooo`040000003oool0oooo00000080oooo0P00000;0?ooo`030000003oool0oooo
0080oooo0P00000:0?ooo`040000003oool0oooo000000L0oooo1@0000190?ooo`00B03oool00`00
0000oooo0?ooo`020?ooo`@000002@3oool3000000<0oooo0P0000030?ooo`80000000<0oooo0000
000000000`0000040?ooo`<00000103oool00`000000oooo0?ooo`090?ooo`<000000`3oool20000
00<0oooo0P000000103oool000000000003oool2000000030?ooo`00000000000080oooo0P000004
0?ooo`030000003oool0oooo0080oooo0`0000030?ooo`@0000000@0oooo00000000000000001@3o
ool200000080oooo1000000:0?ooo`8000000`3oool4000000T0oooo0`0000020?ooo`<00000103o
ool2000000@0oooo0`0000020?ooo`040000003oool00000000000L0oooo0`0000050?ooo`<00000
203oool010000000oooo0?ooo`0000090?ooo`800000MP3oool00`000000oooo0?ooo`020?ooo`@0
00002@3oool3000000<0oooo0P0000030?ooo`80000000<0oooo0000000000000`0000040?ooo`<0
0000103oool00`000000oooo0?ooo`090?ooo`<000000`3oool2000000<0oooo0P000000103oool0
00000000003oool2000000030?ooo`00000000000080oooo0P0000040?ooo`030000003oool0oooo
0080oooo0`0000030?ooo`@0000000@0oooo00000000000000001@3oool200000080oooo1000000:
0?ooo`8000000`3oool4000000T0oooo0`0000020?ooo`<00000103oool2000000@0oooo0`000002
0?ooo`040000003oool00000000000L0oooo0`0000050?ooo`<00000203oool010000000oooo0?oo
o`0000080?ooo`030000003oool0000004X0oooo00180?ooo`030000003oool0oooo00<0oooo00<0
00000?ooo`3oool09`3oool00`000000oooo0?ooo`0W0?ooo`030000003oool0oooo00T0oooo00<0
00000?ooo`3oool08@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00l0oooo00<0
00000?ooo`3oool06`3oool010000000oooo0?ooo`0000080?ooo`040000003oool0oooo000007D0
oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0W0?ooo`030000003oool0oooo02L0
oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0Q0?ooo`030000003oool0oooo00h0
oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0K0?ooo`040000003oool0oooo0000
00T0oooo0P00001:0?ooo`00AP3oool5000000@0oooo0`00000J0?ooo`030000003oool0oooo00L0
oooo0`00000W0?ooo`<000002`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo01`0
oooo0`00000<0?ooo`800000403oool2000000`0oooo00<000000?ooo`3oool03`3oool2000000X0
oooo0P00001d0?ooo`D00000103oool3000001X0oooo00<000000?ooo`3oool01`3oool3000002L0
oooo0`00000;0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0703oool3000000`0
oooo0P00000@0?ooo`800000303oool00`000000oooo0?ooo`0?0?ooo`8000002`3oool00`000000
oooo0?ooo`180?ooo`00o`3ooooo0?oookh0oooo003o0?ooool0oooo_P3oool00?l0ooooo`3ooonn
0?ooo`00o`3ooooo0?oookh0oooo003o0?ooool0oooo_P3oool00?l0ooooo`3ooonn0?ooo`00o`3o
oooo0?oookh0oooo003o0?ooool0oooo_P3oool00?l0ooooo`3ooonn0?ooo`00o`3ooooo0?oookh0
oooo003o0?ooool0oooo_P3oool00?l0ooooo`3ooonn0?ooo`00o`3ooooo0?oookh0oooo003o0?oo
ool0oooo_P3oool00?l0ooooo`3ooonn0?ooo`00o`3ooooo0?oookh0oooo003o0?ooool0oooo_P3o
ool00?l0ooooo`3ooonn0?ooo`00o`3ooooo0?oookh0oooo003o0?ooool0oooo_P3oool00?l0oooo
o`3ooonn0?ooo`00o`3ooooo0?oookh0oooo003o0?ooool0oooo_P3oool00?l0ooooo`3ooonn0?oo
o`00o`3ooooo0?oookh0oooo003o0?ooool0oooo_P3oool00?l0ooooo`3ooonn0?ooo`00o`3ooooo
0?oookh0oooo003o0?ooool0oooo_P3oool00?l0ooooo`3ooonn0?ooo`00o`3ooooo0?oookh0oooo
001h0?ooo`@00000C@3oool5000007P0oooo1@00002L0?ooo`D00000=P3oool5000002<0oooo1@00
001]0?ooo`00N`3oool2000004d0oooo0P00001k0?ooo`800000W`3oool2000003T0oooo0P00000W
0?ooo`800000KP3oool007/0oooo0P00001=0?ooo`800000N`3oool2000009l0oooo0P00000i0?oo
o`8000009`3oool2000006h0oooo001V0?ooo`D00000103oool6000000<0oooo0P0000000`3oool0
0000000000030?ooo`d000000`3oool4000000d0oooo1P0000040?ooo`8000003@3oool900000004
0?ooo`00000000000?ooo`D0000000<0oooo000000000000103oool600000080oooo100000050?oo
o`<000003`3oool400000080oooo1`00000<0?ooo`H00000203oool3000000040?ooo`0000000000
0?ooo`<0000000<0oooo0000000000002`0000001@3oool00000000000000000oooo00@000000P3o
ool6000000040?ooo`00000000000?ooo`8000003P3oool500000080oooo0`0000020?ooo`<00000
0P3oool4000000@0oooo100000020?ooo`<0000000<0oooo0000000000000P00000<0?ooo`T00000
0P3oool300000080oooo0P000000103oool000000000000000020?ooo`@000000P3oool7000000h0
oooo0`0000020?ooo`<000000P3oool300000080oooo1000000>0?ooo`@000000`3oool200000003
0?ooo`000000000000D0oooo0`0000030?ooo`T0000000@0oooo000000000000oooo0`0000000`3o
ool000000000000<000000`0oooo0P0000000`3oool00000000000040?ooo`@000000P3oool80000
00030?ooo`000000000000@000000`3oool4000000D0oooo0P00001]0?ooo`00I`3oool2000000P0
oooo0P0000040?ooo`80000000@0oooo00000000000000000P3oool200000080oooo0P0000030?oo
o`8000001@3oool2000000<0oooo00<000000?ooo`3oool02P3oool2000000P0oooo0P00000?0?oo
o`8000000`3oool2000000040?ooo`00000000000?ooo`80000000D0oooo00000000000000000?oo
o`0200000080oooo0P0000020?ooo`8000000P3oool2000000<0oooo00@000000?ooo`3oool0oooo
0P0000020?ooo`030000003oool0oooo00/0oooo0P0000020?ooo`8000000`3oool2000000h0oooo
0P0000020?ooo`8000002P3oool2000000040?ooo`00000000000?ooo`80000000<0oooo00000000
00000P3oool2000000<0oooo0P0000050?ooo`8000000P3oool200000080oooo0P0000020?ooo`80
00000P3oool3000000030?ooo`000000000000d0oooo0P0000020?ooo`8000000P3oool200000080
oooo0P0000020?ooo`8000000P3oool200000080oooo0P0000030?ooo`030000003oool0oooo0080
00000P3oool2000000`0oooo0P0000020?ooo`8000000P3oool200000080oooo0P0000020?ooo`80
000000@0oooo00000000000000000P3oool2000000<0oooo00@000000?ooo`3oool0oooo0P00000@
0?ooo`8000000P3oool00`000000oooo0?ooo`0200000080oooo0P0000020?ooo`8000000`3oool0
0`000000oooo0?ooo`0:0?ooo`8000000P3oool200000080oooo0`0000000`3oool0000000000003
0?ooo`8000000P3oool00`000000oooo0?ooo`020?ooo`8000000`3oool2000000040?ooo`000000
00000?ooo`80000000<0oooo0000000000000P3oool2000000@0oooo0P00000?0?ooo`<0000000<0
oooo0000000000000P3oool200000080oooo0P0000040?ooo`8000001P3oool2000000@0oooo0P00
00030?ooo`040000003oool0oooo0?ooo`<00000K@3oool006L0oooo0P0000080?ooo`800000103o
ool200000080oooo0P0000020?ooo`8000000P3oool2000000<0oooo0P0000050?ooo`8000004@3o
ool2000001P0oooo0P0000030?ooo`80000000@0oooo000000000000oooo0P0000000`3oool00000
000000020?ooo`8000000P3oool200000080oooo0P0000020?ooo`8000001`3oool200000100oooo
0P0000020?ooo`8000000`3oool2000000h0oooo0P0000020?ooo`8000002P3oool2000000040?oo
o`00000000000?ooo`80000000<0oooo0000000000000P3oool2000000<0oooo0P0000050?ooo`D0
00000`3oool200000080oooo0P0000020?ooo`8000000P3oool2000000l0oooo100000020?ooo`80
00000P3oool200000080oooo0P0000020?ooo`8000000P3oool2000000H0oooo1@00000=0?ooo`80
00000P3oool200000080oooo0P0000020?ooo`8000000P3oool200000080oooo0P0000020?ooo`80
00001`3oool200000100oooo0P0000050?ooo`8000000P3oool200000080oooo0P00000@0?ooo`80
00000P3oool200000080oooo0P0000020?ooo`8000000`3oool2000000L0oooo0P0000030?ooo`80
000000@0oooo000000000000oooo0P0000000`3oool00000000000020?ooo`800000103oool20000
00l0oooo0P0000020?ooo`8000000P3oool200000080oooo0P0000040?ooo`8000001P3oool20000
00@0oooo0P0000070?ooo`040000003oool00000000006`0oooo001W0?ooo`80000000<0oooo0000
003oool01@3oool2000000@0oooo0P0000020?ooo`8000000P3oool200000080oooo0P0000030?oo
o`8000001@3oool6000000h0oooo0P00000G0?ooo`8000000`3oool2000000040?ooo`0000000000
0?ooo`80000000<0oooo0000000000000P3oool2000000<0oooo1@0000020?ooo`8000000`3oool0
10000000oooo0?ooo`3oool200000100oooo0P0000020?ooo`8000000`3oool2000000l0oooo1@00
000:0?ooo`80000000@0oooo000000000000oooo0P0000020?ooo`D000000`3oool2000000D0oooo
100000040?ooo`8000000P3oool200000080oooo0P0000020?ooo`8000003@3oool4000000@0oooo
0P0000020?ooo`8000000P3oool200000080oooo0P0000020?ooo`8000000`3oool00`000000oooo
0?ooo`04000000h0oooo0P0000020?ooo`8000000P3oool200000080oooo0P0000020?ooo`800000
0P3oool200000080oooo1P0000030?ooo`800000403oool2000000D0oooo0P0000020?ooo`800000
0P3oool6000000`0oooo0P0000020?ooo`8000000P3oool200000080oooo0P0000030?ooo`800000
1`3oool2000000<0oooo0P000000103oool000000000003oool200000080oooo1@0000040?ooo`80
00003`3oool200000080oooo0P0000020?ooo`8000000P3oool2000000@0oooo0P0000060?ooo`80
0000103oool2000000<0oooo00<000000?ooo`3oool00P0000020?ooo`030000003oool0oooo06X0
oooo001W0?ooo`@000001P3oool2000000@0oooo0P000000103oool000000000000000020?ooo`80
00000P3oool2000000<0oooo0`000000103oool000000?ooo`3oool200000080oooo0P00000?0?oo
o`8000005P3oool2000000<0oooo0P000000103oool000000000003oool2000000050?ooo`000000
00000000003oool00P0000060?ooo`8000000P3oool2000000<0oooo00@000000?ooo`3oool0oooo
0P00000@0?ooo`8000000P3oool2000000<0oooo0P00000B0?ooo`8000002P3oool2000000040?oo
o`00000000000?ooo`8000001@3oool2000000<0oooo0`000000103oool000000?ooo`3oool20000
00030?ooo`000000000000<0oooo0P0000020?ooo`8000000P3oool3000000030?ooo`0000000000
00d0oooo0P0000020?ooo`8000000P3oool200000080oooo0P0000020?ooo`8000000P3oool20000
0080oooo0P0000030?ooo`030000003oool0oooo0080000000<0oooo0000000000003@3oool20000
0080oooo0P0000020?ooo`8000000P3oool200000080oooo0P000000103oool00000000000000002
0?ooo`8000000P3oool2000000<0oooo0`0000000`3oool000000?ooo`0<0?ooo`8000001@3oool2
00000080oooo0P0000020?ooo`8000000P3oool2000000`0oooo0P0000020?ooo`8000000P3oool3
000000030?ooo`000000000000<0oooo0P0000070?ooo`8000000`3oool2000000040?ooo`000000
00000?ooo`8000001@3oool2000000@0oooo0P00000?0?ooo`<0000000<0oooo0000000000000P3o
ool200000080oooo0P0000040?ooo`8000001P3oool2000000@0oooo0P0000030?ooo`030000003o
ool0oooo008000000P3oool2000006/0oooo001W0?ooo`80000000@0oooo0000003oool000000P3o
ool4000000D0oooo0P0000000`3oool0000000000004000000050?ooo`00000000000000003oool0
100000000`3oool00000000000030?ooo`@000004@3oool2000001D0oooo0P0000020?ooo`P00000
00D0oooo00000000000000000?ooo`02000000@0oooo100000040?ooo`D000000P3oool5000000l0
oooo100000020?ooo`L00000303oool4000000X0oooo200000030?ooo`@000000P3oool400000003
0?ooo`00000000000080oooo0P0000001@3oool00000000000000000oooo00<0000000D0oooo0000
0000000000000?ooo`03000000030?ooo`000000000000l0oooo1@0000020?ooo`D00000103oool4
000000@0oooo1@0000020?ooo`80000000@0oooo00000000000000002`3oool3000000050?ooo`00
000000000000003oool01P0000040?ooo`80000000<0oooo0000000000000`3oool400000080oooo
100000000`3oool000000000000<0?ooo`D000000`3oool5000000@0oooo1000000>0?ooo`@00000
0P3oool3000000030?ooo`000000000000<0oooo1@0000030?ooo`@000000P3oool8000000<0oooo
100000050?ooo`8000003P3oool3000000030?ooo`000000000000@0oooo100000050?ooo`800000
103oool4000000D0oooo1@0000000`3oool0000000000002000000040?ooo`0000000000000006X0
oooo001W0?ooo`8000000`3oool00`000000oooo0?ooo`0b0?ooo`8000000P3oool2000001D0oooo
0P00000U0?ooo`8000006@3oool2000003L0oooo0P00000Y0?ooo`8000005P3oool2000002@0oooo
0P00000M0?ooo`8000001@3oool2000002T0oooo0P00000O0?ooo`8000008@3oool2000008D0oooo
001V0?ooo`L00000103oool2000002h0oooo0P0000020?ooo`8000004`3oool6000002<0oooo0P00
000I0?ooo`800000=`3oool2000002T0oooo0P00000F0?ooo`800000903oool2000001d0oooo0P00
00050?ooo`800000:@3oool2000000L0oooo0P00000F0?ooo`8000008@3oool2000000H0oooo0P00
001m0?ooo`00L@3oool2000002l0oooo1000001I0?ooo`D00000<P3oool3000002P0oooo0`00000E
0?ooo`<000008`3oool3000002<0oooo0`00000b0?ooo`800000503oool4000001l0oooo10000006
0?ooo`800000O@3oool00?l0ooooo`3ooonn0?ooo`00o`3ooooo0?oookh0oooo003o0?ooool0oooo
_P3oool00001\
\>"],
  ImageRangeCache->{{{0, 699}, {740.625, 0}} -> {-0.088707, -0.0529857, \
0.00311504, 0.00311504}, {{28.4375, 334.188}, {723.563, 43.375}} -> \
{-0.13886, -0.115755, 0.00352353, 0.00352353}, {{39.375, 323.188}, {707.75, \
532.313}} -> {-9.88011, -0.364466, 0.131798, 0.00812393}, {{39.375, 323.188}, \
{479.75, 304.313}} -> {-9.08844, -1.08462, 0.125559, 0.00257981}, {{39.375, \
323.188}, {251.688, 76.3125}} -> {-9.89015, -10.1778, 0.131851, 0.0203181}, \
{{364.75, 670.5}, {723.563, 43.375}} -> {-1.32387, -0.115755, 0.00352353, \
0.00352353}, {{375.688, 659.5}, {707.75, 532.313}} -> {-54.2053, -0.364466, \
0.131798, 0.00812393}, {{375.688, 659.5}, {479.75, 304.313}} -> {-51.3156, \
-1.08462, 0.125559, 0.00257981}, {{375.688, 659.5}, {251.688, 76.3125}} -> \
{-54.2334, -10.1778, 0.131851, 0.0203181}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  GraphicsArray  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]]
},
FrontEndVersion->"4.2 for Microsoft Windows",
ScreenRectangle->{{0, 800}, {0, 517}},
WindowSize->{792, 483},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
PageHeaders->{{Cell[ 
        TextData[ {
          CounterBox[ "Page"]}], "PageNumber"], Inherited, Cell[ 
        TextData[ {
          ValueBox[ "FileName"]}], "Header"]}, {None, Inherited, None}},
PageHeaderLines->{Inherited, False},
PrintingOptions->{"PrintingMargins"->{{10.75, 10.75}, {72, 72}},
"PrintCellBrackets"->False,
"PrintRegistrationMarks"->False,
"PrintMultipleHorizontalPages"->False}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 536, 15, 244, "Input"],
Cell[2293, 68, 986, 17, 270, "Input"],
Cell[3282, 87, 146, 4, 30, "Input"],
Cell[3431, 93, 240, 5, 90, "Input"],
Cell[3674, 100, 241, 5, 75, "Input"],
Cell[3918, 107, 135, 4, 33, "Input"],
Cell[4056, 113, 99, 2, 30, "Input"],
Cell[4158, 117, 2587, 46, 730, "Input"],
Cell[6748, 165, 141, 4, 33, "Input"],
Cell[6892, 171, 1873, 34, 410, "Input"],
Cell[8768, 207, 2161, 37, 510, "Input"],
Cell[10932, 246, 1683, 34, 258, "Input"],
Cell[12618, 282, 165, 4, 33, "Input"],

Cell[CellGroupData[{
Cell[12808, 290, 4047, 83, 550, "Input"],
Cell[16858, 375, 134816, 3331, 750, 35721, 2104, "GraphicsData", \
"PostScript", "Graphics"],
Cell[151677, 3708, 135, 3, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[151849, 3716, 3423, 68, 570, "Input"],
Cell[155275, 3786, 137066, 3480, 750, 37264, 2244, "GraphicsData", \
"PostScript", "Graphics"],
Cell[292344, 7268, 135, 3, 29, "Output"]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

