    
clc;
clear all;
close all;

global time;


%BASELINE DATA
load data/quarterly;
%x = log(ip);  seriesName='log(ip)'; windowSizeRaw = 2;  windowSizeDT = 5; disp('Analyzing log(IP)');  isStationary = false; windowTol = 0;   bpl = 6; bpu = 32;
x = log(1-unemp/100); seriesName='log(1-u)'; windowSizeRaw = 2; windowSizeDT = 5;  disp('Analyzing log(1-u)');  isStationary = true; windowTol = 0;   bpl = 2; bpu = 80;

%table 1e, 2e
%x = log(ip);  seriesName='log(ip)BP(2,80)'; windowSizeRaw = 2;  windowSizeDT = 5; disp('Analyzing log(IP)');  isStationary = false; windowTol = 0;   bpl = 2; bpu = 80;
%x = log(1-unemp/100); seriesName='log(1-u)BP(6,32)'; windowSizeRaw = 2; windowSizeDT = 5;  disp('Analyzing log(1-u)');  isStationary = true; windowTol = 0;   bpl =6; bpu = 32;

%table 4
%x = log(gdp);  seriesName='log(gdp)'; windowSizeRaw = 2;  windowSizeDT =5; disp('Analyzing log(GDP)');  isStationary = false; windowTol = 0; table = 4;  bpl = 6; bpu = 32;

%load data/robustness;
%x = log(nfbOutput);  seriesName='log(non-farm business output)'; windowSizeRaw = 2;  windowSizeDT =5; disp('Analyzing log(non-farm business output)');  isStationary = false; windowTol = 0; table = 4;  bpl = 6; bpu = 32;
%x = log(realPersInc);  seriesName='log(rpi)'; windowSizeRaw = 2;  windowSizeDT = 5; disp('Analyzing log(Real Pers Inc)');  isStationary = false; windowTol = 0; table = 4;  bpl = 6; bpu = 32;

%load data/CGI;
%x = log(retailSales.rs); windowSizeRaw = 2; windowSizeDT = 5; disp('Analyzing retail sales');  isStationary = false; windowTol = 0;  time = retailSales.time; table = 4;  bpl = 6; bpu = 32; NBER = NBER(13:end);
%x = log(gdpi); windowSizeRaw = 2; windowSizeDT = 5;  disp('log(Gross Private Domestic Investment)');  isStationary = false; windowTol = 0; table = 4;  bpl = 6; bpu = 32; NBER = [zeros(7,1); NBER];
%x = log(govExp); windowSizeRaw = 2; windowSizeDT = 5; disp('log(Government Expenditure)');  isStationary = false; windowTol = 0; table = 4;  bpl = 6; bpu = 32; NBER = [zeros(7,1); NBER];
%x = log(pce); windowSizeRaw = 2; windowSizeDT = 5;  disp('log(Personal Consumption Expenditure)');  isStationary = false; windowTol = 0; table = 4;  bpl = 6; bpu = 32; NBER = [zeros(7,1); NBER];


%LABOR MARKET ROBUSTNESS
%load data
%load data/laborMkt;
%hpw = hours ./ nfPayrollEmp;
%Set series here:
%set the window size for the MA method
%x = log(hpw);  seriesName='log(hpw)'; windowSizeRaw = 2;  windowSizeDT = 5; disp('Analyzing -log(hpw)');  isStationary = true; windowTol = 0; table = 5; bpl = 6; bpu = 32;
%x = log(partRate/100); seriesName='log(partRate)'; windowSizeRaw = 2; windowSizeDT = 5;  disp('Analyzing log(partRate)');  isStationary = true; windowTol = 0;  table = 5; bpl = 6; bpu = 32;
%x = log(hhEmp); seriesName='log(hhemp)'; windowSizeRaw = 2; windowSizeDT = 5;  disp('Analyzing log(hhemp)');  isStationary = true; windowTol = 0; table = 5; bpl = 6; bpu = 32;
%x = log(hhEmp ./ pop); seriesName='log(hhemp/pop)'; windowSizeRaw = 2; windowSizeDT = 5;  disp('Analyzing log(hhemp/pop)');  isStationary = true; windowTol = 0; table = 5;
%x = log(nfPayrollEmp); seriesName='log(prEmp)'; windowSizeRaw = 2; windowSizeDT = 5;  disp('Analyzing log(prEmp)');  isStationary = false; windowTol = 0; table = 5; bpl = 6; bpu = 32;
%x = log(1-unempYouth/100); seriesName='log(1-u_yth)'; windowSizeRaw = 2; windowSizeDT = 5;  disp('Analyzing log(1-u_yth)');  isStationary = false; windowTol = 0; table = 5; bpl = 6; bpu = 32;



%load data/empByAge;

%OVER - UNDER 25 Employment Rate
%x = log((emp.men.over16 + emp.women.over16 - emp.men.over25 - emp.women.over25) ./ (lf.men.over16 + lf.women.over16 - lf.men.over25 - lf.women.over25)); seriesName='log(emp rate men 16 - 55)'; windowSizeRaw = 2; windowSizeDT = 5;  disp('Analyzing log(emp rate 16 - 24)');  isStationary = true; windowTol = 0; table = 5; bpl = 6; bpu = 32;
%x = log((emp.men.over25 + emp.women.over25) ./ (lf.men.over25 + lf.women.over25)); seriesName='log(emp rate Over 25)'; windowSizeRaw = 2; windowSizeDT = 5;  disp('Analyzing log(emp rate men 16 - 55)');  isStationary = true; windowTol = 0; table = 5; bpl = 6; bpu = 32;




%Set the order of the polynomial trend
% unemp        -> 3
% log gdp      -> 3
% log(1-unemp) -> 3
polyOrder = 3;



%Detrend in various ways------------------------------
    
% 1 - Raw Data
detrended = x;
    
% 2 - HP
detrended = horzcat(detrended,x-hpfilter(x,1600));
    
% 3 - BP
detrended = horzcat(detrended,bandpass(x,bpl,bpu));
    
% 4 - Polynomial Trend (The second argument is the order)
detrended = horzcat(detrended,x-polynomial(x,polyOrder));

%5 - Linear with Breaks
detrended = horzcat(detrended,x-linBreak(x,1973.75,1995.75));    

%6 - Rotemberg Smooth Trend
detrended = horzcat(detrended,x-rotemberg(x));

% 7 - BP(2,80)
detrended = horzcat(detrended,bandpass(x,2,80));


%Detect Turning Points in Various Ways--------------------

if ~isStationary
    disp('Wide windows used on raw data');
end

% 1 - NBER Dates
recess = NBER;
   
% 2 - window method
%pre-smooth is implemented here as a test
for i = 1:7
    if i == 1 && ~isStationary
        recess = horzcat(recess , window(preSmooth(detrended(:,i),2),windowSizeRaw,windowTol));
        %recess = horzcat(recess , window(detrended(:,i),windowSizeRaw,windowTol));
    else
        recess = horzcat(recess , window(preSmooth(detrended(:,i),2),windowSizeDT,windowTol));
        %recess = horzcat(recess , window(detrended(:,i),windowSizeDT,windowTol));
    end
end
  
% 3 - 2-quarter method
for i = 1:7

    if i == 1 && ~isStationary
        recess = horzcat(recess, TwoQuarter(detrended(:,i),2,1));
    else
        recess = horzcat(recess, TwoQuarter(detrended(:,i),3,2));
    end
end
   
% 4 - Bry-Boschan
for i = 1:7
    if i == 1 && ~isStationary
        recess = horzcat(recess,bryBos(detrended(:,i),false));
    else
        recess = horzcat(recess,bryBos(detrended(:,i),true));
    end
end

% 5 - Chauvet - Hamilton
for i = 1:7
    rtemp = chauvetHamilton84(detrended(:,i),find(time==1984.5));
    recess = horzcat(recess,rtemp);
end




disp('Agreement Tables:');
disp(' ');
disp('Key for TurningPoint:')
TPKey =    ['1 - Window          ';
            '2 - 2QTR            ';
            '3 - Bry Boschan     ';
            '4 - Chauvet-Hamilton'];
disp(TPKey); 
disp(' ');
disp('Key for DeTrending:')
DTKey =[    '1 - Raw Data          ';
            '2 - HP                ';
            '3 - BP                ';
            '4 - Polynomial        ';
            '5 - Linear with Breaks';
            '6 - Rotemberg         ';
            '7 - BP(2,80)          '];
disp(DTKey);
disp(' ');




%~~~~~~~~Compute t-test and Wilcoxon Test~~~~~~~~~~


disp('In the following, the p-value is for a one-sided test that the contraction quantity is greater than the expansion quantity.  For a test of the reverse ordering take 1 - Pvalue.');
rowNames = strvcat('Duration ','Depth ', 'Steepness ','Sharpness ', 'Slope ');

totalOutput = [];
for trd = 1:7
    
    for tp = 0:4
        
        if tp==0
            r = recess(:,1);
        else
            counter = 1 + 7 * (tp - 1) + trd;
            r = recess(:,counter);
        end
        
        xF = detrended(:,trd);
        
        
        disp(horzcat('Detrending: ',DTKey(trd,:)));
        
        if tp ==0
            disp('Turning Point: NBER recessions.');
        else
            disp(horzcat('Turning Point: ',TPKey(tp,:)));
        end
        

        disp('            avg. contr.    avg. expan.       W-stat     p-value      Wilc t-stat   Basic t-stat  p-value');
        output = wilcoxon(xF,r);
        totalOutput = [totalOutput; [repmat([trd  tp],5,1) [1:5]' output]];
        
        disp(horzcat(rowNames,num2str(output)));
        
        disp(' ');
        disp(' ');
        
    end
end


tables345(totalOutput);
if exist('table')
    if table == 4
        disp('Results excluding C-H');
        tables345(totalOutput,table);
    elseif table == 5
        disp('Results with BP(2,80)');
        tables345(totalOutput,table);
    end
end



switch seriesName
    case 'log(1-u)'
        save('results/abc_q_u.mat','recess','x','totalOutput','detrended');
    case 'log(ip)'
        save('results/abc_q_ip.mat','recess','x','totalOutput','detrended');
    case 'log(gdp)'
        save('results/abc_q_gdp.mat','recess','x','totalOutput','detrended');
end
