%this script tests for output to be as asymmetric as employment. 
%Using a ratio test instead of a difference test.  Used for violence
%november 27, 2006


clc;
clear all;
close all;

global time;

%Load the results for cross-series comparison
load results/abc_q_u.mat;
crossResults = totalOutput;
crossResults = crossResults(crossResults(:,1)<7,:);

%BASELINE DATA
load data/quarterly;
%x = log(gdp);  seriesName='log(gdp)'; windowSizeRaw = 2;  windowSizeDT = 5; disp('Analyzing log(GDP)');  isStationary = false; windowTol = 0; table = 4;
x = log(ip);  seriesName='log(ip)'; windowSizeRaw = 2;  windowSizeDT = 5; disp('Analyzing log(IP)');  isStationary = false; windowTol = 0; 
%x = log(1-unemp/100); seriesName='log(1-u)'; windowSizeRaw = 2; windowSizeDT = 5;  disp('Analyzing log(1-u)');  isStationary = true; windowTol = 0;


%Set the order of the polynomial trend
% unemp        -> 3
% log gdp      -> 3
% log(1-unemp) -> 3
polyOrder = 3;



%Detrend in various ways------------------------------
    
% 1 - Raw Data
detrended = x;
    
% 2 - HP
detrended = horzcat(detrended,x-hpfilter(x,1600));
    
% 3 - BP
detrended = horzcat(detrended,bandpass(x,6,32));

    
% 4 - Polynomial Trend (The second argument is the order)
detrended = horzcat(detrended,x-polynomial(x,polyOrder));

%5 - Linear with Breaks
detrended = horzcat(detrended,x-linBreak(x,1973.75,1995.75));    

%6 - Rotemberg Smooth Trend
detrended = horzcat(detrended,x-rotemberg(x));



%Detect Turning Points in Various Ways--------------------

if ~isStationary
    disp('Wide windows used on raw data');
end

% 1 - NBER Dates
recess = NBER;
   
% 2 - window method
%pre-smooth is implemented here as a test
for i = 1:6
    if i == 1 && ~isStationary
        recess = horzcat(recess , window(preSmooth(detrended(:,i),2),windowSizeRaw,windowTol));
        %recess = horzcat(recess , window(detrended(:,i),windowSizeRaw,windowTol));
    else
        recess = horzcat(recess , window(preSmooth(detrended(:,i),2),windowSizeDT,windowTol));
        %recess = horzcat(recess , window(detrended(:,i),windowSizeDT,windowTol));
    end
end
  
% 3 - 2-quarter method
for i = 1:6

    if i == 1 && ~isStationary
        recess = horzcat(recess, TwoQuarter(detrended(:,i),2,1));
    else
        recess = horzcat(recess, TwoQuarter(detrended(:,i),3,2));
    end
end
   
% 4 - Bry-Boschan
for i = 1:6
    if i == 1 && ~isStationary
        recess = horzcat(recess,bryBos(detrended(:,i),false));
    else
        recess = horzcat(recess,bryBos(detrended(:,i),true));
    end
end

% 5 - Chauvet - Hamilton
for i = 1:6
    rtemp = chauvetHamilton84(detrended(:,i),find(time==1984.5));
    recess = horzcat(recess,rtemp);
end


    
    



disp(' ');
disp('Key for TurningPoint:')
TPKey =    ['1 - Window          ';
            '2 - 2QTR            ';
            '3 - Bry Boschan     ';
            '4 - Chauvet-Hamilton'];
disp(TPKey); 
disp(' ');
disp('Key for DeTrending:')
DTKey =[    '1 - Raw Data          ';
            '2 - HP                ';
            '3 - BP                ';
            '4 - Polynomial        ';
            '5 - Linear with Breaks';
            '6 - Rotemberg         ';
            '7 - BP(2,80)          '];
disp(DTKey);
disp(' ');

[T n] = size(recess);



%~~~~~~~~Compute t-test and Wilcoxon Test~~~~~~~~~~


disp('In the following, the p-value is for a one-sided test that the contraction quantity is greater than the expansion quantity.  For a test of the reverse ordering take 1 - Pvalue.');
rowNames = strvcat('Duration ','Depth ', 'Steepness ','Sharpness ', 'Slope ');

totalOutput = [];
temp = [];
for trd = 1:6
    
    for tp = 0:4
        
        if tp==0
            r = recess(:,1);
        else
            counter = 1 + 6 * (tp - 1) + trd;
            r = recess(:,counter);
        end
        
        xF = detrended(:,trd);
        
        
        disp(horzcat('Detrending: ',DTKey(trd,:)));
        
        if tp ==0
            disp('Turning Point: NBER recessions.');
        else
            disp(horzcat('Turning Point: ',TPKey(tp,:)));
        end
        

        mu = crossResults(logical((crossResults(:,1)==trd).*(crossResults(:,2)==tp)),:);
        mu = abs(mu(:,5)) ./ abs(mu(:,4));
        
        
        
        disp('            avg. contr.    avg. expan.       W-stat     p-value      Wilc t-stat   Basic t-stat  p-value');
        output = wilcoxon_altTest2(xF,r,mu);
        totalOutput = [totalOutput; [repmat([trd  tp],5,1) [1:5]' output]];
        
        disp(horzcat(rowNames,num2str(output)));
        
        disp(' ');
        disp(' ');
        
    end
end




%create a table

altTestOutput = [totalOutput(:,1:3)     (abs(crossResults(:,5)) ./ abs(crossResults(:,4))) ...
    (abs(totalOutput(:,5)) ./ abs(totalOutput(:,4)))     totalOutput(:,9:10)];

