

clc;
clear all;
close all;

global time;
load data/monthly;

%Set series here:
%x = log(ip);  seriesName='log(IP)'; windowSizeRaw = 6;  windowSizeDT = 15; disp('Analyzing log(IP)');  isStationary = false; windowTol = 0;
x = log(1-unemp/100); seriesName='log(1-u)'; windowSizeRaw = 6; windowSizeDT = 15;  disp('Analyzing log(1-u)');  isStationary = true; windowTol = 0;


%Set the order of the polynomial trend
% unemp        -> 3
% log gdp      -> 3
% log(1-unemp) -> 3
polyOrder = 1;



%Detrend in various ways------------------------------
    
% 1 - Raw Data
detrended = x;
    
% 2 - HP
detrended = horzcat(detrended,x-hpfilter(x,100000));
    
% 3 - BP
detrended = horzcat(detrended,bandpass(x,18,96));
    
% 4 - Polynomial Trend (The second argument is the order)
detrended = horzcat(detrended,x-polynomial(x,polyOrder,0));

%5 - Linear with Breaks
%1973M11 and 1995M11
detrended = horzcat(detrended,x-linBreak(x,1973.8333,1995.8333));    
    
%6 - Rotemberg Smooth Trend
detrended = horzcat(detrended,x-rotemberg(x,'m'));
    
% 7 - BP (2, 80)
detrended = horzcat(detrended,bandpass(x,6,240));


%Detect Turning Points in Various Ways--------------------

if ~isStationary
    disp('Wide windows used on raw data');
end

% 1 - NBER Dates
recess = NBER;
   
% 2 - window method
for i = 1:7
    if i == 1 && ~isStationary
        recess = horzcat(recess , window(preSmooth(detrended(:,i),6),windowSizeRaw,windowTol));
        %recess = horzcat(recess , window(detrended(:,i),windowSizeRaw,windowTol));
    else
        recess = horzcat(recess , window(preSmooth(detrended(:,i),6),windowSizeDT,windowTol));
        %recess = horzcat(recess , window(detrended(:,i),windowSizeDT,windowTol));
    end
end
  
% 3 - 2-quarter method
for i = 1:7

    if i == 1 && ~isStationary
        recess = horzcat(recess, TwoQuarter(detrended(:,i),2,1,'m'));
    else
        recess = horzcat(recess, TwoQuarter(detrended(:,i),3,2,'m'));
    end
end
   
% 4 - Bry-Boschan
for i = 1:7
    if i == 1 && ~isStationary
        recess = horzcat(recess,bryBos(detrended(:,i),false,'m'));
    else
        recess = horzcat(recess,bryBos(detrended(:,i),true,'m'));
    end
end
    
% 5 - Chauvet - Hamilton
for i = 1:7
    rtemp = chauvetHamilton84(detrended(:,i),find(time==1984.5));
    recess = horzcat(recess,rtemp);
end
    


disp('Agreement Tables:');
disp(' ');
disp('Key for TurningPoint:')
TPKey =    ['1 - Window          ';
            '2 - 2QTR            ';
            '3 - Bry Boschan     ';
            '4 - Chauvet-Hamilton'];
disp(TPKey); 
disp(' ');
disp('Key for DeTrending:')
DTKey =[    '1 - Raw Data          ';
            '2 - HP                ';
            '3 - BP                ';
            '4 - Polynomial        ';
            '5 - Linear with Breaks';
            '6 - Rotemberg         ';
            '7 - BP (2,80)         '];
disp(DTKey);


disp('In the following, the p-value is for a one-sided test that the contraction quantity is greater than the expansion quantity.  For a test of the reverse ordering take 1 - Pvalue.');
rowNames = strvcat('Duration ','Depth ', 'Steepness ','Sharpness ', 'Slope ');

totalOutput = [];
for trd = 1:7
    
    for tp = 0:4
        
        if tp==0
            r = recess(:,1);
        else
            counter = 1 + 7 * (tp - 1) + trd;
            r = recess(:,counter);
        end
        
        xF = detrended(:,trd);
        
        
        disp(horzcat('Detrending: ',DTKey(trd,:)));
        
        if tp ==0
            disp('Turning Point: NBER recessions.');
        else
            disp(horzcat('Turning Point: ',TPKey(tp,:)));
        end
        
        disp('            avg. contr.    avg. expan.       W-stat     p-value      Wilc t-stat   Basic t-stat  p-value');
        output = wilcoxon(xF,r);
        totalOutput = [totalOutput; [repmat([trd  tp],5,1) [1:5]' output]];
            
        disp(horzcat(rowNames,num2str(output)));
        
        disp(' ');
        disp(' ');
        
    end
end



tables345(totalOutput);
disp('Results using BP(2,80)');
tables345(totalOutput,true);