    
clc;
clear all;
close all;

global time;



%Pre-War
%load data
load data/prewar;
%hpw = hours ./ nfPayrollEmp;
%Set series here:
%set the window size for the MA method
x = log(pigIron); seriesName='log(pigIron)'; windowSizeRaw = 2; windowSizeDT = 5;  disp('Analyzing log(pigIron)');  isStationary = false; windowTol = 0; table = 5; time = time_pi;
%x = log(factoryEmp); seriesName='log(factoryEmp)'; windowSizeRaw = 2; windowSizeDT = 5;  disp('Analyzing log(factoryEmp)');  isStationary = false; windowTol = 0; table = 5; time = time_fe; NBER = NBER(ismember(time_pi,time_fe));



%Set the order of the polynomial trend
% unemp        -> 3
% log gdp      -> 3
% log(1-unemp) -> 3
polyOrder = 3;



%Detrend in various ways------------------------------
    
% 1 - Raw Data
detrended = x;
    
% 2 - HP
detrended = horzcat(detrended,x-hpfilter(x,1600));
    
% 3 - BP
detrended = horzcat(detrended,bandpass(x,6,32));

    
% 4 - Polynomial Trend (The second argument is the order)
detrended = horzcat(detrended,x-polynomial(x,polyOrder));

%5 - Linear with Breaks
detrended = horzcat(detrended,x-linBreak(x));    

%6 - Rotemberg Smooth Trend
detrended = horzcat(detrended,x-rotemberg(x));


%7 - BP experiment
detrended = horzcat(detrended,bandpass(x,2,80));


%Detect Turning Points in Various Ways--------------------

if ~isStationary
    disp('Wide windows used on raw data');
end

% 1 - NBER Dates
recess = NBER;
   
% 2 - window method
%pre-smooth is implemented here as a test
for i = 1:7
    if i == 1 && ~isStationary
        recess = horzcat(recess , window(preSmooth(detrended(:,i),2),windowSizeRaw,windowTol));
        %recess = horzcat(recess , window(detrended(:,i),windowSizeRaw,windowTol));
    else
        recess = horzcat(recess , window(preSmooth(detrended(:,i),2),windowSizeDT,windowTol));
        %recess = horzcat(recess , window(detrended(:,i),windowSizeDT,windowTol));
    end
end
  
% 3 - 2-quarter method
for i = 1:7

    if i == 1 && ~isStationary
        recess = horzcat(recess, TwoQuarter(detrended(:,i),2,1));
    else
        recess = horzcat(recess, TwoQuarter(detrended(:,i),3,2));
    end
end
   
% 4 - Bry-Boschan
for i = 1:7
    if i == 1 && ~isStationary
        recess = horzcat(recess,bryBos(detrended(:,i),false));
    else
        recess = horzcat(recess,bryBos(detrended(:,i),true));
    end
end

% 5 - Chauvet - Hamilton
for i = 1:7
    rtemp = chauvetHamilton(detrended(:,i));
    recess = horzcat(recess,rtemp);
end


    
    



disp(' ');
disp('Key for TurningPoint:')
TPKey =    ['1 - Window          ';
            '2 - 2QTR            ';
            '3 - Bry Boschan     ';
            '4 - Chauvet-Hamilton'];
disp(TPKey); 
disp(' ');
disp('Key for DeTrending:')
DTKey =[    '1 - Raw Data          ';
            '2 - HP                ';
            '3 - BP                ';
            '4 - Polynomial        ';
            '5 - Linear with Breaks';
            '6 - Rotemberg         ';
            '7 - BP(2,80)          '];
disp(DTKey);
disp(' ');

%~~~~~~~~Compute t-test and Wilcoxon Test~~~~~~~~~~


disp('In the following, the p-value is for a one-sided test that the contraction quantity is greater than the expansion quantity.  For a test of the reverse ordering take 1 - Pvalue.');
rowNames = strvcat('Duration ','Depth ', 'Steepness ','Sharpness ', 'Slope ');

totalOutput = [];
for trd = 1:7
    
    for tp = 0:4
        
        if tp==0
            r = recess(:,1);
        else
            counter = 1 + 7 * (tp - 1) + trd;
            r = recess(:,counter);
        end
        
        xF = detrended(:,trd);
        
        
        disp(horzcat('Detrending: ',DTKey(trd,:)));
        
        if tp ==0
            disp('Turning Point: NBER recessions.');
        else
            disp(horzcat('Turning Point: ',TPKey(tp,:)));
        end
        

        disp('            avg. contr.    avg. expan.       W-stat     p-value      Wilc t-stat   Basic t-stat  p-value');
        output = wilcoxon(xF,r);
        totalOutput = [totalOutput; [repmat([trd  tp],5,1) [1:5]' output]];
        
        disp(horzcat(rowNames,num2str(output)));
        
        disp(' ');
        disp(' ');
        
    end
end


tables345(totalOutput);
if exist('table')
    if table == 4
        disp('Results excluding C-H');
        tables345(totalOutput,table);
    elseif table == 5
        disp('Results with BP(2,80)');
        tables345(totalOutput,table);
    end
end


switch seriesName
    case 'log(1-u)'
        save('results/abc_q_u.mat','recess','x','totalOutput','detrended');
    case 'log(ip)'
        save('results/abc_q_ip.mat','recess','x','totalOutput','detrended');
    case 'log(gdp)'
        save('results/abc_q_gdp.mat','recess','x','totalOutput','detrended');
end
