function recess = TwoQuarter(y,a,b,monthly)

%This function uses the "two-quarter" methods to identify peaks and
%troughs.  A trough is identified where there are (a) quarters of decline
%followed by (b) of increase.  Peaks are identified analogously.  Peaks and
%Troughs are eliminated so that the in the end they alternate peak, trough,
%peak,....  The elimination follows Bry-Boschan so that the lowest trough
%is retained and in the event of equality the latest one is retained.
%Inputs     y   The series
%           a   scalar...default is 2
%           b   scalar...default is 1
%           monthly set to 'm' for monthly datat

if nargin < 3
    a = 2;
    b = 1;
end

T = length(y);

peak = zeros(T,1);
trough = zeros(T,1);

if nargin == 4 && monthly == 'm'
    
    for t = 3*a+1:(T-3*b)
        temp1 = []; temp2 = []; temp3=[]; temp4=[];
        for j = 1:a
            temp1 = [temp1; y(t-3*(j-1))];
            temp2 = [temp2; y(t-3*j)];
        end
        for j = 1:b
            temp3 = [temp3; y(t+3*j)];
            temp4 = [temp4; y(t+3*(j-1))];
        end
        %The *1 in the lines below is to cast the logical values as integers so
        %I can use the product function
        if prod(1*((temp1 - temp2) < 0)) == 1  && prod(1*((temp3-temp4) >= 0)) == 1
            trough(t) = 1;
        elseif prod(1*((temp1 - temp2) > 0)) == 1  && prod(1*((temp3-temp4) <= 0)) == 1
            peak(t) = 1;
        end 
    end
     
else

    for t = a+1:(T-b)
        %The *1 in the lines below is to cast the logical values as integers so
        %I can use the product function
        if prod(1*((y((t-a+1):t) - y((t-a):t-1)) < 0)) == 1  && prod(1*((y((t+b):(t+1)) - y((t+b-1):t)) >= 0)) == 1
        %if (y(t) - y(t-1) < 0) && (y(t-1) - y(t-2) < 0) && (y(t+1) - y(t) >= 0)
            trough(t) = 1;
            elseif prod(1*((y((t-a+1):t) - y((t-a):t-1)) > 0)) == 1  && prod(1*((y((t+b):(t+1)) - y((t+b-1):t)) <= 0)) == 1
            %elseif (y(t) - y(t-1) > 0) && (y(t-1) - y(t-2) > 0) && (y(t+1) - y(t) <= 0)
            peak(t) = 1;
        end 
    end
    
end


%Ensure alternating peaks and troughs by eliminating the first of
%consecutive peaks (troughs).
current = 0;
lastIndex = [];
for t = 1:T
    if peak(t)==1 && current == 1
        peak(lastIndex) = 0;
    elseif trough(t) == 1 && current == -1
        trough(lastIndex) = 0;
    end
    
    if peak(t) == 1
        current = 1;
        lastIndex = t;
    elseif trough(t) == 1;
        current = -1;
        lastIndex = t;
    end
end



recess = cumsum(peak - trough);
if sum(recess) < 0
    recess = recess + 1;
end
