function recess = bryBos(y, double, freq)
%This function takes in a series and runs it through Monch and Uhlig's
%Bry-Boschan routine.  Interpolation to monthly data is simply repeating
%the quarterly observations following Bry-Boschan.
%Input: a QUARTERLY series (y) and a boolean (double) telling whether to
%double the standard window size.  freq = 'm'/'q' tells the
%program what kind of data is being fed into it (default is q).
%Output: an indicator vector with ones in the recessions.

T = length(y);


%convert to Monthly
if nargin < 3 || freq ~= 'm';
    interpMat = [];

    for i = 1:T
        interpMat=vertcat(interpMat,horzcat(zeros(3,(i-1)),[1;1;1],zeros(3,T-i)));
    end

    y = interpMat * y;
end


%Apply Bry-Boschan
if ~double
    [peak, trough] = bryBos_code(y,5,3,1,0);
else
    [peak, trough] = bryBos_code(y,10,6,1,0);
end


%convert back to quarterly
if nargin < 3 || freq ~= 'm';
    peakQuarterly = zeros(T,1);
    troughQuarterly = zeros(T,1);

    for i = 1:T
        month1 = (i-1)*3 + 1;
        month3 = (i-1)*3 + 3;
    
        if sum(peak(month1:month3)) > 0
            peakQuarterly(i) = 1;
        end
    
        if sum(trough(month1:month3)) > 0
            troughQuarterly(i) = 1;
        end
    
    end

    peak = peakQuarterly;
    trough = troughQuarterly;

end


%Ensure alternating peaks and troughs by eliminating the first of
%consecutive peaks (troughs).
current = 0;
lastIndex = [];
for t = 1:T
    if peak(t)==1 && current == 1
        if peak(t) >= peak(lastIndex)
            peak(lastIndex) = 0;
        else
            peak(t) = 0;
        end
    elseif trough(t) == 1 && current == -1
        if trough(t) <= trough(lastIndex)
            trough(lastIndex) = 0;
        else
            trough(t) = 0;
        end
    end
    
    if peak(t) == 1
        current = 1;
        lastIndex = t;
    elseif trough(t) == 1;
        current = -1;
        lastIndex = t;
    end
end



%convert from peak/trough to recess
recess = cumsum(peak - trough);

    %the following raisess recess if we begin in a recession
if sum(recess) < 0;
    recess = recess + ones(length(recess),1);
end

