function [recess, smoothedRecessProb] = chauvetHamilton(y)
%input series in levels (y)
%modified 12/3 to allow the std of dy to change between booms and
%recessions.  Also I corrected the parameterization to constrain
%probabilities to lie within [0,1], which I forgot to do in the previous
%version.

global chauvHamdY;

T = length(y);

dy = y(2:T) - y(1:T-1);

chauvHamdY = dy;

T = length(dy);

theta = [mean(dy(dy>0)); mean(dy(dy<0));...
            std(dy(dy>0)); std(dy(dy<0));...
            ilogistic(.85); ilogistic(.85)];
    
if true  %switch the maximization routine here
    options = optimset('MaxIter',5e3);
    [theta, fval] = fminsearch(@chauvetHamiltonLLH,theta,options);
    clear options;
else
    [fh,xh,gh,H,itct,fcount,retcodeh] = csminwel('chauvetHamiltonLLH',theta,eye(length(theta))*.001,[],1e-6,5e3)
    theta = xh;
end


disp(['Resulting Params: '  num2str(theta')]);


%get the smoothed regime probs

mu1 = theta(1);
mu2 = theta(2);
sigma1 = abs(theta(3));
sigma2 = abs(theta(4));
p11 = logistic(theta(5));
p22 = logistic(theta(6));

p12 = 1 - p11;
p21 = 1 - p22;


fp1 = []; fp2 = []; prp=[];

for t = 1:T

    if t == 1
        predProb1 = (1 - p11)/(2 - p11 - p22);
        predProb2 = (1 - p22)/(2 - p11 - p22);
    else
        predProb1 = filtrdProb1 * p11 + filtrdProb2 * p21;
        predProb2 = filtrdProb1 * p12 + filtrdProb2 * p22;
    end
 

    lht = predProb1/(sqrt(2 * pi)*sigma1)*exp(-(dy(t)-mu1)^2/(2*sigma1^2))...
        +predProb2/(sqrt(2 * pi)*sigma2)*exp(-(dy(t)-mu2)^2/(2*sigma2^2));
    
    filtrdProb1 = (1/lht)* predProb1 * (1/(sqrt(2*pi)*sigma1))*...
        exp(-(dy(t)-mu1)^2/(2*sigma1^2));
    filtrdProb2 = (1/lht)* predProb2 * (1/(sqrt(2*pi)*sigma2))*...
        exp(-(dy(t)-mu2)^2/(2*sigma2^2));
    
    fp1 = [fp1; filtrdProb1];    
    fp2 = [fp2; filtrdProb2];

    prp = [prp; [predProb1 predProb2]];
end

fp = [fp1 fp2];

smoothProb = zeros(T,2);
smoothProb(T,:) = fp(T,:);


for t = T-1:-1:1
    smoothProb(t,:) = transpose(transpose(fp(t,:)) .* ( [p11 p12; p21 p22] * ...
        (transpose(smoothProb(t+1,:)) ./ transpose(prp(t+1,:)))));    
end



%define a recession (expansion) as period when the smoothed probability of
%recession is above (below) 0.5
recess = smoothProb(:,2) > 0.5;

%impose a criterion that phases must be at least two quarters
for t = 2:(T-1)
    if abs(recess(t) - recess(t-1)) == 1  && ...
            abs(recess(t+1) - recess(t)) == 1
        recess(t) = recess(t-1);
    end
end

%There is one fewer observations because of first differencing so add it
%back with a repeat of the first 
recess = [recess(1); recess];


smoothedRecessProb = smoothProb;


    
function p = logistic(x)
    p = exp(x)/(1+exp(x));
    
function x = ilogistic(p)
    x = log(p/(1-p));
