function llh = chauvetHamiltonLLH(theta)

    global chauvHamdY;

    dy = chauvHamdY;

    T = length(dy);


    mu1 = theta(1);
    mu2 = theta(2);
    sigma1 = abs(theta(3));
    sigma2 = abs(theta(4));
    p11 = logistic(theta(5));
    p22 = logistic(theta(6));
    
    p12 = 1 - p11;
    p21 = 1 - p22;

    llh = 0;
    
    for t = 1:T

        if t == 1
            predProb1 = (1 - p11)/(2 - p11 - p22);
            predProb2 = (1 - p22)/(2 - p11 - p22);
        else
            predProb1 = filtrdProb1 * p11 + filtrdProb2 * p21;
            predProb2 = filtrdProb1 * p12 + filtrdProb2 * p22;
        end
 

        lht = predProb1/(sqrt(2 * pi)*sigma1)*exp(-(dy(t)-mu1)^2/(2*sigma1^2))...
            +predProb2/(sqrt(2 * pi)*sigma2)*exp(-(dy(t)-mu2)^2/(2*sigma2^2));
    
        filtrdProb1 = (1/lht)* predProb1 * (1/(sqrt(2*pi)*sigma1))*...
            exp(-(dy(t)-mu1)^2/(2*sigma1^2));
        filtrdProb2 = (1/lht)* predProb2 * (1/(sqrt(2*pi)*sigma2))*...
            exp(-(dy(t)-mu2)^2/(2*sigma2^2));
    
        llh = llh + log(lht);
    
    end


    llh = -llh;


function p = logistic(x)
    p = exp(x)/(1+exp(x));
    
function x = ilogistic(p)
    x = log(p/(1-p));

