function llh = chauvetHamiltonLLH84(theta)
%llh for pre- and post-84 switch

    global chauvHamdY chauvHamBreakIndex;

    dy = chauvHamdY;
    breakIndex = chauvHamBreakIndex;

    T = length(dy);
    
    mu1 = theta(1);
    mu2 = theta(2);
    sigma1pre = abs(theta(3));
    sigma2pre = abs(theta(4));
    sigma1post = abs(theta(5));
    sigma2post = abs(theta(6));
    p11 = logistic(theta(7));
    p22 = logistic(theta(8));
    
    
    p12 = 1 - p11;
    p21 = 1 - p22;

    llh = 0;
    
    for t = 1:T
        
        if t < breakIndex
            sigma1 = sigma1pre; sigma2 = sigma2pre;
        else
            sigma1 = sigma1post; sigma2 = sigma2post;
        end

        if t == 1
            predProb1 = (1 - p11)/(2 - p11 - p22);
            predProb2 = (1 - p22)/(2 - p11 - p22);
        else
            predProb1 = filtrdProb1 * p11 + filtrdProb2 * p21;
            predProb2 = filtrdProb1 * p12 + filtrdProb2 * p22;
        end
 

        lht = predProb1/(sqrt(2 * pi)*sigma1)*exp(-(dy(t)-mu1)^2/(2*sigma1^2))...
            +predProb2/(sqrt(2 * pi)*sigma2)*exp(-(dy(t)-mu2)^2/(2*sigma2^2));
    
        filtrdProb1 = (1/lht)* predProb1 * (1/(sqrt(2*pi)*sigma1))*...
            exp(-(dy(t)-mu1)^2/(2*sigma1^2));
        filtrdProb2 = (1/lht)* predProb2 * (1/(sqrt(2*pi)*sigma2))*...
            exp(-(dy(t)-mu2)^2/(2*sigma2^2));
    
        llh = llh + log(lht);
    
    end


    llh = -llh;


function p = logistic(x)
    p = exp(x)/(1+exp(x));
    
function x = ilogistic(p)
    x = log(p/(1-p));

