function plotCDFs()
% This one is unemployment sharpness

%Create plots of CDFs
%The output is a bunch of color postcripts in results/plots, which can then
%be converted to PDFs with acrobat distiller.

clear all;
close all;
clc;



DTKey =[    'Raw Data              ';
            'HP Trend              ';
            'Bandpass Filter       ';
            'Polynomial Trend      ';
            'Piecewise-Linear Trend';
            'Modified HP Trend     '];


        
%load the data from the different variables
load results/abc_q_u.mat;
rec.u = recess;
y.u = x;
dtrnd.u = detrended;

load results/abc_q_ip.mat;
rec.ip = recess;
y.ip = x;
dtrnd.ip = detrended;


    f1 = figure();
    tableXPlots(rec,y,dtrnd,'u');

    %format for printing
    set(f1,'Color',[1 1 1]);
    

    %close all;
    




function makeCDFs(varargin) %~~~~~~~~~~~~~~~~~~~~~~~
%This function produces a plot of the CDFs of the supplied column vectors
%varargin can be any number of inputs, but they should all be column
%vectors of data.


for i = 1:nargin
    
    x = varargin{i};
    
    
    %CHANGE THE LINE SERIES OPTIONS HERE%
    
    if i == 2
        plot(sort(x),(1/length(x))*[1:length(x)]','--','LineWidth',2);
    else
        plot(sort(x),(1/length(x))*[1:length(x)]','LineWidth',2);
    end
    
    hold all;
    
end

hold off;


function tableXPlots(rec,y,dtrnd,ylabel,ylabelClear) %~~~~~~~~~~~~~~~~~~~~~~~~~~
%input the number of the trend to use and two data series

recess = eval(strcat('rec.',ylabel));
x = eval(strcat('y.',ylabel));
detrended = eval(strcat('dtrnd.',ylabel));

i = 0;

tpLabel = strvcat('Window','Reversal','Bry-Boschan','Chauvet-Hamilton');


    for tp = 1:4

        for trd = 3:6
            
            xF = detrended(:,trd);
            counter = 1 + 6 * (tp - 1) + trd;
            subplot(4,4,(4*(tp-1) + (trd-2)));
            makeCDFs(abs(sharpness(xF,recess(:,counter))),abs(sharpness(xF,~recess(:,counter))));
            xlim([0 0.01]);
        end
        
    end

    fig1 = get(0,'CurrentFigure');
    
 
%% Create textbox
annotation2 = annotation(...
  fig1,'textbox',...
  'Position',[0.01358 0.8253 0.08395 0.0512],...
  'LineStyle','none',...
  'FitHeightToText','off',...
  'HorizontalAlignment','center',...
  'String',{'Window'});
 
%% Create textbox
annotation3 = annotation(...
  fig1,'textbox',...
  'Position',[0.01605 0.5979 0.08395 0.0512],...
  'LineStyle','none',...
  'FitHeightToText','off',...
  'HorizontalAlignment','center',...
  'String',{'Reversal'});
 
%% Create textbox
annotation4 = annotation(...
  fig1,'textbox',...
  'Position',[0.01605 0.3886 0.08395 0.0512],...
  'LineStyle','none',...
  'FitHeightToText','off',...
  'HorizontalAlignment','center',...
  'String',{'Bry-Boschan'});
 
%% Create textbox
annotation5 = annotation(...
  fig1,'textbox',...
  'Position',[0.01975 0.1596 0.08395 0.0512],...
  'LineStyle','none',...
  'FitHeightToText','off',...
  'HorizontalAlignment','center',...
  'String',{'Chauvet-Hamilton'});
 
%% Create textbox
annotation6 = annotation(...
  fig1,'textbox',...
  'Position',[0.163 0.9202 0.08395 0.0512],...
  'LineStyle','none',...
  'FitHeightToText','off',...
  'HorizontalAlignment','center',...
  'String',{'Bandpass Filter'});
 
%% Create textbox
annotation7 = annotation(...
  fig1,'textbox',...
  'Position',[0.3679 0.9217 0.08395 0.0512],...
  'LineStyle','none',...
  'FitHeightToText','off',...
  'HorizontalAlignment','center',...
  'String',{'Polynomial Trend'});
 
%% Create textbox
annotation8 = annotation(...
  fig1,'textbox',...
  'Position',[0.5753 0.9217 0.08395 0.0512],...
  'LineStyle','none',...
  'FitHeightToText','off',...
  'HorizontalAlignment','center',...
  'String',{'Piecewise-Linear Trend'});
 
%% Create textbox
annotation9 = annotation(...
  fig1,'textbox',...
  'Position',[0.7815 0.9187 0.08395 0.0512],...
  'LineStyle','none',...
  'FitHeightToText','off',...
  'HorizontalAlignment','center',...
  'String',{'Modified-HP Trend'});
 
    
 
%% Create legend
legend1 = legend(get(fig1,'CurrentAxes'),{'Contractions','Expansions'},'Position',[0.4654 0.01291 0.126 0.05412],'EdgeColor',[1 1 1]);
