function [beta sigma]=ols(y,x,print);

%function that implements OLS and returns coefficient and covariance matrix

[n, k] = size(x);

beta = inv( x' * x ) * x' * y;

eps = y - x * beta;

sigma = (eps' * eps / (n-k) ) * inv(x' * x);

if nargin > 2
    disp('OLS Coefficients:         ');  disp(beta);
    disp('std errors:               ');  disp(sqrt(diag(sigma)));
    disp('t-stats:                  ');  disp(beta ./ sqrt(diag(sigma)));
    disp('Std. Error of Regression: ');  disp(sqrt(eps' * eps / (n-k) ));
end