function trend = polynomial(x,order,diagnostic)
%This function takes in a time series (x) and fits a polynomial trend to
%it.
%If the argument diagnostic=1 then plot the trend and print some stats.
%Default is diagnostic=0.

T = length(x);

t = [1:T]';

rhs = ones(T,1);

for i = 1:order
    rhs = horzcat(rhs,t.^i);
end


if nargin > 2 && diagnostic == 1
    
    [beta sigma]=ols(x,rhs,'print');
        
else
    [beta sigma]=ols(x,rhs);

end

trend = rhs * beta;