function S = slope(x,recess)
%This function takes a time series x and a vector indication contractions
%(recess) and then calculates the slope of each of the contractions and
%returns them in the vector S.  Note that the length of S is equal to the
%number of discreet (and complete contractions).  Slope is the coefficient
%b in the least squares regression x(t) = a + b * t + e(t) estimated over
%the contraction.

T = length(x);

if length(recess) ~= T
    disp('Error in sharpness function: vectors must be of same length');
end

%we want the contraction to be from the peak to the trough, inclusive.
%Therefore, I want to select the last period of the expansion as well as
%the contraction.
for t=1:T-1
    if recess(t+1)==1
        recess(t) = 1;
    end
end


S = [];
temp = [];

for t = 1:T
    if recess(t) == 1
        temp = vertcat(temp,x(t));
    elseif recess(t) ~= 1 && length(temp) > 1

        TC = length(temp);
        rhs = horzcat(ones(TC,1),[1:TC]');
        b = inv(rhs' * rhs) * rhs' * temp;
        S = vertcat(S, b(2));
        temp = [];
    end
end