function tables345(totalOutput, table)

ipm = totalOutput;
toWidth = size(ipm,2);

%select just our turning point and detrending methods
if nargin < 2 || table ~= 5
    %trends 3 - 6
    ipm = reshape(ipm(logical(repmat(((ipm(:,1) > 2) .* (ipm(:,1) < 7)),1,toWidth))),sum((ipm(:,1) > 2) .* (ipm(:,1) < 7)),toWidth);
elseif nargin > 1 && table == 5
    %replace the standard bandpass with the (2,80) one
    ipm = reshape(ipm(logical(repmat(((ipm(:,1) > 3) .* (ipm(:,1) <= 7)),1,toWidth))),sum((ipm(:,1) > 3) .* (ipm(:,1) <= 7)),toWidth);
end


%turning points 1-4
if nargin < 2 || table ~= 4
    ipm = reshape(ipm(repmat((ipm(:,2) > 0),1,toWidth)),sum(ipm(:,2)>0),toWidth);
elseif table == 4
    ipm = reshape(ipm(repmat(logical((ipm(:,2) > 0) .* (ipm(:,2) < 4)),1,toWidth)),sum(logical((ipm(:,2)>0) .* (ipm(:,2) < 4))),toWidth);
end




%DURATION
q = 1;
iTemp = reshape(ipm(repmat((ipm(:,3) == q),1,toWidth)),sum(ipm(:,3)==q),toWidth);


%average quantities are in columns 4 and 5
iAvg = iTemp(:,4:5);


%w-stat pvalues are in column 7 t-stat pvalues are in column 10
iWp = iTemp(:,7); iTp = iTemp(:,10);



TABLE5 = [mean(iAvg(:,1)-iAvg(:,2)); sum(iWp < 0.1); sum(iTp < 0.1); sum(iWp < 0.05); sum(iTp < 0.05); sum(iWp < 0.01); sum(iTp < 0.01)];
              
                  
                  
                  

%STEEPNESS
q = 3;
iTemp = reshape(ipm(repmat((ipm(:,3) == q),1,toWidth)),sum(ipm(:,3)==q),toWidth);

%average quantities are in columns 4 and 5
iAvg = iTemp(:,4:5);

%w-stat pvalues are in column 7 t-stat pvalues are in column 10
iWp = iTemp(:,7); iTp = iTemp(:,10);

TABLE5 = [TABLE5 [mean(iAvg(:,1)-iAvg(:,2)); sum(iWp < 0.1); sum(iTp < 0.1); sum(iWp < 0.05); sum(iTp < 0.05); sum(iWp < 0.01); sum(iTp < 0.01)]]; 
              

%SHARPNESS
q = 4;
iTemp = reshape(ipm(repmat((ipm(:,3) == q),1,toWidth)),sum(ipm(:,3)==q),toWidth);

%average quantities are in columns 4 and 5
iAvg = iTemp(:,4:5);

%w-stat pvalues are in column 7 t-stat pvalues are in column 10
iWp = iTemp(:,7); iTp = iTemp(:,10);

TABLE5 = [TABLE5 [mean(iAvg(:,1)-iAvg(:,2)); sum(iWp < 0.1); sum(iTp < 0.1); sum(iWp < 0.05); sum(iTp < 0.05); sum(iWp < 0.01); sum(iTp < 0.01)]]; 
              
                  

%SLOPE
q = 5;
iTemp = reshape(ipm(repmat((ipm(:,3) == q),1,toWidth)),sum(ipm(:,3)==q),toWidth);

%average quantities are in columns 4 and 5
iAvg = iTemp(:,4:5);

%w-stat pvalues are in column 7 t-stat pvalues are in column 10
iWp = iTemp(:,7); iTp = iTemp(:,10);


TABLE5 = [TABLE5 [mean(iAvg(:,1)-iAvg(:,2)); sum(iWp < 0.1); sum(iTp < 0.1); sum(iWp < 0.05); sum(iTp < 0.05); sum(iWp < 0.01); sum(iTp < 0.01)]];                  

disp('      Duration      Steepness     Sharpness     Slope');
disp([strvcat('avg diff','W 10%','t 10%','W 5%','t 5%','W 1%','t 1%') num2str(TABLE5)]);