function output = wilcoxon_altTest(xF, r, mu)
%this function computes averages and does a wilcoxon rank sum test for each
%of the five quantities (duration, depth, steepness, sharpness, slope).
%Modified 11-12-05 to also do a basic t-test
%Modified 11-30-06 to compare across series
        
       
         
        %duration
        [p,ranksum,wtStat,tstat,tpval] = wilcTest(duration(r) + mu(1),duration(~r),1);
        output = horzcat(mean(duration(r)),mean(duration(~r)),ranksum,p,wtStat,tstat,tpval);
        %depth
        [p,ranksum,wtStat,tstat,tpval] = wilcTest(abs(depth(xF,r))+mu(2),abs(depth(xF,~r)),1);
        output = vertcat(output,horzcat(mean(depth(xF,r)),mean(depth(xF,~r)),ranksum,p,wtStat,tstat,tpval));
        %steepness
        [p,ranksum,wtStat,tstat,tpval] = wilcTest(abs(steepness(xF,r))+mu(3),abs(steepness(xF,~r)),1);
        output = vertcat(output,horzcat(mean(steepness(xF,r)),mean(steepness(xF,~r)),ranksum,p,wtStat,tstat,tpval));
        %sharpness
        [p,ranksum,wtStat,tstat,tpval] = wilcTest(abs(sharpness(xF,r))+mu(4),abs(sharpness(xF,~r)),1);
        output = vertcat(output,horzcat(mean(sharpness(xF,r)),mean(sharpness(xF,~r)),ranksum,p,wtStat,tstat,tpval));
        %slope
        [p,ranksum,wtStat,tstat,tpval] = wilcTest(abs(slope(xF,r))+mu(5),abs(slope(xF,~r)),1);
        output = vertcat(output,horzcat(mean(slope(xF,r)),mean(slope(xF,~r)),ranksum,p,wtStat,tstat,tpval));
        





function  [pval, ranksum, wtStat, tstat, tpval] = wilcTest(x,y,oneSided)
%TEST2R   Test for equal location of two samples using rank test
%         
%         [pval, ranksum] = test1r(x,y)
%         
%         This is the Wilcoxon-Mann-Whitney test. It is two sided. 
%         If you want a one sided alternative then devide pval by 2.
%
%
%       Anders Holtsberg, 18-11-93
%       Copyright (c) Anders Holtsberg
%
%       modified by Alisdair:
%       oneSided = 1 tests the alternative that x is shifted
%       above y (i.e. the median of x is above that of y).
%
%       wtStat is an approximate t-statistic. It is reliable when x and y
%       both have 8 or more elements.



x = x(:);
%x = x(find(x~=0));
y = y(:);
%y = y(find(y~=0));
n = length(x);
m = length(y);
mP = ceil((m*n+1)/2);
P = zeros(mP,n+1);
P(1,:) = P(1,:) + 1;
for i=1:m
   for j = 1:n
      P(:,j+1) = (P(:,j+1)*i + [zeros(min(i,mP),1); P(1:mP-i,j)]*j)/(i+j);
   end
end



P = P(:,n+1);

% --- count number of y's less than x's ---

    [z, I] = sort([x;y]);
R = 1:m+n;
r = sum(R(find(I<=n)));
ranksum = r;

% --- and the propability under the null hypothesis of that 
%     outome or worse is ... 

r = r - n*(n+1)/2;
r = min(r,m*n-r);
pval = min(2*sum(P(1:r+1)),1);

%tStatApprox = (ranksum - n*(n+m+1)/2)/sqrt(n*m*(n+m+1)/12);

if nargin > 2 && oneSided == 1
    
    pval = pval / 2;
    
    lb = n*(n+1) /2;
    ub = (n+m) * (n+m+1)/2 - m*(m+1)/2;
    
    if ranksum < mean([lb;ub])
        pval = 1 - pval;
    end
end

%disp(horzcat('m,n: ',num2str(m),',',num2str(n)));
%disp(cumsum(P));



RxBar = ranksum/n;
RyBar = (sum(R) - ranksum) / m;

sStar = (n+m-2)^(-1/2) * ( sum((R(find(I<=n)) - RxBar).^2) + sum((R(find(I>n)) - RyBar).^2) ) ^(1/2);

wtStat = (n*m/(n+m))^(1/2)*((RxBar - RyBar)/sStar);

%compute tstat and tpval
xbar = mean(x);     %n
ybar = mean(y);     %m
sx = sum((x - xbar).^2);
sy = sum((y - ybar).^2);
tstat = ((n + m - 2)^(1/2) * (xbar - ybar))/((1/m + 1/n)^(1/2)*(sx + sy)^(1/2));
%tpval = 1-pt(tstat,m+n-2);
tpval = 1-pnorm(tstat);

if tpval > .5; tpval = 1 - tpval; end
if pval > .5; pval = 1 - pval; end

