function D = depth(x,recess)
%This function takes a time series y and a vector indication contractions
%(recess) and then calculates the depth of each of the contractions and
%returns them in the vector D.  Note that the length of D is equal to the
%number of discreet (and complete contractions).

T = length(x);

temp = zeros(T-1,1);

peak = recess(2:T) - recess(1:T-1) == 1;
trough = recess(2:T) - recess(1:T-1) == -1;
trough(1) = 0; 
    

x = x(2:T);   %THIS LINE MODIFIED ON 1/4/07

for t=1:T-1
    if peak(t) == 1;
        temp(t) = x(t);
    elseif t==1
        temp(t) = x(t);
    else
        temp(t) = temp(t-1);
    end
end


D = x - temp;

D = D(logical(trough));