function [N1 Nss] = getPolicy_12(s,VN_N_s,VN_N_sPlus1)


global NGrid beta chi nu mu r T z;



%step one: find steady state

Nssr = @(x)(nu*((chi*x).^(1-1/nu)).*( (1-x).*(T(s) - 1) - z + mu(s)*interp1(NGrid,VN_N_sPlus1,x,'linear','extrap')) - (r + chi + mu(s)));  %Change the VN(:,1,s+1)

Nss = fzero(Nssr,[0.5 1]);



N1 = -99*ones(size(NGrid));


for i = 1:length(NGrid)

    
    %first fire if necessary
    if VN_N_s(i) <= -beta
        N1(i) = N1(i-1);
    else
        [t, Y] = ode45(@vnDotNDot,[0 1], [VN_N_s(i);NGrid(i)],[],s,VN_N_sPlus1);
        %plot(t,Y)
        
        
        N1(i) = Y(end,2);
    end
end


        


function dy = vnDotNDot(t,y,s,VN_N_sPlus1)
%this computes the time derivative of y
% y = [Vn; N]

global z rho nu chi T NGrid mu;

Vn = y(1);
N = y(2);

H = (nu*max(Vn,0)).^(nu/(1-nu));

dy = [z - (1-N)*(T(s)-1) + (rho+chi+mu(s))*Vn...
    - mu(s)*interp1(NGrid,VN_N_sPlus1,N,'linear','extrap');  ...
    H-chi*N];
