function [NPathOut VNPathOut TimeGrid s3] = getPolicy_3(VN_N_3_0, sVec, phase)
%compute the policy rule


global NGrid beta chi;

nN = length(NGrid);

TimeGrid = [0:.05:1];
sOut = zeros(size(NGrid));
NPathOut = zeros(nN,size(TimeGrid,2));
VNPathOut = zeros(size(NPathOut));
s3 = sVec;

for i = 1:nN  %loop over the NGrid points

    if VN_N_3_0(i) <= -beta
        NPathOut(i,:) = NPathOut(i-1,:);
        VNPathOut(i,:) = VNPathOut(i-1,:);
        s3(i) = s3(i-1);
    else
        %shoot
        if phase(i) == 1
            [t,NPath, VNPath] = shoot(VN_N_3_0(i), NGrid(i),sVec(i));
            NPathOut(i,:) = interp1(t,NPath,sVec(i)*TimeGrid,'linear','extrap');
            VNPathOut(i,:) = interp1(t,VNPath,sVec(i)*TimeGrid,'linear','extrap');
        else
            [t,NPath, VNPath] = shootExog(VN_N_3_0(i), NGrid(i),sVec(i));
            NPathOut(i,:) = interp1(t,NPath,sVec(i)*TimeGrid,'linear','extrap');
            VNPathOut(i,:) = interp1(t,VNPath,sVec(i)*TimeGrid,'linear','extrap');
        end
    end
    
end







%------Shooting Functions-----------------------


function [t, N, VN] = shoot(VN0, N0,s)
%solve a sytem of two ODEs with the initial condition VN0, N0
%The system is VNdot and Ndot
%[s VN0 N0]
[t, Y] = ode45(@VNdotNdot,[0, s],[VN0;N0]);
VN = Y(:,1);
N = Y(:,2);


function dydt = VNdotNdot(t,y)
%evaluate the ode function for y=[VN;N]
VN = y(1); N = y(2);
global chi z T rho nu;
H = (nu * max(VN,0))^(nu/(1-nu));
dydt = [z-(1-N)*(T(3)-1)+(rho+chi)*VN ; H-chi*N];
        


function [t, N, VN] = shootExog(VN0, N0,s)
%solve a sytem of two ODEs with the initial condition VN0, N0
%The system is VNdot and Ndot
%[s VN0 N0]
[t, Y] = ode45(@VNdotNdotExog,[0, s],[VN0;N0]);
VN = Y(:,1);
N = Y(:,2);


function dydt = VNdotNdotExog(t,y)
%evaluate the ode function for y=[VN;N]
VN = y(1); N = y(2);
global chi z T rho nu;
H = 0;
dydt = [z-(1-N)*(T(3)-1)+(rho+chi)*VN ; H-chi*N];
        
