function VN_N_s = getVN_N_12(s,VN_N_23,VN_N_31)
%This function takes the marginal value of employees in stage 2 or 3 and
%computes the same for stage 1 or 2 (indicated by s);  if s is 1 the
%VN_N_23 should be VN_N_2 and if s is 2 then VN_N_23 should be VN_N_3

global nu chi T mu NGrid r z beta;

%step one: find steady state
%have to reset this function handle inside the loop because it depends on s
Nssr = @(x)(nu*((chi*x).^(1-1/nu)).*( (1-x).*(T(s) - 1) - z + mu(s)*interp1(NGrid,VN_N_23,x,'linear','extrap')) - (r + chi + mu(s)));  %Change the VN(:,1,s+1)

Nss = fzero(Nssr,[0.5 1])
Hss = chi * Nss


%step two: set up the linearized system around the steady-state
%for this I need the second derivative (this comes up again later)
VNN = @(n,vn,st,Nubst1)(((1-n)*(T(st)-1)-z-(r+chi+mu(st))*vn + mu(st)*interp1(NGrid,VN_N_31,n,'linear','extrap'))/(chi*n - ((nu*max(vn,0))^(nu/(1-nu))) + (n-Nubst1)));
A = zeros(2);
A(1,1) = (r+chi+mu(s))/(1/nu - 1) - ((2 - 1/nu)*(Hss^(1-1/nu))*( (1-Nss)*(T(s)-1) - z + mu(s)*interp1(NGrid,VN_N_23,Nss,'linear','extrap')))*nu/(1/nu - 1);  %dHdot/dH
temp = min(find(VN_N_23 == -beta));
if isempty(temp)
    Nubs1 = 1;
else
    Nubs1 = NGrid(temp);
end
A(1,2) = ( (Hss^(2-1/nu)) *(T(s) -1 -mu(s)*VNN(Nss,interp1(NGrid,VN_N_23,Nss,'linear'),s+1,Nubs1))*nu/(1/nu - 1));  %dHdot/dN
A(2,1) = 1; %dNdot/dH
A(2,2) = -chi;%dNdot/dN

%interp1(NGrid,VN_N_23,Nss,'linear')
A

[V D] = eig(A);
temp = find(diag(D)<0);
if size(temp,1) > 1
    disp('Error: No unstable arm');
end
negEigVec = V(:,temp);
negEigVecSlope = negEigVec(1)/negEigVec(2);  %in H/N terms


%step three: use the time elimination method to solve for the stable arm
%(calls Hprime.m)
%solve for N < Nss
Hprime_reversed = @(n,h,s,Nss,negEigVecSlope, VN_N_23)(-Hprime(-n,h,s,Nss,negEigVecSlope, VN_N_23));
[t, H1] = ode45(Hprime_reversed,[-Nss,-NGrid(1)],Hss,[],s,Nss,negEigVecSlope, VN_N_23);
[N1, I] = sort(-t);
H1 = H1(I);


%solve for N > Nss
[N2, H2] = ode45(@Hprime,[Nss,NGrid(end)],Hss,[],s,Nss,negEigVecSlope, VN_N_23);  %note that when you pass function in an m-file you need to use the @ symbol
N2 = N2(2:end); H2 = H2(2:end);  %we don't need to replicate the Nss value


%H2(abs(imag(H2))>0) = 0;
%H2(real(H2) < 0) = 0;



%combine the two solutions
Nt = [N1; N2];
Ht = [H1; H2];

%step four: compute Nlb ("N lower bar")
if Ht(end) > 0
    Nlb = Nt(end);
else
   % Nlb = interp1(Ht(Ht>0),Nt(Ht>0),0,'linear','extrap');
   Nlb = Nt(min(find(Ht <=0)));
end


%step five: compute VN for N in the region N < Nlb
I = Nt<Nlb;
Nt=Nt(I); 
Ht=Ht(I);

I = logical([1; abs(diff(Nt)) > 0.0001]);
Nt=Nt(I); 
Ht=Ht(I);
VNt = (1/nu)*Ht.^(1/nu-1);


%step six: compute VN for N > Nlb using the envelope theorem as ODE and
%VN(Nlb)=0 as initial condition
if Nlb < NGrid(end)
    VNN = @(n,vn,st)(((1-n)*(T(st)-1)-z-(r+chi+mu(st))*vn + mu(st)*interp1(NGrid,VN_N_23,n,'linear','extrap'))/(chi*n));%only valid when H=0, F=0
    [t,Y] = ode45(VNN,[Nlb,NGrid(end)],0,[],s);
    %add the solution to the solution to the other region
    Nt = [Nt; t];
    Ht = [Ht; zeros(size(t))];
    VNt = [VNt; Y];
end

%[Nt VNt Nt < Nlb]

%step seven: find Nub ("N upper bar") as the point at which VN reaches
%-beta.  Above this point VN = -beta.
Nub = interp1(VNt,Nt,-beta,'linear','extrap');
if Nub > 1, Nub = 1; end
VNt(Nt>Nub) = -beta;
if isempty(find(Nt==Nub))  %make sure Nub is on the Nt grid
    Nt = [Nt; Nub]; VNt = [VNt; -beta]; Ht = [Ht; 0]; [Nt, I] = sort(Nt); VNt = VNt(I); Ht = Ht(I);
end


%step eight: all variables are on grid Nt.  convert to N grid
VN_N_s = interp1(Nt,VNt,NGrid,'linear');
%H(:,1,s) = interp1(Nt,Ht,NGrid,'linear');
%F(:,1,s) = max(0,NGrid-Nub);

%plot(Nt,Ht);