function [VN_N_3_0 sVec phaseOut] = getVN_N_3_0(VN_N_1)
%this function takes a vector VN_N_1 of marginal values in stage 1 and
%returns a vector of marginal values at the beginning of stage 3.

global NGrid beta chi g T kappa;

nN = length(NGrid);

VN_N_3_0 = zeros(size(NGrid));
sVec = zeros(size(NGrid));
phaseOut = zeros(size(NGrid));


%some infrastructure---
smax = (1/g)* log( (T(3)^2 - T(1)^2)/(2*kappa*(T(3)-1))) 
smin = (1/g)* log( (T(3) - T(1))/(2*kappa)) 
slb = max(0.01,smin+0.01);
sub = 10;



phase = 1;
for i = 1:nN  %loop over the NGrid points

    [i NGrid(i)]


    %condition on s for there not to be firing (should be positive
    noFiringCondition = @(st)( 1 + ( 1 - NGrid(i)*exp(-chi*st) ) * ( T(3) - 1 ) - eq61IntegralInv(kappa*exp(st*g) ));

   
    
    if phase == 3
        VN_N_3_0(i) = VN_N_3_0(i-1);
        sVec(i) = sVec(i-1);
    else
        
        
        
        %count the sign changes assuming that the function is somewhat smooth
        temp = noFiringCondition([slb:1:sub]');
        %plot([slb:1:sub]', temp);
        signChanges = sum(sign(temp(2:end)) ~= sign(temp(1:end-1)));


        if signChanges > 1
            disp('Many sign changes');
            plot(temp);
            return
        elseif signChanges == 0
            s0 = fzero(noFiringCondition,slb);
            [t, VNPath] = exogSepGetVNPath(getNs(s0),s0,VN_N_1);         
            
            if noFiringCondition(slb) >= 0
                disp('search over [slb, sub]');
                
                sVec(i) = gets(NGrid(i),VN_N_1,slb,sub);
                phaseOut(i) = 1;    
            end
                
                
                
              
        elseif signChanges == 1
            s0 = fzero(noFiringCondition,[slb, sub]);
            if noFiringCondition(slb) >= 0
                disp(['search over [slb, ' num2str(s0) ']']);
                
                [t, VNPath] = exogSepGetVNPath(getNs(s0),s0,VN_N_1);
                if max(VNPath) <= 0  && min(VNPath) >= -beta
                    VN_N_3_0(i) = VNPath(1);
                    sVec(i) = s0;
                    phase = 2;phaseOut(i) = 2;
                elseif max(VNPath) > 0
                    sVec(i) = gets(NGrid(i),VN_N_1,slb,s0-0.05);
                    
                    phaseOut(i) = 1;
                    
                    if sVec(i) == -1 %no solution to the hiring problem
                        VN_N_3_0(i) = VNPath(1);
                        sVec(i) = s0;
                        phase = 2; phaseOut(i) = 2;
                    end
                    
                else
                    disp('Fire');
                    phase = 3; phaseOut(i) = 3;
                    sVec(i) = sVec(i-1);
                end
                
            else
                disp(['search over [' num2str(s0) ', sub]']);
                [t, VNPath] = exogSepGetVNPath(getNs(s0),s0,VN_N_1);
                                                                
                if max(VNPath) <= 0  && min(VNPath) >= -beta
                    VN_N_3_0(i) = VNPath(1);
                    sVec(i) = s0;
                    phase = 2;phaseOut(i) = 2;
                elseif max(VNPath) > 0
                    %we know we need to hire                
                    disp('here')
                    sVec(i) = gets(NGrid(i),VN_N_1,s0+0.001,sub);
                    phaseOut(i) = 1;
                    %sVec(i) = gets(NGrid(i),VN_N_1,slb,sub,smax);
                    %if sVec(i) < s0, disp('This case confuses me'); end
                else
                    disp('Fire');
                    phase = 3; phaseOut(i) = 3;
                    sVec(i) = sVec(i-1);
                end
                
            end
        end
    
        
        
        if phase == 1  && sVec(i) >0
            VN_N_3_0(i) = fzero(@shotAttempt,0,[],NGrid(i),sVec(i),getNs(sVec(i)));
        elseif phase ==2
            phase = 1;  %just check the next ones as it is quick
        else
            VN_N_3_0(i) = -beta;
        end
        
        if VN_N_3_0(i) <= -beta 
            VN_N_3_0(i) = -beta;
            phase = 3;phaseOut(i) = 3;
        end
        
    end
    
    [VN_N_3_0(i) sVec(i)]
    
    
end











%--------------------BELOW HERE ARE FUNCTIONS TO COMPUTE VN(N0,3,0) given an N0

function x = eq61IntegralInv(y)
global T;
x=(sqrt(  T(1)^2- (2*y- (T(3)^2-T(1)^2) ) / (1-(T(3)-1)/(T(1)-1))   ));

function y = eq61Integral(x)
global T;
y=( ( 0.5*(T(1)^2-x.^2)*(1/(T(3)-1)-1/(T(1)-1)) + 0.5*(T(3)^2-T(1)^2)*(1/(T(3)-1))));


function Ns = getNs(s)
global T g kappa;
xs = eq61IntegralInv(kappa*exp(s*g));
Ns = 1 - (xs - 1)/(T(3) - 1);



    
%------Shooting Functions for Hiring Phase-----------------------

function [s] = gets(N0,VNs,slb,sub)
disp(['gets: slb ' num2str(slb) ' ' num2str(sub)])
optnew = optimset('TolX',1e-3);
if  sign(sAttempt(slb,N0,VNs)) * sign(sAttempt(sub,N0,VNs)) == -1
    s = fzero(@sAttempt,[slb, sub],optnew,N0,VNs);
else
    disp('do a brute force search');
    er = 1;
    blb = slb;
    bub = sub;
    while er > 1e-3 && (bub-blb) > 1e-3
        temp2 = linspace(blb,bub,21);
        for j = 1:21
            temp(j) = sAttempt(temp2(j),N0,VNs);
        end
        %plot(temp2,temp); pause;
        temp = abs(temp);
        blb = temp2(min(find(temp==min(temp)))) - (bub - blb)/21;
        bub = temp2(min(find(temp==min(temp)))) + (bub - blb)/21;
        er = min(temp);
    end
    if er <= 1e-3
        s = temp2(min(find(temp==min(temp))));
    else
        disp('search failed');
        s = -1;
    end
end




function res = sAttempt(s,N0,VNs)
global NGrid beta;
%solve the shooting problem for a given s and see if it hits VNs
%N0
Ns = getNs(s);
%disp('--');
%VN0 = fzero(@shotAttempt,[-beta, 1],[],N0,s,Ns);  %I'm unsure about the bounds of this line 
VN0 = fzero(@shotAttempt,0,[],N0,s,Ns);  %I'm unsure about the bounds of this line  was [-2*beta, 2] now just give a point of zero
[t, N, VN] = shoot(VN0, N0,s);
res = VN(end) - interp1(NGrid,VNs,Ns,'linear','extrap'); %extrap is only for endpoints

    




function resNs = shotAttempt(VN0, N0,s,Ns)
%take an VN0 and make an attempt and evaluate the results
%[VN0, N0,s,Ns]
[t, N, VN] = shoot(VN0, N0,s);
resNs = N(end) - Ns;

function [t, N, VN] = shoot(VN0, N0,s)
%[VN0 N0]
%solve a sytem of two ODEs with the initial condition VN0, N0
%The system is VNdot and Ndot
[t, Y] = ode45(@VNdotNdot,[0, s],[VN0;N0]);
VN = Y(:,1);
N = Y(:,2);


function dydt = VNdotNdot(t,y)
%evaluate the ode function for y=[VN;N]
VN = y(1); N = y(2);
global chi z T rho nu;
if VN > 0
    H = (nu * VN)^(nu/(1-nu));
else
    H=0;
end
if H<1e3
    dydt = [z-(1-N)*(T(3)-1)+(rho+chi)*VN ; H-chi*N];
else
    disp('Function exploding');
    return;
end
        



%----------------------------- Exogenous Separation Functions
function [t, VNPath] = exogSepGetVNPath(Ns,s,VNs)
%this function solves backwards from VNs to find the path of VN.  It
%assumes we are in the exogenous separation phase.
global chi z T g kappa rho NGrid;


VNdot = @(sLESSt,VNt)(-( 1+ z -(1+(1-Ns*exp((sLESSt)*chi))*(T(3)-1)) + (rho+chi)*VNt ));
%VNdot_reversed = @(sLESSt,VNt)(-VNdot(sLESSt,VNt));
[tt,Y] = ode45(VNdot,[0, s], interp1(NGrid, VNs,Ns,'linear','extrap'));  %extap for endpoints
[t, I] = sort(-tt+s);
VNPath = Y(I);







