function [react Y_bgp L_bgp] = logLin(s)
%takes a stage for the economy (1, 2, or 3) and returns the reaction
%function in terms of matrix of where the columns represent the state
%variables constant, log(K), log(A), and xi (log of deviation of trend from smooth
%trend) and the rows are the decision variables and things affected by them
%kp,E[cp],l,c.  So it is 4x4
%The second result (Y_bgp) is the detrened level of output on the balanced
%growth path and similarly for the third

global alpha rho gamma prodAR b mu delta g;

B = 1/(1+rho);  %discount for log-lin

%compute the BGP
C_bgp = (alpha/b) * (((exp(gamma)/B)-1+delta)/(1-alpha))^((alpha-1)/alpha);
K_bgp = C_bgp/( (alpha/(b*C_bgp))^(alpha/(1-alpha)) +1 - delta - exp(gamma) );
L_bgp = (alpha/(b*C_bgp))^(1/(1-alpha))*K_bgp;
Y_bgp = L_bgp^alpha * K_bgp^(1-alpha);

%disp('consumption-output ratio')
%C_bgp/Y_bgp



%Solve the system using the method of undetermined coefficients
%I first solve the real side then the nominal side.

%declare the symbolic variables (xp denotes E_t(x_t+1) for variable x)
syms k kp c cp l lp z zpr xi xip a ap phi_ca phi_ck phi_cxi phi_c1;
%the variable zpr should just be called zp but there is a native function
%called zp, which may conflict with it.  Not a problem in Windows, but
%seems to be in Unix version.

%Input the system variable in parenthesis is equated to the expression
f1 = (( (1-alpha)*Y_bgp+(1-delta)*K_bgp )/(Y_bgp-C_bgp+(1-delta)*K_bgp))*k...
    + (( alpha*Y_bgp )/(Y_bgp-C_bgp+(1-delta)*K_bgp))*l...
    -(( C_bgp )/(Y_bgp-C_bgp+(1-delta)*K_bgp))*c; %capital next period (kp)
f2 =  c + (((1-alpha)*alpha*L_bgp^alpha*K_bgp^(-alpha))/((1-alpha)*L_bgp^alpha*K_bgp^(-alpha)+1-delta))*(lp-kp-zpr);  %consumption next period (cp)
f3 = k + (alpha/(1-alpha))*(z-c); %labor supply (l)
f4 = cp; %Left hand side of the Euler equation (needed for matching coefficients)
f = [f1; f2; f3; f4];


%eliminate l
f = subs(f,l,f(3));
temp = subs(f(3),{k,z,c},{kp,zpr,cp});
f = subs(f,lp,temp);


%eliminate z and zpr
temp = xi + a; %def of z
f = subs(f,z,temp);
temp = xip + ap; %def of zpr
f = subs(f,zpr,temp);


%eliminate c variables
eulerLHS = phi_cxi * xip + phi_ca * ap + phi_ck * kp + phi_c1;
f = subs(f,cp,eulerLHS); %plug in for cp
f=subs(f,c,phi_cxi * xi + phi_ca * a  + phi_ck * k + phi_c1);



%eliminate expectations
f = subs(f,kp,f(1));
f = subs(f,xip,prodAR*xi);
temp = a + g * ((s<3)*((1-mu(s))*(-1)^(s)+mu(s)*(-1)^(s+1)) - (s==3));
f = subs(f,ap,temp);



%match coefficients in the seventh and second expressions, which represent
%the LHS and RHS of my Euler equation, respectively.
coef_a = [diff(f(4),'a') diff(f(2),'a')];
coef_k = [diff(f(4),'k') diff(f(2),'k')];
coef_xi = [diff(f(4),'xi') diff(f(2),'xi')];
temp = subs(f,{k,a,xi},{0,0,0});
coef_1 = [temp(4) temp(2)];

coef = [coef_a; coef_k; coef_xi; coef_1];
clear coef_a coef_k coef_xi coef_1;

%solve for phi_ck and eliminate
solution_phi_ck = solve(coef(2,1)-coef(2,2),'phi_ck');

%there are two solutions for phi_ck so test to see which makes the capital
%stock stable
temp1 = subs(f(1),phi_ck,solution_phi_ck(1));
temp2 = subs(f(1),phi_ck,solution_phi_ck(2));

dkpdk1 = double(diff(temp1,'k'));
dkpdk2 = double(diff(temp2,'k'));

if dkpdk1 > 1 && dkpdk2 < 1
    solution_phi_ck = solution_phi_ck(2);
elseif dkpdk1 < 1 && dkpdk2 > 1
    solution_phi_ck = solution_phi_ck(1);
else
    disp('Either there are two stable solutions for capital or none.');
end

%plug in for the stable solution
coef = subs(coef,phi_ck,solution_phi_ck);

%solve for phi_ca
solution_phi_ca = solve(coef(1,1)-coef(1,2),'phi_ca');

%solve for phi_cxi
solution_phi_cxi = solve(coef(3,1)-coef(3,2),'phi_cxi');

coef = subs(coef,{phi_ca, phi_cxi},{solution_phi_ca, solution_phi_cxi});
solution_phi_c1 = solve(coef(4,1)-coef(4,2),'phi_c1');


%substitute out the solutions to find the response of capital and labor
%supply
f=subs(f,{phi_ca,phi_ck,phi_cxi, phi_c1},{solution_phi_ca,solution_phi_ck,solution_phi_cxi,solution_phi_c1});



    



%store the decision functions in the following matrix
%reactij is reaction of i={y;cp;n;kp;m;piep} to j={a,k,mu}
upDown = [kp,cp,l];  %can leave off the last two as they are redundant
leftRight = [k;a;xi];
react = zeros(length(upDown),length(leftRight));
for i = 1:length(upDown) 
    for j = 1:length(leftRight)
        react(i,j) = double(diff(f(i),leftRight(j)));
    end
end
%and add the constants
temp = subs(f,{k,a,xi},{0,0,0});
react = [ temp(1:3) react];
%c is given by its solution
react = [react; [double(solution_phi_c1) double(solution_phi_ck), double(solution_phi_ca), double(solution_phi_cxi)]];




disp(' ');
disp('Solution:');
disp('Variable on row as a linear function of variables in columns')
disp('             1          k           a          xi');
disp([['kp   = ';
       'cp   = ';
       'l    = ';
       'c    = ']  num2str(react)]);
disp(' ');
   
 