function m = moments_3(x,unemp,totalHours)


trend = rotemberg(x);

%disp('Variance of detrended output');
detrendedOutput = x - trend;
m(1) = var(detrendedOutput);

%disp('Variance of the employment rate');
temp = (1 - unemp/100);
dte = temp -rotemberg(temp);
m(2) = var(dte);

%disp('Avg. unemployment rate');
m(3) = mean(unemp/100);

%disp('Variance of 1st diff of emp rate');   
m(4) = 1000*var(diff(dte));


%labor productivity
labProd = x - log(totalHours);
dtlp = labProd - rotemberg(labProd);
m(5) = std(dtlp);


%compute variance of total hours
dtth = log(totalHours)-rotemberg(log(totalHours));
m(6) = var(dtth);