function [m gamma prodAR sigma] = moments_data()

% Compute moments in the data
%clc
load ../appendix_results/data/quarterly;

x = log(gdp);

trend = rotemberg(x);


[beta sigma sigmaReg]=ols(trend(2:end),[ones(length(trend)-1,1) trend(1:end-1)]);

%disp('Average output growth')
gamma = beta(1);

%disp('Mean-reversion of trend productivity shocks')
prodAR = beta(2);

%disp('Std. Dev. of trend productivity shocks')
sigma = sigmaReg;

%disp('Variance of detrended output');
detrendedOutput = x - trend;
m(1) = var(detrendedOutput);

%disp('Variance of the employment rate');
m(2) = var(1 - unemp/100);

%disp('Avg. unemployment rate');
m(3) = mean(unemp/100);


%disp('Variance of 1st diff of emp rate');
m(4) = 1000*var(diff(1-unemp/100));


%disp('Std Dev Output per Hour');
load ../appendix_results/data/laborMkt.mat;

labProd = log(gdp) - log(hours);
dtlp = labProd - rotemberg(labProd);

m(5) = std(dtlp);


%disp('var total hours')
dtth = log(hours)-rotemberg(log(hours));
m(6) = var(dtth);
