

clc; close all; clear all;

global alpha b delta gamma prodAR sigma nu r chi z T g kappa rho beta mu NGrid;


%------------------------
%Preferences
b = 0.675;
rho = 0.01;
%Technology
delta = 0.02;
alpha = 0.64;
%Productivity
gamma = 0.0143;
prodAR = 0.9993;
sigma = 0.0007;
%Tech. Adoption
g = 0.00353; 
mu(1) = 0.125;
mu(2) = 0.087;
mu(3) = 0;
%Labor Adjustment Params
beta = 0.05;
nu = 0.5;
chi = 1e-5;
%Specialization Params
z = 0.0445;
kappa = 0.2805;  %kappa =  0.326
T(2) = 1+1;   %F is uniform with support [1, T(s)] with s = 2 or 3
T(1) = 1+0.525; %Support of G is [1, T(s)] with s = 1   0.43
T(3) = T(2);

r = rho;  %get rid of this


%---------------------------

%solve the output side
react = zeros(4,4,3);  %response variables x states x stage
for stage = 1:3
    disp(['Log-linearizing stage ' num2str(stage)]);
    [temp Ytil Lhat] = logLin(stage);
    react(:,:,stage) = temp;
end


%solve the employment side
[NGrid,N1,N2,N3Path,s3,N3TimeGrid]=employmentSolve();
N1 = [N1 N2];

simT = 229;
nonstochSim


disp('number of cycles');
sum(diff(stage)==-2)

disp('fraction of sample in stage 2')
sum(stage==2)/simT



temp = N; temp(stage~=2) = NaN; plot(temp); hold on; temp = N; temp(stage~=1) = NaN; plot(temp); temp = N; temp(stage~=3) = NaN; plot(temp); hold off;




%--------------------------------------

%fully stochastic simulation of the model

simT =  229;  %sample length
nrep = 1000;  %number of repetitions 1000

simResults=zeros(2,7,nrep,2);
simCheck = zeros(nrep,2);
simMoments = zeros(nrep,6);

wbh = waitbar(0,'Simulating...');
for simj = 1:nrep

    %call simulation routine
    stochSim;
    
    %run our algorithms
    [oput, recGDP] = assym_detect(log(Y));  %first do output
    simResults(:,:,simj,1) = oput;
    [oput, recU] =assym_detect(log(N));  %then the employment rate
    simResults(:,:,simj,2) = oput;
    

    %check that the cycle has the right number of cycles
    simCheck(simj,1) = sum(diff(stage)==-2);  %    disp('number of cycles');
    simCheck(simj,2) = sum(stage==2)/simT;  %disp('fraction of sample in stage 2')
    
    %compute moments
    %simMoments(simj,:) = moments_3(log(Y),(1-N)*100,N.*(1+l_t),(1+l_t));
    simMoments(simj,:) = moments_3(log(Y),(1-N)*100,N.*(1+l_t));
    
   
    waitbar(simj/nrep,wbh);
end
close(wbh);

meanSimResults = squeeze(mean(simResults,3));

rowNames = strvcat('Duration ', 'Steepness ');

disp('Mean simulation results: output');
disp('            avg. contr.    avg. expan.       W-stat     p-value      Wilc t-stat   Basic t-stat  p-value');
disp(horzcat(rowNames,num2str(meanSimResults(:,:,1))));
disp(' ');
disp('Mean simulation results: employment');
disp('            avg. contr.    avg. expan.       W-stat     p-value      Wilc t-stat   Basic t-stat  p-value');
disp(horzcat(rowNames,num2str(meanSimResults(:,:,2))));


md = moments_data;
mm = mean(simMoments);

disp(' ');
disp('Moments: data, model');
disp('    var y     var n     mean u    var dn   std y/n   var h')
disp([md; mm]);


save r070109_15.mat;

%exit;
