function S = sharpness(x,recess)
%This function takes a time series x and a vector indication contractions
%(recess) and then calculates the sharpness of each of the contractions and
%returns them in the vector S.  Note that the length of S is equal to the
%number of discreet (and complete contractions).  Sharpness is the square
%root of the average squared change in x during a contraction.  This too is
%implemented as a special case of depth where the time series is
%transformed to be the cumulative sum of the squared first differences.

T = length(x);

if length(recess) ~= T
    disp('Error in sharpness function: vectors must be of same length');
end

dx2 = ( x(2:T) - x(1:T-1) ).^2;

S = ( depth(cumsum(dx2),recess(2:T)) ./ duration(recess(2:T)) ) .^ 0.5 ;

