%stochastic simulation
x = zeros(simT+100,4); % xt = [kp E(cp) l c];
N = zeros(simT+100,1);
state = zeros(simT+100,3);  %statet = [k a xi]  is the state for the output problem
stage = zeros(simT+100,1);  %is the stage of the economy (1, 2 or 3)

%initialize
state(1,:) = [0 0 0];
stage(1) = 2;
x(1,:) = [1 state(1,:)] * react(:,:,stage(1))';
N(1) = NGrid(round(length(NGrid)/2));

%iterate through and get the stage switches and employment
for t = 2:simT + 100  %the one-hundred is a burn-in period
        if N(t) == 0 %i.e. it hasn't already been filled in
        if stage(t-1) < 3
            if rand(1,1) < mu(stage(t-1))
                stage(t) = stage(t-1)+1;
            else
                stage(t) = stage(t-1);
            end
        
            N(t) = interp1(NGrid,N1(:,stage(t-1)),N(t-1),'linear');
            
            %stay on the grid
            if N(t) > NGrid(end), N(t) = NGrid(end); end
            if N(t) < NGrid(1), N(t) = NGrid(1); end
        
        else
            sRaw = interp1(NGrid,s3,N(t-1),'linear','extrap');
            s = round(sRaw);
            if s < 1, s = 1; end
        
            for j = 1:s
                nearestTimeGridPoint = round((j/s)*size(N3TimeGrid,2));
                N(t-1+j) = interp1(NGrid,N3Path(:,nearestTimeGridPoint),N(t-1));
                stage(t-1+j) = 3;
            end
            stage(t-1+s) = 1;
        end
    end
end        



%now go through, read off the stage switches and simulate output
eps = sigma * randn(simT+100,1);  %productivity trend shocks
for t = 2:simT+100
    %update state
    state(t,:) = [x(t-1,1)  state(t-1,2)+((-1)^stage(t))*g  prodAR*state(t-1,3)+eps(t)];
    x(t,:) = [1 state(t,:)] * react(:,:,stage(t))';
end

%if we end in stage 3 we may go over simT
N = N(101:100+simT);
stage = stage(101:simT+100);
state = state(101:simT+100,:);
x = x(101:simT+100,:);



%calculate output
%we know k and l, which are give us y and then we can add in the trend and
%exponentiate
y = (1-alpha)*state(:,1) + alpha*(sum(state(:,2:3),2)+x(:,3));
Ytil_t = Ytil * exp(y);
Y = exp(gamma*[1:simT]').*Ytil_t;

%calc the mean maintenace cost
%y = (1-alpha)*state(:,1) + alpha*(sum(state(:,2),2)+x(:,3));
%Ytil_t = Ytil * exp(y);
%temp = exp(state(:,2));
%temp(stage==1) = 0;
%for foo = 1:length(temp)
%    if stage(foo) == 3
%        I = find(stage(foo:end)==1);
%        if length(I)==0, I = foo;end
%        temp(foo) = temp(min(I));
%    end
%end
%meanMaintFrac = mean(kappa*temp./Ytil_t);

%compute the overtime
Lhat_t = Lhat*exp(x(:,3));
x_t = 1+(1-N).*(transpose(T(stage))-1);  %lowest task used
skills_t = N.*(transpose(T(stage)) + x_t)/2; %average skill level times employment
l_t = (Lhat_t - skills_t + z*N + kappa.*(stage~=1))./N; %overtime per worker


%adj cost
%temp = diff(N);
%ac = (temp>-chi*N(1:end-1)).*(temp+chi*N(1:end-1)).^(1/nu) - (temp<-chi*N(1:end-1)).*beta.*(temp+chi*N(1:end-1));
%Y_cf= exp(gamma*[2:simT]').*Ytil_t(2:end).*((exp(x(2:end,3))+ac/Lhat)./(exp(x(2:end,3)))).^alpha;
%ac = sum((Y_cf - Y(2:end))./Y(2:end));  %notice error here 10/11/07


