function S=bartKern(X,nlags)
%function S=bartKern(X,nlags)
%This function estimates the spectral density of the process in the rows of
%X at freq. zero using the Bartlett kernel.  nlags is the number of lags to
%use (default to T^(1/3), which yields fastest convergence according to
%Andrews(1991).

[T,k] = size(X);

if nargin < 2
    nlags = round(T^(1/3));
end

S = zeros(k);

for lag = 0:nlags
  rho = X(1:T-lag,:)'*X(1+lag:T,:)/(T-k);  
  if lag >= 1, rho = rho + rho'; end
  wt = 1 - lag/(nlags+1);
  S = S + wt*rho;    
end

