%This script comptutes the skewness in u_(t) - u_(t-k)

global time;

clc;
load data/quarterly.mat;


skewCoeffs = -99 * ones(10,5);
testStats = -99 * ones(10,5);
pVals = -99 * ones(10,5);  %one-sided test


k_s = [1 2 4 6 8];
varNames = 'k' ;

for i = 1:size(k_s,2)
   
    k = k_s(i);
    
    
    %Raw Output: GDP
    j=1;
    x = log(gdp);
    diff = x(1+k:end) - x(1:end-k);
    [s t] = skewTestAC(diff);
    skewCoeffs(j,i) = s;
    testStats(j,i) = t;
    pVals(j,i) = pnorm(t);
    if i==1, varNames = strvcat(varNames,'raw gdp '); end
    
    %Linear Detrended Output: GDP
    j=2;
    x = log(gdp);
    x = x - linBreak(x,1973.75,1995.75);
    diff = x(1+k:end) - x(1:end-k);
    [s t] = skewTestAC(diff);
    skewCoeffs(j,i) = s;
    testStats(j,i) = t;
    pVals(j,i) = pnorm(t);
    if i==1, varNames = strvcat(varNames,'linear gdp '); end
    
    %polynomial Detrended Output: GDP
    j=3;
    x = log(gdp);
    x = x - polynomial(x,3);
    diff = x(1+k:end) - x(1:end-k);
    [s t] = skewTestAC(diff);
    skewCoeffs(j,i) = s;
    testStats(j,i) = t;
    pVals(j,i) = pnorm(t);
    if i==1, varNames = strvcat(varNames,'polynomial gdp '); end
    
    %bandpass Detrended Output: GDP
    j=4;
    x = log(gdp);
    x = bandpass(x,6,32);
    diff = x(1+k:end) - x(1:end-k);
    [s t] = skewTestAC(diff);
    skewCoeffs(j,i) = s;
    testStats(j,i) = t;
    pVals(j,i) = pnorm(t);
    if i==1, varNames = strvcat(varNames,'bandpass(6,32) gdp '); end

    
    %Rotemberg Detrended Output: GDP
    j=5;
    x = log(gdp);
    x = x - rotemberg(x);
    diff = x(1+k:end) - x(1:end-k);
    [s t] = skewTestAC(diff);
    skewCoeffs(j,i) = s;
    testStats(j,i) = t;
    pVals(j,i) = pnorm(t);
    if i==1, varNames = strvcat(varNames,'rotemberg gdp '); end
    
    %Raw Output: emp rate
    j=6;
    x = log(1-unemp/100);
    diff = x(1+k:end) - x(1:end-k);
    [s t] = skewTestAC(diff);
    skewCoeffs(j,i) = s;
    testStats(j,i) = t;
    pVals(j,i) = pnorm(t);
    if i==1, varNames = strvcat(varNames,'raw emp rate '); end
    
    %Linear Detrended Output: emp rate
    j=7;
    x = log(1-unemp/100);
    x = x - linBreak(x,1973.75,1995.75);
    diff = x(1+k:end) - x(1:end-k);
    [s t] = skewTestAC(diff);
    skewCoeffs(j,i) = s;
    testStats(j,i) = t;
    pVals(j,i) = pnorm(t);
    if i==1, varNames = strvcat(varNames,'linear emp rate '); end
    
    %polynomial Detrended Output: emp rate
    j=8;
    x = log(1-unemp/100);
    x = x - polynomial(x,3);
    diff = x(1+k:end) - x(1:end-k);
    [s t] = skewTestAC(diff);
    skewCoeffs(j,i) = s;
    testStats(j,i) = t;
    pVals(j,i) = pnorm(t);
    if i==1, varNames = strvcat(varNames,'polynomial emp rate '); end
    
    %Bandpass Detrended Output: emp rate
    j=9;
    x = log(1-unemp/100);
    x = bandpass(x,2,80);
    diff = x(1+k:end) - x(1:end-k);
    [s t] = skewTestAC(diff);
    skewCoeffs(j,i) = s;
    testStats(j,i) = t;
    pVals(j,i) = pnorm(t);
    if i==1, varNames = strvcat(varNames,'bandpass(2,80) emp rate '); end

    
    %Rotemberg Detrended Output: emp rate
    j=10;
    x = log(1-unemp/100);
    x = x - rotemberg(x);
    diff = x(1+k:end) - x(1:end-k);
    [s t] = skewTestAC(diff);
    skewCoeffs(j,i) = s;
    testStats(j,i) = t;
    pVals(j,i) = pnorm(t);
    if i==1, varNames = strvcat(varNames,'rotemberg emp rate '); end
    
    

    
end

disp('skewness coefficients');
disp([varNames num2str([k_s; skewCoeffs])]);

disp(' ');

disp('test stats');    
disp([varNames num2str([k_s; testStats])]);

disp(' ');

disp('p-values -- one-sided');    
disp([varNames num2str([k_s; pVals])]);
