function f= spider(recess, series, labels, pORt, quarters)
%This function creates a "spider" chart for series using date classifications in recess.
%
%Inputs:
%
%recess     T x j       Indicates recessions
%
%series     T x k       Data
%
%labels     k x m       Vertically stacked labels for series
%
%pORt       1 x 1       normalize around peaks or troughs ('p' or 't')
%
%quarters   1 x 2       months before and after the peak/trough to include
%
%
%Output
%
%f          1 x 1       Graphic handle


[T k] = size(series);

[foo j] = size(recess);
clear foo;


%invert the indicator for troughs
if pORt == 't'
    recess = ~recess;
end


recessOrig = recess;
recess = recess(:,1);


temp = recess(2:end) - recess(1:end-1);

%select those dates that are not at the ends of the sample and are peaks
peakInds = find(temp == 1) + 1; % The +1 is to correct for the first differencing
peakInds = peakInds(logical((peakInds > quarters(1)) .* (peakInds <= T - quarters(2))));
disp('Turning Points Used');
disp(peakInds);
nPeak = length(peakInds);

%select the dates around the peaks
temp = [];
for i = 1:nPeak;
    temp = [temp [peakInds(i)-quarters(1):peakInds(i)+quarters(2)]'];
end
peakInds2 = temp;

%compute the average for each series for those dates
temp = [];
for i = 1:k
    temp2 = reshape(series(peakInds2,i),size(peakInds2));
%    temp2 = temp2 ./ repmat(temp2(quarters(1)+1,:),sum(quarters)+1,1); %normalize by peak level
    temp2 = temp2 - repmat(temp2(quarters(1)+1,:),sum(quarters)+1,1);    %normalize by peak level
    temp = [temp mean(temp2,2)];
end


if nargout > 0 
    f = figure();
end

if k == 2
    hl1 = line([-quarters(1):quarters(2)]',temp(:,1),'Color','b');
    ax1 = gca;
    set(ax1,'XColor','k','YColor','b')
    

    ax2 = axes('Position',get(ax1,'Position'),...
           'YAxisLocation','right',...
           'Color','none',...
           'YColor','r');

    hl2 = line([-quarters(1):quarters(2)]',temp(:,2),'Color','r','Parent',ax2);
    
    ylabel(ax1, labels(1,:));
    ylabel(ax2, labels(2,:));
    
else
    plot([-quarters(1):quarters(2)]',temp);
    legend(labels);
end


if pORt == 'p'
    xlabel('Quarters From Peak');
else
    xlabel('Quarters From Trough');
end



if j == k   %multiple recess supplied

    meanDuration.next = [];
    meanDuration.prev = [];    
    
    for i = 1:j
        troughs = recessOrig(2:end, i) - recessOrig(1:end-1, i);
        troughInds = find(troughs == -1) + 1; % The +1 is to correct for the first differencing
        
        interval.previous = [];
        interval.next = [];
        for q = 1:nPeak
            temp = troughInds - peakInds(q);
            interval.next = [interval.next; minpos(temp)];
            interval.previous = [interval.previous; minpos(-temp)];        
        end
        
                
        meanDuration.next = [meanDuration.next mean(interval.next(interval.next ~= -1))];
        meanDuration.prev = [meanDuration.prev mean(interval.previous(interval.previous ~= -1))];
    end
    
    
    if pORt == 'p'
        disp('Mean duration until the next trough');
    else
        disp('Mean duration until the next peak');
    end
    disp(meanDuration.next);
    
    if pORt == 'p'
        disp('Mean duration until the previous trough');
    else
        disp('Mean duration until the previous peak');
    end
    disp(meanDuration.prev);
    
end



%~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
function y = minpos(x,dim)

%this function takes a matrix x and finds the minimum non-negative value in
%each row (if dim = 1, default) or column (dim = 2).  If there is no such
%entry in a column (row) then -1 is returned in the corresponding position
%of y.

if nargin > 1 && dim == 2,  x = x'; end


[r c] = size(x);

y = -1 * ones(1,c);

for i = 1:c
    s = x(:,i);
    t = min(s(s >= 0));
    if length(t) > 0, y(i) = t; end
end


if nargin > 1 && dim == 2,    y = y'; end