    
clc;
clear all;
close all;

global time;


%BASELINE DATA
load data/quarterly;
x = log(gdp);  seriesName='log(gdp)'; windowSizeRaw = 2;  windowSizeDT = 5; disp('Analyzing log(GDP)');  isStationary = false; windowTol = 0; table = 4;  bpl = 6; bpu = 32;
%x = log(ip);  seriesName='log(ip)'; windowSizeRaw = 2;  windowSizeDT = 5; disp('Analyzing log(IP)');  isStationary = false; windowTol = 0;   bpl = 6; bpu = 32;
%x = log(1-unemp/100); seriesName='log(1-u)'; windowSizeRaw = 2; windowSizeDT = 5;  disp('Analyzing log(1-u)');  isStationary = true; windowTol = 0;   bpl = 2; bpu = 80;


%Set the order of the polynomial trend
% unemp        -> 3
% log gdp      -> 3
% log(1-unemp) -> 3
polyOrder = 3;



%Detrend in various ways------------------------------
    

%6 - Rotemberg Smooth Trend
detrended = x-rotemberg(x);


%Detect Turning Points in Various Ways--------------------

if ~isStationary
    disp('Wide windows used on raw data');
end

   
% 4 - Bry-Boschan
recess = bryBos(detrended,true);




%~~~~~~~~Compute t-test and Wilcoxon Test~~~~~~~~~~




totalOutput = [];
r = recess;
    
xF = detrended;
        
                


output = wilcoxon(xF,r);
totalOutput = [totalOutput; [repmat([6 4],2,1) [1:2]' output]];


disp('            avg. contr.    avg. expan.       W-stat     p-value      Wilc t-stat   Basic t-stat  p-value');
rowNames = strvcat('Duration ','Steepness ');
disp(horzcat(rowNames,num2str(output)));


switch seriesName
    case 'log(1-u)'
        save('results/abc_q_u.mat','recess','x','totalOutput','detrended');
    case 'log(ip)'
        save('results/abc_q_ip.mat','recess','x','totalOutput','detrended');
    case 'log(gdp)'
        save('results/abc_q_gdp.mat','recess','x','totalOutput','detrended');
end
