%this script tests for output to be as asymmetric as employment. 
%Using a ratio test instead of a difference test.  Used for violence
%november 27, 2006


clc;
clear all;
close all;

global time;

%Load the results for cross-series comparison
load results/abc_q_u.mat;
crossResults = totalOutput;
crossResults = crossResults(crossResults(:,1)<7,:);

%BASELINE DATA
load data/quarterly;
x = log(gdp);  seriesName='log(gdp)'; windowSizeRaw = 2;  windowSizeDT = 5; disp('Analyzing log(GDP)');  isStationary = false; windowTol = 0; table = 4;
%x = log(ip);  seriesName='log(ip)'; windowSizeRaw = 2;  windowSizeDT = 5; disp('Analyzing log(IP)');  isStationary = false; windowTol = 0; 
%x = log(1-unemp/100); seriesName='log(1-u)'; windowSizeRaw = 2; windowSizeDT = 5;  disp('Analyzing log(1-u)');  isStationary = true; windowTol = 0;


%Set the order of the polynomial trend
% unemp        -> 3
% log gdp      -> 3
% log(1-unemp) -> 3
polyOrder = 3;



%Detrend in various ways------------------------------

%6 - Rotemberg Smooth Trend
detrended = x-rotemberg(x);



%Detect Turning Points in Various Ways--------------------
recess = bryBos(detrended,true);


    
    


[T n] = size(recess);



%~~~~~~~~Compute t-test and Wilcoxon Test~~~~~~~~~~



rowNames = strvcat('Steepness ');

r = recess;
xF = detrended;
        
mu = crossResults;
mu = abs(mu(:,5)) ./ abs(mu(:,4));
        
        
        
disp('            avg. contr.    avg. expan.       W-stat     p-value      Wilc t-stat   Basic t-stat  p-value');
output = wilcoxon_altTest2(xF,r,mu);
totalOutput = [totalOutput; [repmat([6 4],1,1) 2 output]];
        
disp(horzcat(rowNames,num2str(output)));
        