function F = pt(x,df)
%PT       The student t cdf
%
%         F = pt(x,DegreesOfFreedom)

%       Anders Holtsberg, 18-11-93
%       Copyright (c) Anders Holtsberg

if any(any(df<=0))
   error('DegreesOfFreedom is wrong')
end

df = min(df,1000000); % make it converge and also accept Inf.

neg = x<0;
F = pf(x.^2,1,df);
F = 1-(1-F)/2;
F = F + (1-2*F).*neg;

function F = pf(x,a,b)
%PF       The F distribution function
%
%         F = pf(x,df1,df2)

%        Anders Holtsberg, 18-11-93
%        Copyright (c) Anders Holtsberg

x = x./(x+b./a);
F = pbeta(x,a/2,b/2);





function F = pbeta(x,a,b)
%PBETA    The beta distribution function
%
%         F = pbeta(x,a,b)

%       Anders Holtsberg, 18-11-93
%       Copyright (c) Anders Holtsberg

if any(any((a<=0)|(b<=0)))
   error('Parameter a or b is nonpositive')
end

Ii = find(x>0&x<1);
Il = find(x<=0);
Iu = find(x>=1);
F = 0*(x+a+b); % Stupid allocation trick
F(Il) = 0*Il;
F(Iu) = 0*Iu + 1;
if length(Ii) > 0 
   F(Ii) = betainc(x(Ii),a,b);
end
