%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%  This file is part of the replication files for the figures in:       %
%Reis, Ricardo (2009) "A Sticky-Information General-Equilibrium Model   %
%  for Policy Analysis." In: Monetary Policy under Uncertainty and      %
%  Learning, edited by K. Schmidt-Heubel and C. Walsh, Central Bank of  %
%  Chile: forthcoming, 2009.                                            %
%See the paper for a detailed explanation of the algorithms.            %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Please cite if you use the programs. I do not provide tech support.    %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%This file: produce tables 2 and 4 in the paper                         %
%Last revised: January 29, 2009                                         %
%Written by: Tiago Berriel and Ricardo Reis                             %
%Input: Chile_###post.mat a large file with the draws form the posterior%
%Output: displayed on screen                                            %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

clear global; clear; clc; close all
global N

%%%%STEP 0: PICK CASE %%%%%%%
Sample = 2;         %Pick, 1 - USG; 2 - EMU
N = 200;            %Length of solution MA
Nplot = 20;         %Length of plots

%%%%STEP 1: PARAMETER INPUTS %%%%%%%
disp('~~~~~~~~~~~~~~~~~~~~')
if Sample==1; load Chile_USGpost; disp('~~USGSPAN sample~~~~~');
elseif Sample==2; load Chile_EMUpost; disp('~~EMU sample~~~~~~');
end; disp('~~~~~~~~~~~~~~~~~~~~'); disp(' ');

%%%%% TABLE 2 : ESTIMATES AND CONFIDENCE INTERVALS %%%%%%%
disp('%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%');
disp('        TABLE 2 OR 4: THE POSTERIOR                 ');
disp('%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%');
disp(' ')
vc=cov(MixedResults); se=std(MixedResults);
lb = prctile(MixedResults,2.5); ub = prctile(MixedResults,97.5);
disp('Bayesian mean, mode and standard errors:  ')
disp('      nu      gamma      phiy     phipi     rho_m     sigma_m   rho_g     sigma_g')
disp([mea(1:8);mod(1:8);se(1:8)]);
disp('    rho_nu   sigma_nu   rho_gam  sigma_gam  delta     omega     lambda    psi');
disp([mea(9:16);mod(9:16);se(9:16)]);
disp('')
disp('Bayesian median, 2.5 percentile and 97.5 percentile:  ')
disp('      nu      gamma      phiy     phipi     rho_m     sigma_m   rho_g     sigma_g')
disp([med(1:8);lb(1:8);ub(1:8)]);
disp('    rho_nu   sigma_nu   rho_gam  sigma_gam  delta     omega     lambda    psi');
disp([med(9:16);lb(9:16);ub(9:16)]);
disp('')

