%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%  This file is part of the replication files for the figures in:       %
%Reis, Ricardo (2009) "A Sticky-Information General-Equilibrium Model   %
%  for Policy Analysis." In: Monetary Policy under Uncertainty and      %
%  Learning, edited by K. Schmidt-Heubel and C. Walsh, Central Bank of  %
%  Chile: forthcoming, 2009.                                            %
%See the paper for a detailed explanation of the algorithms.            %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Please cite if you use the programs. I do not provide tech support.    %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%This file: produce tables 2 and 4 in the paper                         %
%Last revised: January 29, 2009                                         %
%Written by: Tiago Berriel and Ricardo Reis                             %
%Input: Chile_###post.mat or Chile_###vardec                            %
%Output: displayed on screen                                            %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

clear global; clear; clc; close all
global N

%%%%STEP 0: PICK CASE %%%%%%%
Sample = 2;         %Pick, 1 - USG; 2 - EMU
N = 200;            %Length of solution MA
Nplot = 20;         %Length of plots
Num = 10000;        %# draws for vardec
recalculate = 0;     %1 if want to re-draw, 0 if just load prior results

if recalculate == 1;
    %%%%STEP 1: PARAMETER INPUTS %%%%%%%
    disp('~~~~~~~~~~~~~~~~~~~~')
    if Sample==1; load Chile_USGpost; disp('~~USGSPAN sample~~~~~');
    elseif Sample==2; load Chile_EMUpost; disp('~~EMU sample~~~~~~');
    end; disp('~~~~~~~~~~~~~~~~~~~~'); disp(' ');
    draws = Md;         %number of draws
    %%%%% STEP 2: VARIANCE DECOMPOSITION %%%%%%%
    tic
     VARDEC1=[];
     h = waitbar(0,'Going over variance decomposition 1-quarter ahead...');
     for i=1:Num
         dd = randsample(draws,1); temp = ests(dd,:); %temp=ests(i,:); 
         VARDEC1=[VARDEC1 Chilevd(temp,1)];
         waitbar(i/Num,h);
     end
     close(h);
     for i=1:5
         for j=1:5
             for k=1:Num
                 z(i,j,k)=VARDEC1(i,j+5*(k-1));
             end
         VD1_025(i,j)=prctile(z(i,j,:),2.5); VD1_500(i,j)=prctile(z(i,j,:),50);
         VD1_975(i,j)=prctile(z(i,j,:),97.5);
         end
     end
    %%%
     VARDEC4=[];
     h = waitbar(0,'Going over variance decomposition 4-quarter ahead...');
     for i=1:Num
         dd = randsample(draws,1); temp = ests(dd,:); %temp=ests(i,:); 
         VARDEC4=[VARDEC4 Chilevd(temp,4)];
         waitbar(i/Num,h);
     end
     close(h);
     for i=1:5
         for j=1:5
             for k=1:Num
                 z(i,j,k)=VARDEC4(i,j+5*(k-1));
             end
         VD4_025(i,j)=prctile(z(i,j,:),2.5); VD4_500(i,j)=prctile(z(i,j,:),50);
         VD4_975(i,j)=prctile(z(i,j,:),97.5);
         end
     end
    %%%
     VARDEC16=[];
     h = waitbar(0,'Going over variance decomposition 16-quarter ahead...');
     for i=1:Num
         dd = randsample(draws,1); temp = ests(dd,:); %temp=ests(i,:); 
         VARDEC16=[VARDEC16 Chilevd(temp,16)];
         waitbar(i/Num,h);
     end
     close(h);
     for i=1:5
         for j=1:5
             for k=1:Num
                 z(i,j,k)=VARDEC16(i,j+5*(k-1));
             end
         VD16_025(i,j)=prctile(z(i,j,:),2.5); VD16_500(i,j)=prctile(z(i,j,:),50);
         VD16_975(i,j)=prctile(z(i,j,:),97.5);
         end
     end
    %%%
     VARDECN=[];
     h = waitbar(0,'Going over variance decomposition INF-quarter ahead...');
     for i=1:Num
         dd = randsample(draws,1); temp = ests(dd,:); %temp=ests(i,:); 
         VARDECN=[VARDECN Chilevd(temp,N)];
         waitbar(i/Num,h);
     end
     close(h);
     for i=1:5
         for j=1:5
             for k=1:Num
                 z(i,j,k)=VARDECN(i,j+5*(k-1));
             end
         VDN_025(i,j)=prctile(z(i,j,:),2.5); VDN_500(i,j)=prctile(z(i,j,:),50);
         VDN_975(i,j)=prctile(z(i,j,:),97.5);
         end
     end
    toc
    clear h i dd temp j z
    %%%%% STEP 3: SAVING OR LOADING %%%%%%%
    if Sample==1;
        save Chile_USGvardec VD1_025 VD1_500 VD1_975 ...
        VD4_025 VD4_500 VD4_975 VD16_025 VD16_500 VD16_975...
        VDN_025 VDN_500 VDN_975
    elseif Sample==2; 
        save Chile_EMUvardec VD1_025 VD1_500 VD1_975 ...
        VD4_025 VD4_500 VD4_975 VD16_025 VD16_500 VD16_975...
        VDN_025 VDN_500 VDN_975
    end;
end
if recalculate == 0;
    disp('~~~~~~~~~~~~~~~~~~~~')
    if Sample==1; load Chile_USGvardec; disp('~~USGSPAN sample~~~~~');
    elseif Sample==2; load Chile_EMUvardec; disp('~~EMU sample~~~~~~');
    end; disp('~~~~~~~~~~~~~~~~~~~~'); disp(' ');
end

%%%%% TABLE 3 : VARIANCE DECOMPOSITION %%%%%%%
disp('%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%');
disp(' TABLES 3 OR 5: THE VARIANCE DECOMPOSITION: PANEL A ');
disp('%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%');
disp('Variance decomposition median over draws:')
disp('  inflation     Dy        i        Dwp      hours')
disp(VDN_500');
disp('Variance decomposition 2.5% estimates :')
disp('  inflation     Dy        i        Dwp      hours')
disp(VDN_025');
disp('Variance decomposition 97.5% estimates :')
disp('  inflation     Dy        i        Dwp      hours')
disp(VDN_975');
disp('%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%');
disp('     TABLE 3: THE VARIANCE DECOMPOSITION: PANEL B   ');
disp('%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%');
disp('Variance decomposition 1-quarter ahead, median')
disp('  inflation     Dy        i        Dwp      hours'); disp(VD1_500');
disp('Variance decomposition 4-quarter ahead, median 2.5, 97.5')
disp('  inflation     Dy        i        Dwp      hours'); disp(VD4_500');
disp('Variance decomposition 16-quarter ahead, median 2.5, 97.5')
disp('  inflation     Dy        i        Dwp      hours'); disp(VD16_500');