%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%  This file is part of the replication files for the figures in:       %
%Reis, Ricardo (2009) "A Sticky-Information General-Equilibrium Model   %
%  for Policy Analysis." In: Monetary Policy under Uncertainty and      %
%  Learning, edited by K. Schmidt-Heubel and C. Walsh, Central Bank of  %
%  Chile: forthcoming, 2009.                                            %
%See the paper for a detailed explanation of the algorithms.            %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Please cite if you use the programs. I do not provide tech support.    %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%This file: produces figures for the paper                              %
%Last revised: January 29, 2009                                         %
%Written by: Tiago Berriel and Ricardo Reis                             %
%Input: Chile_###post_stats.mat has the mean posterior estimates        %
%Output: displayed on screen and on created figures                     %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

clear global; clear; clc; close all
global N

%%%%STEP 0: PICK CASE %%%%%%%
path(path,'e:\SIPR')%Need SIPR programs
Sample = 1;         %Pick, 1 - USG; 2 - EMU
N = 200;            %Length of solution MA
Nplot = 16;         %Length of plots

%%%%STEP 1: PARAMETER INPUTS %%%%%%%
disp('~~~~~~~~~~~~~~~~~~~~')
if Sample==1; load Chile_USGpost_stats est_mean; disp('~~USGSPAN sample~~~~~');
elseif Sample==2; load Chile_EMUpost_stats est_mean; disp('~~EMU sample~~~~~~');
end; disp('~~~~~~~~~~~~~~~~~~~~'); disp(' ');

%%%%% FIGURES 1 or 2: IMPULSE RESPONSE FUNCTION AT POSTERIORS %%%%%%%
pars_sq = est_mean';
[sq_m sq_a sq_g sq_nu sq_gam] = SIGEma(pars_sq); 
sq_m = 100*pars_sq(9)*sq_m; sq_a = 100*pars_sq(11)*sq_a; sq_g = 100*pars_sq(13)*sq_g;
sq_nu = 100*pars_sq(15)*sq_nu; sq_gam = 100*pars_sq(17)*sq_gam;

figure(1)
subplot(2,2,1),...
    plot(1:Nplot,sq_m(1:Nplot,1),'mo-',1:Nplot,sq_a(1:Nplot,1),'b-',1:Nplot,sq_g(1:Nplot,1),'rx-',...
    1:Nplot,sq_nu(1:Nplot,1),'c-.',1:Nplot,sq_gam(1:Nplot,1),'g--','LineWidth',2.5,'MarkerSize',10),
title('Inflation'); 
if Sample==1; axis([1 16 -0.2 0.1]); elseif Sample==2; axis([1 16 -0.25 0.1]); end
subplot(2,2,2),...
    plot(1:Nplot,sq_m(1:Nplot,3),'mo-',1:Nplot,sq_a(1:Nplot,3),'b-',1:Nplot,sq_g(1:Nplot,3),'rx-',...
    1:Nplot,sq_nu(1:Nplot,3),'c-.',1:Nplot,sq_gam(1:Nplot,3),'g--','LineWidth',2.5,'MarkerSize',10),
title('Nominal interest rate');
axis([1 16 -0.4 0.1]);
subplot(2,2,3),...
    plot(1:Nplot,sq_m(1:Nplot,5),'mo-',1:Nplot,sq_a(1:Nplot,5),'b-',1:Nplot,sq_g(1:Nplot,5),'rx-',...
    1:Nplot,sq_nu(1:Nplot,5),'c-.',1:Nplot,sq_gam(1:Nplot,5),'g--','LineWidth',2.5,'MarkerSize',10),
title('Hours');
if Sample==1; axis([1 16 -1 1.5]); elseif Sample==2; axis([1 16 -0.3 0.6]); end
subplot(2,2,4),...
    plot(1:Nplot,sq_m(1:Nplot,6),'mo-',1:Nplot,sq_a(1:Nplot,6),'b-',1:Nplot,sq_g(1:Nplot,6),'rx-',...
    1:Nplot,sq_nu(1:Nplot,6),'c-.',1:Nplot,sq_gam(1:Nplot,6),'g--','LineWidth',2.5,'MarkerSize',10),
title('Output gap');
if Sample==1; axis([1 16 -0.8 0.4]); elseif Sample==2; axis([1 16 -1 0.2]); end
legend('Monetary','Productivity','Aggregate demand','Goods-markup','Wage-markup')
disp('...Figure 1 or 2: Estimated IRFs')

%%%%% FIGURE 3: IMPULSE RESPONSE FUNCTION RAISING PERSISTENCE %%%%%%%
pars_rho = est_mean'; adj = inv(sqrt((1-pars_rho(8)^2)/(1-0.9^2)));
pars_rho(8) = 0.9; [drho_m drho_a drho_g drho_nu drho_gam] = SIGEma(pars_rho);
drho_m = 100*pars_rho(9)*adj*drho_m; 

figure(3)
subplot(2,2,1),...
    plot(1:Nplot,sq_m(1:Nplot,1),'mo-',1:Nplot,drho_m(1:Nplot,1),'b-','LineWidth',2.5,'MarkerSize',10),
title('Inflation'); 
if Sample==1; axis([1 16 -0.1 0.4]); elseif Sample==2; axis([1 16 -0.1 0.5]); end
subplot(2,2,2),...
    plot(1:Nplot,sq_m(1:Nplot,3),'mo-',1:Nplot,drho_m(1:Nplot,3),'b-','LineWidth',2.5,'MarkerSize',10),
title('Nominal interest rate');
if Sample==1; axis([1 16 -0.4 0.4]); elseif Sample==2; axis([1 16 -0.5 0.5]); end
subplot(2,2,3),...
    plot(1:Nplot,sq_m(1:Nplot,5),'mo-',1:Nplot,drho_m(1:Nplot,5),'b-','LineWidth',2.5,'MarkerSize',10),
title('Hours');
if Sample==1; axis([1 16 0 0.2]); elseif Sample==2; axis([1 16 -0.1 0.8]); end
subplot(2,2,4),...
    plot(1:Nplot,sq_m(1:Nplot,6),'mo-',1:Nplot,drho_m(1:Nplot,6),'b-','LineWidth',2.5,'MarkerSize',10),
title('Output gap');
if Sample==1; axis([1 16 0 0.12]); elseif Sample==2; axis([1 16 -0.1 0.5]); end
legend('Estimates','With more persistent shocks')
disp('...Figure 3: Raising persistence')
disp(' '); clear adj drho_m drho_a drho_g drho_nu drho_gam

%%%%% FIGURE 4: ANNOUNCED DISINFLATIONS %%%%%%%
disp('ANNOUNCED DISINFLATIONS')
C(1,1) = 1; for i=2:N; C(i,1)=pars_sq(8)^(i-1); end
C = pars_sq(8)^(-4).*C; C(1:4,1) = 0; %one-year ahead
disinf1 = -100*pars_sq(9)*SIGEmam(pars_sq,C); 
C = pars_sq(8)^(-4).*C; C(1:8,1) = 0; %two-year ahead
disinf2 = -100*pars_sq(9)*SIGEmam(pars_sq,C); 

figure(4);
subplot(2,2,1), plot(1:Nplot,-sq_m(1:Nplot,1),'mo-',1:Nplot,disinf1(1:Nplot,1),'b-',...
    1:Nplot,disinf2(1:Nplot,1),'rx-','LineWidth',2.5,'MarkerSize',10);
title('Inflation');
if Sample==1; axis([1 16 -0.1 0.5]); elseif Sample==2; axis([1 16 -0.1 0.8]); end
subplot(2,2,2), plot(1:Nplot,-sq_m(1:Nplot,3),'mo-',1:Nplot,disinf1(1:Nplot,3),'b-',...
    1:Nplot,disinf2(1:Nplot,3),'rx-','LineWidth',2.5,'MarkerSize',10);
title('Nominal interest rate');
if Sample==1; axis([1 16 -0.4 0.6]); elseif Sample==2; axis([1 16 -0.5 0.7]); end
subplot(2,2,3), plot(1:Nplot,-sq_m(1:Nplot,5),'mo-',1:Nplot,disinf1(1:Nplot,5),'b-',...
    1:Nplot,disinf2(1:Nplot,5),'rx-','LineWidth',2.5,'MarkerSize',10);
title('Hours');
if Sample==1; axis([1 16 0 0.1]); elseif Sample==2; axis([1 16 0 0.5]); end
subplot(2,2,4), plot(1:Nplot,-sq_m(1:Nplot,2),'mo-',1:Nplot,disinf1(1:Nplot,2),'b-',...
    1:Nplot,disinf2(1:Nplot,2),'rx-','LineWidth',2.5,'MarkerSize',10);
title('Output gap');
if Sample==1; axis([1 16 0 0.06]); elseif Sample==2; axis([1 16 0 0.35]); end
legend('Unanticipated shock','Anticipated 1 year','Anticipated 2 years')
disp('...Figure 4: announced disinflation')
clear C ; disp(' ');

%%%%% FIGURE 5: GRADUALISM %%%%%%%
disp('THE ROLE OF POLICY ANNOUNCEMENTS - GRADUALISM')
gradual1 = 0.25*(sq_m + [zeros(1,6);sq_m(1:N,:)] + [zeros(2,6);sq_m(1:N-1,:)] + [zeros(3,6);sq_m(1:N-2,:)]);
C(1:4,1) = [0.25;0.5;0.75;1]; for i=5:N; C(i,1)=pars_sq(8)*C(i-1,1); end
gradual2 = -100*pars_sq(9)*SIGEmam(pars_sq,C); clear C

figure(5)
subplot(2,2,1), plot(1:Nplot,sq_m(1:Nplot,1),'b-',1:Nplot,gradual1(1:Nplot,1),'rx-',...
    1:Nplot,gradual2(1:Nplot,1),'ko-','LineWidth',2.5,'MarkerSize',10);
title('Inflation');
if Sample==1; axis([1 16 -0.05 0.35]); elseif Sample==2; axis([1 16 -0.1 0.4]); end
subplot(2,2,2), plot(1:Nplot,sq_m(1:Nplot,3),'b-',1:Nplot,gradual1(1:Nplot,3),'rx-',...
    1:Nplot,gradual2(1:Nplot,3),'ko-','LineWidth',2.5,'MarkerSize',10);
title('Nominal interest rate');
if Sample==1; axis([1 16 -0.4 0.1]); elseif Sample==2; axis([1 16 -0.4 0.1]); end
subplot(2,2,3), plot(1:Nplot,sq_m(1:Nplot,5),'b-',1:Nplot,gradual1(1:Nplot,5),'rx-',...
    1:Nplot,gradual2(1:Nplot,5),'ko-','LineWidth',2.5,'MarkerSize',10);
title('Hours');
if Sample==1; axis([1 16 0 0.2]); elseif Sample==2; axis([1 16 0 0.7]); end
subplot(2,2,4), plot(1:Nplot,sq_m(1:Nplot,2),'b-',1:Nplot,gradual1(1:Nplot,2),'rx-',...
    1:Nplot,gradual2(1:Nplot,2),'ko-','LineWidth',2.5,'MarkerSize',10);
title('Output gap');
if Sample==1; axis([1 16 0 0.12]); elseif Sample==2; axis([1 16 0 0.5]); end
legend('One time adjustment', 'Gradual with surprises each time', 'Gradual announced at 0')
disp('...Figure 5: gradualism')
clear C; disp(' ');

disp('POLICY COUNTERFACTUALS')
[VarDecomp_sq TotVar_sq VarComp_sq] = Chilevd2(pars_sq,N);
kappa = 0.5*pars_sq(1)*(1+1/pars_sq(2));
[a b c d] = SIPRll(pars_sq); p = SIPRtrp(pars_sq,'tr');
Wbar = SIPRw('all',pars_sq,p,a,b,c,d);
clear VarDecomp_sq VarComp_sq a b c d p
parsD=pars_sq; parsD(9)=parsD(9)+0.01; parsD(11)=parsD(11)+0.01;
parsD(13)=parsD(13)+0.01; parsD(15)=parsD(15)+0.01; parsD(17)=parsD(17)+0.01;
[temp1 zz temp3] = Chilevd2(parsD,N);
BMRomega = (zz(4)-TotVar_sq(4))/(zz(1)-TotVar_sq(1));
BMRalpha = (1+pars_sq(2))/(1+pars_sq(2)*pars_sq(4));
disp('...BMRomega   BMRalpha'); disp([BMRomega BMRalpha]);
clear temp1 temp3 zz parsD

%%%%% FIGURE 6: TAYLORS PROPOSAL %%%%%%%
disp('TAYLORS PROPOSAL'); 
pars_taylor=est_mean; pars_taylor(6)=0.5; pars_taylor(7)=1.5;
disp('    phiy      phipi     rho_m     sigma_m');
disp([pars_taylor(6) pars_taylor(7) pars_taylor(8) pars_taylor(9)]);
[VarDecomp_taylor TotVar_taylor VarComp_taylor] = Chilevd2(pars_taylor,N);
[a b c d] = SIPRll(pars_taylor); p = SIPRtrp(pars_taylor,'tr');
Wtaylor = SIPRw('all',pars_taylor,p,a,b,c,d);
clear VarDecomp_taylor VarComp_taylor a b c d p 

disp('  Change in variance in % units');
disp('  inflation     i       hours      gap')
disp(100*(TotVar_taylor./TotVar_sq-ones(1,4)));
disp('  Welfare gain:')
disp(100*(exp(kappa*(Wbar-Wtaylor))-1));

[taylor_m taylor_a taylor_g taylor_nu taylor_gam] = SIGEma(pars_taylor); 
taylor_m = 100*pars_taylor(9)*taylor_m; taylor_a = 100*pars_taylor(11)*taylor_a;
taylor_g = 100*pars_taylor(13)*taylor_g; taylor_nu = 100*pars_taylor(15)*taylor_nu;
taylor_gam = 100*pars_taylor(17)*taylor_gam;

figure(6)
subplot(2,2,1), plot(1:Nplot,sq_a(1:Nplot,1),'mo-',...
    1:Nplot,taylor_a(1:Nplot,1),'b-','LineWidth',2.5,'MarkerSize',10);
title('Inflation'); 
if Sample==1; axis([1 16 -0.1 0.2]); elseif Sample==2; axis([1 16 -0.2 0.05]); end
subplot(2,2,2), plot(1:Nplot,sq_a(1:Nplot,5),'mo-',...
    1:Nplot,taylor_a(1:Nplot,5),'b-','LineWidth',2.5,'MarkerSize',10);
title('Hours');
if Sample==1; axis([1 16 -1 0]); elseif Sample==2; axis([1 16 -0.25 0]); end
subplot(2,2,3), plot(1:Nplot,sq_g(1:Nplot,1),'mo-',...
    1:Nplot,taylor_g(1:Nplot,1),'b-','LineWidth',2.5,'MarkerSize',10);
title('Inflation'); 
if Sample==1; axis([1 16 -0.1 0.04]); elseif Sample==2; axis([1 16 0 0.08]); end
subplot(2,2,4), plot(1:Nplot,sq_g(1:Nplot,5),'mo-',...
    1:Nplot,taylor_g(1:Nplot,5),'b-','LineWidth',2.5,'MarkerSize',10);
title('Hours');
if Sample==1; axis([1 16 0 2]); elseif Sample==2; axis([1 16 0 0.5]); end
legend('Status quo','Taylors proposal')
disp('...Figure 6: Taylor rule on productivity and aggregate-demand')
disp(' ');

%%%%% FIGURE 7: BMR STRICT PRICE-STANDARD %%%%%%%
disp('BMR STRICT PRICE-STANDARD')
py1 = 0;
py1_p = SIPRpyp(pars_sq,py1); [py1_m py1_a py1_g py1_nu py1_gam] = SIPRma(pars_sq,py1_p);
py1_a = 100*pars_sq(11)*py1_a; py1_g = 100*pars_sq(13)*py1_g;
py1_nu = 100*pars_sq(15)*py1_nu; py1_gam = 100*pars_sq(17)*py1_gam;

figure(7)
subplot(2,2,1), plot(1:Nplot,sq_a(1:Nplot,1),'mo-',...
    1:Nplot,py1_a(1:Nplot,1),'b-','LineWidth',2.5,'MarkerSize',10);
title('Inflation'); 
if Sample==1; axis([1 16 -0.1 0.01]); elseif Sample==2; axis([1 16 -0.15 0.01]); end
subplot(2,2,2), plot(1:Nplot,sq_a(1:Nplot,5),'mo-',...
    1:Nplot,py1_a(1:Nplot,5),'b-','LineWidth',2.5,'MarkerSize',10);
title('Hours');
if Sample==1; axis([1 16 -1 0]); elseif Sample==2; axis([1 16 -0.3 0.3]); end
subplot(2,2,3), plot(1:Nplot,sq_g(1:Nplot,1),'mo-',...
    1:Nplot,py1_g(1:Nplot,1),'b-','LineWidth',2.5,'MarkerSize',10);
title('Inflation'); 
if Sample==1; axis([1 16 -0.01 0.05]); elseif Sample==2; axis([1 16 -0.01 0.05]); end
subplot(2,2,4), plot(1:Nplot,sq_g(1:Nplot,5),'mo-',...
    1:Nplot,py1_g(1:Nplot,5),'b-','LineWidth',2.5,'MarkerSize',10);
title('Hours');
if Sample==1; axis([1 16 0 1.2]); elseif Sample==2; axis([1 16 0 0.5]); end
legend('Status quo','Price-targeting rule')
disp('...Figure 7: BMR rule on productivity and aggregate-demand IRF')

pars_py1 = pars_sq; pars_py1(8)=0; pars_py1(9)=0;
global N pars a b c d
[a b c d] = SIPRll(pars_py1); py1_p = SIPRpyp(pars_py1,py1);
pars=pars_py1; Wpy1=SIPRpyw(py1);
disp('...Welfare gain:'); disp(100*(exp(kappa*(Wbar-Wpy1))-1));
clear glocal; clear pars_py1 a b c d py1_p pars

%%%%% FIGURE 8: BMR ELASTIC PRICE-STANDARD %%%%%%%
disp('BMR ELASTIC PRICE-STANDARD')
py2 = -1/(BMRalpha*BMRomega); disp('...Elastic coefficient'); disp(py2);

py2_p = SIPRpyp(pars_sq,py2); [py2_m py2_a py2_g py2_nu py2_gam] = SIPRma(pars_sq,py2_p);
py2_a = 100*pars_sq(11)*py2_a; py2_g = 100*pars_sq(13)*py2_g;
py2_nu = 100*pars_sq(15)*py2_nu; py2_gam = 100*pars_sq(17)*py2_gam;

figure(8)
subplot(2,2,1), plot(1:Nplot,sq_a(1:Nplot,1),'mo-',...
    1:Nplot,py2_a(1:Nplot,1),'b-','LineWidth',2.5,'MarkerSize',10);
title('Inflation'); 
if Sample==1; axis([1 16 -0.1 0.1]); elseif Sample==2; axis([1 16 -0.15 0.05]); end
subplot(2,2,2), plot(1:Nplot,sq_a(1:Nplot,5),'mo-',...
    1:Nplot,py2_a(1:Nplot,5),'b-','LineWidth',2.5,'MarkerSize',10);
title('Hours');
if Sample==1; axis([1 16 -1 0]); elseif Sample==2; axis([1 16 -0.25 0.05]); end
subplot(2,2,3), plot(1:Nplot,sq_g(1:Nplot,1),'mo-',...
    1:Nplot,py2_g(1:Nplot,1),'b-','LineWidth',2.5,'MarkerSize',10);
title('Inflation'); 
if Sample==1; axis([1 16 -0.05 0.05]); elseif Sample==2; axis([1 16 -0.01 0.05]); end
subplot(2,2,4), plot(1:Nplot,sq_g(1:Nplot,5),'mo-',...
    1:Nplot,py2_g(1:Nplot,5),'b-','LineWidth',2.5,'MarkerSize',10);
title('Hours');
if Sample==1; axis([1 16 0 1.5]); elseif Sample==2; axis([1 16 0 0.5]); end
legend('Status quo','Price-targeting rule')
disp('...Figure 8: BMR rule on productivity and aggregate-demand IRF')

pars_py2 = pars_sq; pars_py2(8)=0; pars_py2(9)=0;
global N pars a b c d
[a b c d] = SIPRll(pars_py2); py2_p = SIPRpyp(pars_py2,py2);
pars=pars_py2; Wpy2=SIPRpyw(py2);
disp('...Welfare gain:'); disp(100*(exp(kappa*(Wbar-Wpy2))-1));
clear global; clear pars_py1 a b c d py1_p pars