function vardecomp=Chilevd(pars,horizon)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%  This file is part of the replication files for the figures in:       %
%Reis, Ricardo (2009) "A Sticky-Information General-Equilibrium Model   %
%  for Policy Analysis." In: Monetary Policy under Uncertainty and      %
%  Learning, edited by K. Schmidt-Heubel and C. Walsh, Central Bank of  %
%  Chile: forthcoming, 2009.                                            %
%See the paper for a detailed explanation of the algorithms.            %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Please cite if you use the programs. I do not provide tech support.    %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%This file: Calculate variance decomposition                            %
%Last revised: January 29, 2009                                         %
%Written by: Tiago Berriel and Ricardo Reis                             %
%Input: Parameter list and horizon of decomposition                     %
%Output: Variance decomposition in rows with m,a,g,nu,gam for           %
%         (inflation output-growth nominal-rate wage-growth hours)      %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%STEP 1: RECOVER PARAMETERS %%%%%
sigma_m=pars(9); sigma_a=pars(11); sigma_g=pars(13); sigma_nu=pars(15);
sigma_gam=pars(17);

%%%%STEP 2: SOLVE FOR MA REPRESENTATION %%%%%
[ma_m ma_a ma_g ma_nu ma_gam]=SIGEmafive(pars);

%%%%STEP 3: VARIANCE DECOMPOSITION %%%%%
%inflation%
temp=(sigma_m^2)*(ma_m(1:horizon,1)'*ma_m(1:horizon,1))+...
    (sigma_a^2)*(ma_a(1:horizon,1)'*ma_a(1:horizon,1))+...
    (sigma_g^2)*(ma_g(1:horizon,1)'*ma_g(1:horizon,1))+...
    (sigma_nu^2)*(ma_nu(1:horizon,1)'*ma_nu(1:horizon,1))+...
    (sigma_gam^2)*(ma_gam(1:horizon,1)'*ma_gam(1:horizon,1));
vardecomp(1,1)=((sigma_m^2)*(ma_m(1:horizon,1)'*ma_m(1:horizon,1)))/temp;
vardecomp(1,2)=((sigma_a^2)*(ma_a(1:horizon,1)'*ma_a(1:horizon,1)))/temp;
vardecomp(1,3)=((sigma_g^2)*(ma_g(1:horizon,1)'*ma_g(1:horizon,1)))/temp;
vardecomp(1,4)=((sigma_nu^2)*(ma_nu(1:horizon,1)'*ma_nu(1:horizon,1)))/temp;
vardecomp(1,5)=((sigma_gam^2)*(ma_gam(1:horizon,1)'*ma_gam(1:horizon,1)))/temp;
clear temp;
% Dy %
temp=(sigma_m^2)*(ma_m(1:horizon,2)'*ma_m(1:horizon,2))+...
    (sigma_a^2)*(ma_a(1:horizon,2)'*ma_a(1:horizon,2))+...
    (sigma_g^2)*(ma_g(1:horizon,2)'*ma_g(1:horizon,2))+...
    (sigma_nu^2)*(ma_nu(1:horizon,2)'*ma_nu(1:horizon,2))+...
    (sigma_gam^2)*(ma_gam(1:horizon,2)'*ma_gam(1:horizon,2));
vardecomp(2,1)=((sigma_m^2)*(ma_m(1:horizon,2)'*ma_m(1:horizon,2)))/temp;
vardecomp(2,2)=((sigma_a^2)*(ma_a(1:horizon,2)'*ma_a(1:horizon,2)))/temp;
vardecomp(2,3)=((sigma_g^2)*(ma_g(1:horizon,2)'*ma_g(1:horizon,2)))/temp;
vardecomp(2,4)=((sigma_nu^2)*(ma_nu(1:horizon,2)'*ma_nu(1:horizon,2)))/temp;
vardecomp(2,5)=((sigma_gam^2)*(ma_gam(1:horizon,2)'*ma_gam(1:horizon,2)))/temp;
clear temp;
%i%
temp=(sigma_m^2)*(ma_m(1:horizon,3)'*ma_m(1:horizon,3))+...
    (sigma_a^2)*(ma_a(1:horizon,3)'*ma_a(1:horizon,3))+...
    (sigma_g^2)*(ma_g(1:horizon,3)'*ma_g(1:horizon,3))+...
    (sigma_nu^2)*(ma_nu(1:horizon,3)'*ma_nu(1:horizon,3))+...
    (sigma_gam^2)*(ma_gam(1:horizon,3)'*ma_gam(1:horizon,3));
vardecomp(3,1)=((sigma_m^2)*(ma_m(1:horizon,3)'*ma_m(1:horizon,3)))/temp;
vardecomp(3,2)=((sigma_a^2)*(ma_a(1:horizon,3)'*ma_a(1:horizon,3)))/temp;
vardecomp(3,3)=((sigma_g^2)*(ma_g(1:horizon,3)'*ma_g(1:horizon,3)))/temp;
vardecomp(3,4)=((sigma_nu^2)*(ma_nu(1:horizon,3)'*ma_nu(1:horizon,3)))/temp;
vardecomp(3,5)=((sigma_gam^2)*(ma_gam(1:horizon,3)'*ma_gam(1:horizon,3)))/temp;
clear temp;
% Dwp %
temp=(sigma_m^2)*(ma_m(1:horizon,4)'*ma_m(1:horizon,4))+...
    (sigma_a^2)*(ma_a(1:horizon,4)'*ma_a(1:horizon,4))+...
    (sigma_g^2)*(ma_g(1:horizon,4)'*ma_g(1:horizon,4))+...
    (sigma_nu^2)*(ma_nu(1:horizon,4)'*ma_nu(1:horizon,4))+...
    (sigma_gam^2)*(ma_gam(1:horizon,4)'*ma_gam(1:horizon,4));
vardecomp(4,1)=((sigma_m^2)*(ma_m(1:horizon,4)'*ma_m(1:horizon,4)))/temp;
vardecomp(4,2)=((sigma_a^2)*(ma_a(1:horizon,4)'*ma_a(1:horizon,4)))/temp;
vardecomp(4,3)=((sigma_g^2)*(ma_g(1:horizon,4)'*ma_g(1:horizon,4)))/temp;
vardecomp(4,4)=((sigma_nu^2)*(ma_nu(1:horizon,4)'*ma_nu(1:horizon,4)))/temp;
vardecomp(4,5)=((sigma_gam^2)*(ma_gam(1:horizon,4)'*ma_gam(1:horizon,4)))/temp;
clear temp;
% hours %
temp=(sigma_m^2)*(ma_m(1:horizon,5)'*ma_m(1:horizon,5))+...
    (sigma_a^2)*(ma_a(1:horizon,5)'*ma_a(1:horizon,5))+...
    (sigma_g^2)*(ma_g(1:horizon,5)'*ma_g(1:horizon,5))+...
    (sigma_nu^2)*(ma_nu(1:horizon,5)'*ma_nu(1:horizon,5))+...
    (sigma_gam^2)*(ma_gam(1:horizon,5)'*ma_gam(1:horizon,5));
vardecomp(5,1)=((sigma_m^2)*(ma_m(1:horizon,5)'*ma_m(1:horizon,5)))/temp;
vardecomp(5,2)=((sigma_a^2)*(ma_a(1:horizon,5)'*ma_a(1:horizon,5)))/temp;
vardecomp(5,3)=((sigma_g^2)*(ma_g(1:horizon,5)'*ma_g(1:horizon,5)))/temp;
vardecomp(5,4)=((sigma_nu^2)*(ma_nu(1:horizon,5)'*ma_nu(1:horizon,5)))/temp;
vardecomp(5,5)=((sigma_gam^2)*(ma_gam(1:horizon,5)'*ma_gam(1:horizon,5)))/temp;
clear temp;