function ma_m = SIGEmam(pars,C)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%This is part of the set of files that accompany the article:       %
%                                                                   %
%Ricardo Reis (2008) "Estimating a SIGE model for policy evaluation"%
%in Monetary Policy under Uncertainty, Central Bank of Chile.       %
%                                                                   %
%See the appendix of the paper or its NBER or CEPR working paper    %
%versions for a detailed explanation of the algorithms.             %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Please cite if you use the programs. I do not provide tech support.%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%This file: Impulse response to monetary experiments                %
%Last revised: October 30, 2007                                     %
%Written by: Tiago Berriel and Ricardo Reis                         %
%Input: full set parameters and C, Nx1 column vector in solution    %
%Output: MA coefficients for the response to m shocks only, with    %
%        (inflation output-gap nomrate realwage hours)              %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

global N

%%%%STEP 1: RECOVER PARAMETERS %%%%%
beta=pars(1); psi=pars(2); theta=pars(3); nu=pars(4); gamma=pars(5);
phiy=pars(6); phipi=pars(7); rho_m=pars(8);
% rho_a=pars(10); rho_g=pars(12); rho_nu=pars(14); rho_gam=pars(16);
delta=pars(18); omega=pars(19); lambda=pars(20);
%sigma_nu=pars(15); sigma_a=pars(11);  sigma_m=pars(9); sigma_g=pars(13);
%sigma_gam=pars(17); %The variances are not necessary

%%%%STEP 2: MODEL AUXILIARY VARIABLES %%%%%%
DELTA(1,1)=delta; OMEGA(1,1)=omega; LAMBDA(1,1)=lambda;
temp1=theta*DELTA(1,1)*((psi+gamma*(1-OMEGA(1,1)))*((beta+nu*(1-beta))/LAMBDA(1,1)-nu*(1-beta))-beta*psi*OMEGA(1,1));
temp2=(1-beta)*(gamma+psi)*theta*DELTA(1,1)+OMEGA(1,1)*(theta*DELTA(1,1)*(1-gamma*(1-beta))+psi*beta);
PSI(1,1)=temp1/temp2;
A(1,1)=1+PSI(1,1)/(theta*DELTA(1,1));
B(1,1)=A(1,1)+phipi+phiy*PSI(1,1);
for i=2:N+2;
    DELTA(i,1)=DELTA(i-1,1)+delta*(1-delta)^(i-1);
    OMEGA(i,1)=OMEGA(i-1,1)+omega*(1-omega)^(i-1);
    LAMBDA(i,1)=LAMBDA(i-1,1)+lambda*(1-lambda)^(i-1);
    temp1=theta*DELTA(i,1)*((psi+gamma*(1-OMEGA(i,1)))*((beta+nu*(1-beta))/LAMBDA(i,1)-nu*(1-beta))-beta*psi*OMEGA(i,1));
    temp2=(1-beta)*(gamma+psi)*theta*DELTA(i,1)+OMEGA(i,1)*(theta*DELTA(i,1)*(1-gamma*(1-beta))+psi*beta);
    PSI(i,1)=temp1/temp2;
end
for i=2:N+1;
    A(i,1)=1+PSI(i,1)/(theta*DELTA(i,1));
    B(i,1)=A(i,1)+phipi+phiy*PSI(i,1);
end

%%%%STEP 3: PATH FOR PRICES FROM SOLVING DIFF. EQUATION %%%%%%%
%Solve system H*p = b; first build the H matrix
H(1,:)=[-B(1,1) A(2,1) zeros(1,N-1)];
H(2,:)=[phipi -B(2,1) A(3,1) zeros(1,N-2)];
for i=3:N
    H(i,:)=[zeros(1,i-2) phipi -B(i,1) A(i+1,1) zeros(1,N-i)];
end
H(N+1,:)=[zeros(1,N-1) 1 -1];
%monetary shocks
path=H\[C; 0];
inflation(1:N+1,1)=path(1:N+1,1)-[0;path(1:N,1)];
output=PSI(1:N+1,1).*path; output(N+2,1)=0; inflation(N+2,1)=0;
for i=1:N+1;
    nomrate(i,1)=(1/theta)*(output(i+1,1)/DELTA(i+1,1)-output(i,1)/DELTA(i,1)) + inflation(i+1,1);
    realwage(i,1)=(1+nu*(1/beta-1))*(1/LAMBDA(i,1)-1)*path(i,1)+(1-1/beta)*output(i,1);
    hours(i,1)=output(i,1)/beta;
end
%note that gap = output, as money shocks, and output=beta*hours
ma_m=[inflation(1:N+1,1) output(1:N+1,1) nomrate realwage hours];
clear path inflation output realwage nomrate hours
