function [a b c d] = SIGEll(pars)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%This is part of the set of files that accompany the article:       %
%                                                                   %
%Ricardo Reis (2008) "Estimating a SIGE model for policy evaluation"%
%in Monetary Policy under Uncertainty, Central Bank of Chile.       %
%                                                                   %
%See the appendix of the paper or its NBER or CEPR working paper    %
%versions for a detailed explanation of the algorithms.             %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Please cite if you use the programs. I do not provide tech support.%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%This file: welfare parameters                                      %
%Last revised: October 30, 2007                                     %
%Written by: Tiago Berriel and Ricardo Reis                         %
%Input: full set parameters, even though policy parameters not used %
%Output: The a, b, c, d coefficients in l_tilda and l_invhat        %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

global N

%%%%STEP 1: RECOVER PARAMETERS %%%%%
beta=pars(1); psi=pars(2); theta=pars(3); nu=pars(4); gamma=pars(5);
phiy=pars(6); phipi=pars(7); rho_m=pars(8); rho_a=pars(10); rho_g=pars(12);
rho_nu=pars(14); rho_gam=pars(16); delta=pars(18); omega=pars(19);
lambda=pars(20);
%sigma_nu=pars(15); sigma_a=pars(11);  sigma_m=pars(9); sigma_g=pars(13);
%sigma_gam=pars(17); %The variances are not necessary
%Natural rate parameters
%xi_a=(1+1/psi)/(1+1/psi+beta/theta-beta);
%xi_g=(beta/theta)/(1+1/psi+beta/theta-beta);
%xi_gam=(beta/(gamma-1))/(1+1/psi+beta/theta-beta);
%xi_nu=(beta/(nu-1))/(1+1/psi+beta/theta-beta);

%%%%STEP 2: MODEL AUXILIARY VARIABLES %%%%%%
DELTA(1,1)=delta; OMEGA(1,1)=omega; LAMBDA(1,1)=lambda;
temp1=theta*DELTA(1,1)*((psi+gamma*(1-OMEGA(1,1)))*((beta+nu*(1-beta))/LAMBDA(1,1)-nu*(1-beta))-beta*psi*OMEGA(1,1));
temp2=(1-beta)*(gamma+psi)*theta*DELTA(1,1)+OMEGA(1,1)*(theta*DELTA(1,1)*(1-gamma*(1-beta))+psi*beta);
PSI(1,1)=temp1/temp2;
UPSILON_a(1,1)=(theta*DELTA(1,1)*(gamma+psi+OMEGA(1,1)*(1-gamma)))/temp2;
UPSILON_g(1,1)=(beta*psi*OMEGA(1,1))/temp2;
UPSILON_nu(1,1)=beta*theta*DELTA(1,1)*(psi+gamma*(1-OMEGA(1,1)))/(temp2*(nu-1));
UPSILON_gam(1,1)=beta*theta*psi*DELTA(1,1)*OMEGA(1,1)/(temp2*(gamma-1));
A(1,1)=1+PSI(1,1)/(theta*DELTA(1,1));
B(1,1)=A(1,1)+phipi+phiy*PSI(1,1);
for i=2:N+2;
    DELTA(i,1)=DELTA(i-1,1)+delta*(1-delta)^(i-1);
    OMEGA(i,1)=OMEGA(i-1,1)+omega*(1-omega)^(i-1);
    LAMBDA(i,1)=LAMBDA(i-1,1)+lambda*(1-lambda)^(i-1);
    temp1=theta*DELTA(i,1)*((psi+gamma*(1-OMEGA(i,1)))*((beta+nu*(1-beta))/LAMBDA(i,1)-nu*(1-beta))-beta*psi*OMEGA(i,1));
    temp2=(1-beta)*(gamma+psi)*theta*DELTA(i,1)+OMEGA(i,1)*(theta*DELTA(i,1)*(1-gamma*(1-beta))+psi*beta);
    PSI(i,1)=temp1/temp2;
    UPSILON_a(i,1)=(theta*DELTA(i,1)*(gamma+psi+OMEGA(i,1)*(1-gamma)))/temp2;
    UPSILON_g(i,1)=(beta*psi*OMEGA(i,1))/temp2;
    UPSILON_nu(i,1)=beta*theta*DELTA(i,1)*(psi+gamma*(1-OMEGA(i,1)))/(temp2*(nu-1));
    UPSILON_gam(i,1)=beta*theta*psi*DELTA(i,1)*OMEGA(i,1)/(temp2*(gamma-1));
end

%%%%STEP 3: COEFFICIENTS INVARIANT TO SHOCK: a(i) and c(i) %%%%%%%
for i=1:N+1;
    z =  1 + (1+nu*(1/beta-1))*(1/LAMBDA(i,1)-1);
    k(i) = 1/(gamma*beta) + 1 - 1/beta - 1/DELTA(i);
    a(i) = PSI(i,1)*((1-gamma)/beta + gamma) + gamma*z;
    c(i) = ((gamma*psi)/(gamma+psi)) * (PSI(i)*k(i) + z - 1);
end
%%%%STEP 4: COEFFICIENTS THAT DEPEND ON SHOCK %%%%%%%
%monetary shocks -- m
b=zeros(N+1,1); d=zeros(N+1,1);
%technology shock -- a
for i=1:N+1;
    b(i,2) = ((1-rho_a^(i))/(1-rho_a))*((gamma-1)/beta + UPSILON_a(i,1)*(gamma+(1-gamma)/beta));
    d(i,2) = ((1-rho_a^(i))/(1-rho_a))*(UPSILON_a(i,1)*k(i)+(gamma-1)/(beta*gamma));
end
%aggregate demand shock -- g
for i=1:N+1;
    b(i,3) = (rho_g^(i-1))*UPSILON_g(i,1)*(gamma+(1-gamma)/beta);
    d(i,3) = (rho_g^(i-1))*(k(i)*UPSILON_g(i,1)-1/DELTA(i));
end
%goods markup shock -- nu
for i=1:N+1;
    b(i,4) = (rho_nu^(i-1))*(UPSILON_nu(i,1)*(gamma+(1-gamma)/beta) + gamma/(nu-1));
    d(i,4) = (rho_nu^(i-1))*(k(i)*UPSILON_nu(i,1)+1/(nu-1));
end
%labor markup shock -- gam
for i=1:N+1;
    b(i,5) = (rho_gam^(i-1))*UPSILON_gam(i,1)*(gamma+(1-gamma)/beta);
    d(i,5) = (rho_gam^(i-1))*(k(i)*UPSILON_gam(i,1)+1/(gamma-1));
end