%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%This is part of the set of files that accompany the article:       %
%                                                                   %
%Ricardo Reis (2008) "Estimating a SIGE model for policy evaluation"%
%in Monetary Policy under Uncertainty, Central Bank of Chile.       %
%                                                                   %
%See the appendix of the paper or of its NBER or CEPR working paper %
%versions for a detailed explanation of the algorithms.             %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Please cite if you use the programs. I do not provide tech support.%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%This file: predictive density moments                              %
%Last revised: October 15, 2007                                     %
%Written by: Tiago Berriel and Ricardo Reis                         %
%Input: the posterior draws in Chile_USpost.mat                     %
%Output: displayed on screen                                        %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

clear global; clear; clc; close all
global N pars a b c d

%%%%% STEP 0: CHOICES %%%%%
Sample = 1;                         %Pick, 1 - USG; 2 - EMU
N = 200;                            %Length of impulse responses
startUSG = -0.05; startEMU = -1.25; %search start-point and grid mid-point
increments = 0.01;                  %increments in grid
ubUSG = 0.09; ubEMU=0.008;          %loss lower bound for plotting
grids = 99;                         %grid points, must be odd
lb = -100; ub = 100;                %bounds for search

%%%%% STEP 1: LOADING PARAMETERS%%%%%
disp('~~~~~~~~~~~~~~~~~~~~')
if Sample==1; load OMPR_USGpost_stats est_mean; disp('~~USGSPAN sample~~~~~');
elseif Sample==2; load OMPR_EMUpost_stats est_mean; disp('~~EMU sample~~~~~~');
end; disp('~~~~~~~~~~~~~~~~~~~~'); disp(' ');
pars = est_mean'; clear est_mean;
pars(8) = 0; pars(9) = 0;   %rho and sigma for m
[a b c d] = SIPRll(pars);  %solution of model

%%%%% STEP 2: FINDING MAXIMUM WELFARE%%%%%
if Sample==1; py0 = startUSG; elseif Sample==2; py0=startEMU; end;
options = optimset('MaxFunEvals',1000000);
%[opt_py Wpy] = fmincon(@SIPRpyw,py0,[],[],[],[],lb,ub,[],options);
%[opt_py Wpy] = fminunc(@SIPRpyw,py0,options);     %check1
[opt_py Wpy] = fminsearch(@SIPRpyw,py0,options);  %check2
opt_py_p = SIPRpyp(pars,opt_py);      %optimal p path
disp(' '); disp('~~Components of optimal welfare loss');
disp([SIPRw('m',pars,opt_py_p,a,b,c,d) ...
    SIPRw('a',pars,opt_py_p,a,b,c,d) ...
    SIPRw('g',pars,opt_py_p,a,b,c,d) ...
    SIPRw('nuu',pars,opt_py_p,a,b,c,d) ...
    SIPRw('gam',pars,opt_py_p,a,b,c,d)]);

%%%%% STEP 3: GRID TO LOOK BETTER AT FEATURES OF OPTIMUM
A=[];       %grid storing for search
if Sample==1; start=startUSG; ubA=ubUSG;
elseif Sample==2; start=startEMU; ubA=ubEMU; end
start = start - increments*(grids-1)/2;
for i=1:grids; grid(i,1) = start + increments*i - increments; end
for j=1:grids; A(j) = SIPRpyw(grid(j)); end
Atemp=A; for i=1:grids; if A(i)>ubA; Atemp(i)=NaN; end; end;
Atemp=-Atemp; plot(grid,Atemp), title('Welfare trying to maximise')
%Check
if min(A)-Wpy<0; disp('~~fmincon didnt find global minimum'); end; disp(' ');
[Wpy_alt temp2] = min(A); alt_py=grid(temp2,1);
disp('~~Grid-search optimum and loss are'); disp([alt_py Wpy_alt]);
clear temp1 temp2 i j ubA lb ub start py0 options N pars;

%%%%% STEP 4: DISPLAYING AND SAVING %%%%%%
clear alt_py Wpy_alt a b c d pyUSG pyEMU startUSG startEMU grid N...
    Atemp A pars increments ubUSG ubEMU grids;
disp('##########################################################')
disp('Parameters:  ')
disp('    x  in p = x*(y-yn)'); disp(opt_py)
disp('   path of prices '); disp(opt_py_p(1:10,:))
disp('Welfare value:'); disp(Wpy)
disp('##########################################################')