%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%This is part of the set of files that accompany the article:       %
%                                                                   %
%Ricardo Reis (2008) "Estimating a SIGE model for policy evaluation"%
%in Monetary Policy under Uncertainty, Central Bank of Chile.       %
%                                                                   %
%See the appendix of the paper or of its NBER or CEPR working paper %
%versions for a detailed explanation of the algorithms.             %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Please cite if you use the programs. I do not provide tech support.%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%This file: predictive density moments                              %
%Last revised: October 15, 2007                                     %
%Written by: Tiago Berriel and Ricardo Reis                         %
%Input: the posterior draws in Chile_USpost.mat                     %
%Output: displayed on screen                                        %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

clear global; clear; clc; close all
global N pars a b c d

%%%%% STEP 0: CHOICES %%%%%
Sample = 1;                         %Pick, 1 - USG; 2 - EMU
N = 200;                            %Length of impulse responses
startUSG = [-0.06 -0.16]; startEMU = [-0.55 0.83];   %search start-point and grid mid-point
increments = [0.01 0.01];           %increments in grid
ubUSG = 0.085; ubEMU=0.01;             %loss lower bound for plotting
grids = 15;                         %grid points, must be odd
lb = [-100 -1]; ub = [100 1];        %bounds for search

%%%%% STEP 1: LOADING PARAMETERS%%%%%
disp('~~~~~~~~~~~~~~~~~~~~')
if Sample==1; load OMPR_USGpost_stats est_mean; disp('~~USGSPAN sample~~~~~');
elseif Sample==2; load OMPR_EMUpost_stats est_mean; disp('~~EMU sample~~~~~~');
end; disp('~~~~~~~~~~~~~~~~~~~~'); disp(' ');
pars = est_mean'; clear est_mean;
pars(8) = 0; pars(9) = 0;   %rho and sigma for m
[a b c d] = SIPRll(pars);  %solution of model

%%%%% STEP 2: FINDING MAXIMUM WELFARE%%%%%
if Sample==1; py0 = startUSG; elseif Sample==2; py0=startEMU; end;
options = optimset('MaxFunEvals',1000000);
[opt_pyin Wpyin] = fmincon(@SIPRpywin,py0,[],[],[],[],lb,ub,[],options);
%[opt_pyin Wpyin] = fminunc(@SIPRpywin,py0,options);     %check1
%[opt_pyin Wpyin] = fminsearch(@SIPRpywin,py0,options);  %check2
opt_pyin_p = SIPRpypin(pars,opt_pyin);      %optimal p path
disp(' '); disp('~~Components of optimal welfare loss');
disp([SIPRw('m',pars,opt_pyin_p,a,b,c,d) ...
    SIPRw('a',pars,opt_pyin_p,a,b,c,d) ...
    SIPRw('g',pars,opt_pyin_p,a,b,c,d) ...
    SIPRw('nuu',pars,opt_pyin_p,a,b,c,d) ...
    SIPRw('gam',pars,opt_pyin_p,a,b,c,d)]);

%%%%% STEP 3: GRID TO LOOK BETTER AT FEATURES OF OPTIMUM
A=[];       %grid storing for search
if Sample==1; start=startUSG; ubA=ubUSG;
elseif Sample==2; start=startEMU; ubA=ubEMU; end
start = start - increments*(grids-1)/2 - increments;
if start(2)>1; error('Trying rho>1. Lower start or raise increments'); end
for i=1:grids; grid(i,1:2) = start + increments*(i-1); end
h = waitbar(0,'...Iterating over grid...');
for j=1:grids
    for k=1:grids; A(j,k)=SIPRpywin([grid(j,1);grid(k,2)]);  end
    waitbar(j/grids,h);
end
close(h);
Atemp=A;
for i=1:grids; for j=1:grids; if A(i,j)>ubA; Atemp(i,j)=NaN; end; end; end; %pick to draw nicer
Atemp=-Atemp; surf(Atemp); title('Welfare trying to maximise')
%Check
if min(A)-Wpyin<0; disp('~~fmincon didnt find global minimum'); end; disp(' ');
[temp1 temp2] = min(A); [Wpy_alt temp3] = min(temp1);
alt_py=[grid(temp2(temp3),1); grid(temp3,2)];
disp('~~Grid-search optimum and loss are'); disp([alt_py' Wpy_alt]);
clear temp1 temp2 i j ubA lb ub start py0 options N pars h k temp3;
disp(grid);

%%%%% STEP 4: DISPLAYING AND SAVING %%%%%%
clear alt_py Wpy_alt a b c d pyUSG pyEMU startUSG startEMU grid N...
    Atemp A pars increments ubUSG ubEMU grids;
disp('##########################################################')
disp('Parameters:  ')
disp('    x and rho in p = x*(y-yn) + rho*p(-1)'); disp(opt_pyin)
disp('   path of prices '); disp(opt_pyin_p(1:10,:))
disp('Welfare value:'); disp(Wpyin)
disp('##########################################################')