%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%This is part of the set of files that accompany the article:       %
%                                                                   %
%Ricardo Reis (2008) "Estimating a SIGE model for policy evaluation"%
%in Monetary Policy under Uncertainty, Central Bank of Chile.       %
%                                                                   %
%See the appendix of the paper or of its NBER or CEPR working paper %
%versions for a detailed explanation of the algorithms.             %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Please cite if you use the programs. I do not provide tech support.%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Last revised: May 26, 2007                                         %
%Written by: Tiago Berriel and Ricardo Reis                         %
%Maximizing the Welfare for different Taylor Rules iwth inertia     %
%Input: USGpost and EMUpost                                         %
%Output: on the screen, optimal Taylor rule                         %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

clear global; clear; clc; close all
global N pars a b c d

%%%%% STEP 0: CHOICES %%%%%
Sample = 1;                         %Pick, 1 - USG; 2 - EMU
N = 200;                            %Length of impulse responses
startUSG = [0.8 5.9 0.4]; startEMU = [1.68 1.27 0.15];   %search start-point and grid mid-point
increments = [0.01 0.01 0.01];       %increments in grid
ubUSG = 0.008; ubEMU=0.005;          %loss lower bound for plotting
grids = 7;                          %grid points, must be odd
lb=[-10,1.01,-1]; ub=[20,20,1];          %bounds for search

%%%%% STEP 1: LOADING PARAMETERS%%%%%
disp('~~~~~~~~~~~~~~~~~~~~')
if Sample==1; load OMPR_USGpost_stats est_mean; disp('~~USGSPAN sample~~~~~');
elseif Sample==2; load OMPR_EMUpost_stats est_mean; disp('~~EMU sample~~~~~~');
end; disp('~~~~~~~~~~~~~~~~~~~~'); disp(' ');
pars = est_mean'; clear est_mean;
pars(8) = 0; pars(9) = 0;   %rho and sigma for m
[a b c d] = SIPRll(pars);  %solution of model

%%%%% STEP 2: FINDING MAXIMUM WELFARE%%%%%
if Sample==1; trin0 = startUSG; elseif Sample==2; trin0=startEMU; end;
options = optimset('MaxFunEvals',1000000);  %options
%[opt_trin Wtrin] = fmincon(@SIPRtrwin,trin0,[],[],[],[],lb,ub,[],options);
%[opt_trin Wtrin] = fminunc(@SIPRtrwin,trin0,options);     %check 1
[opt_trin Wtrin] = fminsearch(@SIPRtrwin,trin0,options);  %check 2
opt_pars=pars; opt_pars(6) = opt_trin(1); opt_pars(7) = opt_trin(2); %parameter vector at optimum
opt_pars(8) = opt_trin(3);  %nrew part with rho; 
opt_trin_p = SIPRtrp(opt_pars,'inertia');                 %optimal p path
disp(' '); disp('~~Components of optimal welfare loss');
disp([SIPRw('m',pars,opt_trin_p,a,b,c,d) ...
    SIPRw('a',pars,opt_trin_p,a,b,c,d) ...
    SIPRw('g',pars,opt_trin_p,a,b,c,d) ...
    SIPRw('nuu',pars,opt_trin_p,a,b,c,d) ...
    SIPRw('gam',pars,opt_trin_p,a,b,c,d)]);

%%%%% STEP 3: GRID TO LOOK BETTER AT FEATURES OF OPTIMUM
A=[];       %grid storing for search
if Sample==1; start=startUSG; ubA=ubUSG;
elseif Sample==2; start=startEMU; ubA=ubEMU; end
start = start - increments*(grids-1)/2 - increments;
if start(2)<1; error('Trying phipi<1. Raise start or lower increments'); end
if start(3)>1; error('Trying rho>1. Lower start or lower increments'); end
%very different because have to go to to 3 dimensions
for i=1:grids; grid(i,1:3) = start + increments*(i-1); end
h = waitbar(0,'...Iterating over grid...');
for j=1:grids
    for k=1:grids;
        for l=1:grids;
            A(j,k,l) = SIPRtrwin([grid(j,1);grid(k,2);grid(l,3)]);
        end
    end
    waitbar(j/grids,h);
end
close(h);
%Check
if min(min(min(A)))-Wtrin<0; disp('~~fmincon did not find global minimum'); end; disp(' ');
[a b]=min(A); [a c]=min(a); [a d]=min(a);
temp3=d; temp2=c(1,1,d); temp1=b(1,c(1,1,d),1);
Wtrin_alt=A(temp1,temp2,temp3); %or =a;
alt_trin=[grid(temp1,1); grid(temp2,2); grid(temp3,3)];
disp('~~Grid-search optimum and loss are'); disp([alt_trin' Wtrin_alt]);
clear temp1 temp2 temp3 h i j k l trin0 startUSG startEMU ubA lb ub ...
    N pars options start

%%%%% STEP 4: DISPLAYING %%%%%%
clear Wtrin_alt alt_trin a b c d trinUSG trinEMU A Atemp opt_p opt_pars ...
    ubUSG ubEMU increments grids grid
disp('##########################################################')
disp('Parameters:  ')
disp('    phi_y     phi_pi   rho'); disp(opt_trin)
disp('   path of prices '); disp(opt_trin_p(1:10,:))
disp('Welfare value:'); disp(Wtrin)
disp('##########################################################')